/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.iterators;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompoundIterator<T>
implements Iterator<T> {
    private final Iterator<? extends Iterator<? extends T>> iterators;
    private Iterator<? extends T> iterator = Collections.emptyIterator();

    public CompoundIterator(Iterable<? extends Iterator<? extends T>> iterators) {
        this.iterators = iterators.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator.hasNext()) {
            return true;
        }
        try {
            this.iterator = this.iterators.next();
        }
        catch (NoSuchElementException ex) {
            return false;
        }
        return this.hasNext();
    }

    @Override
    public T next() {
        try {
            return this.iterator.next();
        }
        catch (NoSuchElementException ex) {
            this.iterator = this.iterators.next();
            return this.next();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

