/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.syntax;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.MessageFactory;
import org.metaborg.core.source.ISourceRegion;
import org.metaborg.spoofax.core.syntax.JSGLRI;
import org.metaborg.spoofax.core.syntax.JSGLRSourceRegionFactory;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.MultiBadTokenException;
import org.spoofax.jsglr.client.ParseTimeoutException;
import org.spoofax.jsglr.client.RegionRecovery;
import org.spoofax.jsglr.client.imploder.AbstractTokenizer;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITokenizer;
import org.spoofax.jsglr.client.imploder.ITokens;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.jsglr.client.imploder.Token;
import org.spoofax.jsglr.shared.BadTokenException;
import org.spoofax.jsglr.shared.TokenExpectedException;

public class JSGLRParseErrorHandler {
    private static final int LARGE_REGION_SIZE = 8;
    private static final String LARGE_REGION_START = "Region could not be parsed because of subsequent syntax error(s) indicated below";
    private final JSGLRI<?> parser;
    @Nullable
    private final FileObject resource;
    private final boolean hasRecoveryRules;
    private final Collection<IMessage> messages = Lists.newArrayList();
    private boolean recoveryFailed;

    public JSGLRParseErrorHandler(JSGLRI<?> parser, @Nullable FileObject resource, boolean hasRecoveryRules) {
        this.parser = parser;
        this.resource = resource;
        this.hasRecoveryRules = hasRecoveryRules;
    }

    public Iterable<IMessage> messages() {
        return this.messages;
    }

    public void setRecoveryFailed(boolean recoveryFailed) {
        this.recoveryFailed = recoveryFailed;
    }

    public void gatherNonFatalErrors(IStrategoTerm top) {
        ITokenizer tokenizer = (ITokenizer)ImploderAttachment.getTokenizer(top);
        if (tokenizer != null) {
            int i = 0;
            int max2 = tokenizer.getTokenCount();
            while (i < max2) {
                Token token = tokenizer.getTokenAt(i);
                String error = token.getError();
                if (error != null) {
                    if (Objects.equals(error, "Syntax error, unexpected construct(s)")) {
                        i = JSGLRParseErrorHandler.findRightMostWithSameError(token, null);
                        this.reportSkippedRegion(token, tokenizer.getTokenAt(i));
                    } else if (error.startsWith("Warning")) {
                        i = JSGLRParseErrorHandler.findRightMostWithSameError(token, null);
                        this.reportWarningAtTokens(token, tokenizer.getTokenAt(i), error);
                    } else if (error.startsWith("Syntax error, not expected here")) {
                        i = JSGLRParseErrorHandler.findRightMostWithSameError(token, "Syntax error, not expected here");
                        this.reportErrorAtTokens(token, tokenizer.getTokenAt(i), error);
                    } else {
                        i = JSGLRParseErrorHandler.findRightMostWithSameError(token, null);
                        this.reportErrorAtTokens(token, tokenizer.getTokenAt(i), error);
                    }
                }
                ++i;
            }
        }
    }

    private static int findRightMostWithSameError(Token token, String prefix) {
        String expectedError = token.getError();
        ITokenizer tokenizer = (ITokenizer)token.getTokenizer();
        int i = token.getIndex();
        int max2 = tokenizer.getTokenCount();
        while (i + 1 < max2) {
            String error = tokenizer.getTokenAt(i + 1).getError();
            if (!Objects.equals(error, expectedError) && (error == null || prefix == null || !error.startsWith(prefix))) break;
            ++i;
        }
        return i;
    }

    private void reportSkippedRegion(IToken left, IToken right) {
        int line = left.getLine();
        int reportedLine = -1;
        for (BadTokenException e : this.getCollectedErrorsInRegion(left, right, true)) {
            this.processFatalException(left.getTokenizer(), e);
            if (reportedLine != -1) continue;
            reportedLine = e.getLineNumber();
        }
        if (reportedLine == -1) {
            this.reportErrorAtTokens(left, right, "Syntax error, unexpected construct(s)");
        } else if (reportedLine - line >= 8) {
            this.reportErrorAtTokens(AbstractTokenizer.findLeftMostTokenOnSameLine(left), AbstractTokenizer.findRightMostTokenOnSameLine(left), LARGE_REGION_START);
        }
    }

    private List<BadTokenException> getCollectedErrorsInRegion(IToken left, IToken right, boolean alsoOutside) {
        ArrayList<BadTokenException> results = new ArrayList<BadTokenException>();
        int line = left.getLine();
        int endLine = right.getLine() + (alsoOutside ? RegionRecovery.NR_OF_LINES_TILL_SUCCESS : 0);
        for (BadTokenException e : this.parser.getCollectedErrors()) {
            if (e.getLineNumber() < line || e.getLineNumber() > endLine) continue;
            results.add(e);
        }
        return results;
    }

    public void processFatalException(ITokens tokenizer, Exception exception) {
        try {
            throw exception;
        }
        catch (ParseTimeoutException e) {
            this.reportTimeOut(tokenizer, e);
        }
        catch (TokenExpectedException e) {
            this.reportTokenExpected(tokenizer, e);
        }
        catch (MultiBadTokenException e) {
            this.reportMultiBadToken(tokenizer, e);
        }
        catch (BadTokenException e) {
            this.reportBadToken(tokenizer, e);
        }
        catch (Exception e) {
            this.createErrorAtFirstLine("Internal parsing error: " + e);
        }
    }

    private void reportTimeOut(ITokens tokenizer, ParseTimeoutException exception) {
        String message = "Internal parsing error: " + exception.getMessage();
        this.createErrorAtFirstLine(message);
        this.reportMultiBadToken(tokenizer, exception);
    }

    private void reportTokenExpected(ITokens tokenizer, TokenExpectedException exception) {
        String message = exception.getShortMessage();
        this.reportErrorNearOffset(tokenizer, exception.getOffset(), message);
    }

    private void reportMultiBadToken(ITokens tokenizer, MultiBadTokenException exception) {
        for (BadTokenException e : exception.getCauses()) {
            this.processFatalException(tokenizer, e);
        }
    }

    private void reportBadToken(ITokens tokenizer, BadTokenException exception) {
        String message;
        if (exception.isEOFToken() || tokenizer.getTokenCount() <= 1) {
            message = exception.getShortMessage();
        } else {
            IToken token = tokenizer.getTokenAtOffset(exception.getOffset());
            token = JSGLRParseErrorHandler.findNextNonEmptyToken(token);
            message = "Syntax error, not expected here: " + token.toString().trim();
        }
        this.reportErrorNearOffset(tokenizer, exception.getOffset(), message);
    }

    private void reportErrorNearOffset(ITokens tokenizer, int offset, String message) {
        IToken errorToken = ((AbstractTokenizer)tokenizer).getErrorTokenOrAdjunct(offset);
        ISourceRegion region = JSGLRSourceRegionFactory.fromTokens(errorToken, errorToken);
        this.reportErrorAtRegion(region, message);
    }

    private static IToken findNextNonEmptyToken(IToken token) {
        ITokenizer tokenizer = (ITokenizer)token.getTokenizer();
        Token result = null;
        int i = token.getIndex();
        int max2 = tokenizer.getTokenCount();
        while (i < max2) {
            result = tokenizer.getTokenAt(i);
            if (result.getLength() != 0 && !Token.isWhiteSpace(result)) break;
            ++i;
        }
        return result;
    }

    private void createErrorAtFirstLine(String message) {
        this.messages.add(MessageFactory.newParseErrorAtTop(this.resource, String.valueOf(message) + this.getErrorExplanation(), null));
    }

    private void reportErrorAtTokens(IToken left, IToken right, String message) {
        this.reportErrorAtRegion(JSGLRSourceRegionFactory.fromTokens(left, right), message);
    }

    private void reportErrorAtRegion(ISourceRegion sourceRegion, String message) {
        this.messages.add(MessageFactory.newParseError(this.resource, sourceRegion, message, null));
    }

    private void reportWarningAtTokens(IToken left, IToken right, String message) {
        this.reportWarningAtRegion(JSGLRSourceRegionFactory.fromTokens(left, right), message);
    }

    private void reportWarningAtRegion(ISourceRegion sourceRegion, String message) {
        this.messages.add(MessageFactory.newParseWarning(this.resource, sourceRegion, message, null));
    }

    private String getErrorExplanation() {
        if (this.recoveryFailed) {
            return " (recovery failed)";
        }
        if (!this.hasRecoveryRules) {
            return " (no recovery rules in parse table)";
        }
        return "";
    }
}

