/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.language;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.language.ComponentCreationConfig;
import org.metaborg.core.language.IComponentCreationConfigRequest;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageComponentFactory;
import org.metaborg.core.language.ILanguageDiscoveryRequest;
import org.metaborg.core.language.ILanguageDiscoveryService;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.ILanguageService;
import org.metaborg.core.language.LanguageUtils;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class LanguageDiscoveryService
implements ILanguageDiscoveryService {
    private static final ILogger logger = LoggerUtils.logger(LanguageDiscoveryService.class);
    private final ILanguageService languageService;
    private final ILanguageComponentFactory componentFactory;

    @Inject
    public LanguageDiscoveryService(ILanguageService languageService, ILanguageComponentFactory componentFactory) {
        this.languageService = languageService;
        this.componentFactory = componentFactory;
    }

    @Override
    public ILanguageImpl languageFromDirectory(FileObject directory) throws MetaborgException {
        Set<ILanguageImpl> languages = this.languagesFromDirectory(directory);
        if (Iterables.size(languages) > 1) {
            throw new MetaborgException("Attempted to load a single language implementation from directory " + directory + " but got multiple: " + Joiner.on((String)", ").join(languages));
        }
        return (ILanguageImpl)Iterables.get(languages, (int)0);
    }

    @Override
    public Set<ILanguageImpl> languagesFromDirectory(FileObject directory) throws MetaborgException {
        ILanguageComponent component = this.componentFromDirectory(directory);
        return Sets.newHashSet(component.contributesTo());
    }

    @Override
    public ILanguageImpl languageFromArchive(FileObject archiveFile) throws MetaborgException {
        Set<ILanguageImpl> languages = this.languagesFromArchive(archiveFile);
        if (Iterables.size(languages) > 1) {
            throw new MetaborgException("Attempted to load a single language implementation from archive " + archiveFile + " but got multiple: " + Joiner.on((String)", ").join(languages));
        }
        return (ILanguageImpl)Iterables.get(languages, (int)0);
    }

    @Override
    public Set<ILanguageImpl> languagesFromArchive(FileObject archiveFile) throws MetaborgException {
        ILanguageComponent component = this.componentFromArchive(archiveFile);
        return Sets.newHashSet(component.contributesTo());
    }

    @Override
    public Set<ILanguageImpl> scanLanguagesInDirectory(FileObject directory) throws MetaborgException {
        Set<ILanguageComponent> components = this.scanComponentsInDirectory(directory);
        return LanguageUtils.toImpls(components);
    }

    @Override
    public ILanguageComponent componentFromDirectory(FileObject directory) throws MetaborgException {
        IComponentCreationConfigRequest request = this.componentFactory.requestFromDirectory(directory);
        return this.create(request);
    }

    @Override
    public ILanguageComponent componentFromArchive(FileObject archiveFile) throws MetaborgException {
        IComponentCreationConfigRequest request = this.componentFactory.requestFromArchive(archiveFile);
        return this.create(request);
    }

    @Override
    public Set<ILanguageComponent> scanComponentsInDirectory(FileObject directory) throws MetaborgException {
        Collection<IComponentCreationConfigRequest> requests = this.componentFactory.requestAllInDirectory(directory);
        Collection<ComponentCreationConfig> configs = this.componentFactory.createConfigs(requests);
        HashSet components = Sets.newHashSet();
        for (ComponentCreationConfig config : configs) {
            ILanguageComponent component = this.languageService.add(config);
            components.add(component);
        }
        return components;
    }

    private ILanguageComponent create(IComponentCreationConfigRequest request) throws MetaborgException {
        ComponentCreationConfig config = this.componentFactory.createConfig(request);
        ILanguageComponent component = this.languageService.add(config);
        return component;
    }

    @Override
    @Deprecated
    public Iterable<ILanguageDiscoveryRequest> request(FileObject location) throws MetaborgException {
        FileObject[] configFiles;
        LinkedList requests = Lists.newLinkedList();
        try {
            configFiles = location.findFiles(new FileSelector(){

                public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
                    String baseName = fileInfo.getFile().getName().getBaseName();
                    return !baseName.equals("bin") && !baseName.equals("target");
                }

                public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
                    return fileInfo.getFile().getName().getBaseName().equals("metaborg.component.yaml");
                }
            });
        }
        catch (FileSystemException e) {
            throw new MetaborgException("Searching for language components failed unexpectedly", e);
        }
        if (configFiles == null || configFiles.length == 0) {
            return requests;
        }
        FileObject[] fileObjectArray = configFiles;
        int n = configFiles.length;
        int n2 = 0;
        while (n2 < n) {
            FileObject configFile = fileObjectArray[n2];
            try {
                FileObject directory = configFile.getParent().getParent();
                IComponentCreationConfigRequest request = this.componentFactory.requestFromDirectory(directory);
                requests.add(request);
            }
            catch (FileSystemException e) {
                logger.error("Could not resolve parent directory of config file {}, skipping", e, configFile);
            }
            ++n2;
        }
        return requests;
    }

    @Override
    @Deprecated
    public ILanguageComponent discover(ILanguageDiscoveryRequest request) throws MetaborgException {
        IComponentCreationConfigRequest realRequest = (IComponentCreationConfigRequest)request;
        return this.create(realRequest);
    }

    @Override
    @Deprecated
    public Iterable<ILanguageComponent> discover(Iterable<ILanguageDiscoveryRequest> requests) throws MetaborgException {
        ArrayList components = Lists.newArrayList();
        for (ILanguageDiscoveryRequest request : requests) {
            components.add(this.discover(request));
        }
        return components;
    }
}

