/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.action;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.metaborg.core.action.CompileGoal;
import org.metaborg.core.action.EndNamedGoal;
import org.metaborg.core.action.ITransformAction;
import org.metaborg.core.action.ITransformGoal;
import org.metaborg.core.action.NamedGoal;
import org.metaborg.core.action.TransformActionFlags;
import org.metaborg.core.menu.Menu;
import org.metaborg.core.menu.MenuAction;
import org.metaborg.core.menu.Separator;
import org.metaborg.spoofax.core.action.ActionFacet;
import org.metaborg.spoofax.core.action.TransformAction;
import org.metaborg.spoofax.core.esv.ESVReader;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

public class ActionFacetFromESV {
    private static final ILogger logger = LoggerUtils.logger(ActionFacetFromESV.class);

    @Nullable
    public static ActionFacet create(IStrategoAppl esv) {
        ArrayList<IStrategoAppl> menuTerms = ESVReader.collectTerms(esv, "ToolbarMenu");
        LinkedList menus = Lists.newLinkedList();
        HashMultimap actions = HashMultimap.create();
        ImmutableList nesting = ImmutableList.of();
        for (IStrategoAppl menuTerm : menuTerms) {
            Menu submenu = ActionFacetFromESV.menu(menuTerm, new TransformActionFlags(), (ImmutableList<String>)nesting, (Multimap<ITransformGoal, ITransformAction>)actions);
            menus.add(submenu);
        }
        ActionFacetFromESV.addCompileGoal(esv, (Multimap<ITransformGoal, ITransformAction>)actions);
        if (menus.isEmpty() && actions.isEmpty()) {
            return null;
        }
        return new ActionFacet((Multimap<ITransformGoal, ITransformAction>)actions, menus);
    }

    private static Menu menu(IStrategoTerm menuTerm, TransformActionFlags flags, ImmutableList<String> nesting, Multimap<ITransformGoal, ITransformAction> actions) {
        String name = ActionFacetFromESV.name(menuTerm.getSubterm(0));
        ImmutableList newNesting = ImmutableList.builder().addAll(nesting).add((Object)name).build();
        TransformActionFlags extraFlags = ActionFacetFromESV.flags(menuTerm.getSubterm(1));
        TransformActionFlags mergedFlags = TransformActionFlags.merge(flags, extraFlags);
        IStrategoTerm items = menuTerm.getSubterm(2);
        Menu menu = new Menu(name);
        for (IStrategoTerm item : items) {
            String constructor = TermUtils.asAppl(item).map(t -> t.getConstructor().getName()).orElse(null);
            if (constructor == null) {
                logger.error("Could not interpret menu item from term {}", item);
                continue;
            }
            switch (constructor) {
                case "Submenu": {
                    Menu submenu = ActionFacetFromESV.menu(item, mergedFlags, (ImmutableList<String>)newNesting, actions);
                    menu.add(submenu);
                    break;
                }
                case "Action": {
                    String actionName = ActionFacetFromESV.name(item.getSubterm(0));
                    String strategy = TermUtils.toJavaStringAt(item.getSubterm(1), 0);
                    TransformActionFlags actionFlags = ActionFacetFromESV.flags(item.getSubterm(2));
                    TransformActionFlags mergedActionFlags = TransformActionFlags.merge(mergedFlags, actionFlags);
                    ImmutableList newActionNesting = ImmutableList.builder().addAll((Iterable)newNesting).add((Object)actionName).build();
                    NamedGoal goal = new NamedGoal((List<String>)newActionNesting);
                    TransformAction action = new TransformAction(actionName, goal, mergedActionFlags, strategy);
                    actions.put((Object)goal, (Object)action);
                    actions.put((Object)new EndNamedGoal(goal.names.get(goal.names.size() - 1)), (Object)action);
                    MenuAction menuAction = new MenuAction(action);
                    menu.add(menuAction);
                    break;
                }
                case "Separator": {
                    Separator separator = new Separator();
                    menu.add(separator);
                    break;
                }
                default: {
                    logger.warn("Unhandled menu item term {}", item);
                }
            }
        }
        return menu;
    }

    private static String name(IStrategoTerm nameTerm) {
        IStrategoTerm term = TermUtils.isAppl(nameTerm, "Label") ? nameTerm.getSubterm(0) : nameTerm;
        return ESVReader.termContents(term);
    }

    private static TransformActionFlags flags(Iterable<IStrategoTerm> flagTerms) {
        TransformActionFlags flags = new TransformActionFlags();
        for (IStrategoTerm flagTerm : flagTerms) {
            String constructor = TermUtils.asAppl(flagTerm).map(t -> t.getConstructor().getName()).orElse(null);
            if (constructor == null) {
                logger.error("Could not interpret flag from term {}", flagTerm);
                continue;
            }
            switch (constructor) {
                case "Source": {
                    flags.parsed = true;
                    break;
                }
                case "OpenEditor": {
                    flags.openEditor = true;
                    break;
                }
                case "RealTime": {
                    flags.realtime = true;
                    break;
                }
                default: {
                    logger.warn("Unhandled flag term {}", flagTerm);
                }
                case "Meta": 
            }
        }
        return flags;
    }

    private static void addCompileGoal(IStrategoAppl esv, Multimap<ITransformGoal, ITransformAction> actions) {
        ArrayList<IStrategoAppl> onSaveHandlers = ESVReader.collectTerms(esv, "OnSave");
        if (onSaveHandlers.isEmpty()) {
            return;
        }
        for (IStrategoAppl onSaveHandler : onSaveHandlers) {
            String strategyName = TermUtils.toJavaStringAt(onSaveHandler.getSubterm(0), 0);
            CompileGoal goal = new CompileGoal();
            TransformAction action = new TransformAction("Compile", goal, new TransformActionFlags(), strategyName);
            actions.put((Object)goal, (Object)action);
        }
    }
}

