/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Set;
import mb.nabl2.terms.ITerm;
import mb.statix.spec.Rule;
import mb.statix.spec.RuleSet;
import mb.statix.spec.Spec;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.metaborg.util.tuple.Tuple2;

@Value.Immutable
@Serial.Version(value=42L)
public abstract class ASpec {
    @Value.Parameter
    public abstract RuleSet rules();

    @Value.Parameter
    public abstract Set<ITerm> edgeLabels();

    @Value.Parameter
    public abstract Set<ITerm> dataLabels();

    @Value.Lazy
    public Set<ITerm> allLabels() {
        return Sets.union(this.edgeLabels(), this.dataLabels());
    }

    @Value.Parameter
    public abstract SetMultimap<String, Tuple2<Integer, ITerm>> scopeExtensions();

    @Value.Default
    public boolean hasPrecomputedCriticalEdges() {
        return false;
    }

    public Spec precomputeCriticalEdges() {
        return Spec.of(this.rules().precomputeCriticalEdges(this.scopeExtensions()), this.edgeLabels(), this.dataLabels(), this.scopeExtensions()).withHasPrecomputedCriticalEdges(true);
    }

    public static Spec of() {
        return Spec.of(new RuleSet((ListMultimap<String, Rule>)ImmutableListMultimap.of()), (Set<ITerm>)ImmutableSet.of(), (Set<ITerm>)ImmutableSet.of(), (SetMultimap<String, Tuple2<Integer, ITerm>>)ImmutableSetMultimap.of());
    }
}

