/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import oracle.pgx.api.ClientContext;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PoolType;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.admin.internal.AbstractControl;
import oracle.pgx.api.admin.internal.InternalControl;
import oracle.pgx.api.internal.ClientSessionContext;
import oracle.pgx.client.AbstractAsyncRequest;
import oracle.pgx.client.HeaderBuilder;
import oracle.pgx.client.HttpRequestExecutor;
import oracle.pgx.client.RemoteCoreImpl;
import oracle.pgx.client.RemoteResponse;
import oracle.pgx.client.RemoteUtils;
import oracle.pgx.common.MemoryUnit;
import oracle.pgx.common.VersionInfo;
import oracle.pgx.common.auth.PgxGenericPermission;
import oracle.pgx.common.marshalers.GenericMarshaler;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.marshalers.Marshalers;
import oracle.pgx.common.pojo.CacheStatisticsRequest;
import oracle.pgx.common.pojo.ControlConfigUpdateRequest;
import oracle.pgx.common.pojo.ControlSessionMaxMemoryRequest;
import oracle.pgx.common.pojo.ControlShutdownRequest;
import oracle.pgx.common.pojo.ControlStartRequest;
import oracle.pgx.common.pojo.PoolRequest;
import oracle.pgx.common.pojo.UnsafeHttpMethodRequest;
import oracle.pgx.common.pojo.admin.CacheStatistics;
import oracle.pgx.common.pojo.admin.GraphInfo;
import oracle.pgx.common.pojo.admin.JoinMachineRequest;
import oracle.pgx.common.pojo.admin.MemoryInfo;
import oracle.pgx.common.pojo.admin.PoolInfo;
import oracle.pgx.common.pojo.admin.ResourceElasticityStatus;
import oracle.pgx.common.pojo.admin.SessionInfo;
import oracle.pgx.common.pojo.admin.UnpinGraphRequest;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.LinkTemplate;
import oracle.pgx.config.PgxConfig;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.fluent.Executor;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.client5.http.fluent.Response;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteControlImpl
extends AbstractControl {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteCoreImpl.class);
    private static final SessionContext REMOTE_CONTROL_SESSION_CONTEXT = new SessionContext(){

        public String getSessionId() {
            return null;
        }

        public String getStickyCookieValue() {
            return null;
        }
    };
    private final String baseUrl;
    private final String versionUrl;
    private final ClientContext context;
    private final String csrfToken;
    private final URI baseUri;

    private <T> PgxFuture<T> request(ControlRequest<T> request) {
        return request.execute();
    }

    public RemoteControlImpl(ClientContext context) {
        this.context = context;
        this.csrfToken = context.getCsrfToken();
        String url = context.getConfig().getCleanedBaseUrl();
        LOG.info("initializing PGX client with base URL {}", (Object)url);
        this.baseUri = URI.create(url);
        LOG.info("initializing PGX client with base URL {}", (Object)url);
        this.baseUrl = url;
        this.versionUrl = url + "/version";
    }

    public PgxFuture<String> getVersion() {
        return this.doSyncRequest(Request.get((String)this.versionUrl), (Marshaler)Marshalers.STRING_MARSHALER);
    }

    public PgxFuture<VersionInfo> getExtendedVersion() {
        return RemoteUtils.asyncRequest(this.context.getExecutorService(), () -> {
            Response response;
            GenericMarshaler versionMarshaler = new GenericMarshaler(VersionInfo.class);
            Executor httpExecutor = RemoteUtils.newHttpExecutor(this.context.getHttpClient(), this.baseUrl, null, this.context.getCsrfToken(), this.context.getClientStickyCookie());
            try {
                URIBuilder builder = new URIBuilder(this.versionUrl);
                builder.addParameter("extendedInfo", "true");
                Request request = Request.get((URI)builder.build());
                response = httpExecutor.execute(request);
            }
            catch (URISyntaxException e) {
                throw new MalformedURLException("Error " + e.getMessage());
            }
            return (VersionInfo)RemoteUtils.parse(response, versionMarshaler);
        });
    }

    public PgxFuture<Map<PgxConfig.Field, Object>> getPgxConfig() {
        return this.request(new ControlRequest<Map<PgxConfig.Field, Object>>((Marshaler)Marshalers.PGX_CONFIG_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException, RemoteUtils.RequestPendingException {
                return executor.get(LinkTemplate.PGX_CONFIG.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> start(final String json, final String keystorePath, final char[] keystorePassword, boolean runPostStart, InternalControl.DeferredPreloadedGraphLoadedCallback callback) {
        assert (runPostStart);
        assert (callback == null);
        ErrorMessages.requireNonNull((Object)json, (String)"json");
        return this.request(new ControlRequest<Void>((Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException, RemoteUtils.RequestPendingException {
                ControlStartRequest request = new ControlStartRequest();
                request.json = json;
                request.keystorePath = keystorePath;
                request.keystorePassword = keystorePassword;
                request.startWithJson = true;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.START_ENGINE.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> postStart(InternalControl.DeferredPreloadedGraphLoadedCallback callback) {
        return PgxFuture.exceptionallyCompletedFuture((Throwable)new UnsupportedOperationException("should not be called"));
    }

    public PgxFuture<Boolean> isRunning() {
        return this.request(new ControlRequest<Boolean>((Marshaler)Marshalers.BOOLEAN_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException, RemoteUtils.RequestPendingException {
                return executor.get(LinkTemplate.ENGINE_IS_RUNNING.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Boolean> isReady() {
        return this.request(new ControlRequest<Boolean>((Marshaler)Marshalers.BOOLEAN_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException, RemoteUtils.RequestPendingException {
                return executor.get(LinkTemplate.ENGINE_IS_READY.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Boolean> isGraphPreloadingDone() {
        return this.request(new ControlRequest<Boolean>((Marshaler)Marshalers.BOOLEAN_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException, RemoteUtils.RequestPendingException {
                return executor.get(LinkTemplate.IS_GRAPH_PRELOADING_DONE.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Boolean> shutdown(final long timeout, final TimeUnit unit) {
        ErrorMessages.requireNonNull((Object)timeout, (String)"timeout");
        ErrorMessages.requireNonNull((Object)((Object)unit), (String)"unit");
        return this.request(new ControlRequest<Boolean>((Marshaler)Marshalers.BOOLEAN_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException, RemoteUtils.RequestPendingException {
                ControlShutdownRequest request = new ControlShutdownRequest();
                request.timeout = String.valueOf(timeout);
                request.timeUnit = String.valueOf((Object)unit);
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.SHUTDOWN_ENGINE.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> shutdownNow() {
        return this.request(new ControlRequest<Void>((Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException, RemoteUtils.RequestPendingException {
                ControlShutdownRequest request = new ControlShutdownRequest();
                request.forceShutdown = true;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.SHUTDOWN_ENGINE.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Collection<SessionInfo>> getSessionInfos() {
        return this.request(new ControlRequest<Collection<SessionInfo>>((Marshaler)Marshalers.SESSION_INFO_COLLECTION_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException, RemoteUtils.RequestPendingException {
                return executor.get(LinkTemplate.SESSIONS_INFOS.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Collection<GraphInfo>> getGraphInfos() {
        return this.request(new ControlRequest<Collection<GraphInfo>>((Marshaler)Marshalers.GRAPH_INFO_COLLECTION_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException, RemoteUtils.RequestPendingException {
                return executor.get(LinkTemplate.SHARED_GRAPHS.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<SessionInfo> getSessionInfo(String sessionId) {
        return this.getSessionInfo((SessionContext)new ClientSessionContext(sessionId, null));
    }

    public PgxFuture<SessionInfo> getSessionInfo(final SessionContext sessionContext) {
        ErrorMessages.requireNonNull((Object)sessionContext, (String)"sessionContext");
        ErrorMessages.requireNonNull((Object)sessionContext.getSessionId(), (String)"sessionId");
        return this.request(new ControlRequest<SessionInfo>((Marshaler)Marshalers.SESSION_INFO_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                String sessionId = sessionContext.getSessionId();
                String stickyCookieValue = sessionContext.getStickyCookieValue();
                if (stickyCookieValue != null) {
                    RemoteUtils.validateStickyCookieValue(stickyCookieValue);
                    CookieStore cookieStore = RemoteUtils.createCookieStore(RemoteControlImpl.this.baseUrl, null, RemoteControlImpl.this.csrfToken, RemoteControlImpl.this.context.getClientStickyCookie());
                    cookieStore.addCookie(RemoteUtils.createCookie(RemoteControlImpl.this.baseUrl, "PGX_SESSION_STICKY_COOKIE", stickyCookieValue));
                    this.getHttpExecutor().use(cookieStore);
                }
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-session-id", sessionId);
                return executor.get(headers, LinkTemplate.SESSION_SELF.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<GraphInfo> getGraphInfo(final String graphName) {
        ErrorMessages.requireNonNull((Object)graphName, (String)"graphName");
        return this.request(new ControlRequest<GraphInfo>((Marshaler)Marshalers.GRAPH_INFO_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException, RemoteUtils.RequestPendingException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-graph-name", graphName);
                return executor.get(headers, LinkTemplate.SHARED_GRAPH_INFO.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<GraphInfo> getGraphInfo(final String sessionId, final String graphName) {
        ErrorMessages.requireNonNull((Object)sessionId, (String)"sessionId");
        ErrorMessages.requireNonNull((Object)graphName, (String)"graphName");
        return this.request(new ControlRequest<GraphInfo>((Marshaler)Marshalers.GRAPH_INFO_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException, RemoteUtils.RequestPendingException {
                List<NameValuePair> headers = new HeaderBuilder().addHeader("x-graph-name", graphName).addHeader("x-session-id", sessionId).build();
                return executor.get(headers, LinkTemplate.GRAPH_INFO.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<CacheStatistics> freeCachedMemory() {
        return this.request(new ControlRequest<CacheStatistics>((Marshaler)Marshalers.CACHE_STATISTICS_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException, RemoteUtils.RequestPendingException {
                CacheStatisticsRequest request = new CacheStatisticsRequest();
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.MEMORY_CLEANUP.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<CacheStatistics> freeCachedMemory(final double threshold) {
        return this.request(new ControlRequest<CacheStatistics>((Marshaler)Marshalers.CACHE_STATISTICS_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException, RemoteUtils.RequestPendingException {
                CacheStatisticsRequest request = new CacheStatisticsRequest(threshold);
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.MEMORY_CLEANUP.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> unpinGraph(final String graphName) {
        return this.request(new ControlRequest<Void>((Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor httpExecutor) throws IOException, ExecutionException, RemoteUtils.RequestPendingException {
                UnpinGraphRequest request = new UnpinGraphRequest();
                request.graphName = graphName;
                return httpExecutor.post((UnsafeHttpMethodRequest)request, LinkTemplate.ADMIN_UNPIN.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<MemoryInfo> getMemoryInfo() {
        return this.request(new ControlRequest<MemoryInfo>((Marshaler)Marshalers.MEMORY_INFO_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException, RemoteUtils.RequestPendingException {
                return executor.get(LinkTemplate.MEMORY_INFO.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<PoolInfo> getThreadPoolInfo(final PoolType type) {
        ErrorMessages.requireNonNull((Object)type, (String)"type");
        return this.request(new ControlRequest<PoolInfo>((Marshaler)Marshalers.POOL_INFO_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException, RemoteUtils.RequestPendingException {
                PoolRequest request = new PoolRequest();
                request.poolType = type;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.THREAD_POOL_INFO.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<JsonNode> getServerState() {
        return this.request(new ControlRequest<JsonNode>((Marshaler)Marshalers.JSON_NODE_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException, RemoteUtils.RequestPendingException {
                return executor.getWithHeaders(LinkTemplate.SERVER_STATE.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]), "Prefer", "respond-async");
            }
        });
    }

    public PgxFuture<Void> killSession(final String sessionId) {
        ErrorMessages.requireNonNull((Object)sessionId, (String)"sessionId");
        return this.request(new ControlRequest<Void>((Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException, RemoteUtils.RequestPendingException {
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-session-id", sessionId);
                return executor.delete(headers, LinkTemplate.SESSION_SELF.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> updatePgxConfig(final String json) {
        ErrorMessages.requireNonNull((Object)json, (String)"json");
        return this.request(new ControlRequest<Void>((Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ControlConfigUpdateRequest request = new ControlConfigUpdateRequest();
                request.updateWithJson = true;
                request.json = json;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.UPDATE_PGX_CONFIG.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> updatePgxConfig(final Map<PgxConfig.Field, Object> config) {
        ErrorMessages.requireNonNull(config, (String)"config");
        return this.request(new ControlRequest<Void>((Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ControlConfigUpdateRequest request = new ControlConfigUpdateRequest();
                request.updateWithJson = false;
                request.mapConfig = config;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.UPDATE_PGX_CONFIG.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Void> setSessionMaxMemorySize(final String sessionId, final int size, final MemoryUnit unit) {
        ErrorMessages.requireNonNull((Object)sessionId, (String)"sessionId");
        return this.request(new ControlRequest<Void>((Marshaler)Marshalers.VOID_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                ControlSessionMaxMemoryRequest request = new ControlSessionMaxMemoryRequest();
                request.size = size;
                request.memoryUnit = unit.toString();
                List<NameValuePair> headers = HeaderBuilder.singleHeader("x-session-id", sessionId);
                return executor.post(headers, (UnsafeHttpMethodRequest)request, LinkTemplate.MAX_SESSION_MEMORY_LIMIT.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<String> getUsername() {
        return this.request(new ControlRequest<String>((Marshaler)Marshalers.WRAPPED_STRING_MARSHALER){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                return executor.get(LinkTemplate.CURRENT_USER_NAME.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Set<String>> getUserRoles() {
        return this.request(new ControlRequest<Set<String>>((Marshaler)Marshalers.STRING_SET_MARSHALER){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                return executor.get(LinkTemplate.CURRENT_USER_ROLES.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<Set<PgxGenericPermission>> getSystemPermissions() {
        return this.request(new ControlRequest<Set<PgxGenericPermission>>((Marshaler)Marshalers.GENERIC_PERMISSION_SET_MARSHALER){

            @Override
            RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                return executor.get(LinkTemplate.CURRENT_USER_SYSTEM_PERMISSIONS.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    private <T> PgxFuture<T> doSyncRequest(Request request, Marshaler<T> marshaler) {
        return RemoteUtils.asyncRequest(this.context.getExecutorService(), () -> {
            Executor httpExecutor = RemoteUtils.newHttpExecutor(this.context.getHttpClient(), this.baseUrl, null, this.context.getCsrfToken(), this.context.getClientStickyCookie());
            Response response = httpExecutor.execute(request);
            return RemoteUtils.parse(response, marshaler);
        });
    }

    public void addUserData(String sessionId, String key, Object data) {
        throw new RuntimeException("RemoteControlImpl does not support addUserData");
    }

    public Object getUserData(SessionContext sessionContext, String key) {
        throw new RuntimeException("RemoteControlImpl does not support getUserData");
    }

    public PgxFuture<JsonNode> joinMachine(final String hostname) {
        return this.request(new ControlRequest<JsonNode>((Marshaler)Marshalers.JSON_NODE_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                JoinMachineRequest request = new JoinMachineRequest();
                request.hostname = hostname;
                return executor.post((UnsafeHttpMethodRequest)request, LinkTemplate.JOIN_MACHINE.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    public PgxFuture<ResourceElasticityStatus> getResourceElasticityStatus() {
        return this.request(new ControlRequest<ResourceElasticityStatus>((Marshaler)Marshalers.RESOURCE_ELASTICITY_STATUS_MARSHALER){

            @Override
            public RemoteResponse request(HttpRequestExecutor executor) throws IOException, ExecutionException {
                return executor.get(LinkTemplate.GET_RESOURCE_ELASTICITY_STATUS.generateUrl(RemoteControlImpl.this.baseUri, new Object[0]));
            }
        });
    }

    private abstract class ControlRequest<T>
    extends AbstractAsyncRequest<T> {
        ControlRequest(Marshaler<T> marshaler) {
            super(RemoteControlImpl.this.context, marshaler, RemoteControlImpl.this.baseUrl, REMOTE_CONTROL_SESSION_CONTEXT, true);
        }

        @Override
        public final RemoteResponse request() throws IOException, ExecutionException, InterruptedException, RemoteUtils.RequestPendingException {
            return this.request(this.getHttpRequestExecutor());
        }

        abstract RemoteResponse request(HttpRequestExecutor var1) throws IOException, ExecutionException, InterruptedException, RemoteUtils.RequestPendingException;
    }
}

