/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common.loader;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import oracle.pg.common.SimpleLog;
import org.apache.commons.io.FilenameUtils;

public class DelayedFileOutputStream
extends OutputStream {
    static SimpleLog ms_log = SimpleLog.getLog(DelayedFileOutputStream.class);
    String m_fileName;
    FileOutputStream m_fos = null;

    public DelayedFileOutputStream(String fileName) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"DelayedFileOutputStream: constructor with file ", fileName);
        }
        this.m_fileName = fileName;
    }

    private void openIfNecessary() throws IOException {
        if (this.m_fos == null) {
            if (Thread.interrupted()) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("openIfNecessary: Thread already interrupted");
                }
                throw new IOException("openIfNecessary: thread already interrupted");
            }
            String normalizedFileName = FilenameUtils.normalize((String)this.m_fileName);
            this.m_fos = new FileOutputStream(normalizedFileName, true);
        }
    }

    @Override
    public void close() throws IOException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("close: starts");
        }
        this.openIfNecessary();
        this.m_fos.close();
    }

    @Override
    public void flush() throws IOException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("flush: starts");
        }
        this.openIfNecessary();
        this.m_fos.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.openIfNecessary();
        this.m_fos.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.openIfNecessary();
        this.m_fos.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.openIfNecessary();
        this.m_fos.write(b);
    }
}

