/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import oracle.pg.common.OracleElement;
import oracle.pg.common.OracleElementHelper;
import oracle.pg.common.OraclePropertyBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.OracleVertexBase;

public class OracleVertexPropertyBase<V>
extends OraclePropertyBase<V>
implements OracleElement {
    protected String m_key;
    protected V m_value;
    protected OracleVertexBase m_vertex;

    public OracleVertexPropertyBase(OracleVertexBase oracleVertex, String key, V value) {
        super(oracleVertex, key, value);
        this.m_key = key;
        this.m_value = value;
        this.m_vertex = oracleVertex;
    }

    @Override
    public boolean isPresent() {
        return null != this.m_value;
    }

    @Override
    public String key() {
        return this.m_key;
    }

    @Override
    public void remove() {
        this.m_vertex.removeProperty(this.m_key);
    }

    @Override
    public V value() throws NoSuchElementException {
        return this.m_value;
    }

    @Override
    public OraclePropertyGraphBase graph() {
        return this.graph();
    }

    @Override
    public Object id() {
        return (long)(this.m_key.hashCode() + this.m_value.hashCode() + this.m_vertex.id().hashCode());
    }

    @Override
    public String label() {
        return this.m_vertex.label();
    }

    @Override
    public <V> OraclePropertyBase<V> property(String key, V value) {
        throw new OraclePropertyGraphException("not supported yet");
    }

    @Override
    public OracleVertexBase element() {
        return this.m_vertex;
    }

    public <U> Iterator<OraclePropertyBase<U>> properties(String ... propertyKeys) {
        return Collections.emptyIterator();
    }

    @Override
    public boolean equals(Object object) {
        return OracleElementHelper.areEqual(this, object);
    }

    @Override
    public int hashCode() {
        return OracleElementHelper.hashCode(this);
    }

    @Override
    public String toString() {
        if (!this.isPresent()) {
            return "vp[empty]";
        }
        String valueString = String.valueOf(this.value());
        return "vp[" + this.key() + "->" + valueString.substring(0, Math.min(valueString.length(), 20)) + "]";
    }
}

