/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.pg.common.OracleElement;
import oracle.pg.common.OracleElementHelper;
import oracle.pg.common.OraclePropertyBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.ParametersBase;
import oracle.pg.common.SimpleJsonDataWrapper;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.SimpleRdfDataWrapper;
import oracle.pg.common.SimpleSpatialDataWrapper;

public abstract class OracleElementBase
implements OracleElement {
    static SimpleLog ms_log = SimpleLog.getLog(OracleElementBase.class);
    private boolean ms_bDebug = ms_log.isDebugEnabled();
    protected OraclePropertyGraphBase m_opg = null;
    protected Long m_lID = null;
    private OracleElement.FLAG m_flag = OracleElement.FLAG.UNKNOWN;
    private String[] m_szKeys = null;
    private Object[] m_objVals = null;
    private HashMap<String, List<Object>> m_hmDeletedKeys = null;
    private HashMap<String, Object> m_hmAddedKeys = null;
    private int m_iKVIdx;
    protected boolean m_bPartial = false;
    boolean m_bCreatedWithOptFlag = false;
    private volatile boolean m_bNeedToRecreateKeySets = false;
    private HashSet<String> m_hsKeys = null;
    private HashSet<String> m_hsKeysSnapshot = null;
    static final Set<String> ms_setEmpty = new HashSet<String>();

    public OracleElementBase() {
        ms_log.debug("OracleElementBase: Constructor start");
        int iArraySize = ParametersBase.getInstance().getInitialKVAS();
        this.m_szKeys = new String[iArraySize];
        this.m_objVals = new Object[iArraySize];
        this.m_hmDeletedKeys = new HashMap();
        this.m_hmAddedKeys = new HashMap();
        this.cleanup();
    }

    public OracleElementBase(OraclePropertyGraphBase opg, Long id) {
        this();
        this.m_opg = opg;
        this.m_lID = id;
    }

    boolean getCreatedWithOptFlag() {
        return this.m_bCreatedWithOptFlag;
    }

    public void setCreatedWithOptFlag(boolean bFlag) {
        this.m_bCreatedWithOptFlag = bFlag;
    }

    @Override
    public OraclePropertyGraphBase graph() {
        return this.m_opg;
    }

    public final void setGraph(OraclePropertyGraphBase opg) {
        this.m_opg = opg;
    }

    @Override
    public final Object id() {
        if (ms_log.isDebugEnabled() && ParametersBase.getInstance().isSuperVerboseOn()) {
            ms_log.debug("id: start");
        }
        return this.m_lID;
    }

    public boolean isPartial() {
        return this.m_bPartial;
    }

    public void setPartial(boolean partial) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"setPartial: partial ", partial ? "true" : "false");
        }
        this.m_bPartial = partial;
    }

    public void refresh() {
        if (this.m_bPartial) {
            ms_log.debug("refresh: force refresh");
            try {
                if (!this.getCreatedWithOptFlag()) {
                    this.forceRefresh();
                }
            }
            catch (Exception ioe) {
                ms_log.debug((Object)"refresh: hit ioe ", ioe);
                throw new OraclePropertyGraphException(ioe);
            }
            ms_log.debug("refresh: done force refresh");
            this.m_bPartial = false;
        } else {
            ms_log.debug("refresh: m_bPartial false, no op");
        }
    }

    public abstract void forceRefresh() throws Exception;

    protected final void cleanup() {
        ms_log.debug("cleanup: start/initialize");
        for (int idx = 0; idx < this.m_szKeys.length; ++idx) {
            this.m_szKeys[idx] = null;
            this.m_objVals[idx] = null;
        }
        this.m_iKVIdx = 0;
        this.cleanUpAddedDeletedKeys();
    }

    protected void cleanUpAddedDeletedKeys() {
        if (this.m_hmDeletedKeys.size() > 0) {
            this.m_hmDeletedKeys.clear();
        }
        if (this.m_hmAddedKeys.size() > 0) {
            this.m_hmAddedKeys.clear();
        }
        this.m_iKVIdx = 0;
    }

    public Set<String> getAddedKeys() {
        return this.m_hmAddedKeys.keySet();
    }

    public void clearDeletedKeys() {
        this.m_hmDeletedKeys.clear();
    }

    public Object propertyValue(String key) {
        this.refresh();
        Object obj = null;
        for (int idx = 0; idx < this.m_iKVIdx; ++idx) {
            if (!this.m_szKeys[idx].equals(key)) continue;
            ms_log.debug("getProperty: found a match");
            obj = this.m_objVals[idx];
            break;
        }
        return obj;
    }

    public Set<String> keys() {
        ms_log.debug("keys: start ");
        this.refresh();
        if (this.m_iKVIdx == 0) {
            return ms_setEmpty;
        }
        if (this.m_hsKeys == null) {
            this.m_bNeedToRecreateKeySets = true;
            this.m_hsKeys = new HashSet(this.m_iKVIdx);
            ms_log.debug("keys: build a new Set");
            for (int idx = 0; idx < this.m_iKVIdx; ++idx) {
                this.m_hsKeys.add(this.m_szKeys[idx]);
            }
        }
        if (this.m_bNeedToRecreateKeySets) {
            this.m_hsKeysSnapshot = new HashSet<String>(this.m_hsKeys);
            this.m_bNeedToRecreateKeySets = false;
        }
        return this.m_hsKeysSnapshot;
    }

    public List<Object> getDeletedProperties(String key) {
        return this.m_hmDeletedKeys.get(key);
    }

    protected List<Object> clearDeletedProperties(String key) {
        return this.m_hmDeletedKeys.remove(key);
    }

    public Set<String> getDeletedKeys() {
        return this.m_hmDeletedKeys.keySet();
    }

    public void clearAddedKeys() {
        this.m_hmAddedKeys.clear();
    }

    public final void property(String key, Object value, boolean skipQueue) {
        this.propertyCommon(key, value, skipQueue);
    }

    public final void propertyCommon(String key, Object value, boolean skipQueue) {
        this.propertyCommon(key, value, skipQueue, false);
    }

    protected void propertyCommon(String key, Object value, boolean skipQueue, boolean skipLucene) {
        if (!skipQueue && this.m_opg.isTransientPropertyGraphInstance()) {
            throw new OraclePropertyGraphException("Property Graph is a transient graph, no update operations allowed");
        }
        OracleElementHelper.validateProperty(key, value);
        if (key.equals("_vertexLabel")) {
            throw new IllegalArgumentException("key cannot be vertex label identifier[_vertexLabel] for element with ID " + (this.m_lID == null ? "null" : this.m_lID));
        }
        ms_log.debug((Object)"propertyCommon: value class is ", value.getClass().getName());
        if (!(value instanceof String || value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Float || value instanceof Date || value instanceof Boolean || value instanceof Serializable || value instanceof SimpleSpatialDataWrapper || value instanceof SimpleRdfDataWrapper || value instanceof SimpleJsonDataWrapper)) {
            throw new IllegalArgumentException("value type not accepted " + value.getClass().getName() + " for element with ID " + (this.m_lID == null ? "null" : this.m_lID));
        }
        boolean bObjUpdated = false;
        boolean bFoundMatch = false;
        Object oldValue = null;
        for (int idx = 0; idx < this.m_iKVIdx; ++idx) {
            if (!this.m_szKeys[idx].equals(key)) continue;
            bFoundMatch = true;
            if (this.m_objVals[idx] == value || this.m_objVals[idx].equals(value)) {
                ms_log.debug("propertyCommon: found a match, but the same object. Skip.");
                break;
            }
            ms_log.debug("propertyCommon: found a match, different object. Update.");
            oldValue = this.m_objVals[idx];
            this.m_objVals[idx] = value;
            bObjUpdated = true;
            break;
        }
        if (!bFoundMatch) {
            if (this.m_iKVIdx >= this.m_szKeys.length) {
                int iCurrentSize = this.m_szKeys.length;
                int iNewSize = iCurrentSize + ParametersBase.getInstance().getGrowthKVAS();
                if (this.ms_bDebug) {
                    ms_log.debug("propertyCommon: grow array from " + iCurrentSize + " => " + iNewSize);
                }
                String[] saNew = new String[iNewSize];
                Object[] oaNew = new Object[iNewSize];
                System.arraycopy(this.m_szKeys, 0, saNew, 0, iCurrentSize);
                System.arraycopy(this.m_objVals, 0, oaNew, 0, iCurrentSize);
                this.m_szKeys = saNew;
                this.m_objVals = oaNew;
            }
            this.m_szKeys[this.m_iKVIdx] = key;
            this.m_objVals[this.m_iKVIdx] = value;
            if (this.m_hsKeys != null) {
                this.m_hsKeys.add(key);
            }
            this.m_bNeedToRecreateKeySets = true;
            ++this.m_iKVIdx;
        }
        if (skipQueue) {
            ms_log.debug("setPropertyCommon: skip queue true");
        } else if (bObjUpdated || !bFoundMatch) {
            if (this.m_hmDeletedKeys != null) {
                List<Object> values;
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("setPropertyCommon: update deleted key/values for secondary index update");
                    ms_log.debug("setPropertyCommon: key: ----");
                }
                if ((values = this.m_hmDeletedKeys.get(key)) == null) {
                    values = new ArrayList<Object>();
                }
                if (values.contains(value)) {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug((Object)"setPropertyCommon: remove new value from list of properties ", " to remove from secondary index");
                        ms_log.debug("setPropertyCommon: new value: ");
                    }
                    values.remove(value);
                    this.m_hmDeletedKeys.put(key, values);
                }
                if (oldValue != null && !values.contains(oldValue)) {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug((Object)"setPropertyCommon: add old value to list of properties ", " to remove from secondary index");
                        ms_log.debug("setPropertyCommon: new value: ----");
                    }
                    values.add(oldValue);
                    this.m_hmDeletedKeys.put(key, values);
                }
            }
            if (this.m_hmAddedKeys != null) {
                ms_log.debug("setPropertyCommon: add key to added keys list");
                this.m_hmAddedKeys.put(key, value);
            }
            if (skipLucene) {
                this.m_opg.addUpdatedElement(this);
            } else {
                this.m_opg.addUpdatedElementWithIndices(this);
            }
        }
    }

    public final void property(String key, Object value, boolean skipQueue, boolean skipLucene) {
        this.propertyCommon(key, value, skipQueue, skipLucene);
    }

    public abstract <V> OraclePropertyBase<V> property(String var1);

    public final Object removeProperty(String key) {
        if (this.m_opg.isTransientPropertyGraphInstance()) {
            throw new OraclePropertyGraphException("Property Graph is a transient graph, no update operations allowed");
        }
        this.refresh();
        boolean bFoundMatch = false;
        int iMatchIdx = 0;
        for (int idx = 0; idx < this.m_iKVIdx; ++idx) {
            if (!this.m_szKeys[idx].equals(key)) continue;
            iMatchIdx = idx;
            bFoundMatch = true;
            break;
        }
        if (!bFoundMatch) {
            ms_log.debug("removeProperty: no match for key. return directly");
            return null;
        }
        Object obj = this.m_objVals[iMatchIdx];
        if (this.m_hsKeys != null) {
            this.m_hsKeys.remove(key);
        }
        if (this.m_hmAddedKeys != null && this.m_hmAddedKeys.containsKey(key)) {
            ms_log.debug("removeProperty: remove key from added keys");
            this.m_hmAddedKeys.remove(key);
        }
        if (this.m_hmDeletedKeys != null) {
            List<Object> values;
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"removeProperty: add value to list of properties ", " to remove from secondary index");
                ms_log.debug("removeProperty: value: " + obj);
                ms_log.debug("removeProperty: key: " + key);
            }
            if ((values = this.m_hmDeletedKeys.get(key)) == null) {
                values = new ArrayList<Object>();
            }
            if (!values.contains(obj)) {
                values.add(obj);
                this.m_hmDeletedKeys.put(key, values);
            }
        }
        for (int idx = iMatchIdx; idx < this.m_iKVIdx - 1; ++idx) {
            this.m_szKeys[idx] = this.m_szKeys[idx + 1];
            this.m_objVals[idx] = this.m_objVals[idx + 1];
        }
        this.m_szKeys[idx] = null;
        this.m_objVals[idx] = null;
        --this.m_iKVIdx;
        this.m_opg.addUpdatedElementWithIndices(this);
        this.m_bNeedToRecreateKeySets = true;
        return obj;
    }

    public final String getAttributes() {
        this.refresh();
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int idx = 0; idx < this.m_iKVIdx; ++idx) {
            if (idx > 0) {
                sb.append(", ");
            }
            sb.append(this.m_szKeys[idx]);
            sb.append(":").append(OraclePropertyGraphBase.getStringForObj(this.m_objVals[idx]));
        }
        sb.append("}");
        return sb.toString();
    }

    public final void setFlag(OracleElement.FLAG f) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("setFlag: flag set change from " + (Object)((Object)this.m_flag) + " to " + (Object)((Object)f));
        }
        this.m_flag = f;
    }

    public final OracleElement.FLAG getFlag() {
        return this.m_flag;
    }

    final boolean validateDateTypes(Object obj, Object obj1) {
        String strObj = this.getDateAsStr(obj);
        String strObj1 = this.getDateAsStr(obj1);
        if (strObj == null || strObj1 == null) {
            return false;
        }
        return strObj.equals(strObj1);
    }

    final String getDateAsStr(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof OffsetDateTime) {
            return ((OffsetDateTime)obj).format(OraclePropertyGraphBase.getDateTimeFormatter());
        }
        if (obj instanceof OffsetTime) {
            return ((OffsetTime)obj).format(OraclePropertyGraphBase.getDateTimeFormatter());
        }
        if (obj instanceof LocalDateTime) {
            return ((LocalDateTime)obj).format(OraclePropertyGraphBase.getDateTimeFormatter());
        }
        if (obj instanceof LocalDateTime) {
            return ((LocalDateTime)obj).format(OraclePropertyGraphBase.getDateTimeFormatter());
        }
        if (obj instanceof LocalTime) {
            return ((LocalTime)obj).format(OraclePropertyGraphBase.getDateTimeFormatter());
        }
        if (obj instanceof LocalDate) {
            return ((LocalDate)obj).format(OraclePropertyGraphBase.getDateTimeFormatter());
        }
        if (obj instanceof Instant) {
            return ((Instant)obj).atOffset(ZoneOffset.UTC).format(OraclePropertyGraphBase.getDateTimeFormatter());
        }
        if (obj instanceof Date) {
            return ((Date)obj).toInstant().atOffset(ZoneOffset.UTC).format(OraclePropertyGraphBase.getDateTimeFormatter());
        }
        return null;
    }
}

