/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.common;

import oracle.pg.common.OraclePropertyGraphException;

public class OracleCommonUtils {
    public static int revolve(int hash, int oldHash) {
        return hash ^ oldHash;
    }

    public static String unescapeLiteral(String s) {
        if (s == null) {
            return s;
        }
        return OracleCommonUtils.unescape(s, '\\', false, 1, 1);
    }

    private static String unescape(String s, char escape, boolean pointCodeOnly, int line, int column) {
        int i = s.indexOf(escape);
        if (i == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.substring(0, i));
        int len = s.length();
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': {
                    ++line;
                    column = 1;
                    break;
                }
                default: {
                    ++column;
                }
            }
            if (ch != escape) {
                sb.append(ch);
            } else {
                int x;
                if (i >= len - 1) {
                    throw new OraclePropertyGraphException("Illegal escape at end of string");
                }
                char ch2 = s.charAt(i + 1);
                ++column;
                ++i;
                if (ch2 == 'u') {
                    if (i + 4 >= len) {
                        throw new OraclePropertyGraphException("\\u escape too short");
                    }
                    x = OracleCommonUtils.hex(s, i + 1, 4, line, column);
                    sb.append((char)x);
                    i += 4;
                    column += 4;
                } else if (ch2 == 'U') {
                    if (i + 8 >= len) {
                        throw new OraclePropertyGraphException("\\U escape too short");
                    }
                    x = OracleCommonUtils.hex(s, i + 1, 8, line, column);
                    sb.append((char)x);
                    i += 8;
                    column += 8;
                } else if (pointCodeOnly) {
                    sb.append('\\');
                    sb.append(ch2);
                    ++i;
                } else {
                    char ch3 = '\u0000';
                    switch (ch2) {
                        case 'n': {
                            ch3 = '\n';
                            break;
                        }
                        case 't': {
                            ch3 = '\t';
                            break;
                        }
                        case 'r': {
                            ch3 = '\r';
                            break;
                        }
                        case 'b': {
                            ch3 = '\b';
                            break;
                        }
                        case 'f': {
                            ch3 = '\f';
                            break;
                        }
                        case '\'': {
                            ch3 = '\'';
                            break;
                        }
                        case '\"': {
                            ch3 = '\"';
                            break;
                        }
                        case '\\': {
                            ch3 = '\\';
                            break;
                        }
                        default: {
                            throw new OraclePropertyGraphException("Unknown escape: \\" + ch2);
                        }
                    }
                    sb.append(ch3);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static int hex(String s, int i, int len, int line, int column) {
        int x = 0;
        for (int j = i; j < i + len; ++j) {
            char ch = s.charAt(j);
            ++column;
            int k = 0;
            switch (ch) {
                case '0': {
                    k = 0;
                    break;
                }
                case '1': {
                    k = 1;
                    break;
                }
                case '2': {
                    k = 2;
                    break;
                }
                case '3': {
                    k = 3;
                    break;
                }
                case '4': {
                    k = 4;
                    break;
                }
                case '5': {
                    k = 5;
                    break;
                }
                case '6': {
                    k = 6;
                    break;
                }
                case '7': {
                    k = 7;
                    break;
                }
                case '8': {
                    k = 8;
                    break;
                }
                case '9': {
                    k = 9;
                    break;
                }
                case 'A': 
                case 'a': {
                    k = 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    k = 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    k = 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    k = 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    k = 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    k = 15;
                    break;
                }
                default: {
                    throw new OraclePropertyGraphException("Illegal hex escape: " + ch);
                }
            }
            x = (x << 4) + k;
        }
        return x;
    }
}

