/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.vfs;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oracle.pgx.common.AbstractPlugin;
import oracle.pgx.common.UserContext;
import oracle.pgx.vfs.ClasspathVirtualFile;
import oracle.pgx.vfs.VirtualFile;
import oracle.pgx.vfs.VirtualFileProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathVirtualFileProvider
extends AbstractPlugin
implements VirtualFileProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathVirtualFileProvider.class);

    @Override
    public boolean schemePerformsNetworkCommunications(String scheme) {
        return false;
    }

    @Override
    public boolean schemeRequiresDirectoryWhiteListing(String scheme) {
        return false;
    }

    @Override
    public boolean schemePerformsInsecureRemoteLoading(String scheme) {
        return false;
    }

    @Override
    public List<String> getSchemes() {
        return Arrays.asList("res", "classpath");
    }

    @Override
    public VirtualFile resolve(String path, Map<String, String> attributes, UserContext userContext) throws IOException {
        if (LOG.isWarnEnabled() && attributes != null && !attributes.isEmpty()) {
            LOG.warn("ignoring unsupported attributes: {}", attributes);
        }
        return new ClasspathVirtualFile(path);
    }

    @Override
    public VirtualFile resolve(String parent, String relative, UserContext userContext) throws IOException {
        return new ClasspathVirtualFile(parent, relative);
    }
}

