/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import oracle.pgx.common.GmParseException;
import oracle.pgx.common.util.ErrorMessagesWithoutLog;

public class TemporalTypeUtils {
    private static final DateTimeFormatter DEFAULT_LOCAL_DATE_FORMAT = DateTimeFormatter.ofPattern("uuuu-MM-dd");
    private static final DateTimeFormatter DEFAULT_TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss[.SSS]");
    private static final DateTimeFormatter DEFAULT_TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss[.SSS]");
    private static final DateTimeFormatter DEFAULT_TIME_WITH_TIMEZONE_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss[.SSS]XXXXX");
    private static final DateTimeFormatter DEFAULT_TIMESTAMP_WITH_TIMEZONE_FORMAT = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss[.SSS]XXXXX");
    private static final LocalDate MIN_LOCAL_DATE = LocalDate.ofEpochDay(Integer.MIN_VALUE);
    private static final LocalDate MAX_LOCAL_DATE = LocalDate.ofEpochDay(Integer.MAX_VALUE);
    private static final LocalDate MIN_TIMESTAMP_DATE = LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.MIN_VALUE), ZoneOffset.UTC).toLocalDate().plusDays(1L);
    private static final LocalDateTime MIN_TIMESTAMP = LocalDateTime.of(MIN_TIMESTAMP_DATE, LocalTime.MIN);
    private static final LocalDateTime MAX_TIMESTAMP = LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.MAX_VALUE), ZoneOffset.UTC);
    private static final int DAYS_PER_CYCLE = 146097;
    static final long DAYS_0000_TO_1970 = 719528L;
    static final int HOURS_PER_DAY = 24;
    static final int MINUTES_PER_HOUR = 60;
    static final int SECONDS_PER_MINUTE = 60;
    static final int SECONDS_PER_HOUR = 3600;
    static final int SECONDS_PER_DAY = 86400;
    static final long NANOS_PER_SECOND = 1000000000L;
    static final long NANOS_PER_MINUTE = 60000000000L;
    static final long NANOS_PER_HOUR = 3600000000000L;
    private static final long DIST_TIMESTAMP_BITFIELD_SIZE = 52L;
    private static final long DIST_TZ_BITFIELD_SIZE = 12L;
    private static final long DIST_MAX_TIMESTAMP_WITH_TIMEZONE = 0x7FFFFFFFFFFFFL;
    private static final long DIST_MIN_TIMESTAMP_WITH_TIMEZONE = -2251799813685248L;
    private static final long DIST_MAX_TZ_MINUTES_TIMESTAMP_WITH_TIMEZONE = 2047L;
    private static final long DIST_MIN_TZ_MINUTES_TIMESTAMP_WITH_TIMEZONE = -2048L;
    public static final long DIST_INVALID_TIMESTAMP_WITH_TIMEZONE = 0x7FFFFFFFFFFFFL;
    public static final int DIST_INVALID_TZ_TIMESTAMP_WITH_TIMEZONE = 0;

    public static LocalDate parseLocalDate(String input) throws GmParseException {
        try {
            return LocalDate.parse(input, DEFAULT_LOCAL_DATE_FORMAT);
        }
        catch (DateTimeParseException e) {
            throw new GmParseException(e);
        }
    }

    public static LocalTime parseTime(String input) throws GmParseException {
        try {
            return LocalTime.parse(input, DEFAULT_TIME_FORMAT);
        }
        catch (DateTimeParseException e) {
            throw new GmParseException(e);
        }
    }

    public static LocalDateTime parseTimestamp(String input) throws GmParseException {
        try {
            return LocalDateTime.parse(input, DEFAULT_TIMESTAMP_FORMAT);
        }
        catch (DateTimeParseException e) {
            throw new GmParseException(e);
        }
    }

    public static OffsetTime parseTimeWithTimezone(String input) throws GmParseException {
        try {
            return OffsetTime.parse(input, DEFAULT_TIME_WITH_TIMEZONE_FORMAT);
        }
        catch (DateTimeParseException e) {
            throw new GmParseException(e);
        }
    }

    public static OffsetDateTime parseTimestampWithTimezone(String input) throws GmParseException {
        try {
            return OffsetDateTime.parse(input, DEFAULT_TIMESTAMP_WITH_TIMEZONE_FORMAT);
        }
        catch (DateTimeParseException e) {
            throw new GmParseException(e);
        }
    }

    public static LocalDate parseLocalDate(int input) {
        return LocalDate.ofEpochDay(input);
    }

    public static LocalTime parseTimeFromMillis(int input) {
        return LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(input));
    }

    public static LocalDateTime parseTimestamp(long input) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(input), ZoneOffset.UTC);
    }

    public static LocalDate getAsLocalDate(Object value) throws GmParseException {
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value instanceof Map) {
            return TemporalTypeUtils.parseLocalDate(TemporalTypeUtils.getMapValueInt("LOCAL_DATE", (Map)value));
        }
        return TemporalTypeUtils.parseLocalDate(value.toString());
    }

    public static LocalTime getAsLocalTime(Object value) throws GmParseException {
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        if (value instanceof Map) {
            return TemporalTypeUtils.parseTimeFromMillis(TemporalTypeUtils.getMapValueInt("TIME", (Map)value));
        }
        return TemporalTypeUtils.parseTime(value.toString());
    }

    public static LocalDateTime getAsLocalDateTime(Object value) throws GmParseException {
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        if (value instanceof Map) {
            return TemporalTypeUtils.parseTimestamp(TemporalTypeUtils.getMapValueLong("TIMESTAMP", (Map)value));
        }
        return TemporalTypeUtils.parseTimestamp(value.toString());
    }

    public static OffsetTime getAsOffsetTime(Object value) throws GmParseException {
        if (value instanceof OffsetTime) {
            return (OffsetTime)value;
        }
        if (value instanceof Map) {
            return TemporalTypeUtils.parseTimeWithTimezone(TemporalTypeUtils.getMapValueInt("TIME_PART_OF_TIME_WITH_TZ", (Map)value), TemporalTypeUtils.getMapValueInt("TZ_PART_OF_TIME_WITH_TZ", (Map)value));
        }
        return TemporalTypeUtils.parseTimeWithTimezone(value.toString());
    }

    public static OffsetDateTime getAsOffsetDateTime(Object value) throws GmParseException {
        if (value instanceof OffsetDateTime) {
            return (OffsetDateTime)value;
        }
        if (value instanceof Map) {
            return TemporalTypeUtils.parseTimestampWithTimezone(TemporalTypeUtils.getMapValueInt("TIMESTAMP_PART_OF_TS_WITH_TZ", (Map)value), TemporalTypeUtils.getMapValueInt("TZ_PART_OF_TS_WITH_TZ", (Map)value));
        }
        return TemporalTypeUtils.parseTimestampWithTimezone(value.toString());
    }

    private static int getMapValueInt(String fieldName, Map<?, ?> map) {
        return Integer.parseInt(map.get(fieldName).toString());
    }

    private static long getMapValueLong(String fieldName, Map<?, ?> map) {
        return Long.parseLong(map.get(fieldName).toString());
    }

    public static int getDaysFromLocalDate(LocalDate localDate) {
        TemporalTypeUtils.checkLocalDateInValidRange(localDate);
        return (int)localDate.getLong(ChronoField.EPOCH_DAY);
    }

    public static void checkLocalDateInValidRange(LocalDate localDate) {
        if (localDate.compareTo(MIN_LOCAL_DATE) < 0 || localDate.compareTo(MAX_LOCAL_DATE) > 0) {
            throw new IllegalStateException(ErrorMessagesWithoutLog.getMessage("LOCAL_DATE_NOT_IN_VALID_RANGE", TemporalTypeUtils.formatLocalDate(localDate), TemporalTypeUtils.formatLocalDate(MIN_LOCAL_DATE), TemporalTypeUtils.formatLocalDate(MAX_LOCAL_DATE)));
        }
    }

    public static int getMillisFromLocalTime(LocalTime localTime) {
        return (int)TimeUnit.NANOSECONDS.toMillis(localTime.toNanoOfDay());
    }

    public static long getMillisFromTimestamp(LocalDateTime timestamp) {
        TemporalTypeUtils.checkTimestampInValidRange(timestamp);
        long millisOfDay = TimeUnit.DAYS.toMillis(timestamp.getLong(ChronoField.EPOCH_DAY));
        long millisOfTime = timestamp.getLong(ChronoField.MILLI_OF_DAY);
        return millisOfDay + millisOfTime;
    }

    public static void checkTimestampInValidRange(LocalDateTime timestamp) {
        if (timestamp.compareTo(MIN_TIMESTAMP) < 0 || timestamp.compareTo(MAX_TIMESTAMP) > 0) {
            throw new IllegalStateException(ErrorMessagesWithoutLog.getMessage("TIMESTAMP_NOT_IN_VALID_RANGE", TemporalTypeUtils.formatTimestamp(timestamp), TemporalTypeUtils.formatTimestamp(MIN_TIMESTAMP), TemporalTypeUtils.formatTimestamp(MAX_TIMESTAMP)));
        }
    }

    public static OffsetTime parseTimeWithTimezone(int inputTime, int inputOffset) {
        return OffsetTime.of(LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(inputTime)), ZoneOffset.ofTotalSeconds(inputOffset));
    }

    public static OffsetTime parseTimefromLocalTime(LocalTime localTime, int inputOffset) {
        return OffsetTime.of(localTime, ZoneOffset.ofTotalSeconds(inputOffset));
    }

    public static OffsetDateTime parseTimestampWithTimezone(long inputTimestamp, int inputOffset) {
        LocalDateTime timestampPart = TemporalTypeUtils.parseTimestamp(inputTimestamp);
        return OffsetDateTime.of(timestampPart, ZoneOffset.ofTotalSeconds(inputOffset));
    }

    public static OffsetDateTime parseTimestampfromLocalDateTime(LocalDateTime localDateTimeTime, int inputOffset) {
        return OffsetDateTime.of(localDateTimeTime, ZoneOffset.ofTotalSeconds(inputOffset));
    }

    public static int convertTimeWithTimezoneToTime(int inputTime, int inputOffset) {
        int offsetMillis = (int)TimeUnit.SECONDS.toMillis(inputOffset);
        int normalizedMillis = inputTime - offsetMillis;
        if (normalizedMillis >= 0) {
            return normalizedMillis % (int)TimeUnit.HOURS.toMillis(24L);
        }
        return (int)TimeUnit.HOURS.toMillis(24L) + normalizedMillis;
    }

    public static String formatLocalDate(LocalDate obj) {
        if (obj == null) {
            return null;
        }
        return DEFAULT_LOCAL_DATE_FORMAT.format(obj);
    }

    public static String formatTime(LocalTime obj) {
        if (obj == null) {
            return null;
        }
        return DEFAULT_TIME_FORMAT.format(obj);
    }

    public static String formatTimestamp(LocalDateTime obj) {
        if (obj == null) {
            return null;
        }
        return DEFAULT_TIMESTAMP_FORMAT.format(obj);
    }

    public static String formatTimeWithTimezone(OffsetTime obj) {
        if (obj == null) {
            return null;
        }
        return DEFAULT_TIME_WITH_TIMEZONE_FORMAT.format(obj);
    }

    public static String formatTimestampWithTimezone(OffsetDateTime obj) {
        if (obj == null) {
            return null;
        }
        return DEFAULT_TIMESTAMP_WITH_TIMEZONE_FORMAT.format(obj);
    }

    private static int getFieldFromLocalDate(long epochDay, DateField extractField) {
        long yearEst;
        long doyEst;
        long zeroDay = epochDay + 719528L;
        long adjust = 0L;
        if ((zeroDay -= 60L) < 0L) {
            long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * 146097L;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        if (extractField == DateField.MONTH) {
            return month;
        }
        int dom = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        if (extractField == DateField.DAY) {
            return dom;
        }
        int year = ChronoField.YEAR.checkValidIntValue(yearEst += (long)(marchMonth0 / 10));
        return year;
    }

    public static int getDayFromLocalDate(long epochDay) {
        return TemporalTypeUtils.getFieldFromLocalDate(epochDay, DateField.DAY);
    }

    public static int getMonthFromLocalDate(long epochDay) {
        return TemporalTypeUtils.getFieldFromLocalDate(epochDay, DateField.MONTH);
    }

    public static int getYearFromLocalDate(long epochDay) {
        return TemporalTypeUtils.getFieldFromLocalDate(epochDay, DateField.YEAR);
    }

    private static long getLocalEpochDay(long epochMilli) {
        long secs = Math.floorDiv(epochMilli, 1000L);
        return Math.floorDiv(secs, 86400L);
    }

    public static int getDayFromTimestamp(long epochMilli) {
        return TemporalTypeUtils.getDayFromLocalDate(TemporalTypeUtils.getLocalEpochDay(epochMilli));
    }

    public static int getMonthFromTimestamp(long epochMilli) {
        return TemporalTypeUtils.getMonthFromLocalDate(TemporalTypeUtils.getLocalEpochDay(epochMilli));
    }

    public static int getYearFromTimestamp(long epochMilli) {
        return TemporalTypeUtils.getYearFromLocalDate(TemporalTypeUtils.getLocalEpochDay(epochMilli));
    }

    private static int getFieldFromLocalTime(long nanoOfDay, TimeField extractField) {
        ChronoField.NANO_OF_DAY.checkValidValue(nanoOfDay);
        int hours = (int)(nanoOfDay / 3600000000000L);
        if (extractField == TimeField.HOUR) {
            return hours;
        }
        int minutes = (int)((nanoOfDay -= (long)hours * 3600000000000L) / 60000000000L);
        if (extractField == TimeField.MINUTE) {
            return minutes;
        }
        int seconds = (int)((nanoOfDay -= (long)minutes * 60000000000L) / 1000000000L);
        int micros = seconds * 1000000 + (int)(nanoOfDay -= (long)seconds * 1000000000L) / 1000;
        return micros;
    }

    public static int getHourFromLocalTime(long millis) {
        return TemporalTypeUtils.getFieldFromLocalTime(TimeUnit.MILLISECONDS.toNanos(millis), TimeField.HOUR);
    }

    public static int getMinuteFromLocalTime(long millis) {
        return TemporalTypeUtils.getFieldFromLocalTime(TimeUnit.MILLISECONDS.toNanos(millis), TimeField.MINUTE);
    }

    public static int getMicroFromLocalTime(long millis) {
        return TemporalTypeUtils.getFieldFromLocalTime(TimeUnit.MILLISECONDS.toNanos(millis), TimeField.MICRO);
    }

    private static long getNanoOfDay(long epochMilli) {
        long secs = Math.floorDiv(epochMilli, 1000L);
        int mos = (int)Math.floorMod(epochMilli, 1000L);
        int nanoOfSecond = mos * 1000000;
        ChronoField.NANO_OF_SECOND.checkValidValue(nanoOfSecond);
        int secsOfDay = (int)Math.floorMod(secs, 86400L);
        return (long)secsOfDay * 1000000000L + (long)nanoOfSecond;
    }

    public static int getHourFromTimestamp(long epochMilli) {
        return TemporalTypeUtils.getFieldFromLocalTime(TemporalTypeUtils.getNanoOfDay(epochMilli), TimeField.HOUR);
    }

    public static int getMinuteFromTimestamp(long epochMilli) {
        return TemporalTypeUtils.getFieldFromLocalTime(TemporalTypeUtils.getNanoOfDay(epochMilli), TimeField.MINUTE);
    }

    public static int getMicroFromTimestamp(long epochMilli) {
        return TemporalTypeUtils.getFieldFromLocalTime(TemporalTypeUtils.getNanoOfDay(epochMilli), TimeField.MICRO);
    }

    public static DateFormat createDateFormat(String pattern) {
        return new SimpleDateFormat(pattern);
    }

    public static List<DateTimeFormatter> createDateTimeFormatterList(List<String> patterns) {
        return patterns.stream().map(DateTimeFormatter::ofPattern).collect(Collectors.toList());
    }

    public static <K> String temporalTypeToString(K key) {
        if (key instanceof LocalDateTime) {
            return ((LocalDateTime)key).format(DEFAULT_TIMESTAMP_FORMAT);
        }
        if (key instanceof LocalDate) {
            return ((LocalDate)key).format(DEFAULT_LOCAL_DATE_FORMAT);
        }
        if (key instanceof OffsetTime) {
            return ((OffsetTime)key).format(DEFAULT_TIME_WITH_TIMEZONE_FORMAT);
        }
        if (key instanceof OffsetDateTime) {
            return ((OffsetDateTime)key).format(DEFAULT_TIMESTAMP_WITH_TIMEZONE_FORMAT);
        }
        if (key instanceof LocalTime) {
            return ((LocalTime)key).format(DEFAULT_TIME_FORMAT);
        }
        return key.toString();
    }

    public static int getTimeFromTimeWithTimezone(OffsetTime timeWithTimezone) {
        return timeWithTimezone.get(ChronoField.MILLI_OF_DAY);
    }

    public static int getTimezoneFromTimeWithTimezone(OffsetTime timeWithTimezone) {
        return timeWithTimezone.getOffset().getTotalSeconds();
    }

    public static long getTimestampFromTimestampWithTimezone(OffsetDateTime timestampWithTimezone) {
        return TemporalTypeUtils.getMillisFromTimestamp(timestampWithTimezone.toLocalDateTime());
    }

    public static int getTimezoneFromTimestampWithTimezone(OffsetDateTime timestampWithTimezone) {
        return timestampWithTimezone.getOffset().getTotalSeconds();
    }

    public static boolean isValidForDist(OffsetDateTime timestampWithTimezone) {
        int offsetSeconds = TemporalTypeUtils.getTimezoneFromTimestampWithTimezone(timestampWithTimezone);
        if (offsetSeconds % 60 != 0) {
            return false;
        }
        int offsetMinutes = offsetSeconds / 60;
        if ((long)offsetMinutes < -2048L || (long)offsetMinutes > 2047L) {
            return false;
        }
        long millis = TemporalTypeUtils.getMillisFromTimestamp(timestampWithTimezone.toLocalDateTime());
        return millis >= -2251799813685248L && millis < 0x7FFFFFFFFFFFFL;
    }

    private static enum TimeField {
        HOUR,
        MINUTE,
        MICRO;

    }

    private static enum DateField {
        YEAR,
        MONTH,
        DAY;

    }
}

