/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgx.common.ImmutablePair;
import oracle.pgx.common.util.ErrorMessages;

public class SqlSanitizationUtils {
    public static final int MAX_IDENTIFIER_LENGTH = 128;
    public static final char IDENTIFIER_QUOTE_CHAR = '\"';
    public static final String BACKSLASH_PATTERN = Pattern.quote("\\");
    public static final String BACKSLASH_ESCAPED_REPLACEMENT = Matcher.quoteReplacement("\\\\");

    public static void validateIdentifier(String identifier, String exceptionMessage) {
        if (identifier == null || identifier.isEmpty() || identifier.contains("\"") || identifier.contains("\u0000") || identifier.length() > 128) {
            throw new IllegalArgumentException(exceptionMessage);
        }
    }

    public static void validateIdentifier(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("IDENTIFIER_NULL", new Object[0]));
        }
        if (identifier.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("IDENTIFIER_EMPTY_STRING", new Object[0]));
        }
        if (identifier.length() > 128) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("IDENTIFIER_TOO_LONG", 128));
        }
        if (identifier.indexOf(34) != -1) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("ILLEGAL_CHARACTER_IN_IDENTIFIER", Character.valueOf('\"'), identifier));
        }
        if (identifier.indexOf(0) != -1) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("ILLEGAL_CHARACTER_IN_IDENTIFIER", "NULL", identifier));
        }
    }

    public static String quoteIdentifier(String identifier) {
        return PgqlUtils.printIdentifier((String)identifier);
    }

    public static String validateAndQuoteIdentifier(String identifier) {
        SqlSanitizationUtils.validateIdentifier(identifier);
        return PgqlUtils.printIdentifier((String)identifier);
    }

    public static String quoteOracleUserName(String userName) {
        return SqlSanitizationUtils.quoteIdentifier(userName.toUpperCase());
    }

    public static String createJsonPathLiteral(String ... columns) {
        StringBuilder sb = new StringBuilder();
        sb.append('$');
        for (String column : columns) {
            String quotedColumn = SqlSanitizationUtils.validateAndQuoteIdentifier(column);
            String escapedAndQuotedColumn = quotedColumn.replaceAll(BACKSLASH_PATTERN, BACKSLASH_ESCAPED_REPLACEMENT);
            sb.append('.').append(escapedAndQuotedColumn);
        }
        return PgqlUtils.printLiteral((String)sb.toString());
    }

    @Deprecated
    public static ImmutablePair<String, String> parseSchemaAndName(String schemaName, String graphName) {
        if (schemaName == null) {
            int schemaEnd = graphName.indexOf(46);
            schemaName = schemaEnd == -1 ? null : graphName.substring(0, schemaEnd);
            String string = graphName = schemaEnd == -1 ? graphName : graphName.substring(schemaEnd + 1);
        }
        if (schemaName != null) {
            SqlSanitizationUtils.validateIdentifier(schemaName);
        }
        SqlSanitizationUtils.validateIdentifier(graphName);
        return new ImmutablePair<String, String>(schemaName, graphName);
    }
}

