import { MainAreaWidget } from '@jupyterlab/apputils';
import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import { Panel } from '@lumino/widgets';
import { IPullRequest, IThread } from '../../tokens';
/**
 * DescriptionWidget properties
 */
export interface IDescriptionWidgetProps {
    /**
     * Pull Request data
     */
    pullRequest: IPullRequest;
    /**
     * Render mime type registry
     */
    renderMime: IRenderMimeRegistry;
}
/**
 * DescriptionWidget component
 */
export declare class DescriptionWidget extends MainAreaWidget<Panel> {
    constructor(props: IDescriptionWidgetProps);
    /**
     * Load the discussion of the pull request
     *
     * @param container Discussion widgets container
     * @param pullRequestId Pull request id
     * @param renderMime Rendermime registry
     */
    protected loadComments(container: Panel, pullRequestId: string, renderMime: IRenderMimeRegistry): Promise<void>;
    private static createHeader;
    private createNewThreadButton;
    protected pullRequestId: string;
    protected renderMime: IRenderMimeRegistry;
    protected threads: IThread[];
}
