import { Widget } from '@lumino/widgets';
import CodeMirror from 'codemirror';
import { generateNode } from '../../utils';
import 'codemirror/addon/display/placeholder.js';
/**
 * InputComment widget
 */
export class InputComment extends Widget {
    constructor(props) {
        super();
        this._comment = '';
        this.addClass('jp-PullRequestInputContainer');
        this.initNode();
        this._handleSubmit = props.handleSubmit;
        this._handleRemove = props.handleCancel;
    }
    /**
     * Comment
     */
    get comment() {
        return this._comment;
    }
    set comment(v) {
        if (this._comment !== v) {
            this._comment = v;
            const button = this.node.getElementsByClassName('jp-PullRequest-CommentButton')[0];
            button.disabled = this._comment === '';
        }
    }
    /**
     * Handle click event on cancel button
     *
     * @param event Click event
     */
    handleCancel(event) {
        this._handleRemove();
    }
    /**
     * Handle comment input event
     *
     * @param event Input event
     */
    handleInputChange(editor) {
        this.comment = editor.getValue();
    }
    /**
     * Handle click event on add comment button
     *
     * @param event Click event
     */
    handleSubmit(event) {
        if (this._comment) {
            this._handleSubmit(this._comment);
        }
    }
    /**
     * Initialize the widget HTML node
     */
    initNode() {
        const buttonsContainer = generateNode('div', {
            class: 'jp-PullRequestInputButtonContainer'
        });
        buttonsContainer.appendChild(generateNode('button', {
            class: 'jp-Button-flat jp-mod-styled jp-mod-reject'
        }, 'Cancel', {
            click: this.handleCancel.bind(this)
        }));
        buttonsContainer.appendChild(generateNode('button', {
            class: 'jp-Button-flat jp-PullRequest-CommentButton jp-mod-styled jp-mod-accept',
            disabled: true
        }, 'Comment', {
            click: this.handleSubmit.bind(this)
        }));
        const head = this.node.appendChild(generateNode('div', { class: 'jp-PullRequestCommentItemContent' }));
        const editor = head.appendChild(generateNode('textarea', {
            class: 'jp-PullRequestInputForm jp-PullRequestInputFormTextArea',
            placeholder: 'Leave a comment',
            value: ''
        }));
        const cm = CodeMirror.fromTextArea(editor, {
            mode: 'markdown',
            theme: 'jupyter',
            lineWrapping: true
        });
        cm.on('change', this.handleInputChange.bind(this));
        head.appendChild(buttonsContainer);
    }
}
//# sourceMappingURL=InputComment.js.map