import { Panel } from '@lumino/widgets';
import { IThread } from '../../tokens';
import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
/**
 * Discussion widget properties
 */
export interface IDiscussionProps {
    /**
     * RenderMime registry
     */
    renderMime: IRenderMimeRegistry;
    /**
     * Thread to be displayed
     */
    thread: IThread;
    /**
     * Callback when the thread is removed
     */
    handleRemove: () => void;
}
/**
 * Discussion widget
 */
export declare class Discussion extends Panel {
    constructor(props: IDiscussionProps);
    /**
     * Is the thread expanded?
     */
    get isExpanded(): boolean;
    set isExpanded(v: boolean);
    /**
     * Is the input comment widget shown?
     */
    get inputShown(): boolean;
    set inputShown(v: boolean);
    /**
     * Initialize the widget node
     */
    protected initNode(): void;
    /**
     * Add the thread view in the widget
     */
    protected addThreadView(): void;
    /**
     * Handle new comment submission
     *
     * @param comment Comment text
     */
    protected handleAddComment(text: string): Promise<void>;
    /**
     * Handle cancel event
     *
     * If the thread has no comment, this results in its removal.
     */
    protected handleCancelComment(): void;
    private createCommentInput;
    private createReplyButton;
    private _handleRemove;
    private _inputShown;
    private _isExpanded;
    private _renderMime;
    private _thread;
}
