import * as React from 'react';
import { PullRequestItem } from './PullRequestItem';
/**
 * BrowserGroup component
 *
 * @param props Component properties
 */
export function BrowserGroup(props) {
    return (React.createElement("li", { className: "jp-PullRequestBrowserGroup" },
        React.createElement("header", null,
            React.createElement("h2", null, props.group.name)),
        props.group.error ? (React.createElement("h2", { className: "jp-PullRequestBrowserGroupError" },
            React.createElement("span", { style: { color: 'var(--jp-ui-font-color1)' } }, "Error Listing Pull Requests:"),
            ' ',
            props.group.error)) : (React.createElement("ul", { className: "jp-PullRequestBrowserGroupList" }, props.group.pullRequests.map(pullRequest => (React.createElement(PullRequestItem, { key: pullRequest.id, commands: props.commands, docRegistry: props.docRegistry, pullRequest: pullRequest })))))));
}
//# sourceMappingURL=BrowserGroup.js.map