import React from 'react';
import { refreshIcon } from '@jupyterlab/ui-components';
import { ActionButton } from '@jupyterlab/git/lib/components/ActionButton';
/**
 * Toolbar component
 *
 * @param props Component properties
 */
export function Toolbar(props) {
    return (React.createElement("div", { className: "lm-Widget jp-Toolbar jp-scrollbar-tiny jp-PullRequestToolbar" },
        React.createElement("div", { className: "jp-PullRequestToolbarHeader" },
            React.createElement("h2", null, "Pull Requests")),
        React.createElement("div", { className: "jp-PullRequestToolbarItem" },
            React.createElement(ActionButton, { icon: refreshIcon, title: "Refresh", onClick: props.onRefresh }))));
}
//# sourceMappingURL=Toolbar.js.map