"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLoadBalancerController = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s = require("cdk8s");
const constructs_1 = require("constructs");
/**
 * Generate aws-load-balancer-controller config yaml.
 *
 * see https://github.com/kubernetes-sigs/aws-aws-load-balancer-controller/blob/master/docs/install/v2_0_0_full.yaml
 *
 * @stability stable
 */
class AwsLoadBalancerController extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, options) {
        var _b, _c, _d;
        super(scope, id);
        this.serviceAccountName = 'aws-load-balancer-controller';
        this.deploymentName = 'aws-load-balancer-controller';
        this.clusterName = options.clusterName;
        this.namespace = (_b = options.namespace) !== null && _b !== void 0 ? _b : 'default';
        this.chartVersion = (_c = options.chartVersion) !== null && _c !== void 0 ? _c : '';
        // ingressclassparams elbv2 k8s aws CRD.
        new cdk8s.ApiObject(this, 'aws-load-balancer-controller-ingclassparams-crd', {
            apiVersion: 'apiextensions.k8s.io/v1',
            kind: 'CustomResourceDefinition',
            metadata: {
                annotations: {
                    'controller-gen.kubebuilder.io/version': 'v0.5.0',
                },
                creationTimestamp: null,
                name: 'ingressclassparams.elbv2.k8s.aws',
            },
            spec: {
                group: 'elbv2.k8s.aws',
                names: {
                    kind: 'IngressClassParams',
                    listKind: 'IngressClassParamsList',
                    plural: 'ingressclassparams',
                    singular: 'ingressclassparams',
                },
                scope: 'Cluster',
                versions: [
                    {
                        additionalPrinterColumns: [
                            {
                                description: 'The Ingress Group name',
                                jsonPath: '.spec.group.name',
                                name: 'GROUP-NAME',
                                type: 'string',
                            },
                            {
                                description: 'The AWS Load Balancer scheme',
                                jsonPath: '.spec.scheme',
                                name: 'SCHEME',
                                type: 'string',
                            },
                            {
                                description: 'The AWS Load Balancer ipAddressType',
                                jsonPath: '.spec.ipAddressType',
                                name: 'IP-ADDRESS-TYPE',
                                type: 'string',
                            },
                            {
                                jsonPath: '.metadata.creationTimestamp',
                                name: 'AGE',
                                type: 'date',
                            },
                        ],
                        name: 'v1beta1',
                        schema: {
                            openAPIV3Schema: {
                                description: 'IngressClassParams is the Schema for the IngressClassParams API',
                                properties: {
                                    apiVersion: {
                                        description: 'APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
                                        type: 'string',
                                    },
                                    kind: {
                                        description: 'Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
                                        type: 'string',
                                    },
                                    metadata: {
                                        type: 'object',
                                    },
                                    spec: {
                                        description: 'IngressClassParamsSpec defines the desired state of IngressClassParams',
                                        properties: {
                                            group: {
                                                description: 'Group defines the IngressGroup for all Ingresses that belong to IngressClass with this IngressClassParams.',
                                                properties: {
                                                    name: {
                                                        description: 'Name is the name of IngressGroup.',
                                                        type: 'string',
                                                    },
                                                },
                                                required: [
                                                    'name',
                                                ],
                                                type: 'object',
                                            },
                                            ipAddressType: {
                                                description: 'IPAddressType defines the ip address type for all Ingresses that belong to IngressClass with this IngressClassParams.',
                                                enum: [
                                                    'ipv4',
                                                    'dualstack',
                                                ],
                                                type: 'string',
                                            },
                                            namespaceSelector: {
                                                description: 'NamespaceSelector restrict the namespaces of Ingresses that are allowed to specify the IngressClass with this IngressClassParams. * if absent or present but empty, it selects all namespaces.',
                                                properties: {
                                                    matchExpressions: {
                                                        description: 'matchExpressions is a list of label selector requirements. The requirements are ANDed.',
                                                        items: {
                                                            description: 'A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.',
                                                            properties: {
                                                                key: {
                                                                    description: 'key is the label key that the selector applies to.',
                                                                    type: 'string',
                                                                },
                                                                operator: {
                                                                    description: "operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.",
                                                                    type: 'string',
                                                                },
                                                                values: {
                                                                    description: 'values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.',
                                                                    items: {
                                                                        type: 'string',
                                                                    },
                                                                    type: 'array',
                                                                },
                                                            },
                                                            required: [
                                                                'key',
                                                                'operator',
                                                            ],
                                                            type: 'object',
                                                        },
                                                        type: 'array',
                                                    },
                                                    matchLabels: {
                                                        additionalProperties: {
                                                            type: 'string',
                                                        },
                                                        description: 'matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.',
                                                        type: 'object',
                                                    },
                                                },
                                                type: 'object',
                                            },
                                            scheme: {
                                                description: 'Scheme defines the scheme for all Ingresses that belong to IngressClass with this IngressClassParams.',
                                                enum: [
                                                    'internal',
                                                    'internet-facing',
                                                ],
                                                type: 'string',
                                            },
                                            tags: {
                                                description: 'Tags defines list of Tags on AWS resources provisioned for Ingresses that belong to IngressClass with this IngressClassParams.',
                                                items: {
                                                    description: 'Tag defines a AWS Tag on resources.',
                                                    properties: {
                                                        key: {
                                                            description: 'The key of the tag.',
                                                            type: 'string',
                                                        },
                                                        value: {
                                                            description: 'The value of the tag.',
                                                            type: 'string',
                                                        },
                                                    },
                                                    required: [
                                                        'key',
                                                        'value',
                                                    ],
                                                    type: 'object',
                                                },
                                                type: 'array',
                                            },
                                        },
                                        type: 'object',
                                    },
                                },
                                type: 'object',
                            },
                        },
                        served: true,
                        storage: true,
                        subresources: {},
                    },
                ],
            },
        });
        // targetgroupbindings  elbv2 k8s aws CRD.
        new cdk8s.ApiObject(this, 'aws-load-balancer-controller-tgbinding-crd', {
            apiVersion: 'apiextensions.k8s.io/v1',
            kind: 'CustomResourceDefinition',
            metadata: {
                annotations: {
                    'controller-gen.kubebuilder.io/version': 'v0.5.0',
                },
                creationTimestamp: null,
                name: 'targetgroupbindings.elbv2.k8s.aws',
            },
            spec: {
                group: 'elbv2.k8s.aws',
                names: {
                    kind: 'TargetGroupBinding',
                    listKind: 'TargetGroupBindingList',
                    plural: 'targetgroupbindings',
                    singular: 'targetgroupbinding',
                },
                scope: 'Namespaced',
                versions: [
                    {
                        additionalPrinterColumns: [
                            {
                                description: "The Kubernetes Service's name",
                                jsonPath: '.spec.serviceRef.name',
                                name: 'SERVICE-NAME',
                                type: 'string',
                            },
                            {
                                description: "The Kubernetes Service's port",
                                jsonPath: '.spec.serviceRef.port',
                                name: 'SERVICE-PORT',
                                type: 'string',
                            },
                            {
                                description: "The AWS TargetGroup's TargetType",
                                jsonPath: '.spec.targetType',
                                name: 'TARGET-TYPE',
                                type: 'string',
                            },
                            {
                                description: "The AWS TargetGroup's Amazon Resource Name",
                                jsonPath: '.spec.targetGroupARN',
                                name: 'ARN',
                                priority: 1,
                                type: 'string',
                            },
                            {
                                jsonPath: '.metadata.creationTimestamp',
                                name: 'AGE',
                                type: 'date',
                            },
                        ],
                        name: 'v1alpha1',
                        schema: {
                            openAPIV3Schema: {
                                description: 'TargetGroupBinding is the Schema for the TargetGroupBinding API',
                                properties: {
                                    apiVersion: {
                                        description: 'APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
                                        type: 'string',
                                    },
                                    kind: {
                                        description: 'Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
                                        type: 'string',
                                    },
                                    metadata: {
                                        type: 'object',
                                    },
                                    spec: {
                                        description: 'TargetGroupBindingSpec defines the desired state of TargetGroupBinding',
                                        properties: {
                                            networking: {
                                                description: 'networking provides the networking setup for ELBV2 LoadBalancer to access targets in TargetGroup.',
                                                properties: {
                                                    ingress: {
                                                        description: 'List of ingress rules to allow ELBV2 LoadBalancer to access targets in TargetGroup.',
                                                        items: {
                                                            properties: {
                                                                from: {
                                                                    description: 'List of peers which should be able to access the targets in TargetGroup. At least one NetworkingPeer should be specified.',
                                                                    items: {
                                                                        description: 'NetworkingPeer defines the source/destination peer for networking rules.',
                                                                        properties: {
                                                                            ipBlock: {
                                                                                description: 'IPBlock defines an IPBlock peer. If specified, none of the other fields can be set.',
                                                                                properties: {
                                                                                    cidr: {
                                                                                        description: 'CIDR is the network CIDR. Both IPV4 or IPV6 CIDR are accepted.',
                                                                                        type: 'string',
                                                                                    },
                                                                                },
                                                                                required: [
                                                                                    'cidr',
                                                                                ],
                                                                                type: 'object',
                                                                            },
                                                                            securityGroup: {
                                                                                description: 'SecurityGroup defines a SecurityGroup peer. If specified, none of the other fields can be set.',
                                                                                properties: {
                                                                                    groupID: {
                                                                                        description: 'GroupID is the EC2 SecurityGroupID.',
                                                                                        type: 'string',
                                                                                    },
                                                                                },
                                                                                required: [
                                                                                    'groupID',
                                                                                ],
                                                                                type: 'object',
                                                                            },
                                                                        },
                                                                        type: 'object',
                                                                    },
                                                                    type: 'array',
                                                                },
                                                                ports: {
                                                                    description: 'List of ports which should be made accessible on the targets in TargetGroup. If ports is empty or unspecified, it defaults to all ports with TCP.',
                                                                    items: {
                                                                        properties: {
                                                                            port: {
                                                                                'anyOf': [
                                                                                    {
                                                                                        type: 'integer',
                                                                                    },
                                                                                    {
                                                                                        type: 'string',
                                                                                    },
                                                                                ],
                                                                                'description': 'The port which traffic must match. When NodePort endpoints(instance TargetType) is used, this must be a numerical port. When Port endpoints(ip TargetType) is used, this can be either numerical or named port on pods. if port is unspecified, it defaults to all ports.',
                                                                                'x-kubernetes-int-or-string': true,
                                                                            },
                                                                            protocol: {
                                                                                description: 'The protocol which traffic must match. If protocol is unspecified, it defaults to TCP.',
                                                                                enum: [
                                                                                    'TCP',
                                                                                    'UDP',
                                                                                ],
                                                                                type: 'string',
                                                                            },
                                                                        },
                                                                        type: 'object',
                                                                    },
                                                                    type: 'array',
                                                                },
                                                            },
                                                            required: [
                                                                'from',
                                                                'ports',
                                                            ],
                                                            type: 'object',
                                                        },
                                                        type: 'array',
                                                    },
                                                },
                                                type: 'object',
                                            },
                                            serviceRef: {
                                                description: 'serviceRef is a reference to a Kubernetes Service and ServicePort.',
                                                properties: {
                                                    name: {
                                                        description: 'Name is the name of the Service.',
                                                        type: 'string',
                                                    },
                                                    port: {
                                                        'anyOf': [
                                                            {
                                                                type: 'integer',
                                                            },
                                                            {
                                                                type: 'string',
                                                            },
                                                        ],
                                                        'description': 'Port is the port of the ServicePort.',
                                                        'x-kubernetes-int-or-string': true,
                                                    },
                                                },
                                                required: [
                                                    'name',
                                                    'port',
                                                ],
                                                type: 'object',
                                            },
                                            targetGroupARN: {
                                                description: 'targetGroupARN is the Amazon Resource Name (ARN) for the TargetGroup.',
                                                type: 'string',
                                            },
                                            targetType: {
                                                description: 'targetType is the TargetType of TargetGroup. If unspecified, it will be automatically inferred.',
                                                enum: [
                                                    'instance',
                                                    'ip',
                                                ],
                                                type: 'string',
                                            },
                                        },
                                        required: [
                                            'serviceRef',
                                            'targetGroupARN',
                                        ],
                                        type: 'object',
                                    },
                                    status: {
                                        description: 'TargetGroupBindingStatus defines the observed state of TargetGroupBinding',
                                        properties: {
                                            observedGeneration: {
                                                description: 'The generation observed by the TargetGroupBinding controller.',
                                                format: 'int64',
                                                type: 'integer',
                                            },
                                        },
                                        type: 'object',
                                    },
                                },
                                type: 'object',
                            },
                        },
                        served: true,
                        storage: false,
                        subresources: {
                            status: {},
                        },
                    },
                    {
                        additionalPrinterColumns: [
                            {
                                description: "The Kubernetes Service's name",
                                jsonPath: '.spec.serviceRef.name',
                                name: 'SERVICE-NAME',
                                type: 'string',
                            },
                            {
                                description: "The Kubernetes Service's port",
                                jsonPath: '.spec.serviceRef.port',
                                name: 'SERVICE-PORT',
                                type: 'string',
                            },
                            {
                                description: "The AWS TargetGroup's TargetType",
                                jsonPath: '.spec.targetType',
                                name: 'TARGET-TYPE',
                                type: 'string',
                            },
                            {
                                description: "The AWS TargetGroup's Amazon Resource Name",
                                jsonPath: '.spec.targetGroupARN',
                                name: 'ARN',
                                priority: 1,
                                type: 'string',
                            },
                            {
                                jsonPath: '.metadata.creationTimestamp',
                                name: 'AGE',
                                type: 'date',
                            },
                        ],
                        name: 'v1beta1',
                        schema: {
                            openAPIV3Schema: {
                                description: 'TargetGroupBinding is the Schema for the TargetGroupBinding API',
                                properties: {
                                    apiVersion: {
                                        description: 'APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
                                        type: 'string',
                                    },
                                    kind: {
                                        description: 'Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
                                        type: 'string',
                                    },
                                    metadata: {
                                        type: 'object',
                                    },
                                    spec: {
                                        description: 'TargetGroupBindingSpec defines the desired state of TargetGroupBinding',
                                        properties: {
                                            networking: {
                                                description: 'networking defines the networking rules to allow ELBV2 LoadBalancer to access targets in TargetGroup.',
                                                properties: {
                                                    ingress: {
                                                        description: 'List of ingress rules to allow ELBV2 LoadBalancer to access targets in TargetGroup.',
                                                        items: {
                                                            description: "NetworkingIngressRule defines a particular set of traffic that is allowed to access TargetGroup's targets.",
                                                            properties: {
                                                                from: {
                                                                    description: 'List of peers which should be able to access the targets in TargetGroup. At least one NetworkingPeer should be specified.',
                                                                    items: {
                                                                        description: 'NetworkingPeer defines the source/destination peer for networking rules.',
                                                                        properties: {
                                                                            ipBlock: {
                                                                                description: 'IPBlock defines an IPBlock peer. If specified, none of the other fields can be set.',
                                                                                properties: {
                                                                                    cidr: {
                                                                                        description: 'CIDR is the network CIDR. Both IPV4 or IPV6 CIDR are accepted.',
                                                                                        type: 'string',
                                                                                    },
                                                                                },
                                                                                required: [
                                                                                    'cidr',
                                                                                ],
                                                                                type: 'object',
                                                                            },
                                                                            securityGroup: {
                                                                                description: 'SecurityGroup defines a SecurityGroup peer. If specified, none of the other fields can be set.',
                                                                                properties: {
                                                                                    groupID: {
                                                                                        description: 'GroupID is the EC2 SecurityGroupID.',
                                                                                        type: 'string',
                                                                                    },
                                                                                },
                                                                                required: [
                                                                                    'groupID',
                                                                                ],
                                                                                type: 'object',
                                                                            },
                                                                        },
                                                                        type: 'object',
                                                                    },
                                                                    type: 'array',
                                                                },
                                                                ports: {
                                                                    description: 'List of ports which should be made accessible on the targets in TargetGroup. If ports is empty or unspecified, it defaults to all ports with TCP.',
                                                                    items: {
                                                                        description: 'NetworkingPort defines the port and protocol for networking rules.',
                                                                        properties: {
                                                                            port: {
                                                                                'anyOf': [
                                                                                    {
                                                                                        type: 'integer',
                                                                                    },
                                                                                    {
                                                                                        type: 'string',
                                                                                    },
                                                                                ],
                                                                                'description': 'The port which traffic must match. When NodePort endpoints(instance TargetType) is used, this must be a numerical port. When Port endpoints(ip TargetType) is used, this can be either numerical or named port on pods. if port is unspecified, it defaults to all ports.',
                                                                                'x-kubernetes-int-or-string': true,
                                                                            },
                                                                            protocol: {
                                                                                description: 'The protocol which traffic must match. If protocol is unspecified, it defaults to TCP.',
                                                                                enum: [
                                                                                    'TCP',
                                                                                    'UDP',
                                                                                ],
                                                                                type: 'string',
                                                                            },
                                                                        },
                                                                        type: 'object',
                                                                    },
                                                                    type: 'array',
                                                                },
                                                            },
                                                            required: [
                                                                'from',
                                                                'ports',
                                                            ],
                                                            type: 'object',
                                                        },
                                                        type: 'array',
                                                    },
                                                },
                                                type: 'object',
                                            },
                                            nodeSelector: {
                                                description: 'node selector for instance type target groups to only register certain nodes',
                                                properties: {
                                                    matchExpressions: {
                                                        description: 'matchExpressions is a list of label selector requirements. The requirements are ANDed.',
                                                        items: {
                                                            description: 'A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.',
                                                            properties: {
                                                                key: {
                                                                    description: 'key is the label key that the selector applies to.',
                                                                    type: 'string',
                                                                },
                                                                operator: {
                                                                    description: "operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.",
                                                                    type: 'string',
                                                                },
                                                                values: {
                                                                    description: 'values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.',
                                                                    items: {
                                                                        type: 'string',
                                                                    },
                                                                    type: 'array',
                                                                },
                                                            },
                                                            required: [
                                                                'key',
                                                                'operator',
                                                            ],
                                                            type: 'object',
                                                        },
                                                        type: 'array',
                                                    },
                                                    matchLabels: {
                                                        additionalProperties: {
                                                            type: 'string',
                                                        },
                                                        description: 'matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.',
                                                        type: 'object',
                                                    },
                                                },
                                                type: 'object',
                                            },
                                            serviceRef: {
                                                description: 'serviceRef is a reference to a Kubernetes Service and ServicePort.',
                                                properties: {
                                                    name: {
                                                        description: 'Name is the name of the Service.',
                                                        type: 'string',
                                                    },
                                                    port: {
                                                        'anyOf': [
                                                            {
                                                                type: 'integer',
                                                            },
                                                            {
                                                                type: 'string',
                                                            },
                                                        ],
                                                        'description': 'Port is the port of the ServicePort.',
                                                        'x-kubernetes-int-or-string': true,
                                                    },
                                                },
                                                required: [
                                                    'name',
                                                    'port',
                                                ],
                                                type: 'object',
                                            },
                                            targetGroupARN: {
                                                description: 'targetGroupARN is the Amazon Resource Name (ARN) for the TargetGroup.',
                                                minLength: 1,
                                                type: 'string',
                                            },
                                            targetType: {
                                                description: 'targetType is the TargetType of TargetGroup. If unspecified, it will be automatically inferred.',
                                                enum: [
                                                    'instance',
                                                    'ip',
                                                ],
                                                type: 'string',
                                            },
                                        },
                                        required: [
                                            'serviceRef',
                                            'targetGroupARN',
                                        ],
                                        type: 'object',
                                    },
                                    status: {
                                        description: 'TargetGroupBindingStatus defines the observed state of TargetGroupBinding',
                                        properties: {
                                            observedGeneration: {
                                                description: 'The generation observed by the TargetGroupBinding controller.',
                                                format: 'int64',
                                                type: 'integer',
                                            },
                                        },
                                        type: 'object',
                                    },
                                },
                                type: 'object',
                            },
                        },
                        served: true,
                        storage: true,
                        subresources: {
                            status: {},
                        },
                    },
                ],
            },
        });
        new cdk8s.Helm(this, 'helmawsLoadBalancerController', {
            chart: 'eks/aws-load-balancer-controller',
            releaseName: 'aws-load-balancer-controller',
            helmFlags: ['--namespace', this.namespace, '--version', this.chartVersion],
            values: {
                clusterName: options.clusterName,
                serviceAccount: {
                    create: (_d = options.createServiceAccount) !== null && _d !== void 0 ? _d : true,
                    name: this.serviceAccountName,
                },
            },
        });
    }
}
exports.AwsLoadBalancerController = AwsLoadBalancerController;
_a = JSII_RTTI_SYMBOL_1;
AwsLoadBalancerController[_a] = { fqn: "cdk8s-aws-load-balancer-controller.AwsLoadBalancerController", version: "2.3.6" };
//# sourceMappingURL=data:application/json;base64,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