import { Construct } from 'constructs';
/**
 * @stability stable
 */
export interface AwsLoadBalancerControllerOptions {
    /**
     * Kubernetes Cluster Name for aws-load-balancer-controller.
     *
     * @default - None
     * @stability stable
     */
    readonly clusterName: string;
    /**
     * service account for aws-load-balancer-controller.
     *
     * @default - true
     * @stability stable
     */
    readonly createServiceAccount?: boolean;
    /**
     * Namespace for aws-load-balancer-controller.
     *
     * @default - default
     * @stability stable
     */
    readonly namespace?: string;
    /**
     * Helm Chart Version for aws-load-balancer-controller.
     *
     * @default - latest Helm Chart version.
     * @stability stable
     */
    readonly chartVersion?: string;
}
/**
 * Generate aws-load-balancer-controller config yaml.
 *
 * see https://github.com/kubernetes-sigs/aws-aws-load-balancer-controller/blob/master/docs/install/v2_0_0_full.yaml
 *
 * @stability stable
 */
export declare class AwsLoadBalancerController extends Construct {
    /**
     * Service Account Name for aws-load-balancer-controller.
     *
     * @stability stable
     */
    readonly serviceAccountName: string;
    /**
     * Kubernetes Cluster Name for aws-load-balancer-controller.
     *
     * @stability stable
     */
    readonly clusterName: string;
    /**
     * Kubernetes Deployment Name for aws-load-balancer-controller.
     *
     * @stability stable
     */
    readonly deploymentName: string;
    /**
     * Namespace for aws-load-balancer-controller.
     *
     * @default - default
     * @stability stable
     */
    readonly namespace: string;
    /**
     * Helm Chart Version for aws-load-balancer-controller.
     *
     * @default - latest Helm Chart version.
     * @stability stable
     */
    readonly chartVersion: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, options: AwsLoadBalancerControllerOptions);
}
