import { Construct } from 'constructs';
import { EnvVar } from './envvar-ins';
/**
 * @stability stable
 */
export interface AlbIngressControllerOptions {
    /**
     * Extra labels to associate with resources.
     *
     * @default - none
     * @stability stable
     */
    readonly labels?: {
        [name: string]: string;
    };
    /**
     * Default Namespace for alb-ingress-controller.
     *
     * @default - kube-system
     * @stability stable
     */
    readonly namespace?: string;
    /**
     * Kubernetes Cluster Name for alb-ingress-controller.
     *
     * @default - None
     * @stability stable
     */
    readonly clusterName: string;
    /**
     * Default Service Account Name for alb-ingress-controller.
     *
     * @default - alb-ingress-controller
     * @stability stable
     */
    readonly serviceAccountName?: string;
    /**
     * Default image for alb-ingress-controller.
     *
     * @default - docker.io/amazon/aws-alb-ingress-controller:v1.1.9
     * @stability stable
     */
    readonly image?: string;
    /**
     * Another Args for alb-ingress-controller.
     *
     * @default - None
     * @stability stable
     */
    readonly args?: string[];
    /**
     * Another Args for alb-ingress-controller.
     *
     * @default - None
     * @stability stable
     */
    readonly env?: EnvVar[];
    /**
     * Replicas for alb-ingress-controller.
     *
     * @default - 1
     * @stability stable
     */
    readonly replicas?: number;
}
/**
 * Generate alb-ingress-controller config yaml.
 *
 * see https://github.com/kubernetes-sigs/aws-alb-ingress-controller/blob/master/docs/examples
 *
 * @stability stable
 */
export declare class AlbIngressController extends Construct {
    /**
     * Service Account Name for alb-ingress-controller.
     *
     * @stability stable
     */
    readonly serviceAccountName: string;
    /**
     * Kubernetes Cluster Name for alb-ingress-controller.
     *
     * @stability stable
     */
    readonly clusterName: string;
    /**
     * Kubernetes Deployment Name for alb-ingress-controller.
     *
     * @stability stable
     */
    readonly deploymentName: string;
    /**
     * Namespace for alb-ingress-controller.
     *
     * @default - kube-system
     * @stability stable
     */
    readonly namespace: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, options: AlbIngressControllerOptions);
    private argsFunc;
    private envFunc;
}
