/**
 * @stability stable
 */
export declare enum VersionsLists {
    /**
     * @stability stable
     */
    AWS_LOAD_BALANCER_CONTROLLER_POLICY_V1 = "v1",
    /**
     * @stability stable
     */
    AWS_LOAD_BALANCER_CONTROLLER_POLICY_V2 = "v2"
}
export declare const awsLoadBalancerControllerPolicyV1: {
    actions: string[];
    resources: string[];
};
export declare const awsLoadBalancerControllerPolicyV2: ({
    Effect: string;
    Action: string[];
    Resource: string;
    Condition?: undefined;
} | {
    Effect: string;
    Action: string[];
    Resource: string;
    Condition: {
        StringEquals: {
            'ec2:CreateAction': string;
        };
        Null: {
            'aws:RequestTag/elbv2.k8s.aws/cluster': string;
            'aws:ResourceTag/elbv2.k8s.aws/cluster'?: undefined;
        };
    };
} | {
    Effect: string;
    Action: string[];
    Resource: string;
    Condition: {
        Null: {
            'aws:RequestTag/elbv2.k8s.aws/cluster': string;
            'aws:ResourceTag/elbv2.k8s.aws/cluster': string;
        };
        StringEquals?: undefined;
    };
} | {
    Effect: string;
    Action: string[];
    Resource: string;
    Condition: {
        Null: {
            'aws:ResourceTag/elbv2.k8s.aws/cluster': string;
            'aws:RequestTag/elbv2.k8s.aws/cluster'?: undefined;
        };
        StringEquals?: undefined;
    };
} | {
    Effect: string;
    Action: string[];
    Resource: string;
    Condition: {
        Null: {
            'aws:RequestTag/elbv2.k8s.aws/cluster': string;
            'aws:ResourceTag/elbv2.k8s.aws/cluster'?: undefined;
        };
        StringEquals?: undefined;
    };
} | {
    Effect: string;
    Action: string[];
    Resource: string[];
    Condition: {
        Null: {
            'aws:RequestTag/elbv2.k8s.aws/cluster': string;
            'aws:ResourceTag/elbv2.k8s.aws/cluster': string;
        };
        StringEquals?: undefined;
    };
} | {
    Effect: string;
    Action: string[];
    Resource: string[];
    Condition?: undefined;
})[];
/**
 * awsLoadBalancePolicy class ,help you add policy to your Iam Role for service account.
 *
 * @stability stable
 */
export declare class AwsLoadBalancePolicy {
    /**
     * @stability stable
     */
    static addPolicy(version: string, role: any): void;
}
