# coding: utf-8

"""
    CloudTower APIs

    cloudtower operation API and SDK  # noqa: E501

    The version of the OpenAPI document: 1.10.0
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class VmNicParams(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'subnet_mask': 'str',
        'gateway': 'str',
        'ip_address': 'str',
        'nic_id': 'str',
        'connect_vlan_id': 'str',
        'mirror': 'bool',
        'model': 'VmNicModel',
        'enabled': 'bool',
        'mac_address': 'str',
        'local_id': 'str'
    }

    attribute_map = {
        'subnet_mask': 'subnet_mask',
        'gateway': 'gateway',
        'ip_address': 'ip_address',
        'nic_id': 'nic_id',
        'connect_vlan_id': 'connect_vlan_id',
        'mirror': 'mirror',
        'model': 'model',
        'enabled': 'enabled',
        'mac_address': 'mac_address',
        'local_id': 'local_id'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """VmNicParams - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._subnet_mask = None
        self._gateway = None
        self._ip_address = None
        self._nic_id = None
        self._connect_vlan_id = None
        self._mirror = None
        self._model = None
        self._enabled = None
        self._mac_address = None
        self._local_id = None
        self.discriminator = None

        if "subnet_mask" in kwargs:
            self.subnet_mask = kwargs["subnet_mask"]
        if "gateway" in kwargs:
            self.gateway = kwargs["gateway"]
        if "ip_address" in kwargs:
            self.ip_address = kwargs["ip_address"]
        if "nic_id" in kwargs:
            self.nic_id = kwargs["nic_id"]
        if "connect_vlan_id" in kwargs:
            self.connect_vlan_id = kwargs["connect_vlan_id"]
        if "mirror" in kwargs:
            self.mirror = kwargs["mirror"]
        if "model" in kwargs:
            self.model = kwargs["model"]
        if "enabled" in kwargs:
            self.enabled = kwargs["enabled"]
        if "mac_address" in kwargs:
            self.mac_address = kwargs["mac_address"]
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]

    @property
    def subnet_mask(self):
        """Gets the subnet_mask of this VmNicParams.  # noqa: E501


        :return: The subnet_mask of this VmNicParams.  # noqa: E501
        :rtype: str
        """
        return self._subnet_mask

    @subnet_mask.setter
    def subnet_mask(self, subnet_mask):
        """Sets the subnet_mask of this VmNicParams.


        :param subnet_mask: The subnet_mask of this VmNicParams.  # noqa: E501
        :type subnet_mask: str
        """

        self._subnet_mask = subnet_mask

    @property
    def gateway(self):
        """Gets the gateway of this VmNicParams.  # noqa: E501


        :return: The gateway of this VmNicParams.  # noqa: E501
        :rtype: str
        """
        return self._gateway

    @gateway.setter
    def gateway(self, gateway):
        """Sets the gateway of this VmNicParams.


        :param gateway: The gateway of this VmNicParams.  # noqa: E501
        :type gateway: str
        """

        self._gateway = gateway

    @property
    def ip_address(self):
        """Gets the ip_address of this VmNicParams.  # noqa: E501


        :return: The ip_address of this VmNicParams.  # noqa: E501
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """Sets the ip_address of this VmNicParams.


        :param ip_address: The ip_address of this VmNicParams.  # noqa: E501
        :type ip_address: str
        """

        self._ip_address = ip_address

    @property
    def nic_id(self):
        """Gets the nic_id of this VmNicParams.  # noqa: E501


        :return: The nic_id of this VmNicParams.  # noqa: E501
        :rtype: str
        """
        return self._nic_id

    @nic_id.setter
    def nic_id(self, nic_id):
        """Sets the nic_id of this VmNicParams.


        :param nic_id: The nic_id of this VmNicParams.  # noqa: E501
        :type nic_id: str
        """

        self._nic_id = nic_id

    @property
    def connect_vlan_id(self):
        """Gets the connect_vlan_id of this VmNicParams.  # noqa: E501


        :return: The connect_vlan_id of this VmNicParams.  # noqa: E501
        :rtype: str
        """
        return self._connect_vlan_id

    @connect_vlan_id.setter
    def connect_vlan_id(self, connect_vlan_id):
        """Sets the connect_vlan_id of this VmNicParams.


        :param connect_vlan_id: The connect_vlan_id of this VmNicParams.  # noqa: E501
        :type connect_vlan_id: str
        """
        if self.local_vars_configuration.client_side_validation and connect_vlan_id is None:  # noqa: E501
            raise ValueError("Invalid value for `connect_vlan_id`, must not be `None`")  # noqa: E501

        self._connect_vlan_id = connect_vlan_id

    @property
    def mirror(self):
        """Gets the mirror of this VmNicParams.  # noqa: E501


        :return: The mirror of this VmNicParams.  # noqa: E501
        :rtype: bool
        """
        return self._mirror

    @mirror.setter
    def mirror(self, mirror):
        """Sets the mirror of this VmNicParams.


        :param mirror: The mirror of this VmNicParams.  # noqa: E501
        :type mirror: bool
        """

        self._mirror = mirror

    @property
    def model(self):
        """Gets the model of this VmNicParams.  # noqa: E501


        :return: The model of this VmNicParams.  # noqa: E501
        :rtype: VmNicModel
        """
        return self._model

    @model.setter
    def model(self, model):
        """Sets the model of this VmNicParams.


        :param model: The model of this VmNicParams.  # noqa: E501
        :type model: VmNicModel
        """

        self._model = model

    @property
    def enabled(self):
        """Gets the enabled of this VmNicParams.  # noqa: E501


        :return: The enabled of this VmNicParams.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this VmNicParams.


        :param enabled: The enabled of this VmNicParams.  # noqa: E501
        :type enabled: bool
        """

        self._enabled = enabled

    @property
    def mac_address(self):
        """Gets the mac_address of this VmNicParams.  # noqa: E501


        :return: The mac_address of this VmNicParams.  # noqa: E501
        :rtype: str
        """
        return self._mac_address

    @mac_address.setter
    def mac_address(self, mac_address):
        """Sets the mac_address of this VmNicParams.


        :param mac_address: The mac_address of this VmNicParams.  # noqa: E501
        :type mac_address: str
        """

        self._mac_address = mac_address

    @property
    def local_id(self):
        """Gets the local_id of this VmNicParams.  # noqa: E501


        :return: The local_id of this VmNicParams.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this VmNicParams.


        :param local_id: The local_id of this VmNicParams.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmNicParams):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VmNicParams):
            return True

        return self.to_dict() != other.to_dict()
