# coding: utf-8

"""
    CloudTower APIs

    cloudtower operation API and SDK  # noqa: E501

    The version of the OpenAPI document: 1.10.0
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class User(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'username': 'str',
        'source': 'UserSource',
        'roles': 'list[UserRoleNext]',
        'role': 'UserRole',
        'password_updated_at': 'object',
        'password_recover_qa': 'PasswordRecoverQa',
        'password_expired': 'bool',
        'name': 'str',
        'mobile_phone': 'str',
        'login_info': 'UserLoginInfo',
        'ldap_dn': 'str',
        'internal': 'bool',
        'id': 'str',
        'email_address': 'str',
        'typename': 'str'
    }

    attribute_map = {
        'username': 'username',
        'source': 'source',
        'roles': 'roles',
        'role': 'role',
        'password_updated_at': 'password_updated_at',
        'password_recover_qa': 'password_recover_qa',
        'password_expired': 'password_expired',
        'name': 'name',
        'mobile_phone': 'mobile_phone',
        'login_info': 'login_info',
        'ldap_dn': 'ldap_dn',
        'internal': 'internal',
        'id': 'id',
        'email_address': 'email_address',
        'typename': '__typename'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """User - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._username = None
        self._source = None
        self._roles = None
        self._role = None
        self._password_updated_at = None
        self._password_recover_qa = None
        self._password_expired = None
        self._name = None
        self._mobile_phone = None
        self._login_info = None
        self._ldap_dn = None
        self._internal = None
        self._id = None
        self._email_address = None
        self._typename = None
        self.discriminator = None

        if "username" in kwargs:
            self.username = kwargs["username"]
        if "source" in kwargs:
            self.source = kwargs["source"]
        self.roles = kwargs.get("roles", None)
        self.role = kwargs.get("role", None)
        self.password_updated_at = kwargs.get("password_updated_at", None)
        self.password_recover_qa = kwargs.get("password_recover_qa", None)
        self.password_expired = kwargs.get("password_expired", None)
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.mobile_phone = kwargs.get("mobile_phone", None)
        self.login_info = kwargs.get("login_info", None)
        self.ldap_dn = kwargs.get("ldap_dn", None)
        if "internal" in kwargs:
            self.internal = kwargs["internal"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.email_address = kwargs.get("email_address", None)
        if "typename" in kwargs:
            self.typename = kwargs["typename"]

    @property
    def username(self):
        """Gets the username of this User.  # noqa: E501


        :return: The username of this User.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this User.


        :param username: The username of this User.  # noqa: E501
        :type username: str
        """
        if self.local_vars_configuration.client_side_validation and username is None:  # noqa: E501
            raise ValueError("Invalid value for `username`, must not be `None`")  # noqa: E501

        self._username = username

    @property
    def source(self):
        """Gets the source of this User.  # noqa: E501


        :return: The source of this User.  # noqa: E501
        :rtype: UserSource
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this User.


        :param source: The source of this User.  # noqa: E501
        :type source: UserSource
        """
        if self.local_vars_configuration.client_side_validation and source is None:  # noqa: E501
            raise ValueError("Invalid value for `source`, must not be `None`")  # noqa: E501

        self._source = source

    @property
    def roles(self):
        """Gets the roles of this User.  # noqa: E501


        :return: The roles of this User.  # noqa: E501
        :rtype: list[UserRoleNext]
        """
        return self._roles

    @roles.setter
    def roles(self, roles):
        """Sets the roles of this User.


        :param roles: The roles of this User.  # noqa: E501
        :type roles: list[UserRoleNext]
        """

        self._roles = roles

    @property
    def role(self):
        """Gets the role of this User.  # noqa: E501


        :return: The role of this User.  # noqa: E501
        :rtype: UserRole
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this User.


        :param role: The role of this User.  # noqa: E501
        :type role: UserRole
        """

        self._role = role

    @property
    def password_updated_at(self):
        """Gets the password_updated_at of this User.  # noqa: E501


        :return: The password_updated_at of this User.  # noqa: E501
        :rtype: object
        """
        return self._password_updated_at

    @password_updated_at.setter
    def password_updated_at(self, password_updated_at):
        """Sets the password_updated_at of this User.


        :param password_updated_at: The password_updated_at of this User.  # noqa: E501
        :type password_updated_at: object
        """

        self._password_updated_at = password_updated_at

    @property
    def password_recover_qa(self):
        """Gets the password_recover_qa of this User.  # noqa: E501


        :return: The password_recover_qa of this User.  # noqa: E501
        :rtype: PasswordRecoverQa
        """
        return self._password_recover_qa

    @password_recover_qa.setter
    def password_recover_qa(self, password_recover_qa):
        """Sets the password_recover_qa of this User.


        :param password_recover_qa: The password_recover_qa of this User.  # noqa: E501
        :type password_recover_qa: PasswordRecoverQa
        """

        self._password_recover_qa = password_recover_qa

    @property
    def password_expired(self):
        """Gets the password_expired of this User.  # noqa: E501


        :return: The password_expired of this User.  # noqa: E501
        :rtype: bool
        """
        return self._password_expired

    @password_expired.setter
    def password_expired(self, password_expired):
        """Sets the password_expired of this User.


        :param password_expired: The password_expired of this User.  # noqa: E501
        :type password_expired: bool
        """

        self._password_expired = password_expired

    @property
    def name(self):
        """Gets the name of this User.  # noqa: E501


        :return: The name of this User.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this User.


        :param name: The name of this User.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def mobile_phone(self):
        """Gets the mobile_phone of this User.  # noqa: E501


        :return: The mobile_phone of this User.  # noqa: E501
        :rtype: str
        """
        return self._mobile_phone

    @mobile_phone.setter
    def mobile_phone(self, mobile_phone):
        """Sets the mobile_phone of this User.


        :param mobile_phone: The mobile_phone of this User.  # noqa: E501
        :type mobile_phone: str
        """

        self._mobile_phone = mobile_phone

    @property
    def login_info(self):
        """Gets the login_info of this User.  # noqa: E501


        :return: The login_info of this User.  # noqa: E501
        :rtype: UserLoginInfo
        """
        return self._login_info

    @login_info.setter
    def login_info(self, login_info):
        """Sets the login_info of this User.


        :param login_info: The login_info of this User.  # noqa: E501
        :type login_info: UserLoginInfo
        """

        self._login_info = login_info

    @property
    def ldap_dn(self):
        """Gets the ldap_dn of this User.  # noqa: E501


        :return: The ldap_dn of this User.  # noqa: E501
        :rtype: str
        """
        return self._ldap_dn

    @ldap_dn.setter
    def ldap_dn(self, ldap_dn):
        """Sets the ldap_dn of this User.


        :param ldap_dn: The ldap_dn of this User.  # noqa: E501
        :type ldap_dn: str
        """

        self._ldap_dn = ldap_dn

    @property
    def internal(self):
        """Gets the internal of this User.  # noqa: E501


        :return: The internal of this User.  # noqa: E501
        :rtype: bool
        """
        return self._internal

    @internal.setter
    def internal(self, internal):
        """Sets the internal of this User.


        :param internal: The internal of this User.  # noqa: E501
        :type internal: bool
        """
        if self.local_vars_configuration.client_side_validation and internal is None:  # noqa: E501
            raise ValueError("Invalid value for `internal`, must not be `None`")  # noqa: E501

        self._internal = internal

    @property
    def id(self):
        """Gets the id of this User.  # noqa: E501


        :return: The id of this User.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this User.


        :param id: The id of this User.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def email_address(self):
        """Gets the email_address of this User.  # noqa: E501


        :return: The email_address of this User.  # noqa: E501
        :rtype: str
        """
        return self._email_address

    @email_address.setter
    def email_address(self, email_address):
        """Sets the email_address of this User.


        :param email_address: The email_address of this User.  # noqa: E501
        :type email_address: str
        """

        self._email_address = email_address

    @property
    def typename(self):
        """Gets the typename of this User.  # noqa: E501


        :return: The typename of this User.  # noqa: E501
        :rtype: str
        """
        return self._typename

    @typename.setter
    def typename(self, typename):
        """Sets the typename of this User.


        :param typename: The typename of this User.  # noqa: E501
        :type typename: str
        """
        allowed_values = ["User"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and typename not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `typename` ({0}), must be one of {1}"  # noqa: E501
                .format(typename, allowed_values)
            )

        self._typename = typename

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, User):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, User):
            return True

        return self.to_dict() != other.to_dict()
