# coding: utf-8

"""
    CloudTower APIs

    cloudtower operation API and SDK  # noqa: E501

    The version of the OpenAPI document: 1.10.0
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class SecurityPolicy(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'apply_to': 'list[NestedSecurityPolicyApply]',
        'description': 'str',
        'egress': 'list[NestedNetworkPolicyRule]',
        'everoute_cluster': 'NestedEverouteCluster',
        'id': 'str',
        'ingress': 'list[NestedNetworkPolicyRule]',
        'name': 'str',
        'policy_mode': 'PolicyMode'
    }

    attribute_map = {
        'apply_to': 'apply_to',
        'description': 'description',
        'egress': 'egress',
        'everoute_cluster': 'everoute_cluster',
        'id': 'id',
        'ingress': 'ingress',
        'name': 'name',
        'policy_mode': 'policy_mode'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """SecurityPolicy - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._apply_to = None
        self._description = None
        self._egress = None
        self._everoute_cluster = None
        self._id = None
        self._ingress = None
        self._name = None
        self._policy_mode = None
        self.discriminator = None

        if "apply_to" in kwargs:
            self.apply_to = kwargs["apply_to"]
        if "description" in kwargs:
            self.description = kwargs["description"]
        self.egress = kwargs.get("egress", None)
        if "everoute_cluster" in kwargs:
            self.everoute_cluster = kwargs["everoute_cluster"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.ingress = kwargs.get("ingress", None)
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.policy_mode = kwargs.get("policy_mode", None)

    @property
    def apply_to(self):
        """Gets the apply_to of this SecurityPolicy.  # noqa: E501


        :return: The apply_to of this SecurityPolicy.  # noqa: E501
        :rtype: list[NestedSecurityPolicyApply]
        """
        return self._apply_to

    @apply_to.setter
    def apply_to(self, apply_to):
        """Sets the apply_to of this SecurityPolicy.


        :param apply_to: The apply_to of this SecurityPolicy.  # noqa: E501
        :type apply_to: list[NestedSecurityPolicyApply]
        """
        if self.local_vars_configuration.client_side_validation and apply_to is None:  # noqa: E501
            raise ValueError("Invalid value for `apply_to`, must not be `None`")  # noqa: E501

        self._apply_to = apply_to

    @property
    def description(self):
        """Gets the description of this SecurityPolicy.  # noqa: E501


        :return: The description of this SecurityPolicy.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this SecurityPolicy.


        :param description: The description of this SecurityPolicy.  # noqa: E501
        :type description: str
        """
        if self.local_vars_configuration.client_side_validation and description is None:  # noqa: E501
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def egress(self):
        """Gets the egress of this SecurityPolicy.  # noqa: E501


        :return: The egress of this SecurityPolicy.  # noqa: E501
        :rtype: list[NestedNetworkPolicyRule]
        """
        return self._egress

    @egress.setter
    def egress(self, egress):
        """Sets the egress of this SecurityPolicy.


        :param egress: The egress of this SecurityPolicy.  # noqa: E501
        :type egress: list[NestedNetworkPolicyRule]
        """

        self._egress = egress

    @property
    def everoute_cluster(self):
        """Gets the everoute_cluster of this SecurityPolicy.  # noqa: E501


        :return: The everoute_cluster of this SecurityPolicy.  # noqa: E501
        :rtype: NestedEverouteCluster
        """
        return self._everoute_cluster

    @everoute_cluster.setter
    def everoute_cluster(self, everoute_cluster):
        """Sets the everoute_cluster of this SecurityPolicy.


        :param everoute_cluster: The everoute_cluster of this SecurityPolicy.  # noqa: E501
        :type everoute_cluster: NestedEverouteCluster
        """
        if self.local_vars_configuration.client_side_validation and everoute_cluster is None:  # noqa: E501
            raise ValueError("Invalid value for `everoute_cluster`, must not be `None`")  # noqa: E501

        self._everoute_cluster = everoute_cluster

    @property
    def id(self):
        """Gets the id of this SecurityPolicy.  # noqa: E501


        :return: The id of this SecurityPolicy.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SecurityPolicy.


        :param id: The id of this SecurityPolicy.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def ingress(self):
        """Gets the ingress of this SecurityPolicy.  # noqa: E501


        :return: The ingress of this SecurityPolicy.  # noqa: E501
        :rtype: list[NestedNetworkPolicyRule]
        """
        return self._ingress

    @ingress.setter
    def ingress(self, ingress):
        """Sets the ingress of this SecurityPolicy.


        :param ingress: The ingress of this SecurityPolicy.  # noqa: E501
        :type ingress: list[NestedNetworkPolicyRule]
        """

        self._ingress = ingress

    @property
    def name(self):
        """Gets the name of this SecurityPolicy.  # noqa: E501


        :return: The name of this SecurityPolicy.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SecurityPolicy.


        :param name: The name of this SecurityPolicy.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def policy_mode(self):
        """Gets the policy_mode of this SecurityPolicy.  # noqa: E501


        :return: The policy_mode of this SecurityPolicy.  # noqa: E501
        :rtype: PolicyMode
        """
        return self._policy_mode

    @policy_mode.setter
    def policy_mode(self, policy_mode):
        """Sets the policy_mode of this SecurityPolicy.


        :param policy_mode: The policy_mode of this SecurityPolicy.  # noqa: E501
        :type policy_mode: PolicyMode
        """

        self._policy_mode = policy_mode

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SecurityPolicy):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SecurityPolicy):
            return True

        return self.to_dict() != other.to_dict()
