# coding: utf-8

"""
    CloudTower APIs

    cloudtower operation API and SDK  # noqa: E501

    The version of the OpenAPI document: 1.10.0
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class NfsExport(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cluster': 'NestedCluster',
        'description': 'str',
        'entity_async_status': 'EntityAsyncStatus',
        'export_inode_id': 'str',
        'id': 'str',
        'inodes': 'list[NestedNfsInode]',
        'internal': 'bool',
        'ip_whitelist': 'str',
        'labels': 'list[NestedLabel]',
        'local_id': 'str',
        'name': 'str',
        'replica_num': 'int',
        'thin_provision': 'bool'
    }

    attribute_map = {
        'cluster': 'cluster',
        'description': 'description',
        'entity_async_status': 'entityAsyncStatus',
        'export_inode_id': 'export_inode_id',
        'id': 'id',
        'inodes': 'inodes',
        'internal': 'internal',
        'ip_whitelist': 'ip_whitelist',
        'labels': 'labels',
        'local_id': 'local_id',
        'name': 'name',
        'replica_num': 'replica_num',
        'thin_provision': 'thin_provision'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """NfsExport - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._cluster = None
        self._description = None
        self._entity_async_status = None
        self._export_inode_id = None
        self._id = None
        self._inodes = None
        self._internal = None
        self._ip_whitelist = None
        self._labels = None
        self._local_id = None
        self._name = None
        self._replica_num = None
        self._thin_provision = None
        self.discriminator = None

        if "cluster" in kwargs:
            self.cluster = kwargs["cluster"]
        if "description" in kwargs:
            self.description = kwargs["description"]
        self.entity_async_status = kwargs.get("entity_async_status", None)
        if "export_inode_id" in kwargs:
            self.export_inode_id = kwargs["export_inode_id"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.inodes = kwargs.get("inodes", None)
        if "internal" in kwargs:
            self.internal = kwargs["internal"]
        if "ip_whitelist" in kwargs:
            self.ip_whitelist = kwargs["ip_whitelist"]
        self.labels = kwargs.get("labels", None)
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "replica_num" in kwargs:
            self.replica_num = kwargs["replica_num"]
        if "thin_provision" in kwargs:
            self.thin_provision = kwargs["thin_provision"]

    @property
    def cluster(self):
        """Gets the cluster of this NfsExport.  # noqa: E501


        :return: The cluster of this NfsExport.  # noqa: E501
        :rtype: NestedCluster
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this NfsExport.


        :param cluster: The cluster of this NfsExport.  # noqa: E501
        :type cluster: NestedCluster
        """
        if self.local_vars_configuration.client_side_validation and cluster is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster`, must not be `None`")  # noqa: E501

        self._cluster = cluster

    @property
    def description(self):
        """Gets the description of this NfsExport.  # noqa: E501


        :return: The description of this NfsExport.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this NfsExport.


        :param description: The description of this NfsExport.  # noqa: E501
        :type description: str
        """
        if self.local_vars_configuration.client_side_validation and description is None:  # noqa: E501
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this NfsExport.  # noqa: E501


        :return: The entity_async_status of this NfsExport.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this NfsExport.


        :param entity_async_status: The entity_async_status of this NfsExport.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def export_inode_id(self):
        """Gets the export_inode_id of this NfsExport.  # noqa: E501


        :return: The export_inode_id of this NfsExport.  # noqa: E501
        :rtype: str
        """
        return self._export_inode_id

    @export_inode_id.setter
    def export_inode_id(self, export_inode_id):
        """Sets the export_inode_id of this NfsExport.


        :param export_inode_id: The export_inode_id of this NfsExport.  # noqa: E501
        :type export_inode_id: str
        """
        if self.local_vars_configuration.client_side_validation and export_inode_id is None:  # noqa: E501
            raise ValueError("Invalid value for `export_inode_id`, must not be `None`")  # noqa: E501

        self._export_inode_id = export_inode_id

    @property
    def id(self):
        """Gets the id of this NfsExport.  # noqa: E501


        :return: The id of this NfsExport.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this NfsExport.


        :param id: The id of this NfsExport.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def inodes(self):
        """Gets the inodes of this NfsExport.  # noqa: E501


        :return: The inodes of this NfsExport.  # noqa: E501
        :rtype: list[NestedNfsInode]
        """
        return self._inodes

    @inodes.setter
    def inodes(self, inodes):
        """Sets the inodes of this NfsExport.


        :param inodes: The inodes of this NfsExport.  # noqa: E501
        :type inodes: list[NestedNfsInode]
        """

        self._inodes = inodes

    @property
    def internal(self):
        """Gets the internal of this NfsExport.  # noqa: E501


        :return: The internal of this NfsExport.  # noqa: E501
        :rtype: bool
        """
        return self._internal

    @internal.setter
    def internal(self, internal):
        """Sets the internal of this NfsExport.


        :param internal: The internal of this NfsExport.  # noqa: E501
        :type internal: bool
        """
        if self.local_vars_configuration.client_side_validation and internal is None:  # noqa: E501
            raise ValueError("Invalid value for `internal`, must not be `None`")  # noqa: E501

        self._internal = internal

    @property
    def ip_whitelist(self):
        """Gets the ip_whitelist of this NfsExport.  # noqa: E501


        :return: The ip_whitelist of this NfsExport.  # noqa: E501
        :rtype: str
        """
        return self._ip_whitelist

    @ip_whitelist.setter
    def ip_whitelist(self, ip_whitelist):
        """Sets the ip_whitelist of this NfsExport.


        :param ip_whitelist: The ip_whitelist of this NfsExport.  # noqa: E501
        :type ip_whitelist: str
        """
        if self.local_vars_configuration.client_side_validation and ip_whitelist is None:  # noqa: E501
            raise ValueError("Invalid value for `ip_whitelist`, must not be `None`")  # noqa: E501

        self._ip_whitelist = ip_whitelist

    @property
    def labels(self):
        """Gets the labels of this NfsExport.  # noqa: E501


        :return: The labels of this NfsExport.  # noqa: E501
        :rtype: list[NestedLabel]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this NfsExport.


        :param labels: The labels of this NfsExport.  # noqa: E501
        :type labels: list[NestedLabel]
        """

        self._labels = labels

    @property
    def local_id(self):
        """Gets the local_id of this NfsExport.  # noqa: E501


        :return: The local_id of this NfsExport.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this NfsExport.


        :param local_id: The local_id of this NfsExport.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def name(self):
        """Gets the name of this NfsExport.  # noqa: E501


        :return: The name of this NfsExport.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this NfsExport.


        :param name: The name of this NfsExport.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def replica_num(self):
        """Gets the replica_num of this NfsExport.  # noqa: E501


        :return: The replica_num of this NfsExport.  # noqa: E501
        :rtype: int
        """
        return self._replica_num

    @replica_num.setter
    def replica_num(self, replica_num):
        """Sets the replica_num of this NfsExport.


        :param replica_num: The replica_num of this NfsExport.  # noqa: E501
        :type replica_num: int
        """
        if self.local_vars_configuration.client_side_validation and replica_num is None:  # noqa: E501
            raise ValueError("Invalid value for `replica_num`, must not be `None`")  # noqa: E501

        self._replica_num = replica_num

    @property
    def thin_provision(self):
        """Gets the thin_provision of this NfsExport.  # noqa: E501


        :return: The thin_provision of this NfsExport.  # noqa: E501
        :rtype: bool
        """
        return self._thin_provision

    @thin_provision.setter
    def thin_provision(self, thin_provision):
        """Sets the thin_provision of this NfsExport.


        :param thin_provision: The thin_provision of this NfsExport.  # noqa: E501
        :type thin_provision: bool
        """
        if self.local_vars_configuration.client_side_validation and thin_provision is None:  # noqa: E501
            raise ValueError("Invalid value for `thin_provision`, must not be `None`")  # noqa: E501

        self._thin_provision = thin_provision

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NfsExport):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NfsExport):
            return True

        return self.to_dict() != other.to_dict()
