# coding: utf-8

"""
    CloudTower APIs

    cloudtower operation API and SDK  # noqa: E501

    The version of the OpenAPI document: 1.10.0
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class IsolationPolicy(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'egress': 'list[NestedNetworkPolicyRule]',
        'everoute_cluster': 'NestedEverouteCluster',
        'id': 'str',
        'ingress': 'list[NestedNetworkPolicyRule]',
        'labels': 'list[NestedLabel]',
        'mode': 'IsolationMode',
        'vm': 'NestedVm'
    }

    attribute_map = {
        'egress': 'egress',
        'everoute_cluster': 'everoute_cluster',
        'id': 'id',
        'ingress': 'ingress',
        'labels': 'labels',
        'mode': 'mode',
        'vm': 'vm'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """IsolationPolicy - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._egress = None
        self._everoute_cluster = None
        self._id = None
        self._ingress = None
        self._labels = None
        self._mode = None
        self._vm = None
        self.discriminator = None

        self.egress = kwargs.get("egress", None)
        if "everoute_cluster" in kwargs:
            self.everoute_cluster = kwargs["everoute_cluster"]
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.ingress = kwargs.get("ingress", None)
        self.labels = kwargs.get("labels", None)
        if "mode" in kwargs:
            self.mode = kwargs["mode"]
        if "vm" in kwargs:
            self.vm = kwargs["vm"]

    @property
    def egress(self):
        """Gets the egress of this IsolationPolicy.  # noqa: E501


        :return: The egress of this IsolationPolicy.  # noqa: E501
        :rtype: list[NestedNetworkPolicyRule]
        """
        return self._egress

    @egress.setter
    def egress(self, egress):
        """Sets the egress of this IsolationPolicy.


        :param egress: The egress of this IsolationPolicy.  # noqa: E501
        :type egress: list[NestedNetworkPolicyRule]
        """

        self._egress = egress

    @property
    def everoute_cluster(self):
        """Gets the everoute_cluster of this IsolationPolicy.  # noqa: E501


        :return: The everoute_cluster of this IsolationPolicy.  # noqa: E501
        :rtype: NestedEverouteCluster
        """
        return self._everoute_cluster

    @everoute_cluster.setter
    def everoute_cluster(self, everoute_cluster):
        """Sets the everoute_cluster of this IsolationPolicy.


        :param everoute_cluster: The everoute_cluster of this IsolationPolicy.  # noqa: E501
        :type everoute_cluster: NestedEverouteCluster
        """
        if self.local_vars_configuration.client_side_validation and everoute_cluster is None:  # noqa: E501
            raise ValueError("Invalid value for `everoute_cluster`, must not be `None`")  # noqa: E501

        self._everoute_cluster = everoute_cluster

    @property
    def id(self):
        """Gets the id of this IsolationPolicy.  # noqa: E501


        :return: The id of this IsolationPolicy.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this IsolationPolicy.


        :param id: The id of this IsolationPolicy.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def ingress(self):
        """Gets the ingress of this IsolationPolicy.  # noqa: E501


        :return: The ingress of this IsolationPolicy.  # noqa: E501
        :rtype: list[NestedNetworkPolicyRule]
        """
        return self._ingress

    @ingress.setter
    def ingress(self, ingress):
        """Sets the ingress of this IsolationPolicy.


        :param ingress: The ingress of this IsolationPolicy.  # noqa: E501
        :type ingress: list[NestedNetworkPolicyRule]
        """

        self._ingress = ingress

    @property
    def labels(self):
        """Gets the labels of this IsolationPolicy.  # noqa: E501


        :return: The labels of this IsolationPolicy.  # noqa: E501
        :rtype: list[NestedLabel]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this IsolationPolicy.


        :param labels: The labels of this IsolationPolicy.  # noqa: E501
        :type labels: list[NestedLabel]
        """

        self._labels = labels

    @property
    def mode(self):
        """Gets the mode of this IsolationPolicy.  # noqa: E501


        :return: The mode of this IsolationPolicy.  # noqa: E501
        :rtype: IsolationMode
        """
        return self._mode

    @mode.setter
    def mode(self, mode):
        """Sets the mode of this IsolationPolicy.


        :param mode: The mode of this IsolationPolicy.  # noqa: E501
        :type mode: IsolationMode
        """
        if self.local_vars_configuration.client_side_validation and mode is None:  # noqa: E501
            raise ValueError("Invalid value for `mode`, must not be `None`")  # noqa: E501

        self._mode = mode

    @property
    def vm(self):
        """Gets the vm of this IsolationPolicy.  # noqa: E501


        :return: The vm of this IsolationPolicy.  # noqa: E501
        :rtype: NestedVm
        """
        return self._vm

    @vm.setter
    def vm(self, vm):
        """Sets the vm of this IsolationPolicy.


        :param vm: The vm of this IsolationPolicy.  # noqa: E501
        :type vm: NestedVm
        """
        if self.local_vars_configuration.client_side_validation and vm is None:  # noqa: E501
            raise ValueError("Invalid value for `vm`, must not be `None`")  # noqa: E501

        self._vm = vm

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IsolationPolicy):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, IsolationPolicy):
            return True

        return self.to_dict() != other.to_dict()
