# coding: utf-8

"""
    CloudTower APIs

    cloudtower operation API and SDK  # noqa: E501

    The version of the OpenAPI document: 1.10.0
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class Host(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'access_ip': 'str',
        'allocatable_memory_bytes': 'int',
        'chunk_id': 'str',
        'cluster': 'NestedCluster',
        'compatible_cpu_models': 'list[str]',
        'cpu_brand': 'str',
        'cpu_fan_speed': 'list[float]',
        'cpu_fan_speed_unit': 'CpuFanSpeedUnit',
        'cpu_hz_per_core': 'int',
        'cpu_model': 'str',
        'cpu_temperature_celsius': 'list[int]',
        'cpu_vendor': 'str',
        'data_ip': 'str',
        'disks': 'list[NestedDisk]',
        'failure_data_space': 'int',
        'hdd_data_capacity': 'int',
        'hdd_disk_count': 'int',
        'hypervisor_ip': 'str',
        'id': 'str',
        'ipmi': 'NestedIpmi',
        'is_os_in_raid1': 'bool',
        'labels': 'list[NestedLabel]',
        'local_id': 'str',
        'lsm_cap_disk_safe_umount': 'bool',
        'management_ip': 'str',
        'model': 'str',
        'name': 'str',
        'nested_virtualization': 'bool',
        'nic_count': 'int',
        'nics': 'list[NestedNic]',
        'node_topo_local_id': 'str',
        'os_memory_bytes': 'int',
        'os_version': 'str',
        'pmem_dimm_capacity': 'int',
        'pmem_dimm_count': 'int',
        'pmem_dimms': 'list[NestedPmemDimm]',
        'pmem_disk_count': 'int',
        'provisioned_cpu_cores': 'int',
        'provisioned_memory_bytes': 'int',
        'running_pause_vm_memory_bytes': 'int',
        'running_vm_num': 'int',
        'scvm_cpu': 'int',
        'scvm_memory': 'int',
        'scvm_name': 'str',
        'serial': 'str',
        'ssd_data_capacity': 'int',
        'ssd_disk_count': 'int',
        'state': 'HostState',
        'status': 'HostStatus',
        'stopped_vm_num': 'int',
        'suspended_vm_num': 'int',
        'total_cache_capacity': 'int',
        'total_cpu_cores': 'int',
        'total_cpu_hz': 'int',
        'total_cpu_sockets': 'int',
        'total_data_capacity': 'int',
        'total_memory_bytes': 'int',
        'usb_devices': 'list[NestedUsbDevice]',
        'used_cpu_hz': 'int',
        'used_data_space': 'int',
        'used_memory_bytes': 'int',
        'vm_num': 'int',
        'vmotion_ip': 'str',
        'vms': 'list[NestedVm]',
        'vsphere_esxi_account': 'NestedVsphereEsxiAccount',
        'with_faster_ssd_as_cache': 'bool',
        'zone': 'NestedZone'
    }

    attribute_map = {
        'access_ip': 'access_ip',
        'allocatable_memory_bytes': 'allocatable_memory_bytes',
        'chunk_id': 'chunk_id',
        'cluster': 'cluster',
        'compatible_cpu_models': 'compatible_cpu_models',
        'cpu_brand': 'cpu_brand',
        'cpu_fan_speed': 'cpu_fan_speed',
        'cpu_fan_speed_unit': 'cpu_fan_speed_unit',
        'cpu_hz_per_core': 'cpu_hz_per_core',
        'cpu_model': 'cpu_model',
        'cpu_temperature_celsius': 'cpu_temperature_celsius',
        'cpu_vendor': 'cpu_vendor',
        'data_ip': 'data_ip',
        'disks': 'disks',
        'failure_data_space': 'failure_data_space',
        'hdd_data_capacity': 'hdd_data_capacity',
        'hdd_disk_count': 'hdd_disk_count',
        'hypervisor_ip': 'hypervisor_ip',
        'id': 'id',
        'ipmi': 'ipmi',
        'is_os_in_raid1': 'is_os_in_raid1',
        'labels': 'labels',
        'local_id': 'local_id',
        'lsm_cap_disk_safe_umount': 'lsm_cap_disk_safe_umount',
        'management_ip': 'management_ip',
        'model': 'model',
        'name': 'name',
        'nested_virtualization': 'nested_virtualization',
        'nic_count': 'nic_count',
        'nics': 'nics',
        'node_topo_local_id': 'node_topo_local_id',
        'os_memory_bytes': 'os_memory_bytes',
        'os_version': 'os_version',
        'pmem_dimm_capacity': 'pmem_dimm_capacity',
        'pmem_dimm_count': 'pmem_dimm_count',
        'pmem_dimms': 'pmem_dimms',
        'pmem_disk_count': 'pmem_disk_count',
        'provisioned_cpu_cores': 'provisioned_cpu_cores',
        'provisioned_memory_bytes': 'provisioned_memory_bytes',
        'running_pause_vm_memory_bytes': 'running_pause_vm_memory_bytes',
        'running_vm_num': 'running_vm_num',
        'scvm_cpu': 'scvm_cpu',
        'scvm_memory': 'scvm_memory',
        'scvm_name': 'scvm_name',
        'serial': 'serial',
        'ssd_data_capacity': 'ssd_data_capacity',
        'ssd_disk_count': 'ssd_disk_count',
        'state': 'state',
        'status': 'status',
        'stopped_vm_num': 'stopped_vm_num',
        'suspended_vm_num': 'suspended_vm_num',
        'total_cache_capacity': 'total_cache_capacity',
        'total_cpu_cores': 'total_cpu_cores',
        'total_cpu_hz': 'total_cpu_hz',
        'total_cpu_sockets': 'total_cpu_sockets',
        'total_data_capacity': 'total_data_capacity',
        'total_memory_bytes': 'total_memory_bytes',
        'usb_devices': 'usb_devices',
        'used_cpu_hz': 'used_cpu_hz',
        'used_data_space': 'used_data_space',
        'used_memory_bytes': 'used_memory_bytes',
        'vm_num': 'vm_num',
        'vmotion_ip': 'vmotion_ip',
        'vms': 'vms',
        'vsphere_esxi_account': 'vsphereEsxiAccount',
        'with_faster_ssd_as_cache': 'with_faster_ssd_as_cache',
        'zone': 'zone'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """Host - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._access_ip = None
        self._allocatable_memory_bytes = None
        self._chunk_id = None
        self._cluster = None
        self._compatible_cpu_models = None
        self._cpu_brand = None
        self._cpu_fan_speed = None
        self._cpu_fan_speed_unit = None
        self._cpu_hz_per_core = None
        self._cpu_model = None
        self._cpu_temperature_celsius = None
        self._cpu_vendor = None
        self._data_ip = None
        self._disks = None
        self._failure_data_space = None
        self._hdd_data_capacity = None
        self._hdd_disk_count = None
        self._hypervisor_ip = None
        self._id = None
        self._ipmi = None
        self._is_os_in_raid1 = None
        self._labels = None
        self._local_id = None
        self._lsm_cap_disk_safe_umount = None
        self._management_ip = None
        self._model = None
        self._name = None
        self._nested_virtualization = None
        self._nic_count = None
        self._nics = None
        self._node_topo_local_id = None
        self._os_memory_bytes = None
        self._os_version = None
        self._pmem_dimm_capacity = None
        self._pmem_dimm_count = None
        self._pmem_dimms = None
        self._pmem_disk_count = None
        self._provisioned_cpu_cores = None
        self._provisioned_memory_bytes = None
        self._running_pause_vm_memory_bytes = None
        self._running_vm_num = None
        self._scvm_cpu = None
        self._scvm_memory = None
        self._scvm_name = None
        self._serial = None
        self._ssd_data_capacity = None
        self._ssd_disk_count = None
        self._state = None
        self._status = None
        self._stopped_vm_num = None
        self._suspended_vm_num = None
        self._total_cache_capacity = None
        self._total_cpu_cores = None
        self._total_cpu_hz = None
        self._total_cpu_sockets = None
        self._total_data_capacity = None
        self._total_memory_bytes = None
        self._usb_devices = None
        self._used_cpu_hz = None
        self._used_data_space = None
        self._used_memory_bytes = None
        self._vm_num = None
        self._vmotion_ip = None
        self._vms = None
        self._vsphere_esxi_account = None
        self._with_faster_ssd_as_cache = None
        self._zone = None
        self.discriminator = None

        self.access_ip = kwargs.get("access_ip", None)
        if "allocatable_memory_bytes" in kwargs:
            self.allocatable_memory_bytes = kwargs["allocatable_memory_bytes"]
        if "chunk_id" in kwargs:
            self.chunk_id = kwargs["chunk_id"]
        if "cluster" in kwargs:
            self.cluster = kwargs["cluster"]
        if "compatible_cpu_models" in kwargs:
            self.compatible_cpu_models = kwargs["compatible_cpu_models"]
        if "cpu_brand" in kwargs:
            self.cpu_brand = kwargs["cpu_brand"]
        if "cpu_fan_speed" in kwargs:
            self.cpu_fan_speed = kwargs["cpu_fan_speed"]
        self.cpu_fan_speed_unit = kwargs.get("cpu_fan_speed_unit", None)
        if "cpu_hz_per_core" in kwargs:
            self.cpu_hz_per_core = kwargs["cpu_hz_per_core"]
        if "cpu_model" in kwargs:
            self.cpu_model = kwargs["cpu_model"]
        if "cpu_temperature_celsius" in kwargs:
            self.cpu_temperature_celsius = kwargs["cpu_temperature_celsius"]
        self.cpu_vendor = kwargs.get("cpu_vendor", None)
        self.data_ip = kwargs.get("data_ip", None)
        self.disks = kwargs.get("disks", None)
        if "failure_data_space" in kwargs:
            self.failure_data_space = kwargs["failure_data_space"]
        if "hdd_data_capacity" in kwargs:
            self.hdd_data_capacity = kwargs["hdd_data_capacity"]
        if "hdd_disk_count" in kwargs:
            self.hdd_disk_count = kwargs["hdd_disk_count"]
        self.hypervisor_ip = kwargs.get("hypervisor_ip", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        self.ipmi = kwargs.get("ipmi", None)
        self.is_os_in_raid1 = kwargs.get("is_os_in_raid1", None)
        self.labels = kwargs.get("labels", None)
        if "local_id" in kwargs:
            self.local_id = kwargs["local_id"]
        if "lsm_cap_disk_safe_umount" in kwargs:
            self.lsm_cap_disk_safe_umount = kwargs["lsm_cap_disk_safe_umount"]
        if "management_ip" in kwargs:
            self.management_ip = kwargs["management_ip"]
        if "model" in kwargs:
            self.model = kwargs["model"]
        if "name" in kwargs:
            self.name = kwargs["name"]
        if "nested_virtualization" in kwargs:
            self.nested_virtualization = kwargs["nested_virtualization"]
        if "nic_count" in kwargs:
            self.nic_count = kwargs["nic_count"]
        self.nics = kwargs.get("nics", None)
        self.node_topo_local_id = kwargs.get("node_topo_local_id", None)
        if "os_memory_bytes" in kwargs:
            self.os_memory_bytes = kwargs["os_memory_bytes"]
        self.os_version = kwargs.get("os_version", None)
        if "pmem_dimm_capacity" in kwargs:
            self.pmem_dimm_capacity = kwargs["pmem_dimm_capacity"]
        if "pmem_dimm_count" in kwargs:
            self.pmem_dimm_count = kwargs["pmem_dimm_count"]
        self.pmem_dimms = kwargs.get("pmem_dimms", None)
        if "pmem_disk_count" in kwargs:
            self.pmem_disk_count = kwargs["pmem_disk_count"]
        if "provisioned_cpu_cores" in kwargs:
            self.provisioned_cpu_cores = kwargs["provisioned_cpu_cores"]
        if "provisioned_memory_bytes" in kwargs:
            self.provisioned_memory_bytes = kwargs["provisioned_memory_bytes"]
        if "running_pause_vm_memory_bytes" in kwargs:
            self.running_pause_vm_memory_bytes = kwargs["running_pause_vm_memory_bytes"]
        self.running_vm_num = kwargs.get("running_vm_num", None)
        self.scvm_cpu = kwargs.get("scvm_cpu", None)
        self.scvm_memory = kwargs.get("scvm_memory", None)
        self.scvm_name = kwargs.get("scvm_name", None)
        self.serial = kwargs.get("serial", None)
        if "ssd_data_capacity" in kwargs:
            self.ssd_data_capacity = kwargs["ssd_data_capacity"]
        if "ssd_disk_count" in kwargs:
            self.ssd_disk_count = kwargs["ssd_disk_count"]
        if "state" in kwargs:
            self.state = kwargs["state"]
        if "status" in kwargs:
            self.status = kwargs["status"]
        self.stopped_vm_num = kwargs.get("stopped_vm_num", None)
        self.suspended_vm_num = kwargs.get("suspended_vm_num", None)
        self.total_cache_capacity = kwargs.get("total_cache_capacity", None)
        if "total_cpu_cores" in kwargs:
            self.total_cpu_cores = kwargs["total_cpu_cores"]
        if "total_cpu_hz" in kwargs:
            self.total_cpu_hz = kwargs["total_cpu_hz"]
        self.total_cpu_sockets = kwargs.get("total_cpu_sockets", None)
        if "total_data_capacity" in kwargs:
            self.total_data_capacity = kwargs["total_data_capacity"]
        if "total_memory_bytes" in kwargs:
            self.total_memory_bytes = kwargs["total_memory_bytes"]
        self.usb_devices = kwargs.get("usb_devices", None)
        self.used_cpu_hz = kwargs.get("used_cpu_hz", None)
        if "used_data_space" in kwargs:
            self.used_data_space = kwargs["used_data_space"]
        self.used_memory_bytes = kwargs.get("used_memory_bytes", None)
        self.vm_num = kwargs.get("vm_num", None)
        self.vmotion_ip = kwargs.get("vmotion_ip", None)
        self.vms = kwargs.get("vms", None)
        self.vsphere_esxi_account = kwargs.get("vsphere_esxi_account", None)
        self.with_faster_ssd_as_cache = kwargs.get("with_faster_ssd_as_cache", None)
        self.zone = kwargs.get("zone", None)

    @property
    def access_ip(self):
        """Gets the access_ip of this Host.  # noqa: E501


        :return: The access_ip of this Host.  # noqa: E501
        :rtype: str
        """
        return self._access_ip

    @access_ip.setter
    def access_ip(self, access_ip):
        """Sets the access_ip of this Host.


        :param access_ip: The access_ip of this Host.  # noqa: E501
        :type access_ip: str
        """

        self._access_ip = access_ip

    @property
    def allocatable_memory_bytes(self):
        """Gets the allocatable_memory_bytes of this Host.  # noqa: E501


        :return: The allocatable_memory_bytes of this Host.  # noqa: E501
        :rtype: int
        """
        return self._allocatable_memory_bytes

    @allocatable_memory_bytes.setter
    def allocatable_memory_bytes(self, allocatable_memory_bytes):
        """Sets the allocatable_memory_bytes of this Host.


        :param allocatable_memory_bytes: The allocatable_memory_bytes of this Host.  # noqa: E501
        :type allocatable_memory_bytes: int
        """
        if self.local_vars_configuration.client_side_validation and allocatable_memory_bytes is None:  # noqa: E501
            raise ValueError("Invalid value for `allocatable_memory_bytes`, must not be `None`")  # noqa: E501

        self._allocatable_memory_bytes = allocatable_memory_bytes

    @property
    def chunk_id(self):
        """Gets the chunk_id of this Host.  # noqa: E501


        :return: The chunk_id of this Host.  # noqa: E501
        :rtype: str
        """
        return self._chunk_id

    @chunk_id.setter
    def chunk_id(self, chunk_id):
        """Sets the chunk_id of this Host.


        :param chunk_id: The chunk_id of this Host.  # noqa: E501
        :type chunk_id: str
        """
        if self.local_vars_configuration.client_side_validation and chunk_id is None:  # noqa: E501
            raise ValueError("Invalid value for `chunk_id`, must not be `None`")  # noqa: E501

        self._chunk_id = chunk_id

    @property
    def cluster(self):
        """Gets the cluster of this Host.  # noqa: E501


        :return: The cluster of this Host.  # noqa: E501
        :rtype: NestedCluster
        """
        return self._cluster

    @cluster.setter
    def cluster(self, cluster):
        """Sets the cluster of this Host.


        :param cluster: The cluster of this Host.  # noqa: E501
        :type cluster: NestedCluster
        """
        if self.local_vars_configuration.client_side_validation and cluster is None:  # noqa: E501
            raise ValueError("Invalid value for `cluster`, must not be `None`")  # noqa: E501

        self._cluster = cluster

    @property
    def compatible_cpu_models(self):
        """Gets the compatible_cpu_models of this Host.  # noqa: E501


        :return: The compatible_cpu_models of this Host.  # noqa: E501
        :rtype: list[str]
        """
        return self._compatible_cpu_models

    @compatible_cpu_models.setter
    def compatible_cpu_models(self, compatible_cpu_models):
        """Sets the compatible_cpu_models of this Host.


        :param compatible_cpu_models: The compatible_cpu_models of this Host.  # noqa: E501
        :type compatible_cpu_models: list[str]
        """
        if self.local_vars_configuration.client_side_validation and compatible_cpu_models is None:  # noqa: E501
            raise ValueError("Invalid value for `compatible_cpu_models`, must not be `None`")  # noqa: E501

        self._compatible_cpu_models = compatible_cpu_models

    @property
    def cpu_brand(self):
        """Gets the cpu_brand of this Host.  # noqa: E501


        :return: The cpu_brand of this Host.  # noqa: E501
        :rtype: str
        """
        return self._cpu_brand

    @cpu_brand.setter
    def cpu_brand(self, cpu_brand):
        """Sets the cpu_brand of this Host.


        :param cpu_brand: The cpu_brand of this Host.  # noqa: E501
        :type cpu_brand: str
        """
        if self.local_vars_configuration.client_side_validation and cpu_brand is None:  # noqa: E501
            raise ValueError("Invalid value for `cpu_brand`, must not be `None`")  # noqa: E501

        self._cpu_brand = cpu_brand

    @property
    def cpu_fan_speed(self):
        """Gets the cpu_fan_speed of this Host.  # noqa: E501


        :return: The cpu_fan_speed of this Host.  # noqa: E501
        :rtype: list[float]
        """
        return self._cpu_fan_speed

    @cpu_fan_speed.setter
    def cpu_fan_speed(self, cpu_fan_speed):
        """Sets the cpu_fan_speed of this Host.


        :param cpu_fan_speed: The cpu_fan_speed of this Host.  # noqa: E501
        :type cpu_fan_speed: list[float]
        """
        if self.local_vars_configuration.client_side_validation and cpu_fan_speed is None:  # noqa: E501
            raise ValueError("Invalid value for `cpu_fan_speed`, must not be `None`")  # noqa: E501

        self._cpu_fan_speed = cpu_fan_speed

    @property
    def cpu_fan_speed_unit(self):
        """Gets the cpu_fan_speed_unit of this Host.  # noqa: E501


        :return: The cpu_fan_speed_unit of this Host.  # noqa: E501
        :rtype: CpuFanSpeedUnit
        """
        return self._cpu_fan_speed_unit

    @cpu_fan_speed_unit.setter
    def cpu_fan_speed_unit(self, cpu_fan_speed_unit):
        """Sets the cpu_fan_speed_unit of this Host.


        :param cpu_fan_speed_unit: The cpu_fan_speed_unit of this Host.  # noqa: E501
        :type cpu_fan_speed_unit: CpuFanSpeedUnit
        """

        self._cpu_fan_speed_unit = cpu_fan_speed_unit

    @property
    def cpu_hz_per_core(self):
        """Gets the cpu_hz_per_core of this Host.  # noqa: E501


        :return: The cpu_hz_per_core of this Host.  # noqa: E501
        :rtype: int
        """
        return self._cpu_hz_per_core

    @cpu_hz_per_core.setter
    def cpu_hz_per_core(self, cpu_hz_per_core):
        """Sets the cpu_hz_per_core of this Host.


        :param cpu_hz_per_core: The cpu_hz_per_core of this Host.  # noqa: E501
        :type cpu_hz_per_core: int
        """
        if self.local_vars_configuration.client_side_validation and cpu_hz_per_core is None:  # noqa: E501
            raise ValueError("Invalid value for `cpu_hz_per_core`, must not be `None`")  # noqa: E501

        self._cpu_hz_per_core = cpu_hz_per_core

    @property
    def cpu_model(self):
        """Gets the cpu_model of this Host.  # noqa: E501


        :return: The cpu_model of this Host.  # noqa: E501
        :rtype: str
        """
        return self._cpu_model

    @cpu_model.setter
    def cpu_model(self, cpu_model):
        """Sets the cpu_model of this Host.


        :param cpu_model: The cpu_model of this Host.  # noqa: E501
        :type cpu_model: str
        """
        if self.local_vars_configuration.client_side_validation and cpu_model is None:  # noqa: E501
            raise ValueError("Invalid value for `cpu_model`, must not be `None`")  # noqa: E501

        self._cpu_model = cpu_model

    @property
    def cpu_temperature_celsius(self):
        """Gets the cpu_temperature_celsius of this Host.  # noqa: E501


        :return: The cpu_temperature_celsius of this Host.  # noqa: E501
        :rtype: list[int]
        """
        return self._cpu_temperature_celsius

    @cpu_temperature_celsius.setter
    def cpu_temperature_celsius(self, cpu_temperature_celsius):
        """Sets the cpu_temperature_celsius of this Host.


        :param cpu_temperature_celsius: The cpu_temperature_celsius of this Host.  # noqa: E501
        :type cpu_temperature_celsius: list[int]
        """
        if self.local_vars_configuration.client_side_validation and cpu_temperature_celsius is None:  # noqa: E501
            raise ValueError("Invalid value for `cpu_temperature_celsius`, must not be `None`")  # noqa: E501

        self._cpu_temperature_celsius = cpu_temperature_celsius

    @property
    def cpu_vendor(self):
        """Gets the cpu_vendor of this Host.  # noqa: E501


        :return: The cpu_vendor of this Host.  # noqa: E501
        :rtype: str
        """
        return self._cpu_vendor

    @cpu_vendor.setter
    def cpu_vendor(self, cpu_vendor):
        """Sets the cpu_vendor of this Host.


        :param cpu_vendor: The cpu_vendor of this Host.  # noqa: E501
        :type cpu_vendor: str
        """

        self._cpu_vendor = cpu_vendor

    @property
    def data_ip(self):
        """Gets the data_ip of this Host.  # noqa: E501


        :return: The data_ip of this Host.  # noqa: E501
        :rtype: str
        """
        return self._data_ip

    @data_ip.setter
    def data_ip(self, data_ip):
        """Sets the data_ip of this Host.


        :param data_ip: The data_ip of this Host.  # noqa: E501
        :type data_ip: str
        """

        self._data_ip = data_ip

    @property
    def disks(self):
        """Gets the disks of this Host.  # noqa: E501


        :return: The disks of this Host.  # noqa: E501
        :rtype: list[NestedDisk]
        """
        return self._disks

    @disks.setter
    def disks(self, disks):
        """Sets the disks of this Host.


        :param disks: The disks of this Host.  # noqa: E501
        :type disks: list[NestedDisk]
        """

        self._disks = disks

    @property
    def failure_data_space(self):
        """Gets the failure_data_space of this Host.  # noqa: E501


        :return: The failure_data_space of this Host.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space

    @failure_data_space.setter
    def failure_data_space(self, failure_data_space):
        """Sets the failure_data_space of this Host.


        :param failure_data_space: The failure_data_space of this Host.  # noqa: E501
        :type failure_data_space: int
        """
        if self.local_vars_configuration.client_side_validation and failure_data_space is None:  # noqa: E501
            raise ValueError("Invalid value for `failure_data_space`, must not be `None`")  # noqa: E501

        self._failure_data_space = failure_data_space

    @property
    def hdd_data_capacity(self):
        """Gets the hdd_data_capacity of this Host.  # noqa: E501


        :return: The hdd_data_capacity of this Host.  # noqa: E501
        :rtype: int
        """
        return self._hdd_data_capacity

    @hdd_data_capacity.setter
    def hdd_data_capacity(self, hdd_data_capacity):
        """Sets the hdd_data_capacity of this Host.


        :param hdd_data_capacity: The hdd_data_capacity of this Host.  # noqa: E501
        :type hdd_data_capacity: int
        """
        if self.local_vars_configuration.client_side_validation and hdd_data_capacity is None:  # noqa: E501
            raise ValueError("Invalid value for `hdd_data_capacity`, must not be `None`")  # noqa: E501

        self._hdd_data_capacity = hdd_data_capacity

    @property
    def hdd_disk_count(self):
        """Gets the hdd_disk_count of this Host.  # noqa: E501


        :return: The hdd_disk_count of this Host.  # noqa: E501
        :rtype: int
        """
        return self._hdd_disk_count

    @hdd_disk_count.setter
    def hdd_disk_count(self, hdd_disk_count):
        """Sets the hdd_disk_count of this Host.


        :param hdd_disk_count: The hdd_disk_count of this Host.  # noqa: E501
        :type hdd_disk_count: int
        """
        if self.local_vars_configuration.client_side_validation and hdd_disk_count is None:  # noqa: E501
            raise ValueError("Invalid value for `hdd_disk_count`, must not be `None`")  # noqa: E501

        self._hdd_disk_count = hdd_disk_count

    @property
    def hypervisor_ip(self):
        """Gets the hypervisor_ip of this Host.  # noqa: E501


        :return: The hypervisor_ip of this Host.  # noqa: E501
        :rtype: str
        """
        return self._hypervisor_ip

    @hypervisor_ip.setter
    def hypervisor_ip(self, hypervisor_ip):
        """Sets the hypervisor_ip of this Host.


        :param hypervisor_ip: The hypervisor_ip of this Host.  # noqa: E501
        :type hypervisor_ip: str
        """

        self._hypervisor_ip = hypervisor_ip

    @property
    def id(self):
        """Gets the id of this Host.  # noqa: E501


        :return: The id of this Host.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Host.


        :param id: The id of this Host.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def ipmi(self):
        """Gets the ipmi of this Host.  # noqa: E501


        :return: The ipmi of this Host.  # noqa: E501
        :rtype: NestedIpmi
        """
        return self._ipmi

    @ipmi.setter
    def ipmi(self, ipmi):
        """Sets the ipmi of this Host.


        :param ipmi: The ipmi of this Host.  # noqa: E501
        :type ipmi: NestedIpmi
        """

        self._ipmi = ipmi

    @property
    def is_os_in_raid1(self):
        """Gets the is_os_in_raid1 of this Host.  # noqa: E501


        :return: The is_os_in_raid1 of this Host.  # noqa: E501
        :rtype: bool
        """
        return self._is_os_in_raid1

    @is_os_in_raid1.setter
    def is_os_in_raid1(self, is_os_in_raid1):
        """Sets the is_os_in_raid1 of this Host.


        :param is_os_in_raid1: The is_os_in_raid1 of this Host.  # noqa: E501
        :type is_os_in_raid1: bool
        """

        self._is_os_in_raid1 = is_os_in_raid1

    @property
    def labels(self):
        """Gets the labels of this Host.  # noqa: E501


        :return: The labels of this Host.  # noqa: E501
        :rtype: list[NestedLabel]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this Host.


        :param labels: The labels of this Host.  # noqa: E501
        :type labels: list[NestedLabel]
        """

        self._labels = labels

    @property
    def local_id(self):
        """Gets the local_id of this Host.  # noqa: E501


        :return: The local_id of this Host.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this Host.


        :param local_id: The local_id of this Host.  # noqa: E501
        :type local_id: str
        """
        if self.local_vars_configuration.client_side_validation and local_id is None:  # noqa: E501
            raise ValueError("Invalid value for `local_id`, must not be `None`")  # noqa: E501

        self._local_id = local_id

    @property
    def lsm_cap_disk_safe_umount(self):
        """Gets the lsm_cap_disk_safe_umount of this Host.  # noqa: E501


        :return: The lsm_cap_disk_safe_umount of this Host.  # noqa: E501
        :rtype: bool
        """
        return self._lsm_cap_disk_safe_umount

    @lsm_cap_disk_safe_umount.setter
    def lsm_cap_disk_safe_umount(self, lsm_cap_disk_safe_umount):
        """Sets the lsm_cap_disk_safe_umount of this Host.


        :param lsm_cap_disk_safe_umount: The lsm_cap_disk_safe_umount of this Host.  # noqa: E501
        :type lsm_cap_disk_safe_umount: bool
        """
        if self.local_vars_configuration.client_side_validation and lsm_cap_disk_safe_umount is None:  # noqa: E501
            raise ValueError("Invalid value for `lsm_cap_disk_safe_umount`, must not be `None`")  # noqa: E501

        self._lsm_cap_disk_safe_umount = lsm_cap_disk_safe_umount

    @property
    def management_ip(self):
        """Gets the management_ip of this Host.  # noqa: E501


        :return: The management_ip of this Host.  # noqa: E501
        :rtype: str
        """
        return self._management_ip

    @management_ip.setter
    def management_ip(self, management_ip):
        """Sets the management_ip of this Host.


        :param management_ip: The management_ip of this Host.  # noqa: E501
        :type management_ip: str
        """
        if self.local_vars_configuration.client_side_validation and management_ip is None:  # noqa: E501
            raise ValueError("Invalid value for `management_ip`, must not be `None`")  # noqa: E501

        self._management_ip = management_ip

    @property
    def model(self):
        """Gets the model of this Host.  # noqa: E501


        :return: The model of this Host.  # noqa: E501
        :rtype: str
        """
        return self._model

    @model.setter
    def model(self, model):
        """Sets the model of this Host.


        :param model: The model of this Host.  # noqa: E501
        :type model: str
        """
        if self.local_vars_configuration.client_side_validation and model is None:  # noqa: E501
            raise ValueError("Invalid value for `model`, must not be `None`")  # noqa: E501

        self._model = model

    @property
    def name(self):
        """Gets the name of this Host.  # noqa: E501


        :return: The name of this Host.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Host.


        :param name: The name of this Host.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def nested_virtualization(self):
        """Gets the nested_virtualization of this Host.  # noqa: E501


        :return: The nested_virtualization of this Host.  # noqa: E501
        :rtype: bool
        """
        return self._nested_virtualization

    @nested_virtualization.setter
    def nested_virtualization(self, nested_virtualization):
        """Sets the nested_virtualization of this Host.


        :param nested_virtualization: The nested_virtualization of this Host.  # noqa: E501
        :type nested_virtualization: bool
        """
        if self.local_vars_configuration.client_side_validation and nested_virtualization is None:  # noqa: E501
            raise ValueError("Invalid value for `nested_virtualization`, must not be `None`")  # noqa: E501

        self._nested_virtualization = nested_virtualization

    @property
    def nic_count(self):
        """Gets the nic_count of this Host.  # noqa: E501


        :return: The nic_count of this Host.  # noqa: E501
        :rtype: int
        """
        return self._nic_count

    @nic_count.setter
    def nic_count(self, nic_count):
        """Sets the nic_count of this Host.


        :param nic_count: The nic_count of this Host.  # noqa: E501
        :type nic_count: int
        """
        if self.local_vars_configuration.client_side_validation and nic_count is None:  # noqa: E501
            raise ValueError("Invalid value for `nic_count`, must not be `None`")  # noqa: E501

        self._nic_count = nic_count

    @property
    def nics(self):
        """Gets the nics of this Host.  # noqa: E501


        :return: The nics of this Host.  # noqa: E501
        :rtype: list[NestedNic]
        """
        return self._nics

    @nics.setter
    def nics(self, nics):
        """Sets the nics of this Host.


        :param nics: The nics of this Host.  # noqa: E501
        :type nics: list[NestedNic]
        """

        self._nics = nics

    @property
    def node_topo_local_id(self):
        """Gets the node_topo_local_id of this Host.  # noqa: E501


        :return: The node_topo_local_id of this Host.  # noqa: E501
        :rtype: str
        """
        return self._node_topo_local_id

    @node_topo_local_id.setter
    def node_topo_local_id(self, node_topo_local_id):
        """Sets the node_topo_local_id of this Host.


        :param node_topo_local_id: The node_topo_local_id of this Host.  # noqa: E501
        :type node_topo_local_id: str
        """

        self._node_topo_local_id = node_topo_local_id

    @property
    def os_memory_bytes(self):
        """Gets the os_memory_bytes of this Host.  # noqa: E501


        :return: The os_memory_bytes of this Host.  # noqa: E501
        :rtype: int
        """
        return self._os_memory_bytes

    @os_memory_bytes.setter
    def os_memory_bytes(self, os_memory_bytes):
        """Sets the os_memory_bytes of this Host.


        :param os_memory_bytes: The os_memory_bytes of this Host.  # noqa: E501
        :type os_memory_bytes: int
        """
        if self.local_vars_configuration.client_side_validation and os_memory_bytes is None:  # noqa: E501
            raise ValueError("Invalid value for `os_memory_bytes`, must not be `None`")  # noqa: E501

        self._os_memory_bytes = os_memory_bytes

    @property
    def os_version(self):
        """Gets the os_version of this Host.  # noqa: E501


        :return: The os_version of this Host.  # noqa: E501
        :rtype: str
        """
        return self._os_version

    @os_version.setter
    def os_version(self, os_version):
        """Sets the os_version of this Host.


        :param os_version: The os_version of this Host.  # noqa: E501
        :type os_version: str
        """

        self._os_version = os_version

    @property
    def pmem_dimm_capacity(self):
        """Gets the pmem_dimm_capacity of this Host.  # noqa: E501


        :return: The pmem_dimm_capacity of this Host.  # noqa: E501
        :rtype: int
        """
        return self._pmem_dimm_capacity

    @pmem_dimm_capacity.setter
    def pmem_dimm_capacity(self, pmem_dimm_capacity):
        """Sets the pmem_dimm_capacity of this Host.


        :param pmem_dimm_capacity: The pmem_dimm_capacity of this Host.  # noqa: E501
        :type pmem_dimm_capacity: int
        """
        if self.local_vars_configuration.client_side_validation and pmem_dimm_capacity is None:  # noqa: E501
            raise ValueError("Invalid value for `pmem_dimm_capacity`, must not be `None`")  # noqa: E501

        self._pmem_dimm_capacity = pmem_dimm_capacity

    @property
    def pmem_dimm_count(self):
        """Gets the pmem_dimm_count of this Host.  # noqa: E501


        :return: The pmem_dimm_count of this Host.  # noqa: E501
        :rtype: int
        """
        return self._pmem_dimm_count

    @pmem_dimm_count.setter
    def pmem_dimm_count(self, pmem_dimm_count):
        """Sets the pmem_dimm_count of this Host.


        :param pmem_dimm_count: The pmem_dimm_count of this Host.  # noqa: E501
        :type pmem_dimm_count: int
        """
        if self.local_vars_configuration.client_side_validation and pmem_dimm_count is None:  # noqa: E501
            raise ValueError("Invalid value for `pmem_dimm_count`, must not be `None`")  # noqa: E501

        self._pmem_dimm_count = pmem_dimm_count

    @property
    def pmem_dimms(self):
        """Gets the pmem_dimms of this Host.  # noqa: E501


        :return: The pmem_dimms of this Host.  # noqa: E501
        :rtype: list[NestedPmemDimm]
        """
        return self._pmem_dimms

    @pmem_dimms.setter
    def pmem_dimms(self, pmem_dimms):
        """Sets the pmem_dimms of this Host.


        :param pmem_dimms: The pmem_dimms of this Host.  # noqa: E501
        :type pmem_dimms: list[NestedPmemDimm]
        """

        self._pmem_dimms = pmem_dimms

    @property
    def pmem_disk_count(self):
        """Gets the pmem_disk_count of this Host.  # noqa: E501


        :return: The pmem_disk_count of this Host.  # noqa: E501
        :rtype: int
        """
        return self._pmem_disk_count

    @pmem_disk_count.setter
    def pmem_disk_count(self, pmem_disk_count):
        """Sets the pmem_disk_count of this Host.


        :param pmem_disk_count: The pmem_disk_count of this Host.  # noqa: E501
        :type pmem_disk_count: int
        """
        if self.local_vars_configuration.client_side_validation and pmem_disk_count is None:  # noqa: E501
            raise ValueError("Invalid value for `pmem_disk_count`, must not be `None`")  # noqa: E501

        self._pmem_disk_count = pmem_disk_count

    @property
    def provisioned_cpu_cores(self):
        """Gets the provisioned_cpu_cores of this Host.  # noqa: E501


        :return: The provisioned_cpu_cores of this Host.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores

    @provisioned_cpu_cores.setter
    def provisioned_cpu_cores(self, provisioned_cpu_cores):
        """Sets the provisioned_cpu_cores of this Host.


        :param provisioned_cpu_cores: The provisioned_cpu_cores of this Host.  # noqa: E501
        :type provisioned_cpu_cores: int
        """
        if self.local_vars_configuration.client_side_validation and provisioned_cpu_cores is None:  # noqa: E501
            raise ValueError("Invalid value for `provisioned_cpu_cores`, must not be `None`")  # noqa: E501

        self._provisioned_cpu_cores = provisioned_cpu_cores

    @property
    def provisioned_memory_bytes(self):
        """Gets the provisioned_memory_bytes of this Host.  # noqa: E501


        :return: The provisioned_memory_bytes of this Host.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_memory_bytes

    @provisioned_memory_bytes.setter
    def provisioned_memory_bytes(self, provisioned_memory_bytes):
        """Sets the provisioned_memory_bytes of this Host.


        :param provisioned_memory_bytes: The provisioned_memory_bytes of this Host.  # noqa: E501
        :type provisioned_memory_bytes: int
        """
        if self.local_vars_configuration.client_side_validation and provisioned_memory_bytes is None:  # noqa: E501
            raise ValueError("Invalid value for `provisioned_memory_bytes`, must not be `None`")  # noqa: E501

        self._provisioned_memory_bytes = provisioned_memory_bytes

    @property
    def running_pause_vm_memory_bytes(self):
        """Gets the running_pause_vm_memory_bytes of this Host.  # noqa: E501


        :return: The running_pause_vm_memory_bytes of this Host.  # noqa: E501
        :rtype: int
        """
        return self._running_pause_vm_memory_bytes

    @running_pause_vm_memory_bytes.setter
    def running_pause_vm_memory_bytes(self, running_pause_vm_memory_bytes):
        """Sets the running_pause_vm_memory_bytes of this Host.


        :param running_pause_vm_memory_bytes: The running_pause_vm_memory_bytes of this Host.  # noqa: E501
        :type running_pause_vm_memory_bytes: int
        """
        if self.local_vars_configuration.client_side_validation and running_pause_vm_memory_bytes is None:  # noqa: E501
            raise ValueError("Invalid value for `running_pause_vm_memory_bytes`, must not be `None`")  # noqa: E501

        self._running_pause_vm_memory_bytes = running_pause_vm_memory_bytes

    @property
    def running_vm_num(self):
        """Gets the running_vm_num of this Host.  # noqa: E501


        :return: The running_vm_num of this Host.  # noqa: E501
        :rtype: int
        """
        return self._running_vm_num

    @running_vm_num.setter
    def running_vm_num(self, running_vm_num):
        """Sets the running_vm_num of this Host.


        :param running_vm_num: The running_vm_num of this Host.  # noqa: E501
        :type running_vm_num: int
        """

        self._running_vm_num = running_vm_num

    @property
    def scvm_cpu(self):
        """Gets the scvm_cpu of this Host.  # noqa: E501


        :return: The scvm_cpu of this Host.  # noqa: E501
        :rtype: int
        """
        return self._scvm_cpu

    @scvm_cpu.setter
    def scvm_cpu(self, scvm_cpu):
        """Sets the scvm_cpu of this Host.


        :param scvm_cpu: The scvm_cpu of this Host.  # noqa: E501
        :type scvm_cpu: int
        """

        self._scvm_cpu = scvm_cpu

    @property
    def scvm_memory(self):
        """Gets the scvm_memory of this Host.  # noqa: E501


        :return: The scvm_memory of this Host.  # noqa: E501
        :rtype: int
        """
        return self._scvm_memory

    @scvm_memory.setter
    def scvm_memory(self, scvm_memory):
        """Sets the scvm_memory of this Host.


        :param scvm_memory: The scvm_memory of this Host.  # noqa: E501
        :type scvm_memory: int
        """

        self._scvm_memory = scvm_memory

    @property
    def scvm_name(self):
        """Gets the scvm_name of this Host.  # noqa: E501


        :return: The scvm_name of this Host.  # noqa: E501
        :rtype: str
        """
        return self._scvm_name

    @scvm_name.setter
    def scvm_name(self, scvm_name):
        """Sets the scvm_name of this Host.


        :param scvm_name: The scvm_name of this Host.  # noqa: E501
        :type scvm_name: str
        """

        self._scvm_name = scvm_name

    @property
    def serial(self):
        """Gets the serial of this Host.  # noqa: E501


        :return: The serial of this Host.  # noqa: E501
        :rtype: str
        """
        return self._serial

    @serial.setter
    def serial(self, serial):
        """Sets the serial of this Host.


        :param serial: The serial of this Host.  # noqa: E501
        :type serial: str
        """

        self._serial = serial

    @property
    def ssd_data_capacity(self):
        """Gets the ssd_data_capacity of this Host.  # noqa: E501


        :return: The ssd_data_capacity of this Host.  # noqa: E501
        :rtype: int
        """
        return self._ssd_data_capacity

    @ssd_data_capacity.setter
    def ssd_data_capacity(self, ssd_data_capacity):
        """Sets the ssd_data_capacity of this Host.


        :param ssd_data_capacity: The ssd_data_capacity of this Host.  # noqa: E501
        :type ssd_data_capacity: int
        """
        if self.local_vars_configuration.client_side_validation and ssd_data_capacity is None:  # noqa: E501
            raise ValueError("Invalid value for `ssd_data_capacity`, must not be `None`")  # noqa: E501

        self._ssd_data_capacity = ssd_data_capacity

    @property
    def ssd_disk_count(self):
        """Gets the ssd_disk_count of this Host.  # noqa: E501


        :return: The ssd_disk_count of this Host.  # noqa: E501
        :rtype: int
        """
        return self._ssd_disk_count

    @ssd_disk_count.setter
    def ssd_disk_count(self, ssd_disk_count):
        """Sets the ssd_disk_count of this Host.


        :param ssd_disk_count: The ssd_disk_count of this Host.  # noqa: E501
        :type ssd_disk_count: int
        """
        if self.local_vars_configuration.client_side_validation and ssd_disk_count is None:  # noqa: E501
            raise ValueError("Invalid value for `ssd_disk_count`, must not be `None`")  # noqa: E501

        self._ssd_disk_count = ssd_disk_count

    @property
    def state(self):
        """Gets the state of this Host.  # noqa: E501


        :return: The state of this Host.  # noqa: E501
        :rtype: HostState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Host.


        :param state: The state of this Host.  # noqa: E501
        :type state: HostState
        """
        if self.local_vars_configuration.client_side_validation and state is None:  # noqa: E501
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501

        self._state = state

    @property
    def status(self):
        """Gets the status of this Host.  # noqa: E501


        :return: The status of this Host.  # noqa: E501
        :rtype: HostStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Host.


        :param status: The status of this Host.  # noqa: E501
        :type status: HostStatus
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def stopped_vm_num(self):
        """Gets the stopped_vm_num of this Host.  # noqa: E501


        :return: The stopped_vm_num of this Host.  # noqa: E501
        :rtype: int
        """
        return self._stopped_vm_num

    @stopped_vm_num.setter
    def stopped_vm_num(self, stopped_vm_num):
        """Sets the stopped_vm_num of this Host.


        :param stopped_vm_num: The stopped_vm_num of this Host.  # noqa: E501
        :type stopped_vm_num: int
        """

        self._stopped_vm_num = stopped_vm_num

    @property
    def suspended_vm_num(self):
        """Gets the suspended_vm_num of this Host.  # noqa: E501


        :return: The suspended_vm_num of this Host.  # noqa: E501
        :rtype: int
        """
        return self._suspended_vm_num

    @suspended_vm_num.setter
    def suspended_vm_num(self, suspended_vm_num):
        """Sets the suspended_vm_num of this Host.


        :param suspended_vm_num: The suspended_vm_num of this Host.  # noqa: E501
        :type suspended_vm_num: int
        """

        self._suspended_vm_num = suspended_vm_num

    @property
    def total_cache_capacity(self):
        """Gets the total_cache_capacity of this Host.  # noqa: E501


        :return: The total_cache_capacity of this Host.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity

    @total_cache_capacity.setter
    def total_cache_capacity(self, total_cache_capacity):
        """Sets the total_cache_capacity of this Host.


        :param total_cache_capacity: The total_cache_capacity of this Host.  # noqa: E501
        :type total_cache_capacity: int
        """

        self._total_cache_capacity = total_cache_capacity

    @property
    def total_cpu_cores(self):
        """Gets the total_cpu_cores of this Host.  # noqa: E501


        :return: The total_cpu_cores of this Host.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores

    @total_cpu_cores.setter
    def total_cpu_cores(self, total_cpu_cores):
        """Sets the total_cpu_cores of this Host.


        :param total_cpu_cores: The total_cpu_cores of this Host.  # noqa: E501
        :type total_cpu_cores: int
        """
        if self.local_vars_configuration.client_side_validation and total_cpu_cores is None:  # noqa: E501
            raise ValueError("Invalid value for `total_cpu_cores`, must not be `None`")  # noqa: E501

        self._total_cpu_cores = total_cpu_cores

    @property
    def total_cpu_hz(self):
        """Gets the total_cpu_hz of this Host.  # noqa: E501


        :return: The total_cpu_hz of this Host.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz

    @total_cpu_hz.setter
    def total_cpu_hz(self, total_cpu_hz):
        """Sets the total_cpu_hz of this Host.


        :param total_cpu_hz: The total_cpu_hz of this Host.  # noqa: E501
        :type total_cpu_hz: int
        """
        if self.local_vars_configuration.client_side_validation and total_cpu_hz is None:  # noqa: E501
            raise ValueError("Invalid value for `total_cpu_hz`, must not be `None`")  # noqa: E501

        self._total_cpu_hz = total_cpu_hz

    @property
    def total_cpu_sockets(self):
        """Gets the total_cpu_sockets of this Host.  # noqa: E501


        :return: The total_cpu_sockets of this Host.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_sockets

    @total_cpu_sockets.setter
    def total_cpu_sockets(self, total_cpu_sockets):
        """Sets the total_cpu_sockets of this Host.


        :param total_cpu_sockets: The total_cpu_sockets of this Host.  # noqa: E501
        :type total_cpu_sockets: int
        """

        self._total_cpu_sockets = total_cpu_sockets

    @property
    def total_data_capacity(self):
        """Gets the total_data_capacity of this Host.  # noqa: E501


        :return: The total_data_capacity of this Host.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity

    @total_data_capacity.setter
    def total_data_capacity(self, total_data_capacity):
        """Sets the total_data_capacity of this Host.


        :param total_data_capacity: The total_data_capacity of this Host.  # noqa: E501
        :type total_data_capacity: int
        """
        if self.local_vars_configuration.client_side_validation and total_data_capacity is None:  # noqa: E501
            raise ValueError("Invalid value for `total_data_capacity`, must not be `None`")  # noqa: E501

        self._total_data_capacity = total_data_capacity

    @property
    def total_memory_bytes(self):
        """Gets the total_memory_bytes of this Host.  # noqa: E501


        :return: The total_memory_bytes of this Host.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes

    @total_memory_bytes.setter
    def total_memory_bytes(self, total_memory_bytes):
        """Sets the total_memory_bytes of this Host.


        :param total_memory_bytes: The total_memory_bytes of this Host.  # noqa: E501
        :type total_memory_bytes: int
        """
        if self.local_vars_configuration.client_side_validation and total_memory_bytes is None:  # noqa: E501
            raise ValueError("Invalid value for `total_memory_bytes`, must not be `None`")  # noqa: E501

        self._total_memory_bytes = total_memory_bytes

    @property
    def usb_devices(self):
        """Gets the usb_devices of this Host.  # noqa: E501


        :return: The usb_devices of this Host.  # noqa: E501
        :rtype: list[NestedUsbDevice]
        """
        return self._usb_devices

    @usb_devices.setter
    def usb_devices(self, usb_devices):
        """Sets the usb_devices of this Host.


        :param usb_devices: The usb_devices of this Host.  # noqa: E501
        :type usb_devices: list[NestedUsbDevice]
        """

        self._usb_devices = usb_devices

    @property
    def used_cpu_hz(self):
        """Gets the used_cpu_hz of this Host.  # noqa: E501


        :return: The used_cpu_hz of this Host.  # noqa: E501
        :rtype: int
        """
        return self._used_cpu_hz

    @used_cpu_hz.setter
    def used_cpu_hz(self, used_cpu_hz):
        """Sets the used_cpu_hz of this Host.


        :param used_cpu_hz: The used_cpu_hz of this Host.  # noqa: E501
        :type used_cpu_hz: int
        """

        self._used_cpu_hz = used_cpu_hz

    @property
    def used_data_space(self):
        """Gets the used_data_space of this Host.  # noqa: E501


        :return: The used_data_space of this Host.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space

    @used_data_space.setter
    def used_data_space(self, used_data_space):
        """Sets the used_data_space of this Host.


        :param used_data_space: The used_data_space of this Host.  # noqa: E501
        :type used_data_space: int
        """
        if self.local_vars_configuration.client_side_validation and used_data_space is None:  # noqa: E501
            raise ValueError("Invalid value for `used_data_space`, must not be `None`")  # noqa: E501

        self._used_data_space = used_data_space

    @property
    def used_memory_bytes(self):
        """Gets the used_memory_bytes of this Host.  # noqa: E501


        :return: The used_memory_bytes of this Host.  # noqa: E501
        :rtype: int
        """
        return self._used_memory_bytes

    @used_memory_bytes.setter
    def used_memory_bytes(self, used_memory_bytes):
        """Sets the used_memory_bytes of this Host.


        :param used_memory_bytes: The used_memory_bytes of this Host.  # noqa: E501
        :type used_memory_bytes: int
        """

        self._used_memory_bytes = used_memory_bytes

    @property
    def vm_num(self):
        """Gets the vm_num of this Host.  # noqa: E501


        :return: The vm_num of this Host.  # noqa: E501
        :rtype: int
        """
        return self._vm_num

    @vm_num.setter
    def vm_num(self, vm_num):
        """Sets the vm_num of this Host.


        :param vm_num: The vm_num of this Host.  # noqa: E501
        :type vm_num: int
        """

        self._vm_num = vm_num

    @property
    def vmotion_ip(self):
        """Gets the vmotion_ip of this Host.  # noqa: E501


        :return: The vmotion_ip of this Host.  # noqa: E501
        :rtype: str
        """
        return self._vmotion_ip

    @vmotion_ip.setter
    def vmotion_ip(self, vmotion_ip):
        """Sets the vmotion_ip of this Host.


        :param vmotion_ip: The vmotion_ip of this Host.  # noqa: E501
        :type vmotion_ip: str
        """

        self._vmotion_ip = vmotion_ip

    @property
    def vms(self):
        """Gets the vms of this Host.  # noqa: E501


        :return: The vms of this Host.  # noqa: E501
        :rtype: list[NestedVm]
        """
        return self._vms

    @vms.setter
    def vms(self, vms):
        """Sets the vms of this Host.


        :param vms: The vms of this Host.  # noqa: E501
        :type vms: list[NestedVm]
        """

        self._vms = vms

    @property
    def vsphere_esxi_account(self):
        """Gets the vsphere_esxi_account of this Host.  # noqa: E501


        :return: The vsphere_esxi_account of this Host.  # noqa: E501
        :rtype: NestedVsphereEsxiAccount
        """
        return self._vsphere_esxi_account

    @vsphere_esxi_account.setter
    def vsphere_esxi_account(self, vsphere_esxi_account):
        """Sets the vsphere_esxi_account of this Host.


        :param vsphere_esxi_account: The vsphere_esxi_account of this Host.  # noqa: E501
        :type vsphere_esxi_account: NestedVsphereEsxiAccount
        """

        self._vsphere_esxi_account = vsphere_esxi_account

    @property
    def with_faster_ssd_as_cache(self):
        """Gets the with_faster_ssd_as_cache of this Host.  # noqa: E501


        :return: The with_faster_ssd_as_cache of this Host.  # noqa: E501
        :rtype: bool
        """
        return self._with_faster_ssd_as_cache

    @with_faster_ssd_as_cache.setter
    def with_faster_ssd_as_cache(self, with_faster_ssd_as_cache):
        """Sets the with_faster_ssd_as_cache of this Host.


        :param with_faster_ssd_as_cache: The with_faster_ssd_as_cache of this Host.  # noqa: E501
        :type with_faster_ssd_as_cache: bool
        """

        self._with_faster_ssd_as_cache = with_faster_ssd_as_cache

    @property
    def zone(self):
        """Gets the zone of this Host.  # noqa: E501


        :return: The zone of this Host.  # noqa: E501
        :rtype: NestedZone
        """
        return self._zone

    @zone.setter
    def zone(self, zone):
        """Sets the zone of this Host.


        :param zone: The zone of this Host.  # noqa: E501
        :type zone: NestedZone
        """

        self._zone = zone

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Host):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Host):
            return True

        return self.to_dict() != other.to_dict()
