# coding: utf-8

"""
    CloudTower APIs

    cloudtower operation API and SDK  # noqa: E501

    The version of the OpenAPI document: 1.10.0
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class Cluster(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'application_highest_version': 'str',
        'applications': 'list[NestedApplication]',
        'architecture': 'Architecture',
        'auto_converge': 'bool',
        'connect_state': 'ConnectState',
        'consistency_groups': 'list[NestedConsistencyGroup]',
        'current_cpu_model': 'str',
        'datacenters': 'list[NestedDatacenter]',
        'disconnected_date': 'str',
        'disconnected_reason': 'ClusterConnectorErrorCode',
        'dns': 'list[str]',
        'entity_async_status': 'EntityAsyncStatus',
        'everoute_cluster': 'NestedEverouteCluster',
        'failure_data_space': 'int',
        'has_metrox': 'bool',
        'host_num': 'int',
        'hosts': 'list[NestedHost]',
        'hypervisor': 'Hypervisor',
        'id': 'str',
        'ip': 'str',
        'is_all_flash': 'bool',
        'iscsi_vip': 'str',
        'labels': 'list[NestedLabel]',
        'license_expire_date': 'str',
        'license_serial': 'str',
        'license_sign_date': 'str',
        'license_type': 'LicenseType',
        'local_id': 'str',
        'maintenance_end_date': 'str',
        'maintenance_start_date': 'str',
        'management_vip': 'str',
        'max_chunk_num': 'int',
        'max_physical_data_capacity': 'int',
        'max_physical_data_capacity_per_node': 'int',
        'metro_availability_checklist': 'NestedMetroAvailabilityChecklist',
        'mgt_gateway': 'str',
        'mgt_netmask': 'str',
        'migration_data_size': 'int',
        'migration_speed': 'int',
        'name': 'str',
        'ntp_mode': 'NtpMode',
        'ntp_servers': 'list[str]',
        'nvme_over_rdma_enabled': 'bool',
        'nvme_over_tcp_enabled': 'bool',
        'nvmf_enabled': 'bool',
        'pmem_enabled': 'bool',
        'provisioned_cpu_cores': 'int',
        'provisioned_cpu_cores_for_active_vm': 'int',
        'provisioned_for_active_vm_ratio': 'float',
        'provisioned_memory_bytes': 'int',
        'provisioned_ratio': 'float',
        'rdma_enabled': 'bool',
        'recommended_cpu_models': 'list[str]',
        'recover_data_size': 'int',
        'recover_speed': 'int',
        'reserved_cpu_cores_for_system_service': 'int',
        'running_vm_num': 'int',
        'settings': 'NestedClusterSettings',
        'software_edition': 'SoftwareEdition',
        'stopped_vm_num': 'int',
        'stretch': 'bool',
        'suspended_vm_num': 'int',
        'total_cache_capacity': 'int',
        'total_cpu_cores': 'int',
        'total_cpu_hz': 'int',
        'total_cpu_models': 'list[str]',
        'total_cpu_sockets': 'int',
        'total_data_capacity': 'int',
        'total_memory_bytes': 'int',
        'type': 'ClusterType',
        'upgrade_tool_version': 'str',
        'used_cpu_hz': 'int',
        'used_data_space': 'int',
        'used_memory_bytes': 'int',
        'valid_data_space': 'int',
        'vcenter_account': 'NestedVcenterAccount',
        'vdses': 'list[NestedVds]',
        'version': 'str',
        'vhost_enabled': 'bool',
        'vm_folders': 'list[NestedVmFolder]',
        'vm_num': 'int',
        'vm_templates': 'list[NestedVmTemplate]',
        'vms': 'list[NestedVm]',
        'witness': 'NestedWitness',
        'zones': 'list[NestedZone]'
    }

    attribute_map = {
        'application_highest_version': 'application_highest_version',
        'applications': 'applications',
        'architecture': 'architecture',
        'auto_converge': 'auto_converge',
        'connect_state': 'connect_state',
        'consistency_groups': 'consistency_groups',
        'current_cpu_model': 'current_cpu_model',
        'datacenters': 'datacenters',
        'disconnected_date': 'disconnected_date',
        'disconnected_reason': 'disconnected_reason',
        'dns': 'dns',
        'entity_async_status': 'entityAsyncStatus',
        'everoute_cluster': 'everoute_cluster',
        'failure_data_space': 'failure_data_space',
        'has_metrox': 'has_metrox',
        'host_num': 'host_num',
        'hosts': 'hosts',
        'hypervisor': 'hypervisor',
        'id': 'id',
        'ip': 'ip',
        'is_all_flash': 'is_all_flash',
        'iscsi_vip': 'iscsi_vip',
        'labels': 'labels',
        'license_expire_date': 'license_expire_date',
        'license_serial': 'license_serial',
        'license_sign_date': 'license_sign_date',
        'license_type': 'license_type',
        'local_id': 'local_id',
        'maintenance_end_date': 'maintenance_end_date',
        'maintenance_start_date': 'maintenance_start_date',
        'management_vip': 'management_vip',
        'max_chunk_num': 'max_chunk_num',
        'max_physical_data_capacity': 'max_physical_data_capacity',
        'max_physical_data_capacity_per_node': 'max_physical_data_capacity_per_node',
        'metro_availability_checklist': 'metro_availability_checklist',
        'mgt_gateway': 'mgt_gateway',
        'mgt_netmask': 'mgt_netmask',
        'migration_data_size': 'migration_data_size',
        'migration_speed': 'migration_speed',
        'name': 'name',
        'ntp_mode': 'ntp_mode',
        'ntp_servers': 'ntp_servers',
        'nvme_over_rdma_enabled': 'nvme_over_rdma_enabled',
        'nvme_over_tcp_enabled': 'nvme_over_tcp_enabled',
        'nvmf_enabled': 'nvmf_enabled',
        'pmem_enabled': 'pmem_enabled',
        'provisioned_cpu_cores': 'provisioned_cpu_cores',
        'provisioned_cpu_cores_for_active_vm': 'provisioned_cpu_cores_for_active_vm',
        'provisioned_for_active_vm_ratio': 'provisioned_for_active_vm_ratio',
        'provisioned_memory_bytes': 'provisioned_memory_bytes',
        'provisioned_ratio': 'provisioned_ratio',
        'rdma_enabled': 'rdma_enabled',
        'recommended_cpu_models': 'recommended_cpu_models',
        'recover_data_size': 'recover_data_size',
        'recover_speed': 'recover_speed',
        'reserved_cpu_cores_for_system_service': 'reserved_cpu_cores_for_system_service',
        'running_vm_num': 'running_vm_num',
        'settings': 'settings',
        'software_edition': 'software_edition',
        'stopped_vm_num': 'stopped_vm_num',
        'stretch': 'stretch',
        'suspended_vm_num': 'suspended_vm_num',
        'total_cache_capacity': 'total_cache_capacity',
        'total_cpu_cores': 'total_cpu_cores',
        'total_cpu_hz': 'total_cpu_hz',
        'total_cpu_models': 'total_cpu_models',
        'total_cpu_sockets': 'total_cpu_sockets',
        'total_data_capacity': 'total_data_capacity',
        'total_memory_bytes': 'total_memory_bytes',
        'type': 'type',
        'upgrade_tool_version': 'upgrade_tool_version',
        'used_cpu_hz': 'used_cpu_hz',
        'used_data_space': 'used_data_space',
        'used_memory_bytes': 'used_memory_bytes',
        'valid_data_space': 'valid_data_space',
        'vcenter_account': 'vcenterAccount',
        'vdses': 'vdses',
        'version': 'version',
        'vhost_enabled': 'vhost_enabled',
        'vm_folders': 'vm_folders',
        'vm_num': 'vm_num',
        'vm_templates': 'vm_templates',
        'vms': 'vms',
        'witness': 'witness',
        'zones': 'zones'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """Cluster - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._application_highest_version = None
        self._applications = None
        self._architecture = None
        self._auto_converge = None
        self._connect_state = None
        self._consistency_groups = None
        self._current_cpu_model = None
        self._datacenters = None
        self._disconnected_date = None
        self._disconnected_reason = None
        self._dns = None
        self._entity_async_status = None
        self._everoute_cluster = None
        self._failure_data_space = None
        self._has_metrox = None
        self._host_num = None
        self._hosts = None
        self._hypervisor = None
        self._id = None
        self._ip = None
        self._is_all_flash = None
        self._iscsi_vip = None
        self._labels = None
        self._license_expire_date = None
        self._license_serial = None
        self._license_sign_date = None
        self._license_type = None
        self._local_id = None
        self._maintenance_end_date = None
        self._maintenance_start_date = None
        self._management_vip = None
        self._max_chunk_num = None
        self._max_physical_data_capacity = None
        self._max_physical_data_capacity_per_node = None
        self._metro_availability_checklist = None
        self._mgt_gateway = None
        self._mgt_netmask = None
        self._migration_data_size = None
        self._migration_speed = None
        self._name = None
        self._ntp_mode = None
        self._ntp_servers = None
        self._nvme_over_rdma_enabled = None
        self._nvme_over_tcp_enabled = None
        self._nvmf_enabled = None
        self._pmem_enabled = None
        self._provisioned_cpu_cores = None
        self._provisioned_cpu_cores_for_active_vm = None
        self._provisioned_for_active_vm_ratio = None
        self._provisioned_memory_bytes = None
        self._provisioned_ratio = None
        self._rdma_enabled = None
        self._recommended_cpu_models = None
        self._recover_data_size = None
        self._recover_speed = None
        self._reserved_cpu_cores_for_system_service = None
        self._running_vm_num = None
        self._settings = None
        self._software_edition = None
        self._stopped_vm_num = None
        self._stretch = None
        self._suspended_vm_num = None
        self._total_cache_capacity = None
        self._total_cpu_cores = None
        self._total_cpu_hz = None
        self._total_cpu_models = None
        self._total_cpu_sockets = None
        self._total_data_capacity = None
        self._total_memory_bytes = None
        self._type = None
        self._upgrade_tool_version = None
        self._used_cpu_hz = None
        self._used_data_space = None
        self._used_memory_bytes = None
        self._valid_data_space = None
        self._vcenter_account = None
        self._vdses = None
        self._version = None
        self._vhost_enabled = None
        self._vm_folders = None
        self._vm_num = None
        self._vm_templates = None
        self._vms = None
        self._witness = None
        self._zones = None
        self.discriminator = None

        self.application_highest_version = kwargs.get("application_highest_version", None)
        self.applications = kwargs.get("applications", None)
        if "architecture" in kwargs:
            self.architecture = kwargs["architecture"]
        self.auto_converge = kwargs.get("auto_converge", None)
        if "connect_state" in kwargs:
            self.connect_state = kwargs["connect_state"]
        self.consistency_groups = kwargs.get("consistency_groups", None)
        self.current_cpu_model = kwargs.get("current_cpu_model", None)
        self.datacenters = kwargs.get("datacenters", None)
        self.disconnected_date = kwargs.get("disconnected_date", None)
        self.disconnected_reason = kwargs.get("disconnected_reason", None)
        if "dns" in kwargs:
            self.dns = kwargs["dns"]
        self.entity_async_status = kwargs.get("entity_async_status", None)
        self.everoute_cluster = kwargs.get("everoute_cluster", None)
        self.failure_data_space = kwargs.get("failure_data_space", None)
        self.has_metrox = kwargs.get("has_metrox", None)
        self.host_num = kwargs.get("host_num", None)
        self.hosts = kwargs.get("hosts", None)
        self.hypervisor = kwargs.get("hypervisor", None)
        if "id" in kwargs:
            self.id = kwargs["id"]
        if "ip" in kwargs:
            self.ip = kwargs["ip"]
        self.is_all_flash = kwargs.get("is_all_flash", None)
        self.iscsi_vip = kwargs.get("iscsi_vip", None)
        self.labels = kwargs.get("labels", None)
        self.license_expire_date = kwargs.get("license_expire_date", None)
        self.license_serial = kwargs.get("license_serial", None)
        self.license_sign_date = kwargs.get("license_sign_date", None)
        self.license_type = kwargs.get("license_type", None)
        self.local_id = kwargs.get("local_id", None)
        self.maintenance_end_date = kwargs.get("maintenance_end_date", None)
        self.maintenance_start_date = kwargs.get("maintenance_start_date", None)
        self.management_vip = kwargs.get("management_vip", None)
        self.max_chunk_num = kwargs.get("max_chunk_num", None)
        self.max_physical_data_capacity = kwargs.get("max_physical_data_capacity", None)
        self.max_physical_data_capacity_per_node = kwargs.get("max_physical_data_capacity_per_node", None)
        self.metro_availability_checklist = kwargs.get("metro_availability_checklist", None)
        self.mgt_gateway = kwargs.get("mgt_gateway", None)
        self.mgt_netmask = kwargs.get("mgt_netmask", None)
        self.migration_data_size = kwargs.get("migration_data_size", None)
        self.migration_speed = kwargs.get("migration_speed", None)
        if "name" in kwargs:
            self.name = kwargs["name"]
        self.ntp_mode = kwargs.get("ntp_mode", None)
        if "ntp_servers" in kwargs:
            self.ntp_servers = kwargs["ntp_servers"]
        self.nvme_over_rdma_enabled = kwargs.get("nvme_over_rdma_enabled", None)
        self.nvme_over_tcp_enabled = kwargs.get("nvme_over_tcp_enabled", None)
        self.nvmf_enabled = kwargs.get("nvmf_enabled", None)
        self.pmem_enabled = kwargs.get("pmem_enabled", None)
        self.provisioned_cpu_cores = kwargs.get("provisioned_cpu_cores", None)
        self.provisioned_cpu_cores_for_active_vm = kwargs.get("provisioned_cpu_cores_for_active_vm", None)
        self.provisioned_for_active_vm_ratio = kwargs.get("provisioned_for_active_vm_ratio", None)
        self.provisioned_memory_bytes = kwargs.get("provisioned_memory_bytes", None)
        self.provisioned_ratio = kwargs.get("provisioned_ratio", None)
        self.rdma_enabled = kwargs.get("rdma_enabled", None)
        if "recommended_cpu_models" in kwargs:
            self.recommended_cpu_models = kwargs["recommended_cpu_models"]
        self.recover_data_size = kwargs.get("recover_data_size", None)
        self.recover_speed = kwargs.get("recover_speed", None)
        self.reserved_cpu_cores_for_system_service = kwargs.get("reserved_cpu_cores_for_system_service", None)
        self.running_vm_num = kwargs.get("running_vm_num", None)
        self.settings = kwargs.get("settings", None)
        self.software_edition = kwargs.get("software_edition", None)
        self.stopped_vm_num = kwargs.get("stopped_vm_num", None)
        self.stretch = kwargs.get("stretch", None)
        self.suspended_vm_num = kwargs.get("suspended_vm_num", None)
        self.total_cache_capacity = kwargs.get("total_cache_capacity", None)
        self.total_cpu_cores = kwargs.get("total_cpu_cores", None)
        self.total_cpu_hz = kwargs.get("total_cpu_hz", None)
        if "total_cpu_models" in kwargs:
            self.total_cpu_models = kwargs["total_cpu_models"]
        self.total_cpu_sockets = kwargs.get("total_cpu_sockets", None)
        self.total_data_capacity = kwargs.get("total_data_capacity", None)
        self.total_memory_bytes = kwargs.get("total_memory_bytes", None)
        if "type" in kwargs:
            self.type = kwargs["type"]
        self.upgrade_tool_version = kwargs.get("upgrade_tool_version", None)
        self.used_cpu_hz = kwargs.get("used_cpu_hz", None)
        self.used_data_space = kwargs.get("used_data_space", None)
        self.used_memory_bytes = kwargs.get("used_memory_bytes", None)
        self.valid_data_space = kwargs.get("valid_data_space", None)
        self.vcenter_account = kwargs.get("vcenter_account", None)
        self.vdses = kwargs.get("vdses", None)
        if "version" in kwargs:
            self.version = kwargs["version"]
        self.vhost_enabled = kwargs.get("vhost_enabled", None)
        self.vm_folders = kwargs.get("vm_folders", None)
        self.vm_num = kwargs.get("vm_num", None)
        self.vm_templates = kwargs.get("vm_templates", None)
        self.vms = kwargs.get("vms", None)
        self.witness = kwargs.get("witness", None)
        self.zones = kwargs.get("zones", None)

    @property
    def application_highest_version(self):
        """Gets the application_highest_version of this Cluster.  # noqa: E501


        :return: The application_highest_version of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._application_highest_version

    @application_highest_version.setter
    def application_highest_version(self, application_highest_version):
        """Sets the application_highest_version of this Cluster.


        :param application_highest_version: The application_highest_version of this Cluster.  # noqa: E501
        :type application_highest_version: str
        """

        self._application_highest_version = application_highest_version

    @property
    def applications(self):
        """Gets the applications of this Cluster.  # noqa: E501


        :return: The applications of this Cluster.  # noqa: E501
        :rtype: list[NestedApplication]
        """
        return self._applications

    @applications.setter
    def applications(self, applications):
        """Sets the applications of this Cluster.


        :param applications: The applications of this Cluster.  # noqa: E501
        :type applications: list[NestedApplication]
        """

        self._applications = applications

    @property
    def architecture(self):
        """Gets the architecture of this Cluster.  # noqa: E501


        :return: The architecture of this Cluster.  # noqa: E501
        :rtype: Architecture
        """
        return self._architecture

    @architecture.setter
    def architecture(self, architecture):
        """Sets the architecture of this Cluster.


        :param architecture: The architecture of this Cluster.  # noqa: E501
        :type architecture: Architecture
        """
        if self.local_vars_configuration.client_side_validation and architecture is None:  # noqa: E501
            raise ValueError("Invalid value for `architecture`, must not be `None`")  # noqa: E501

        self._architecture = architecture

    @property
    def auto_converge(self):
        """Gets the auto_converge of this Cluster.  # noqa: E501


        :return: The auto_converge of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._auto_converge

    @auto_converge.setter
    def auto_converge(self, auto_converge):
        """Sets the auto_converge of this Cluster.


        :param auto_converge: The auto_converge of this Cluster.  # noqa: E501
        :type auto_converge: bool
        """

        self._auto_converge = auto_converge

    @property
    def connect_state(self):
        """Gets the connect_state of this Cluster.  # noqa: E501


        :return: The connect_state of this Cluster.  # noqa: E501
        :rtype: ConnectState
        """
        return self._connect_state

    @connect_state.setter
    def connect_state(self, connect_state):
        """Sets the connect_state of this Cluster.


        :param connect_state: The connect_state of this Cluster.  # noqa: E501
        :type connect_state: ConnectState
        """
        if self.local_vars_configuration.client_side_validation and connect_state is None:  # noqa: E501
            raise ValueError("Invalid value for `connect_state`, must not be `None`")  # noqa: E501

        self._connect_state = connect_state

    @property
    def consistency_groups(self):
        """Gets the consistency_groups of this Cluster.  # noqa: E501


        :return: The consistency_groups of this Cluster.  # noqa: E501
        :rtype: list[NestedConsistencyGroup]
        """
        return self._consistency_groups

    @consistency_groups.setter
    def consistency_groups(self, consistency_groups):
        """Sets the consistency_groups of this Cluster.


        :param consistency_groups: The consistency_groups of this Cluster.  # noqa: E501
        :type consistency_groups: list[NestedConsistencyGroup]
        """

        self._consistency_groups = consistency_groups

    @property
    def current_cpu_model(self):
        """Gets the current_cpu_model of this Cluster.  # noqa: E501


        :return: The current_cpu_model of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._current_cpu_model

    @current_cpu_model.setter
    def current_cpu_model(self, current_cpu_model):
        """Sets the current_cpu_model of this Cluster.


        :param current_cpu_model: The current_cpu_model of this Cluster.  # noqa: E501
        :type current_cpu_model: str
        """

        self._current_cpu_model = current_cpu_model

    @property
    def datacenters(self):
        """Gets the datacenters of this Cluster.  # noqa: E501


        :return: The datacenters of this Cluster.  # noqa: E501
        :rtype: list[NestedDatacenter]
        """
        return self._datacenters

    @datacenters.setter
    def datacenters(self, datacenters):
        """Sets the datacenters of this Cluster.


        :param datacenters: The datacenters of this Cluster.  # noqa: E501
        :type datacenters: list[NestedDatacenter]
        """

        self._datacenters = datacenters

    @property
    def disconnected_date(self):
        """Gets the disconnected_date of this Cluster.  # noqa: E501


        :return: The disconnected_date of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._disconnected_date

    @disconnected_date.setter
    def disconnected_date(self, disconnected_date):
        """Sets the disconnected_date of this Cluster.


        :param disconnected_date: The disconnected_date of this Cluster.  # noqa: E501
        :type disconnected_date: str
        """

        self._disconnected_date = disconnected_date

    @property
    def disconnected_reason(self):
        """Gets the disconnected_reason of this Cluster.  # noqa: E501


        :return: The disconnected_reason of this Cluster.  # noqa: E501
        :rtype: ClusterConnectorErrorCode
        """
        return self._disconnected_reason

    @disconnected_reason.setter
    def disconnected_reason(self, disconnected_reason):
        """Sets the disconnected_reason of this Cluster.


        :param disconnected_reason: The disconnected_reason of this Cluster.  # noqa: E501
        :type disconnected_reason: ClusterConnectorErrorCode
        """

        self._disconnected_reason = disconnected_reason

    @property
    def dns(self):
        """Gets the dns of this Cluster.  # noqa: E501


        :return: The dns of this Cluster.  # noqa: E501
        :rtype: list[str]
        """
        return self._dns

    @dns.setter
    def dns(self, dns):
        """Sets the dns of this Cluster.


        :param dns: The dns of this Cluster.  # noqa: E501
        :type dns: list[str]
        """
        if self.local_vars_configuration.client_side_validation and dns is None:  # noqa: E501
            raise ValueError("Invalid value for `dns`, must not be `None`")  # noqa: E501

        self._dns = dns

    @property
    def entity_async_status(self):
        """Gets the entity_async_status of this Cluster.  # noqa: E501


        :return: The entity_async_status of this Cluster.  # noqa: E501
        :rtype: EntityAsyncStatus
        """
        return self._entity_async_status

    @entity_async_status.setter
    def entity_async_status(self, entity_async_status):
        """Sets the entity_async_status of this Cluster.


        :param entity_async_status: The entity_async_status of this Cluster.  # noqa: E501
        :type entity_async_status: EntityAsyncStatus
        """

        self._entity_async_status = entity_async_status

    @property
    def everoute_cluster(self):
        """Gets the everoute_cluster of this Cluster.  # noqa: E501


        :return: The everoute_cluster of this Cluster.  # noqa: E501
        :rtype: NestedEverouteCluster
        """
        return self._everoute_cluster

    @everoute_cluster.setter
    def everoute_cluster(self, everoute_cluster):
        """Sets the everoute_cluster of this Cluster.


        :param everoute_cluster: The everoute_cluster of this Cluster.  # noqa: E501
        :type everoute_cluster: NestedEverouteCluster
        """

        self._everoute_cluster = everoute_cluster

    @property
    def failure_data_space(self):
        """Gets the failure_data_space of this Cluster.  # noqa: E501


        :return: The failure_data_space of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._failure_data_space

    @failure_data_space.setter
    def failure_data_space(self, failure_data_space):
        """Sets the failure_data_space of this Cluster.


        :param failure_data_space: The failure_data_space of this Cluster.  # noqa: E501
        :type failure_data_space: int
        """

        self._failure_data_space = failure_data_space

    @property
    def has_metrox(self):
        """Gets the has_metrox of this Cluster.  # noqa: E501


        :return: The has_metrox of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._has_metrox

    @has_metrox.setter
    def has_metrox(self, has_metrox):
        """Sets the has_metrox of this Cluster.


        :param has_metrox: The has_metrox of this Cluster.  # noqa: E501
        :type has_metrox: bool
        """

        self._has_metrox = has_metrox

    @property
    def host_num(self):
        """Gets the host_num of this Cluster.  # noqa: E501


        :return: The host_num of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._host_num

    @host_num.setter
    def host_num(self, host_num):
        """Sets the host_num of this Cluster.


        :param host_num: The host_num of this Cluster.  # noqa: E501
        :type host_num: int
        """

        self._host_num = host_num

    @property
    def hosts(self):
        """Gets the hosts of this Cluster.  # noqa: E501


        :return: The hosts of this Cluster.  # noqa: E501
        :rtype: list[NestedHost]
        """
        return self._hosts

    @hosts.setter
    def hosts(self, hosts):
        """Sets the hosts of this Cluster.


        :param hosts: The hosts of this Cluster.  # noqa: E501
        :type hosts: list[NestedHost]
        """

        self._hosts = hosts

    @property
    def hypervisor(self):
        """Gets the hypervisor of this Cluster.  # noqa: E501


        :return: The hypervisor of this Cluster.  # noqa: E501
        :rtype: Hypervisor
        """
        return self._hypervisor

    @hypervisor.setter
    def hypervisor(self, hypervisor):
        """Sets the hypervisor of this Cluster.


        :param hypervisor: The hypervisor of this Cluster.  # noqa: E501
        :type hypervisor: Hypervisor
        """

        self._hypervisor = hypervisor

    @property
    def id(self):
        """Gets the id of this Cluster.  # noqa: E501


        :return: The id of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Cluster.


        :param id: The id of this Cluster.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def ip(self):
        """Gets the ip of this Cluster.  # noqa: E501


        :return: The ip of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._ip

    @ip.setter
    def ip(self, ip):
        """Sets the ip of this Cluster.


        :param ip: The ip of this Cluster.  # noqa: E501
        :type ip: str
        """
        if self.local_vars_configuration.client_side_validation and ip is None:  # noqa: E501
            raise ValueError("Invalid value for `ip`, must not be `None`")  # noqa: E501

        self._ip = ip

    @property
    def is_all_flash(self):
        """Gets the is_all_flash of this Cluster.  # noqa: E501


        :return: The is_all_flash of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._is_all_flash

    @is_all_flash.setter
    def is_all_flash(self, is_all_flash):
        """Sets the is_all_flash of this Cluster.


        :param is_all_flash: The is_all_flash of this Cluster.  # noqa: E501
        :type is_all_flash: bool
        """

        self._is_all_flash = is_all_flash

    @property
    def iscsi_vip(self):
        """Gets the iscsi_vip of this Cluster.  # noqa: E501


        :return: The iscsi_vip of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._iscsi_vip

    @iscsi_vip.setter
    def iscsi_vip(self, iscsi_vip):
        """Sets the iscsi_vip of this Cluster.


        :param iscsi_vip: The iscsi_vip of this Cluster.  # noqa: E501
        :type iscsi_vip: str
        """

        self._iscsi_vip = iscsi_vip

    @property
    def labels(self):
        """Gets the labels of this Cluster.  # noqa: E501


        :return: The labels of this Cluster.  # noqa: E501
        :rtype: list[NestedLabel]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this Cluster.


        :param labels: The labels of this Cluster.  # noqa: E501
        :type labels: list[NestedLabel]
        """

        self._labels = labels

    @property
    def license_expire_date(self):
        """Gets the license_expire_date of this Cluster.  # noqa: E501


        :return: The license_expire_date of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._license_expire_date

    @license_expire_date.setter
    def license_expire_date(self, license_expire_date):
        """Sets the license_expire_date of this Cluster.


        :param license_expire_date: The license_expire_date of this Cluster.  # noqa: E501
        :type license_expire_date: str
        """

        self._license_expire_date = license_expire_date

    @property
    def license_serial(self):
        """Gets the license_serial of this Cluster.  # noqa: E501


        :return: The license_serial of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._license_serial

    @license_serial.setter
    def license_serial(self, license_serial):
        """Sets the license_serial of this Cluster.


        :param license_serial: The license_serial of this Cluster.  # noqa: E501
        :type license_serial: str
        """

        self._license_serial = license_serial

    @property
    def license_sign_date(self):
        """Gets the license_sign_date of this Cluster.  # noqa: E501


        :return: The license_sign_date of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._license_sign_date

    @license_sign_date.setter
    def license_sign_date(self, license_sign_date):
        """Sets the license_sign_date of this Cluster.


        :param license_sign_date: The license_sign_date of this Cluster.  # noqa: E501
        :type license_sign_date: str
        """

        self._license_sign_date = license_sign_date

    @property
    def license_type(self):
        """Gets the license_type of this Cluster.  # noqa: E501


        :return: The license_type of this Cluster.  # noqa: E501
        :rtype: LicenseType
        """
        return self._license_type

    @license_type.setter
    def license_type(self, license_type):
        """Sets the license_type of this Cluster.


        :param license_type: The license_type of this Cluster.  # noqa: E501
        :type license_type: LicenseType
        """

        self._license_type = license_type

    @property
    def local_id(self):
        """Gets the local_id of this Cluster.  # noqa: E501


        :return: The local_id of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id):
        """Sets the local_id of this Cluster.


        :param local_id: The local_id of this Cluster.  # noqa: E501
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def maintenance_end_date(self):
        """Gets the maintenance_end_date of this Cluster.  # noqa: E501


        :return: The maintenance_end_date of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._maintenance_end_date

    @maintenance_end_date.setter
    def maintenance_end_date(self, maintenance_end_date):
        """Sets the maintenance_end_date of this Cluster.


        :param maintenance_end_date: The maintenance_end_date of this Cluster.  # noqa: E501
        :type maintenance_end_date: str
        """

        self._maintenance_end_date = maintenance_end_date

    @property
    def maintenance_start_date(self):
        """Gets the maintenance_start_date of this Cluster.  # noqa: E501


        :return: The maintenance_start_date of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._maintenance_start_date

    @maintenance_start_date.setter
    def maintenance_start_date(self, maintenance_start_date):
        """Sets the maintenance_start_date of this Cluster.


        :param maintenance_start_date: The maintenance_start_date of this Cluster.  # noqa: E501
        :type maintenance_start_date: str
        """

        self._maintenance_start_date = maintenance_start_date

    @property
    def management_vip(self):
        """Gets the management_vip of this Cluster.  # noqa: E501


        :return: The management_vip of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._management_vip

    @management_vip.setter
    def management_vip(self, management_vip):
        """Sets the management_vip of this Cluster.


        :param management_vip: The management_vip of this Cluster.  # noqa: E501
        :type management_vip: str
        """

        self._management_vip = management_vip

    @property
    def max_chunk_num(self):
        """Gets the max_chunk_num of this Cluster.  # noqa: E501


        :return: The max_chunk_num of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._max_chunk_num

    @max_chunk_num.setter
    def max_chunk_num(self, max_chunk_num):
        """Sets the max_chunk_num of this Cluster.


        :param max_chunk_num: The max_chunk_num of this Cluster.  # noqa: E501
        :type max_chunk_num: int
        """

        self._max_chunk_num = max_chunk_num

    @property
    def max_physical_data_capacity(self):
        """Gets the max_physical_data_capacity of this Cluster.  # noqa: E501


        :return: The max_physical_data_capacity of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._max_physical_data_capacity

    @max_physical_data_capacity.setter
    def max_physical_data_capacity(self, max_physical_data_capacity):
        """Sets the max_physical_data_capacity of this Cluster.


        :param max_physical_data_capacity: The max_physical_data_capacity of this Cluster.  # noqa: E501
        :type max_physical_data_capacity: int
        """

        self._max_physical_data_capacity = max_physical_data_capacity

    @property
    def max_physical_data_capacity_per_node(self):
        """Gets the max_physical_data_capacity_per_node of this Cluster.  # noqa: E501


        :return: The max_physical_data_capacity_per_node of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._max_physical_data_capacity_per_node

    @max_physical_data_capacity_per_node.setter
    def max_physical_data_capacity_per_node(self, max_physical_data_capacity_per_node):
        """Sets the max_physical_data_capacity_per_node of this Cluster.


        :param max_physical_data_capacity_per_node: The max_physical_data_capacity_per_node of this Cluster.  # noqa: E501
        :type max_physical_data_capacity_per_node: int
        """

        self._max_physical_data_capacity_per_node = max_physical_data_capacity_per_node

    @property
    def metro_availability_checklist(self):
        """Gets the metro_availability_checklist of this Cluster.  # noqa: E501


        :return: The metro_availability_checklist of this Cluster.  # noqa: E501
        :rtype: NestedMetroAvailabilityChecklist
        """
        return self._metro_availability_checklist

    @metro_availability_checklist.setter
    def metro_availability_checklist(self, metro_availability_checklist):
        """Sets the metro_availability_checklist of this Cluster.


        :param metro_availability_checklist: The metro_availability_checklist of this Cluster.  # noqa: E501
        :type metro_availability_checklist: NestedMetroAvailabilityChecklist
        """

        self._metro_availability_checklist = metro_availability_checklist

    @property
    def mgt_gateway(self):
        """Gets the mgt_gateway of this Cluster.  # noqa: E501


        :return: The mgt_gateway of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._mgt_gateway

    @mgt_gateway.setter
    def mgt_gateway(self, mgt_gateway):
        """Sets the mgt_gateway of this Cluster.


        :param mgt_gateway: The mgt_gateway of this Cluster.  # noqa: E501
        :type mgt_gateway: str
        """

        self._mgt_gateway = mgt_gateway

    @property
    def mgt_netmask(self):
        """Gets the mgt_netmask of this Cluster.  # noqa: E501


        :return: The mgt_netmask of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._mgt_netmask

    @mgt_netmask.setter
    def mgt_netmask(self, mgt_netmask):
        """Sets the mgt_netmask of this Cluster.


        :param mgt_netmask: The mgt_netmask of this Cluster.  # noqa: E501
        :type mgt_netmask: str
        """

        self._mgt_netmask = mgt_netmask

    @property
    def migration_data_size(self):
        """Gets the migration_data_size of this Cluster.  # noqa: E501


        :return: The migration_data_size of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._migration_data_size

    @migration_data_size.setter
    def migration_data_size(self, migration_data_size):
        """Sets the migration_data_size of this Cluster.


        :param migration_data_size: The migration_data_size of this Cluster.  # noqa: E501
        :type migration_data_size: int
        """

        self._migration_data_size = migration_data_size

    @property
    def migration_speed(self):
        """Gets the migration_speed of this Cluster.  # noqa: E501


        :return: The migration_speed of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._migration_speed

    @migration_speed.setter
    def migration_speed(self, migration_speed):
        """Sets the migration_speed of this Cluster.


        :param migration_speed: The migration_speed of this Cluster.  # noqa: E501
        :type migration_speed: int
        """

        self._migration_speed = migration_speed

    @property
    def name(self):
        """Gets the name of this Cluster.  # noqa: E501


        :return: The name of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Cluster.


        :param name: The name of this Cluster.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def ntp_mode(self):
        """Gets the ntp_mode of this Cluster.  # noqa: E501


        :return: The ntp_mode of this Cluster.  # noqa: E501
        :rtype: NtpMode
        """
        return self._ntp_mode

    @ntp_mode.setter
    def ntp_mode(self, ntp_mode):
        """Sets the ntp_mode of this Cluster.


        :param ntp_mode: The ntp_mode of this Cluster.  # noqa: E501
        :type ntp_mode: NtpMode
        """

        self._ntp_mode = ntp_mode

    @property
    def ntp_servers(self):
        """Gets the ntp_servers of this Cluster.  # noqa: E501


        :return: The ntp_servers of this Cluster.  # noqa: E501
        :rtype: list[str]
        """
        return self._ntp_servers

    @ntp_servers.setter
    def ntp_servers(self, ntp_servers):
        """Sets the ntp_servers of this Cluster.


        :param ntp_servers: The ntp_servers of this Cluster.  # noqa: E501
        :type ntp_servers: list[str]
        """
        if self.local_vars_configuration.client_side_validation and ntp_servers is None:  # noqa: E501
            raise ValueError("Invalid value for `ntp_servers`, must not be `None`")  # noqa: E501

        self._ntp_servers = ntp_servers

    @property
    def nvme_over_rdma_enabled(self):
        """Gets the nvme_over_rdma_enabled of this Cluster.  # noqa: E501


        :return: The nvme_over_rdma_enabled of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._nvme_over_rdma_enabled

    @nvme_over_rdma_enabled.setter
    def nvme_over_rdma_enabled(self, nvme_over_rdma_enabled):
        """Sets the nvme_over_rdma_enabled of this Cluster.


        :param nvme_over_rdma_enabled: The nvme_over_rdma_enabled of this Cluster.  # noqa: E501
        :type nvme_over_rdma_enabled: bool
        """

        self._nvme_over_rdma_enabled = nvme_over_rdma_enabled

    @property
    def nvme_over_tcp_enabled(self):
        """Gets the nvme_over_tcp_enabled of this Cluster.  # noqa: E501


        :return: The nvme_over_tcp_enabled of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._nvme_over_tcp_enabled

    @nvme_over_tcp_enabled.setter
    def nvme_over_tcp_enabled(self, nvme_over_tcp_enabled):
        """Sets the nvme_over_tcp_enabled of this Cluster.


        :param nvme_over_tcp_enabled: The nvme_over_tcp_enabled of this Cluster.  # noqa: E501
        :type nvme_over_tcp_enabled: bool
        """

        self._nvme_over_tcp_enabled = nvme_over_tcp_enabled

    @property
    def nvmf_enabled(self):
        """Gets the nvmf_enabled of this Cluster.  # noqa: E501


        :return: The nvmf_enabled of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._nvmf_enabled

    @nvmf_enabled.setter
    def nvmf_enabled(self, nvmf_enabled):
        """Sets the nvmf_enabled of this Cluster.


        :param nvmf_enabled: The nvmf_enabled of this Cluster.  # noqa: E501
        :type nvmf_enabled: bool
        """

        self._nvmf_enabled = nvmf_enabled

    @property
    def pmem_enabled(self):
        """Gets the pmem_enabled of this Cluster.  # noqa: E501


        :return: The pmem_enabled of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._pmem_enabled

    @pmem_enabled.setter
    def pmem_enabled(self, pmem_enabled):
        """Sets the pmem_enabled of this Cluster.


        :param pmem_enabled: The pmem_enabled of this Cluster.  # noqa: E501
        :type pmem_enabled: bool
        """

        self._pmem_enabled = pmem_enabled

    @property
    def provisioned_cpu_cores(self):
        """Gets the provisioned_cpu_cores of this Cluster.  # noqa: E501


        :return: The provisioned_cpu_cores of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores

    @provisioned_cpu_cores.setter
    def provisioned_cpu_cores(self, provisioned_cpu_cores):
        """Sets the provisioned_cpu_cores of this Cluster.


        :param provisioned_cpu_cores: The provisioned_cpu_cores of this Cluster.  # noqa: E501
        :type provisioned_cpu_cores: int
        """

        self._provisioned_cpu_cores = provisioned_cpu_cores

    @property
    def provisioned_cpu_cores_for_active_vm(self):
        """Gets the provisioned_cpu_cores_for_active_vm of this Cluster.  # noqa: E501


        :return: The provisioned_cpu_cores_for_active_vm of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_cpu_cores_for_active_vm

    @provisioned_cpu_cores_for_active_vm.setter
    def provisioned_cpu_cores_for_active_vm(self, provisioned_cpu_cores_for_active_vm):
        """Sets the provisioned_cpu_cores_for_active_vm of this Cluster.


        :param provisioned_cpu_cores_for_active_vm: The provisioned_cpu_cores_for_active_vm of this Cluster.  # noqa: E501
        :type provisioned_cpu_cores_for_active_vm: int
        """

        self._provisioned_cpu_cores_for_active_vm = provisioned_cpu_cores_for_active_vm

    @property
    def provisioned_for_active_vm_ratio(self):
        """Gets the provisioned_for_active_vm_ratio of this Cluster.  # noqa: E501


        :return: The provisioned_for_active_vm_ratio of this Cluster.  # noqa: E501
        :rtype: float
        """
        return self._provisioned_for_active_vm_ratio

    @provisioned_for_active_vm_ratio.setter
    def provisioned_for_active_vm_ratio(self, provisioned_for_active_vm_ratio):
        """Sets the provisioned_for_active_vm_ratio of this Cluster.


        :param provisioned_for_active_vm_ratio: The provisioned_for_active_vm_ratio of this Cluster.  # noqa: E501
        :type provisioned_for_active_vm_ratio: float
        """

        self._provisioned_for_active_vm_ratio = provisioned_for_active_vm_ratio

    @property
    def provisioned_memory_bytes(self):
        """Gets the provisioned_memory_bytes of this Cluster.  # noqa: E501


        :return: The provisioned_memory_bytes of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._provisioned_memory_bytes

    @provisioned_memory_bytes.setter
    def provisioned_memory_bytes(self, provisioned_memory_bytes):
        """Sets the provisioned_memory_bytes of this Cluster.


        :param provisioned_memory_bytes: The provisioned_memory_bytes of this Cluster.  # noqa: E501
        :type provisioned_memory_bytes: int
        """

        self._provisioned_memory_bytes = provisioned_memory_bytes

    @property
    def provisioned_ratio(self):
        """Gets the provisioned_ratio of this Cluster.  # noqa: E501


        :return: The provisioned_ratio of this Cluster.  # noqa: E501
        :rtype: float
        """
        return self._provisioned_ratio

    @provisioned_ratio.setter
    def provisioned_ratio(self, provisioned_ratio):
        """Sets the provisioned_ratio of this Cluster.


        :param provisioned_ratio: The provisioned_ratio of this Cluster.  # noqa: E501
        :type provisioned_ratio: float
        """

        self._provisioned_ratio = provisioned_ratio

    @property
    def rdma_enabled(self):
        """Gets the rdma_enabled of this Cluster.  # noqa: E501


        :return: The rdma_enabled of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._rdma_enabled

    @rdma_enabled.setter
    def rdma_enabled(self, rdma_enabled):
        """Sets the rdma_enabled of this Cluster.


        :param rdma_enabled: The rdma_enabled of this Cluster.  # noqa: E501
        :type rdma_enabled: bool
        """

        self._rdma_enabled = rdma_enabled

    @property
    def recommended_cpu_models(self):
        """Gets the recommended_cpu_models of this Cluster.  # noqa: E501


        :return: The recommended_cpu_models of this Cluster.  # noqa: E501
        :rtype: list[str]
        """
        return self._recommended_cpu_models

    @recommended_cpu_models.setter
    def recommended_cpu_models(self, recommended_cpu_models):
        """Sets the recommended_cpu_models of this Cluster.


        :param recommended_cpu_models: The recommended_cpu_models of this Cluster.  # noqa: E501
        :type recommended_cpu_models: list[str]
        """
        if self.local_vars_configuration.client_side_validation and recommended_cpu_models is None:  # noqa: E501
            raise ValueError("Invalid value for `recommended_cpu_models`, must not be `None`")  # noqa: E501

        self._recommended_cpu_models = recommended_cpu_models

    @property
    def recover_data_size(self):
        """Gets the recover_data_size of this Cluster.  # noqa: E501


        :return: The recover_data_size of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._recover_data_size

    @recover_data_size.setter
    def recover_data_size(self, recover_data_size):
        """Sets the recover_data_size of this Cluster.


        :param recover_data_size: The recover_data_size of this Cluster.  # noqa: E501
        :type recover_data_size: int
        """

        self._recover_data_size = recover_data_size

    @property
    def recover_speed(self):
        """Gets the recover_speed of this Cluster.  # noqa: E501


        :return: The recover_speed of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._recover_speed

    @recover_speed.setter
    def recover_speed(self, recover_speed):
        """Sets the recover_speed of this Cluster.


        :param recover_speed: The recover_speed of this Cluster.  # noqa: E501
        :type recover_speed: int
        """

        self._recover_speed = recover_speed

    @property
    def reserved_cpu_cores_for_system_service(self):
        """Gets the reserved_cpu_cores_for_system_service of this Cluster.  # noqa: E501


        :return: The reserved_cpu_cores_for_system_service of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._reserved_cpu_cores_for_system_service

    @reserved_cpu_cores_for_system_service.setter
    def reserved_cpu_cores_for_system_service(self, reserved_cpu_cores_for_system_service):
        """Sets the reserved_cpu_cores_for_system_service of this Cluster.


        :param reserved_cpu_cores_for_system_service: The reserved_cpu_cores_for_system_service of this Cluster.  # noqa: E501
        :type reserved_cpu_cores_for_system_service: int
        """

        self._reserved_cpu_cores_for_system_service = reserved_cpu_cores_for_system_service

    @property
    def running_vm_num(self):
        """Gets the running_vm_num of this Cluster.  # noqa: E501


        :return: The running_vm_num of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._running_vm_num

    @running_vm_num.setter
    def running_vm_num(self, running_vm_num):
        """Sets the running_vm_num of this Cluster.


        :param running_vm_num: The running_vm_num of this Cluster.  # noqa: E501
        :type running_vm_num: int
        """

        self._running_vm_num = running_vm_num

    @property
    def settings(self):
        """Gets the settings of this Cluster.  # noqa: E501


        :return: The settings of this Cluster.  # noqa: E501
        :rtype: NestedClusterSettings
        """
        return self._settings

    @settings.setter
    def settings(self, settings):
        """Sets the settings of this Cluster.


        :param settings: The settings of this Cluster.  # noqa: E501
        :type settings: NestedClusterSettings
        """

        self._settings = settings

    @property
    def software_edition(self):
        """Gets the software_edition of this Cluster.  # noqa: E501


        :return: The software_edition of this Cluster.  # noqa: E501
        :rtype: SoftwareEdition
        """
        return self._software_edition

    @software_edition.setter
    def software_edition(self, software_edition):
        """Sets the software_edition of this Cluster.


        :param software_edition: The software_edition of this Cluster.  # noqa: E501
        :type software_edition: SoftwareEdition
        """

        self._software_edition = software_edition

    @property
    def stopped_vm_num(self):
        """Gets the stopped_vm_num of this Cluster.  # noqa: E501


        :return: The stopped_vm_num of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._stopped_vm_num

    @stopped_vm_num.setter
    def stopped_vm_num(self, stopped_vm_num):
        """Sets the stopped_vm_num of this Cluster.


        :param stopped_vm_num: The stopped_vm_num of this Cluster.  # noqa: E501
        :type stopped_vm_num: int
        """

        self._stopped_vm_num = stopped_vm_num

    @property
    def stretch(self):
        """Gets the stretch of this Cluster.  # noqa: E501


        :return: The stretch of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._stretch

    @stretch.setter
    def stretch(self, stretch):
        """Sets the stretch of this Cluster.


        :param stretch: The stretch of this Cluster.  # noqa: E501
        :type stretch: bool
        """

        self._stretch = stretch

    @property
    def suspended_vm_num(self):
        """Gets the suspended_vm_num of this Cluster.  # noqa: E501


        :return: The suspended_vm_num of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._suspended_vm_num

    @suspended_vm_num.setter
    def suspended_vm_num(self, suspended_vm_num):
        """Sets the suspended_vm_num of this Cluster.


        :param suspended_vm_num: The suspended_vm_num of this Cluster.  # noqa: E501
        :type suspended_vm_num: int
        """

        self._suspended_vm_num = suspended_vm_num

    @property
    def total_cache_capacity(self):
        """Gets the total_cache_capacity of this Cluster.  # noqa: E501


        :return: The total_cache_capacity of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._total_cache_capacity

    @total_cache_capacity.setter
    def total_cache_capacity(self, total_cache_capacity):
        """Sets the total_cache_capacity of this Cluster.


        :param total_cache_capacity: The total_cache_capacity of this Cluster.  # noqa: E501
        :type total_cache_capacity: int
        """

        self._total_cache_capacity = total_cache_capacity

    @property
    def total_cpu_cores(self):
        """Gets the total_cpu_cores of this Cluster.  # noqa: E501


        :return: The total_cpu_cores of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_cores

    @total_cpu_cores.setter
    def total_cpu_cores(self, total_cpu_cores):
        """Sets the total_cpu_cores of this Cluster.


        :param total_cpu_cores: The total_cpu_cores of this Cluster.  # noqa: E501
        :type total_cpu_cores: int
        """

        self._total_cpu_cores = total_cpu_cores

    @property
    def total_cpu_hz(self):
        """Gets the total_cpu_hz of this Cluster.  # noqa: E501


        :return: The total_cpu_hz of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_hz

    @total_cpu_hz.setter
    def total_cpu_hz(self, total_cpu_hz):
        """Sets the total_cpu_hz of this Cluster.


        :param total_cpu_hz: The total_cpu_hz of this Cluster.  # noqa: E501
        :type total_cpu_hz: int
        """

        self._total_cpu_hz = total_cpu_hz

    @property
    def total_cpu_models(self):
        """Gets the total_cpu_models of this Cluster.  # noqa: E501


        :return: The total_cpu_models of this Cluster.  # noqa: E501
        :rtype: list[str]
        """
        return self._total_cpu_models

    @total_cpu_models.setter
    def total_cpu_models(self, total_cpu_models):
        """Sets the total_cpu_models of this Cluster.


        :param total_cpu_models: The total_cpu_models of this Cluster.  # noqa: E501
        :type total_cpu_models: list[str]
        """
        if self.local_vars_configuration.client_side_validation and total_cpu_models is None:  # noqa: E501
            raise ValueError("Invalid value for `total_cpu_models`, must not be `None`")  # noqa: E501

        self._total_cpu_models = total_cpu_models

    @property
    def total_cpu_sockets(self):
        """Gets the total_cpu_sockets of this Cluster.  # noqa: E501


        :return: The total_cpu_sockets of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._total_cpu_sockets

    @total_cpu_sockets.setter
    def total_cpu_sockets(self, total_cpu_sockets):
        """Sets the total_cpu_sockets of this Cluster.


        :param total_cpu_sockets: The total_cpu_sockets of this Cluster.  # noqa: E501
        :type total_cpu_sockets: int
        """

        self._total_cpu_sockets = total_cpu_sockets

    @property
    def total_data_capacity(self):
        """Gets the total_data_capacity of this Cluster.  # noqa: E501


        :return: The total_data_capacity of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._total_data_capacity

    @total_data_capacity.setter
    def total_data_capacity(self, total_data_capacity):
        """Sets the total_data_capacity of this Cluster.


        :param total_data_capacity: The total_data_capacity of this Cluster.  # noqa: E501
        :type total_data_capacity: int
        """

        self._total_data_capacity = total_data_capacity

    @property
    def total_memory_bytes(self):
        """Gets the total_memory_bytes of this Cluster.  # noqa: E501


        :return: The total_memory_bytes of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._total_memory_bytes

    @total_memory_bytes.setter
    def total_memory_bytes(self, total_memory_bytes):
        """Sets the total_memory_bytes of this Cluster.


        :param total_memory_bytes: The total_memory_bytes of this Cluster.  # noqa: E501
        :type total_memory_bytes: int
        """

        self._total_memory_bytes = total_memory_bytes

    @property
    def type(self):
        """Gets the type of this Cluster.  # noqa: E501


        :return: The type of this Cluster.  # noqa: E501
        :rtype: ClusterType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Cluster.


        :param type: The type of this Cluster.  # noqa: E501
        :type type: ClusterType
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def upgrade_tool_version(self):
        """Gets the upgrade_tool_version of this Cluster.  # noqa: E501


        :return: The upgrade_tool_version of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._upgrade_tool_version

    @upgrade_tool_version.setter
    def upgrade_tool_version(self, upgrade_tool_version):
        """Sets the upgrade_tool_version of this Cluster.


        :param upgrade_tool_version: The upgrade_tool_version of this Cluster.  # noqa: E501
        :type upgrade_tool_version: str
        """

        self._upgrade_tool_version = upgrade_tool_version

    @property
    def used_cpu_hz(self):
        """Gets the used_cpu_hz of this Cluster.  # noqa: E501


        :return: The used_cpu_hz of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._used_cpu_hz

    @used_cpu_hz.setter
    def used_cpu_hz(self, used_cpu_hz):
        """Sets the used_cpu_hz of this Cluster.


        :param used_cpu_hz: The used_cpu_hz of this Cluster.  # noqa: E501
        :type used_cpu_hz: int
        """

        self._used_cpu_hz = used_cpu_hz

    @property
    def used_data_space(self):
        """Gets the used_data_space of this Cluster.  # noqa: E501


        :return: The used_data_space of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._used_data_space

    @used_data_space.setter
    def used_data_space(self, used_data_space):
        """Sets the used_data_space of this Cluster.


        :param used_data_space: The used_data_space of this Cluster.  # noqa: E501
        :type used_data_space: int
        """

        self._used_data_space = used_data_space

    @property
    def used_memory_bytes(self):
        """Gets the used_memory_bytes of this Cluster.  # noqa: E501


        :return: The used_memory_bytes of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._used_memory_bytes

    @used_memory_bytes.setter
    def used_memory_bytes(self, used_memory_bytes):
        """Sets the used_memory_bytes of this Cluster.


        :param used_memory_bytes: The used_memory_bytes of this Cluster.  # noqa: E501
        :type used_memory_bytes: int
        """

        self._used_memory_bytes = used_memory_bytes

    @property
    def valid_data_space(self):
        """Gets the valid_data_space of this Cluster.  # noqa: E501


        :return: The valid_data_space of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._valid_data_space

    @valid_data_space.setter
    def valid_data_space(self, valid_data_space):
        """Sets the valid_data_space of this Cluster.


        :param valid_data_space: The valid_data_space of this Cluster.  # noqa: E501
        :type valid_data_space: int
        """

        self._valid_data_space = valid_data_space

    @property
    def vcenter_account(self):
        """Gets the vcenter_account of this Cluster.  # noqa: E501


        :return: The vcenter_account of this Cluster.  # noqa: E501
        :rtype: NestedVcenterAccount
        """
        return self._vcenter_account

    @vcenter_account.setter
    def vcenter_account(self, vcenter_account):
        """Sets the vcenter_account of this Cluster.


        :param vcenter_account: The vcenter_account of this Cluster.  # noqa: E501
        :type vcenter_account: NestedVcenterAccount
        """

        self._vcenter_account = vcenter_account

    @property
    def vdses(self):
        """Gets the vdses of this Cluster.  # noqa: E501


        :return: The vdses of this Cluster.  # noqa: E501
        :rtype: list[NestedVds]
        """
        return self._vdses

    @vdses.setter
    def vdses(self, vdses):
        """Sets the vdses of this Cluster.


        :param vdses: The vdses of this Cluster.  # noqa: E501
        :type vdses: list[NestedVds]
        """

        self._vdses = vdses

    @property
    def version(self):
        """Gets the version of this Cluster.  # noqa: E501


        :return: The version of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Cluster.


        :param version: The version of this Cluster.  # noqa: E501
        :type version: str
        """
        if self.local_vars_configuration.client_side_validation and version is None:  # noqa: E501
            raise ValueError("Invalid value for `version`, must not be `None`")  # noqa: E501

        self._version = version

    @property
    def vhost_enabled(self):
        """Gets the vhost_enabled of this Cluster.  # noqa: E501


        :return: The vhost_enabled of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._vhost_enabled

    @vhost_enabled.setter
    def vhost_enabled(self, vhost_enabled):
        """Sets the vhost_enabled of this Cluster.


        :param vhost_enabled: The vhost_enabled of this Cluster.  # noqa: E501
        :type vhost_enabled: bool
        """

        self._vhost_enabled = vhost_enabled

    @property
    def vm_folders(self):
        """Gets the vm_folders of this Cluster.  # noqa: E501


        :return: The vm_folders of this Cluster.  # noqa: E501
        :rtype: list[NestedVmFolder]
        """
        return self._vm_folders

    @vm_folders.setter
    def vm_folders(self, vm_folders):
        """Sets the vm_folders of this Cluster.


        :param vm_folders: The vm_folders of this Cluster.  # noqa: E501
        :type vm_folders: list[NestedVmFolder]
        """

        self._vm_folders = vm_folders

    @property
    def vm_num(self):
        """Gets the vm_num of this Cluster.  # noqa: E501


        :return: The vm_num of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._vm_num

    @vm_num.setter
    def vm_num(self, vm_num):
        """Sets the vm_num of this Cluster.


        :param vm_num: The vm_num of this Cluster.  # noqa: E501
        :type vm_num: int
        """

        self._vm_num = vm_num

    @property
    def vm_templates(self):
        """Gets the vm_templates of this Cluster.  # noqa: E501


        :return: The vm_templates of this Cluster.  # noqa: E501
        :rtype: list[NestedVmTemplate]
        """
        return self._vm_templates

    @vm_templates.setter
    def vm_templates(self, vm_templates):
        """Sets the vm_templates of this Cluster.


        :param vm_templates: The vm_templates of this Cluster.  # noqa: E501
        :type vm_templates: list[NestedVmTemplate]
        """

        self._vm_templates = vm_templates

    @property
    def vms(self):
        """Gets the vms of this Cluster.  # noqa: E501


        :return: The vms of this Cluster.  # noqa: E501
        :rtype: list[NestedVm]
        """
        return self._vms

    @vms.setter
    def vms(self, vms):
        """Sets the vms of this Cluster.


        :param vms: The vms of this Cluster.  # noqa: E501
        :type vms: list[NestedVm]
        """

        self._vms = vms

    @property
    def witness(self):
        """Gets the witness of this Cluster.  # noqa: E501


        :return: The witness of this Cluster.  # noqa: E501
        :rtype: NestedWitness
        """
        return self._witness

    @witness.setter
    def witness(self, witness):
        """Sets the witness of this Cluster.


        :param witness: The witness of this Cluster.  # noqa: E501
        :type witness: NestedWitness
        """

        self._witness = witness

    @property
    def zones(self):
        """Gets the zones of this Cluster.  # noqa: E501


        :return: The zones of this Cluster.  # noqa: E501
        :rtype: list[NestedZone]
        """
        return self._zones

    @zones.setter
    def zones(self, zones):
        """Sets the zones of this Cluster.


        :param zones: The zones of this Cluster.  # noqa: E501
        :type zones: list[NestedZone]
        """

        self._zones = zones

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Cluster):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Cluster):
            return True

        return self.to_dict() != other.to_dict()
