# coding: utf-8

"""
    CloudTower APIs

    cloudtower operation API and SDK  # noqa: E501

    The version of the OpenAPI document: 1.10.0
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from cloudtower.configuration import Configuration


class CloudInitNetWorkRoute(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'network': 'str',
        'netmask': 'str',
        'gateway': 'str'
    }

    attribute_map = {
        'network': 'network',
        'netmask': 'netmask',
        'gateway': 'gateway'
    }

    def __init__(self, **kwargs):  # noqa: E501
        """CloudInitNetWorkRoute - a model defined in OpenAPI"""  # noqa: E501
        self.local_vars_configuration = kwargs.get("local_vars_configuration", Configuration.get_default_copy())

        self._network = None
        self._netmask = None
        self._gateway = None
        self.discriminator = None

        if "network" in kwargs:
            self.network = kwargs["network"]
        if "netmask" in kwargs:
            self.netmask = kwargs["netmask"]
        if "gateway" in kwargs:
            self.gateway = kwargs["gateway"]

    @property
    def network(self):
        """Gets the network of this CloudInitNetWorkRoute.  # noqa: E501


        :return: The network of this CloudInitNetWorkRoute.  # noqa: E501
        :rtype: str
        """
        return self._network

    @network.setter
    def network(self, network):
        """Sets the network of this CloudInitNetWorkRoute.


        :param network: The network of this CloudInitNetWorkRoute.  # noqa: E501
        :type network: str
        """
        if self.local_vars_configuration.client_side_validation and network is None:  # noqa: E501
            raise ValueError("Invalid value for `network`, must not be `None`")  # noqa: E501

        self._network = network

    @property
    def netmask(self):
        """Gets the netmask of this CloudInitNetWorkRoute.  # noqa: E501


        :return: The netmask of this CloudInitNetWorkRoute.  # noqa: E501
        :rtype: str
        """
        return self._netmask

    @netmask.setter
    def netmask(self, netmask):
        """Sets the netmask of this CloudInitNetWorkRoute.


        :param netmask: The netmask of this CloudInitNetWorkRoute.  # noqa: E501
        :type netmask: str
        """
        if self.local_vars_configuration.client_side_validation and netmask is None:  # noqa: E501
            raise ValueError("Invalid value for `netmask`, must not be `None`")  # noqa: E501

        self._netmask = netmask

    @property
    def gateway(self):
        """Gets the gateway of this CloudInitNetWorkRoute.  # noqa: E501


        :return: The gateway of this CloudInitNetWorkRoute.  # noqa: E501
        :rtype: str
        """
        return self._gateway

    @gateway.setter
    def gateway(self, gateway):
        """Sets the gateway of this CloudInitNetWorkRoute.


        :param gateway: The gateway of this CloudInitNetWorkRoute.  # noqa: E501
        :type gateway: str
        """
        if self.local_vars_configuration.client_side_validation and gateway is None:  # noqa: E501
            raise ValueError("Invalid value for `gateway`, must not be `None`")  # noqa: E501

        self._gateway = gateway

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CloudInitNetWorkRoute):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CloudInitNetWorkRoute):
            return True

        return self.to_dict() != other.to_dict()
