# -*- coding: utf-8 -*-
"""model_selection_old.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1uVkl7scNgEPrimX8ks6iEC5ijuhB8L_D

**This script demonstrates how to compute a graph kernel.**
---

**0.   Install `graphkit-learn`.**
"""

"""**1. Perform model seletion and classification.**"""

from gklearn.utils import model_selection_for_precomputed_kernel
from gklearn.kernels import untilhpathkernel
import numpy as np

# Set parameters.
datafile = '../../../datasets/MUTAG/MUTAG_A.txt'
param_grid_precomputed = {'depth': np.linspace(1, 10, 10),
                          'k_func': ['MinMax', 'tanimoto'],
                          'compute_method': ['trie']}
param_grid = {'C': np.logspace(-10, 10, num=41, base=10)}

# Perform model selection and classification.
model_selection_for_precomputed_kernel(
	datafile, # The path of dataset file.
	untilhpathkernel, # The graph kernel used for estimation.
	param_grid_precomputed, # The parameters used to compute gram matrices.
	param_grid, # The penelty Parameters used for penelty items.
	'classification', # Or 'regression'.
	NUM_TRIALS=30, # The number of the random trials of the outer CV loop.
	ds_name='MUTAG', # The name of the dataset.
	n_jobs=1,
	verbose=True)