# -*- coding: utf-8 -*-
"""compute_graph_edit_distance.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1Wfgn7WVuyOQQgwOvdUQBz0BzEVdp0YM3

**This script demonstrates how to compute a graph edit distance.**
---

**0.   Install `graphkit-learn`.**
"""

"""**1.   Get dataset.**"""

from gklearn.utils import Dataset

# Predefined dataset name, use dataset "MUTAG".
ds_name = 'MUTAG'

# Initialize a Dataset.
dataset = Dataset()
# Load predefined dataset "MUTAG".
dataset.load_predefined_dataset(ds_name)
graph1 = dataset.graphs[0]
graph2 = dataset.graphs[1]
print(graph1, graph2)

"""**2.  Compute graph edit distance.**"""

from gklearn.ged.env import GEDEnv


ged_env = GEDEnv() # initailize GED environment.
ged_env.set_edit_cost('CONSTANT', # GED cost type.
                      edit_cost_constants=[3, 3, 1, 3, 3, 1] # edit costs.
					  )  
ged_env.add_nx_graph(graph1, '') # add graph1
ged_env.add_nx_graph(graph2, '') # add graph2
listID = ged_env.get_all_graph_ids() # get list IDs of graphs
ged_env.init(init_type='LAZY_WITHOUT_SHUFFLED_COPIES') # initialize GED environment.
options = {'initialization_method': 'RANDOM', # or 'NODE', etc.
           'threads': 1 # parallel threads.
		   }
ged_env.set_method('BIPARTITE', # GED method.
                   options # options for GED method.
				   )
ged_env.init_method() # initialize GED method.

ged_env.run_method(listID[0], listID[1]) # run.

pi_forward = ged_env.get_forward_map(listID[0], listID[1]) # forward map.
pi_backward = ged_env.get_backward_map(listID[0], listID[1]) # backward map.
dis = ged_env.get_upper_bound(listID[0], listID[1])	# GED bewteen two graphs.
print(pi_forward)
print(pi_backward)
print(dis)