"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineStack = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const aws_cdk_lib_1 = require("aws-cdk-lib");
const pipeline_1 = require("aws-prototyping-sdk/pipeline");
class PipelineStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.pipeline = new pipeline_1.PDKPipeline(this, 'ApplicationPipeline', {
            primarySynthDirectory: 'packages/infra/cdk.out',
            repositoryName: this.node.tryGetContext('repositoryName') || 'monorepo',
            publishAssetsInParallel: false,
            crossAccountKeys: true,
            synth: {},
            sonarCodeScannerConfig: this.node.tryGetContext('sonarqubeScannerConfig'),
        });
    }
}
exports.PipelineStack = PipelineStack;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGlwZWxpbmUtc3RhY2suanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvcGlwZWxpbmUtc3RhY2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUE7c0NBQ3NDO0FBQ3RDLDZDQUFnRDtBQUNoRCwyREFBMkQ7QUFHM0QsTUFBYSxhQUFjLFNBQVEsbUJBQUs7SUFHdEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFpQjtRQUN6RCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUV4QixJQUFJLENBQUMsUUFBUSxHQUFHLElBQUksc0JBQVcsQ0FBQyxJQUFJLEVBQUUscUJBQXFCLEVBQUU7WUFDM0QscUJBQXFCLEVBQUUsd0JBQXdCO1lBQy9DLGNBQWMsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLFVBQVU7WUFDdkUsdUJBQXVCLEVBQUUsS0FBSztZQUM5QixnQkFBZ0IsRUFBRSxJQUFJO1lBQ3RCLEtBQUssRUFBRSxFQUFFO1lBQ1Qsc0JBQXNCLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsd0JBQXdCLENBQUM7U0FDMUUsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztDQUNGO0FBZkQsc0NBZUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiEgQ29weXJpZ2h0IFtBbWF6b24uY29tXShodHRwOi8vYW1hem9uLmNvbS8pLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjAgKi9cbmltcG9ydCB7IFN0YWNrLCBTdGFja1Byb3BzIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgUERLUGlwZWxpbmUgfSBmcm9tICdhd3MtcHJvdG90eXBpbmctc2RrL3BpcGVsaW5lJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5leHBvcnQgY2xhc3MgUGlwZWxpbmVTdGFjayBleHRlbmRzIFN0YWNrIHtcbiAgcmVhZG9ubHkgcGlwZWxpbmU6IFBES1BpcGVsaW5lO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBTdGFja1Byb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG5cbiAgICB0aGlzLnBpcGVsaW5lID0gbmV3IFBES1BpcGVsaW5lKHRoaXMsICdBcHBsaWNhdGlvblBpcGVsaW5lJywge1xuICAgICAgcHJpbWFyeVN5bnRoRGlyZWN0b3J5OiAncGFja2FnZXMvaW5mcmEvY2RrLm91dCcsXG4gICAgICByZXBvc2l0b3J5TmFtZTogdGhpcy5ub2RlLnRyeUdldENvbnRleHQoJ3JlcG9zaXRvcnlOYW1lJykgfHwgJ21vbm9yZXBvJyxcbiAgICAgIHB1Ymxpc2hBc3NldHNJblBhcmFsbGVsOiBmYWxzZSxcbiAgICAgIGNyb3NzQWNjb3VudEtleXM6IHRydWUsXG4gICAgICBzeW50aDoge30sXG4gICAgICBzb25hckNvZGVTY2FubmVyQ29uZmlnOiB0aGlzLm5vZGUudHJ5R2V0Q29udGV4dCgnc29uYXJxdWJlU2Nhbm5lckNvbmZpZycpLFxuICAgIH0pO1xuICB9XG59Il19