A class for encoding timeseries data in JSON into an embedded base 16, base 64 or base 91 encoding.

To use simply pass any json into TimeSeriesEncoder.encode_json(data, ts_key, ts_value) where ts_key and ts_value are the timestamp key and the value key in the json.

```
from timeseriesencoder import *
encoded = TimeSeriesEncoder.encode_json(myJson, ts_key='UTC', ts_value='Value')
```

To decode you can simply apply the reverse:
```
decoded = TimeSeriesEncoder.decode_json(encoded)
```

The encoder will encode all time series it finds in the json. Each will get their own encoding that is optimal for the data sparsity and values. Sorting the data before encoding can improve compression. If you'd like the encoder to sort for you, you can include sort_values = True on the encode_json call. This will sort each time series by the timeseries key before encoding. This allows smaller compression if the data is regular by avoiding directly encoding the timeoffsets, and instead only encodes the data.

To run tests call pytests on the tests folder from the base package folder.
```
pytest ./tests/
```

![image](https://user-images.githubusercontent.com/8877753/115096228-d00ccb00-9ee9-11eb-815a-8d837ffc66f3.png)


Example input/outputs
```
Input: {'Request': {'locations': ['WIT_BEBEZ_SS001_WT001'], 'attributes': None, 'aggregate': True, 'startDate': '2021-04-12T01:46:08.8622635Z'}, 'Response': [{'LocationName': 'WIT_BEBEZ_SS001_WT001', 'EntityType': 'WIND_TURBINE', 'DisplayName': 'BEZ_E01', 'Latitude': 50.82426, 'Longitude': 3.32744, 'Timezone': 'Europe/Brussels', 'PlanId': '14d14980-306a-40c8-a784-579022ec9d49', 'HistoricalPlanId': '0d0fb8b5-a00b-4546-925f-0a7e7b72503b', 'DataSource': 'ECMWF-IFS', 'AsOfDateUTC': '2021-04-08T00:00:00Z', 'ForecastWeather': [{'AttributeName': 'fresh_snow_6h:cm', 'AttributeUnitOfMeasure': 'cm', 'AttributeDescription': 'fresh snow of previous 6h [cm]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 0.0}]}, {'AttributeName': 'precip_1h:mm', 'AttributeUnitOfMeasure': 'mm', 'AttributeDescription': 'amount of precipitation in the previous 1h [mm]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 0.2}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 0.2}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 0.2}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 0.2}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 0.2}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 0.2}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 0.08}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 0.08}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 0.08}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 0.08}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 0.08}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 0.08}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 0.29}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 0.29}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 0.29}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 0.29}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 0.29}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 0.29}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 0.08}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 0.08}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 0.08}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 0.08}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 0.08}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 0.08}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 0.0}]}, {'AttributeName': 'relative_humidity_100m:p', 'AttributeUnitOfMeasure': '%', 'AttributeDescription': 'relative humidity at 100m [%]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 75.0}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 73.4}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 72.3}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 54.2}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 59.7}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 65.0}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 70.2}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 70.1}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 70.0}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 70.0}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 63.2}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 56.5}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 50.0}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 50.3}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 50.6}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 50.9}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 54.3}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 57.9}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 61.6}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 61.9}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 62.3}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 62.6}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 61.0}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 59.4}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 57.7}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 71.1}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 70.0}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 65.0}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 60.2}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 55.6}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 52.0}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 48.5}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 45.0}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 42.3}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 39.5}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 36.8}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 40.9}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 45.2}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 49.6}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 51.2}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 52.9}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 54.6}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 52.7}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 50.7}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 48.6}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 50.4}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 52.3}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 57.2}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 56.8}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 56.3}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 55.9}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 55.4}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 55.0}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 53.2}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 51.5}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 49.8}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 48.2}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 46.7}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 45.2}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 45.7}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 46.3}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 46.8}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 47.4}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 48.0}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 48.6}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 49.9}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 51.3}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 52.6}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 54.0}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 55.4}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 56.8}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 56.7}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 56.7}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 56.7}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 56.7}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 56.7}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 56.6}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 55.5}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 54.4}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 53.2}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 52.1}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 51.0}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 49.9}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 51.4}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 53.0}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 54.5}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 56.0}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 57.6}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 59.2}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 62.2}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 65.3}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 68.4}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 71.5}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 74.6}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 77.8}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 78.4}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 79.0}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 79.6}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 80.2}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 80.8}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 81.3}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 77.2}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 73.2}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 69.2}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 65.4}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 61.6}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 57.9}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 59.3}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 60.8}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 62.3}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 63.7}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 65.2}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 66.7}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 71.0}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 75.3}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 79.7}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 84.1}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 88.5}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 92.9}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 93.8}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 94.7}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 95.5}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 96.4}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 97.2}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 98.0}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 95.1}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 92.2}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 89.3}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 86.4}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 83.6}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 80.7}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 77.9}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 75.2}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 72.4}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 69.6}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 66.9}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 64.1}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 65.3}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 66.6}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 67.8}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 69.0}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 70.2}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 71.4}]}, {'AttributeName': 'relative_humidity_50m:p', 'AttributeUnitOfMeasure': '%', 'AttributeDescription': 'relative humidity at 50m [%]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 78.1}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 76.6}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 75.7}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 62.5}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 66.1}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 69.5}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 72.5}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 71.0}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 69.6}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 68.3}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 61.9}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 55.7}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 49.8}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 50.0}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 50.3}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 50.5}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 55.0}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 59.9}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 65.1}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 66.1}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 67.1}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 68.1}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 67.5}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 66.9}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 66.2}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 74.7}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 73.8}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 66.9}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 60.6}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 54.9}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 51.5}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 48.3}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 45.1}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 42.6}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 40.1}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 37.7}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 42.1}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 46.8}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 51.9}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 54.5}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 57.3}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 60.2}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 59.6}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 58.8}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 57.8}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 59.3}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 60.9}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 65.4}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 64.7}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 63.9}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 63.1}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 62.4}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 61.6}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 58.5}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 55.5}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 52.8}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 50.1}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 47.7}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 45.3}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 46.1}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 46.9}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 47.7}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 48.6}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 49.4}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 50.3}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 51.6}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 52.9}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 54.2}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 55.5}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 56.8}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 58.2}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 58.1}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 58.0}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 57.8}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 57.7}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 57.6}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 57.4}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 56.2}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 54.9}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 53.7}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 52.5}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 51.3}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 50.2}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 52.0}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 53.8}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 55.6}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 57.5}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 59.4}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 61.3}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 64.3}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 67.3}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 70.4}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 73.5}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 76.7}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 80.0}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 80.4}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 80.8}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 81.1}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 81.5}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 81.8}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 82.2}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 77.8}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 73.5}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 69.4}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 65.4}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 61.5}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 57.8}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 59.5}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 61.2}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 62.9}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 64.7}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 66.6}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 68.4}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 72.4}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 76.4}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 80.4}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 84.6}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 88.8}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 93.1}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 93.9}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 94.8}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 95.6}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 96.5}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 97.3}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 98.1}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 95.4}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 92.8}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 90.2}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 87.7}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 85.1}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 82.6}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 79.6}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 76.6}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 73.6}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 70.7}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 67.9}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 65.0}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 66.1}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 67.2}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 68.3}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 69.4}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 70.5}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 71.6}]}, {'AttributeName': 't_100m:C', 'AttributeUnitOfMeasure': '°C', 'AttributeDescription': 'temperature at 100m [C]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 8.4}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 9.4}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 9.6}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 9.7}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 9.9}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 9.6}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 9.2}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 8.9}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 8.7}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 8.4}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 8.7}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 9.4}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 10.1}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 10.2}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 10.3}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 10.4}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 10.5}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 10.6}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 10.7}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 10.0}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 9.3}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 8.6}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 7.1}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 7.3}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 8.6}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 10.0}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 11.3}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 12.7}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 13.0}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 13.3}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 13.6}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 14.0}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 14.3}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 14.6}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 14.0}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 13.4}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 12.8}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 12.3}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 11.7}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 11.1}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 11.0}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 11.0}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 10.9}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 10.9}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 10.8}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 10.7}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 11.9}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 13.1}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 14.3}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 15.5}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 16.7}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 17.9}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 18.0}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 18.0}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 18.1}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 18.2}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 18.2}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 18.3}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 17.5}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 16.8}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 16.0}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 15.2}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 14.5}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 13.7}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 13.4}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 13.1}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 12.8}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 12.5}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 12.3}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 12.0}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 12.2}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 12.4}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 12.6}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 12.9}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 13.1}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 13.3}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 13.0}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 12.7}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 12.4}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 12.0}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 11.7}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 11.4}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 11.3}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 11.1}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 11.0}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 10.9}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 10.8}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 10.7}]}, {'AttributeName': 'wind_dir_100m:d', 'AttributeUnitOfMeasure': '°', 'AttributeDescription': 'wind direction at 100m', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 9.5}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 222.8}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 217.7}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 213.4}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 209.7}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 212.1}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 215.4}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 220.3}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 227.7}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 238.1}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 252.1}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 248.6}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 244.8}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 240.8}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 283.3}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 21.0}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 70.5}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 108.4}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 123.7}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 134.8}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 145.9}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 156.1}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 11.8}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 14.9}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 9.0}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 355.9}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 359.6}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 7.6}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 1.3}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 10.2}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 20.4}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 349.7}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 315.2}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 293.5}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 263.5}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 238.3}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 157.7}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 159.1}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 160.5}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 161.7}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 162.8}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 163.9}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 160.2}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 156.3}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 152.2}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 148.1}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 143.9}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 139.7}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 136.0}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 132.7}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 129.7}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 126.9}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 124.5}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 122.3}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 127.3}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 132.1}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 136.5}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 140.6}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 144.3}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 147.7}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 146.9}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 146.0}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 145.2}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 144.3}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 143.4}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 142.5}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 145.9}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 149.6}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 153.7}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 158.1}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 163.0}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 168.2}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 169.4}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 170.7}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 172.1}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 173.6}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 175.2}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 176.9}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 175.3}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 173.8}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 172.6}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 171.5}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 170.5}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 169.6}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 168.5}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 167.3}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 166.1}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 164.9}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 163.6}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 162.3}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 163.9}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 165.7}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 167.8}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 170.3}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 173.1}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 176.4}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 172.4}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 168.5}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 164.8}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 161.4}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 158.2}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 155.2}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 163.3}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 171.1}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 178.4}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 185.1}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 191.0}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 196.1}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 195.3}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 194.4}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 193.4}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 192.4}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 191.3}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 190.1}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 196.5}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 204.9}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 215.9}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 229.6}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 245.0}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 260.1}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 259.7}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 259.4}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 259.0}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 258.7}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 258.4}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 258.2}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 248.9}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 241.5}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 235.6}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 230.9}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 227.1}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 224.0}]}, {'AttributeName': 'wind_dir_120m:d', 'AttributeUnitOfMeasure': '°', 'AttributeDescription': 'wind direction at 120m', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 10.5}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 225.4}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 220.2}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 215.7}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 211.9}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 213.8}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 216.5}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 220.6}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 228.0}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 238.3}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 252.4}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 248.9}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 245.1}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 241.1}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 281.4}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 0.2}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 20.5}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 73.5}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 111.2}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 125.7}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 136.5}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 147.2}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 157.0}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 9.0}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 12.2}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 15.0}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 9.1}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 356.0}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 359.7}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 1.5}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 10.5}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 21.4}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 348.8}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 314.4}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 293.4}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 264.8}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 240.7}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 158.5}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 159.9}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 161.1}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 162.3}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 163.4}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 164.4}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 160.7}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 156.8}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 152.7}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 148.5}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 144.1}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 139.7}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 136.0}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 132.7}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 129.7}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 127.1}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 124.7}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 122.5}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 127.6}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 132.4}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 136.9}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 141.0}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 144.8}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 148.2}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 147.4}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 146.6}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 145.8}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 145.0}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 144.1}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 143.3}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 146.5}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 150.0}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 153.9}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 158.3}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 163.0}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 168.2}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 169.4}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 171.0}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 172.5}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 174.1}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 175.7}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 177.5}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 175.9}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 174.6}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 173.3}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 172.3}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 171.3}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 170.5}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 169.3}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 168.2}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 167.0}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 165.8}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 164.5}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 163.2}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 164.7}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 166.4}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 168.3}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 170.6}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 173.3}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 176.4}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 172.5}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 168.8}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 165.2}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 161.9}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 158.8}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 155.9}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 164.0}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 171.8}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 179.1}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 185.7}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 191.6}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 196.7}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 195.9}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 195.0}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 194.1}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 193.1}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 192.1}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 191.0}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 197.5}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 205.9}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 216.7}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 230.1}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 245.2}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 260.0}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 259.7}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 259.4}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 259.1}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 258.8}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 258.5}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 258.3}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 249.1}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 241.8}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 235.9}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 231.2}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 227.3}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 224.2}]}, {'AttributeName': 'wind_dir_80m:d', 'AttributeUnitOfMeasure': '°', 'AttributeDescription': 'wind direction at 80m', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 1.6}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 217.0}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 212.6}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 209.0}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 205.9}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 209.4}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 213.9}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 219.7}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 227.4}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 237.9}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 252.0}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 248.6}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 244.9}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 240.9}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 280.4}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 21.7}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 68.2}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 105.4}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 121.5}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 132.4}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 143.4}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 153.9}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 0.2}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 358.6}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 10.8}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 14.8}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 8.9}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 2.5}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 355.8}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 359.6}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 5.7}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 0.9}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 10.9}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 20.8}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 349.1}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 310.9}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 288.6}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 259.8}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 233.9}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 155.7}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 157.2}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 158.7}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 160.0}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 161.2}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 162.4}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 158.6}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 154.8}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 150.9}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 147.1}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 143.4}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 139.6}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 136.1}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 132.8}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 129.7}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 126.8}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 124.2}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 121.6}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 126.7}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 131.4}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 135.8}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 139.8}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 143.5}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 146.9}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 146.0}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 145.1}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 144.2}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 143.3}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 142.5}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 141.6}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 145.3}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 149.3}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 153.5}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 158.1}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 163.0}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 168.1}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 169.0}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 170.0}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 171.0}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 172.1}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 173.3}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 174.5}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 173.0}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 171.8}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 170.6}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 169.6}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 168.7}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 168.0}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 166.8}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 165.6}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 164.4}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 163.1}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 161.8}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 160.5}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 162.5}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 164.7}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 167.1}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 169.8}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 172.9}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 176.3}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 172.3}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 168.3}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 164.4}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 160.5}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 156.7}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 152.9}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 161.4}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 169.5}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 177.0}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 183.6}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 189.5}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 194.6}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 193.7}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 192.8}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 191.9}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 190.8}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 189.7}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 188.5}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 195.4}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 204.5}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 216.0}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 230.0}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 245.2}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 259.8}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 259.3}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 258.8}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 258.3}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 257.9}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 257.5}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 257.1}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 247.8}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 240.4}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 234.6}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 230.0}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 226.3}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 223.3}]}, {'AttributeName': 'wind_gusts_100m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': 'wind gusts at 100m [m/s]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 8.7}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 2.5}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 5.7}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 5.7}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 5.7}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 8.0}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 8.6}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 9.2}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 9.9}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 10.8}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 11.8}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 12.8}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 13.8}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 14.8}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 15.8}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 15.5}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 15.2}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 14.9}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 14.6}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 14.3}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 14.0}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 13.0}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 11.9}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 10.9}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 9.8}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 9.2}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 8.6}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 8.5}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 8.4}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 8.3}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 8.0}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 8.4}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 8.8}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 9.3}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 9.2}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 9.0}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 8.9}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 8.8}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 8.6}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 8.5}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 8.0}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 8.0}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 8.0}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 8.0}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 8.4}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 8.7}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 9.2}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 9.6}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 10.1}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 10.6}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 9.6}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 8.6}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 5.7}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 8.4}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 9.1}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 10.2}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 10.9}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 11.5}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 12.2}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 12.8}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 13.5}]}, {'AttributeName': 'wind_gusts_80m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': 'wind gusts at 80m [m/s]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 8.5}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 2.5}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 2.5}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 2.5}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 7.3}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 8.5}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 9.1}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 9.7}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 10.7}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 11.6}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 12.6}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 13.6}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 14.6}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 15.6}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 15.3}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 15.0}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 14.7}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 14.4}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 14.1}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 13.8}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 12.8}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 11.8}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 10.8}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 9.8}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 9.2}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 8.7}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 8.5}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 8.4}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 8.3}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 8.5}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 8.4}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 8.3}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 8.0}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 8.0}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 8.5}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 9.0}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 9.5}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 10.0}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 10.4}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 9.5}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 8.5}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 7.5}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 7.5}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 8.9}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 9.9}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 10.7}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 11.4}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 12.0}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 12.6}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 13.3}]}, {'AttributeName': 'wind_speed_100m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': 'wind speed at 100m [m/s]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 2.0}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 1.6}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 1.6}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 1.5}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 1.9}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 2.1}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 1.9}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 2.1}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 7.5}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 8.4}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 8.3}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 8.3}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 8.3}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 7.5}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 5.7}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 7.3}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 7.1}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 5.7}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 7.5}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 8.2}]}, {'AttributeName': 'wind_speed_120m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': 'wind speed at 120m [m/s]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 2.0}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 1.6}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 1.6}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 1.5}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 1.8}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 2.0}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 2.6}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 1.9}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 2.1}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 7.5}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 8.4}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 8.8}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 8.7}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 8.7}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 8.7}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 8.6}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 8.6}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 8.5}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 7.5}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 7.1}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 7.3}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 7.1}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 5.7}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 8.3}]}, {'AttributeName': 'wind_speed_80m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': 'wind speed at 80m [m/s]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 2.1}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 1.8}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 1.6}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 1.6}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 1.9}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 2.0}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 2.6}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 2.6}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 2.0}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 2.1}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 3.0}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 7.3}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 7.6}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 7.5}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 7.3}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 7.1}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 5.7}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 5.7}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 7.8}]}, {'AttributeName': 'direct_rad:W', 'AttributeUnitOfMeasure': ' W/m²', 'AttributeDescription': 'direct radiation [W]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 46.7}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 161.4}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 289.8}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 383.9}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 449.8}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 438.9}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 347.2}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 234.5}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 164.8}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 132.7}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 92.3}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 42.9}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 45.6}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 136.2}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 212.7}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 240.8}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 231.2}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 209.6}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 188.2}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 154.5}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 159.5}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 182.5}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 163.9}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 90.5}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 17.1}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 55.1}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 171.6}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 313.0}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 459.3}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 549.3}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 603.1}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 616.3}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 587.8}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 520.0}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 418.1}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 267.1}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 127.8}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 25.8}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 40.6}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 122.9}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 222.5}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 325.5}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 401.9}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 455.5}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 480.2}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 472.4}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 430.8}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 357.1}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 219.6}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 100.6}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 19.8}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 8.9}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 29.1}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 56.6}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 87.8}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 114.6}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 136.6}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 150.6}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 154.4}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 146.2}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 125.5}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 83.5}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 42.3}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 9.7}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 10.4}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 30.3}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 54.5}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 79.8}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 94.9}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 104.0}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 106.2}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 101.4}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 89.9}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 72.7}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 61.5}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 38.9}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 11.2}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 0.0}]}, {'AttributeName': 'global_rad:W', 'AttributeUnitOfMeasure': ' W/m²', 'AttributeDescription': 'global radiation [W]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 87.1}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 247.4}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 404.6}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 530.6}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 615.0}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 626.6}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 563.2}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 463.5}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 378.8}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 306.6}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 214.4}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 117.8}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 27.8}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 86.9}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 234.1}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 359.8}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 449.6}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 492.4}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 502.8}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 488.2}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 440.9}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 413.3}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 386.9}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 305.8}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 180.3}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 42.4}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 101.0}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 274.9}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 442.3}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 575.9}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 688.1}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 754.6}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 770.3}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 734.1}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 648.7}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 521.1}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 376.1}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 204.6}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 47.4}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 87.3}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 228.0}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 358.8}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 458.8}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 560.6}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 629.1}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 657.1}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 640.7}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 579.4}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 476.5}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 335.1}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 178.9}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 42.0}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 0.7}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 58.5}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 147.4}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 227.7}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 286.9}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 357.3}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 408.4}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 434.3}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 430.8}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 396.2}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 331.4}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 244.3}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 137.2}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 34.8}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 2.0}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 65.9}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 160.7}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 244.9}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 305.5}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 349.3}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 367.1}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 359.0}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 327.7}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 277.3}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 213.4}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 182.1}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 115.7}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 33.4}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 0.0}]}, {'AttributeName': 'relative_humidity_2m:p', 'AttributeUnitOfMeasure': '%', 'AttributeDescription': 'relative humidity at 2m [%]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 85.5}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 84.1}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 83.6}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 87.0}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 83.7}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 80.4}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 77.5}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 72.9}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 68.7}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 64.8}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 59.2}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 54.0}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 49.4}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 49.5}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 49.6}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 49.8}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 56.6}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 64.3}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 73.1}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 75.8}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 78.7}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 81.6}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 84.0}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 86.5}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 89.0}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 83.1}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 82.6}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 71.3}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 61.6}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 53.4}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 50.5}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 47.7}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 45.1}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 43.2}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 41.3}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 39.5}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 44.6}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 50.4}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 57.0}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 62.3}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 68.2}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 74.6}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 77.7}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 81.0}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 84.4}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 85.3}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 86.1}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 87.3}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 85.6}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 83.9}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 82.3}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 80.6}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 79.0}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 71.8}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 65.3}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 59.5}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 54.3}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 49.7}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 45.4}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 46.8}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 48.2}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 49.6}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 51.1}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 52.6}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 54.2}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 55.3}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 56.5}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 57.7}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 58.9}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 60.2}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 61.5}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 61.1}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 60.7}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 60.3}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 60.0}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 59.6}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 59.2}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 57.6}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 56.1}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 54.6}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 53.3}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 51.9}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 50.7}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 53.0}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 55.5}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 58.0}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 60.7}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 63.4}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 66.3}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 69.1}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 72.0}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 75.1}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 78.3}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 81.6}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 85.2}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 84.9}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 84.6}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 84.4}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 84.1}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 83.9}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 83.6}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 78.6}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 73.9}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 69.6}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 65.6}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 61.9}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 58.4}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 60.6}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 62.9}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 65.3}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 67.8}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 70.4}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 73.0}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 76.1}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 79.4}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 82.8}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 86.3}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 90.0}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 93.9}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 94.5}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 95.1}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 95.7}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 96.4}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 97.0}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 97.6}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 95.5}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 93.4}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 91.4}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 89.4}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 87.5}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 85.7}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 82.4}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 79.1}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 76.0}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 73.0}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 70.1}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 67.2}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 68.1}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 68.9}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 69.7}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 70.6}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 71.4}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 72.3}]}, {'AttributeName': 'wind_dir_10m:d', 'AttributeUnitOfMeasure': '°', 'AttributeDescription': 'wind direction at 10m', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 357.7}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 352.7}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 348.5}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 196.8}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 195.0}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 193.5}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 192.2}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 199.9}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 208.5}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 217.8}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 226.1}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 237.2}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 251.7}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 248.6}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 245.2}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 241.4}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 270.4}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 359.8}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 24.3}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 60.2}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 94.9}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 113.8}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 123.9}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 134.9}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 146.1}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 344.1}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 339.3}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 356.6}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 14.4}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 8.5}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 2.1}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 355.4}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 359.6}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 8.8}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 359.3}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 13.1}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 22.2}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 346.8}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 296.0}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 271.4}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 247.2}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 218.7}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 148.5}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 150.7}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 152.5}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 154.2}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 155.6}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 156.9}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 152.9}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 149.4}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 146.4}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 143.7}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 141.4}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 139.3}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 136.3}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 133.2}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 129.9}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 126.5}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 123.0}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 119.5}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 124.4}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 129.0}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 133.2}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 137.1}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 140.6}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 143.8}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 142.8}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 141.9}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 141.0}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 140.0}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 139.1}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 138.2}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 143.1}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 148.1}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 153.2}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 158.2}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 163.0}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 167.7}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 167.6}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 167.4}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 167.2}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 166.9}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 166.6}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 166.1}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 165.2}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 164.5}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 163.8}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 163.2}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 162.7}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 162.3}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 160.9}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 159.5}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 158.2}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 156.8}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 155.4}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 154.1}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 157.4}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 160.9}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 164.6}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 168.3}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 172.1}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 176.0}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 172.1}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 167.8}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 162.8}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 157.4}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 151.4}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 144.9}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 154.8}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 163.8}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 171.8}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 178.6}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 184.3}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 189.1}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 188.3}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 187.4}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 186.4}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 185.4}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 184.3}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 183.2}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 191.8}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 202.8}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 216.3}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 231.3}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 245.9}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 258.6}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 257.7}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 256.8}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 256.0}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 255.1}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 254.2}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 253.3}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 243.7}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 236.4}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 230.9}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 226.7}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 223.3}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 220.7}]}, {'AttributeName': 't_2m:F', 'AttributeUnitOfMeasure': '°F', 'AttributeDescription': 'temperature at 2m [F]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 34.5}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 34.6}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 34.7}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 28.9}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 30.4}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 31.9}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 33.5}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 37.9}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 42.2}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 46.6}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 48.5}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 50.3}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 52.1}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 52.2}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 52.3}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 52.4}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 50.8}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 49.3}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 47.7}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 46.0}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 44.2}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 42.4}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 41.0}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 39.6}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 38.2}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 34.7}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 34.8}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 37.6}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 40.5}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 43.4}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 44.2}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 45.1}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 46.0}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 46.1}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 46.2}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 46.2}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 44.5}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 42.9}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 41.2}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 39.1}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 36.9}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 34.8}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 33.3}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 31.7}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 30.2}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 29.7}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 29.3}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 38.0}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 37.7}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 37.4}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 37.2}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 36.9}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 36.6}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 39.5}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 42.4}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 45.2}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 48.1}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 50.9}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 53.8}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 53.3}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 52.8}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 52.3}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 51.8}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 51.3}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 50.8}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 49.4}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 48.1}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 46.7}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 45.3}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 44.0}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 42.6}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 42.4}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 42.1}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 41.9}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 41.6}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 41.3}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 41.1}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 43.9}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 46.7}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 49.6}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 52.4}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 55.2}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 58.0}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 58.0}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 57.9}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 57.9}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 57.8}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 57.8}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 57.7}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 56.5}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 55.2}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 54.0}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 52.7}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 51.5}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 50.3}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 50.5}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 50.7}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 50.9}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 51.1}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 51.4}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 51.6}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 54.1}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 56.6}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 59.1}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 61.6}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 64.0}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 66.5}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 66.2}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 65.8}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 65.4}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 65.1}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 64.7}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 64.3}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 63.1}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 61.9}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 60.7}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 59.5}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 58.3}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 57.1}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 56.6}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 56.1}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 55.6}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 55.0}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 54.5}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 54.0}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 54.6}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 55.2}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 55.8}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 56.4}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 57.0}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 57.5}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 56.9}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 56.2}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 55.6}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 54.9}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 54.2}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 53.6}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 53.3}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 53.0}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 52.7}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 52.4}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 52.1}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 51.8}]}, {'AttributeName': 'prob_rr_3h:p', 'AttributeUnitOfMeasure': 'mm', 'AttributeDescription': 'probability of amount of precipitation in the previous 3h [mm]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 14.3}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 20.4}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 20.8}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 21.2}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 21.6}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 17.9}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 13.6}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 8.8}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 13.0}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 19.6}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 26.7}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 29.3}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 31.9}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 34.3}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 28.2}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 20.5}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 10.6}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 9.8}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 9.0}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 1.0}]}, {'AttributeName': 'dew_point_2m:C', 'AttributeUnitOfMeasure': '°C', 'AttributeDescription': '[MET] dew point temperature at 2m height [C]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': -0.8}, {'UTC': '2021-04-12T03:00:00Z', 'Value': -0.9}, {'UTC': '2021-04-12T04:00:00Z', 'Value': -1.0}, {'UTC': '2021-04-12T05:00:00Z', 'Value': -1.0}, {'UTC': '2021-04-13T03:00:00Z', 'Value': -3.6}, {'UTC': '2021-04-13T04:00:00Z', 'Value': -3.3}, {'UTC': '2021-04-13T05:00:00Z', 'Value': -3.0}, {'UTC': '2021-04-13T06:00:00Z', 'Value': -2.7}, {'UTC': '2021-04-13T07:00:00Z', 'Value': -1.1}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 0.4}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 1.9}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 1.6}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 1.3}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 1.1}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 1.1}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 1.2}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 2.5}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 1.8}, {'UTC': '2021-04-12T06:00:00Z', 'Value': -1.1}, {'UTC': '2021-04-12T07:00:00Z', 'Value': -1.5}, {'UTC': '2021-04-12T08:00:00Z', 'Value': -2.0}, {'UTC': '2021-04-12T09:00:00Z', 'Value': -2.5}, {'UTC': '2021-04-12T10:00:00Z', 'Value': -2.8}, {'UTC': '2021-04-12T11:00:00Z', 'Value': -3.1}, {'UTC': '2021-04-12T12:00:00Z', 'Value': -3.4}, {'UTC': '2021-04-12T13:00:00Z', 'Value': -3.9}, {'UTC': '2021-04-12T14:00:00Z', 'Value': -4.5}, {'UTC': '2021-04-12T15:00:00Z', 'Value': -5.0}, {'UTC': '2021-04-12T16:00:00Z', 'Value': -4.3}, {'UTC': '2021-04-12T17:00:00Z', 'Value': -3.5}, {'UTC': '2021-04-12T18:00:00Z', 'Value': -2.7}, {'UTC': '2021-04-12T19:00:00Z', 'Value': -2.6}, {'UTC': '2021-04-12T20:00:00Z', 'Value': -2.5}, {'UTC': '2021-04-12T21:00:00Z', 'Value': -2.5}, {'UTC': '2021-04-12T22:00:00Z', 'Value': -2.7}, {'UTC': '2021-04-12T23:00:00Z', 'Value': -3.0}, {'UTC': '2021-04-13T00:00:00Z', 'Value': -3.3}, {'UTC': '2021-04-13T01:00:00Z', 'Value': -3.4}, {'UTC': '2021-04-13T02:00:00Z', 'Value': -3.5}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 1.4}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 0.6}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 0.1}, {'UTC': '2021-04-14T05:00:00Z', 'Value': -0.3}, {'UTC': '2021-04-14T06:00:00Z', 'Value': -0.7}, {'UTC': '2021-04-14T07:00:00Z', 'Value': -0.5}, {'UTC': '2021-04-14T08:00:00Z', 'Value': -0.2}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 0.2}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 0.4}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 0.7}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 0.8}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 1.1}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 1.3}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 1.4}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 1.6}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 1.2}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 0.7}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 0.3}, {'UTC': '2021-04-14T22:00:00Z', 'Value': -0.1}, {'UTC': '2021-04-14T23:00:00Z', 'Value': -0.5}, {'UTC': '2021-04-15T00:00:00Z', 'Value': -0.9}, {'UTC': '2021-04-15T01:00:00Z', 'Value': -1.1}, {'UTC': '2021-04-15T02:00:00Z', 'Value': -1.4}, {'UTC': '2021-04-15T03:00:00Z', 'Value': -1.6}, {'UTC': '2021-04-15T04:00:00Z', 'Value': -1.8}, {'UTC': '2021-04-15T05:00:00Z', 'Value': -2.0}, {'UTC': '2021-04-15T06:00:00Z', 'Value': -2.3}, {'UTC': '2021-04-15T07:00:00Z', 'Value': -1.1}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 1.1}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 7.5}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 8.0}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 8.0}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 8.0}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 8.7}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 9.1}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 9.5}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 10.0}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 10.4}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 10.8}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 11.2}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 11.6}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 12.0}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 12.3}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 12.7}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 13.1}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 13.1}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 13.0}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 13.0}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 13.0}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 13.0}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 13.0}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 12.8}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 12.6}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 12.4}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 12.2}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 12.0}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 11.9}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 11.9}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 11.9}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 11.9}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 11.8}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 11.8}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 11.8}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 10.9}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 9.9}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 9.0}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 8.0}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 7.1}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 6.2}]}, {'AttributeName': 'diffuse_rad:W', 'AttributeUnitOfMeasure': ' W/m²', 'AttributeDescription': '[MET] diffuse radiation [W]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 40.4}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 86.0}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 114.8}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 146.7}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 165.2}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 187.6}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 216.0}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 229.0}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 214.0}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 173.9}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 122.1}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 74.8}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 20.8}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 41.3}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 97.9}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 147.2}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 208.8}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 261.2}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 293.2}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 300.1}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 286.4}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 253.8}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 204.4}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 141.9}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 89.8}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 25.2}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 45.9}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 103.4}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 129.3}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 116.6}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 138.7}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 151.5}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 154.1}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 146.2}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 128.7}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 102.9}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 109.0}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 76.8}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 21.6}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 46.7}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 105.0}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 136.2}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 133.3}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 158.7}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 173.6}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 176.9}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 168.3}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 148.6}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 119.4}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 115.5}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 78.3}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 22.2}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 0.7}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 49.6}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 118.3}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 171.1}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 199.1}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 242.7}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 271.9}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 283.7}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 276.5}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 250.0}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 205.8}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 160.8}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 94.9}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 25.1}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 2.0}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 55.4}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 130.4}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 190.4}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 225.7}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 254.4}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 263.1}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 252.8}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 226.3}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 187.3}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 140.7}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 120.5}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 76.8}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 22.2}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 0.0}]}, {'AttributeName': 'effective_cloud_cover:p', 'AttributeUnitOfMeasure': '%', 'AttributeDescription': '[MET] effective cloud cover [%]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 47.1}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 48.7}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 48.7}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 48.7}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 54.5}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 53.9}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 54.9}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 57.4}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 44.9}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 32.0}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 18.8}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 53.0}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 77.9}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 93.5}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 95.4}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 96.9}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 98.0}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 97.9}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 97.8}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 97.9}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 91.5}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 81.6}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 68.3}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 75.3}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 83.8}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 93.7}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 48.7}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 68.1}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 83.0}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 93.3}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 87.5}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 81.4}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 74.9}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 64.6}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 52.6}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 38.8}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 27.1}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 14.3}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 0.5}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 0.4}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 0.2}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 0.1}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 0.1}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 20.6}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 38.7}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 86.3}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 78.0}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 68.8}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 58.6}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 47.6}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 35.5}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 33.4}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 31.2}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 29.0}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 26.7}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 24.4}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 22.1}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 19.1}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 16.0}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 13.0}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 9.9}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 10.8}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 17.7}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 24.7}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 31.6}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 38.6}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 45.5}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 55.2}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 64.6}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 73.8}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 82.7}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 91.4}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 99.8}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 91.9}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 81.7}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 69.3}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 54.6}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 37.6}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 18.5}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 30.6}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 42.8}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 55.1}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 67.3}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 79.4}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 91.3}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 81.2}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 72.8}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 65.9}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 60.5}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 56.6}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 54.1}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 61.7}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 69.2}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 76.8}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 84.4}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 92.0}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 99.6}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 99.3}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 99.0}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 98.7}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 98.4}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 98.1}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 97.8}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 92.0}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 86.8}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 82.2}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 78.3}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 75.0}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 72.4}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 73.4}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 74.6}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 76.0}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 77.7}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 79.5}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 81.6}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 76.3}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 71.1}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 66.0}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 61.2}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 56.6}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 52.3}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 60.9}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 69.2}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 77.2}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 85.0}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 92.6}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 99.9}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 94.1}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 87.3}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 79.9}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 72.2}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 64.5}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 57.1}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 65.0}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 72.1}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 78.4}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 83.9}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 88.7}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 92.6}]}, {'AttributeName': 'snow_depth:cm', 'AttributeUnitOfMeasure': 'cm', 'AttributeDescription': '[MET] snow depth  [cm]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 0.0}]}, {'AttributeName': 'sfc_pressure:hPa', 'AttributeUnitOfMeasure': 'hPa', 'AttributeDescription': '[MET] surface preasure [hPa]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 1023.1}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 1023.4}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 1024.0}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 1028.8}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 1029.0}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 1029.2}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 1029.4}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 1029.5}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 1029.5}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 1029.5}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 1029.2}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 1028.9}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 1028.5}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 1028.2}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 1027.8}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 1027.5}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 1027.4}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 1027.3}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 1027.2}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 1027.4}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 1027.6}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 1027.8}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 1027.6}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 1027.3}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 1027.1}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 1024.6}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 1025.1}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 1025.6}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 1026.0}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 1026.5}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 1026.5}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 1026.5}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 1026.5}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 1026.5}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 1026.4}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 1026.4}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 1026.7}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 1027.1}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 1027.4}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 1027.9}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 1028.3}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 1028.8}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 1028.8}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 1028.8}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 1028.8}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 1028.8}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 1028.8}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 1026.9}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 1026.7}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 1026.4}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 1026.2}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 1026.0}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 1025.8}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 1025.3}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 1024.8}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 1024.3}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 1023.8}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 1023.3}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 1022.8}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 1022.2}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 1021.5}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 1020.8}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 1020.2}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 1019.5}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 1018.8}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 1018.6}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 1018.3}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 1018.0}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 1017.7}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 1017.5}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 1017.2}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 1016.8}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 1016.4}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 1016.0}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 1015.7}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 1015.3}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 1014.9}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 1014.6}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 1014.3}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 1014.0}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 1013.7}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 1013.4}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 1013.1}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 1012.9}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 1012.7}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 1012.5}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 1012.4}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 1012.2}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 1012.0}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 1011.9}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 1011.9}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 1011.8}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 1011.8}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 1011.7}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 1011.7}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 1011.6}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 1011.5}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 1011.4}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 1011.3}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 1011.2}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 1011.1}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 1011.0}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 1010.8}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 1010.7}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 1010.5}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 1010.4}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 1010.2}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 1010.0}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 1009.8}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 1009.6}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 1009.4}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 1009.2}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 1009.0}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 1009.1}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 1009.3}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 1009.4}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 1009.5}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 1009.7}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 1009.8}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 1009.8}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 1009.8}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 1009.7}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 1009.7}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 1009.7}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 1009.7}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 1009.6}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 1009.5}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 1009.4}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 1009.3}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 1009.2}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 1009.1}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 1009.5}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 1009.8}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 1010.1}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 1010.4}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 1010.7}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 1011.0}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 1011.2}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 1011.3}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 1011.5}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 1011.6}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 1011.8}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 1011.9}]}, {'AttributeName': 'total_cloud_cover:p', 'AttributeUnitOfMeasure': '%', 'AttributeDescription': '[MET] total cloud cover [%]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 47.1}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 48.7}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 48.7}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 54.5}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 53.9}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 54.9}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 57.4}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 44.9}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 32.0}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 18.8}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 53.0}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 77.9}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 93.5}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 96.2}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 98.2}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 99.6}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 99.7}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 99.8}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 99.9}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 99.6}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 99.3}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 99.1}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 99.3}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 99.5}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 99.8}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 48.7}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 48.7}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 68.1}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 83.0}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 93.3}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 87.5}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 81.4}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 74.9}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 64.6}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 52.6}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 38.8}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 27.1}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 14.3}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 0.5}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 0.4}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 0.2}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 0.1}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 0.1}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 20.6}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 38.7}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 98.1}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 94.8}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 89.8}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 83.3}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 75.0}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 65.0}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 61.7}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 58.3}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 54.9}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 51.4}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 47.8}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 44.2}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 38.1}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 32.0}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 25.9}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 19.9}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 13.8}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 21.6}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 35.5}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 49.4}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 63.3}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 77.2}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 91.1}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 93.8}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 96.0}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 97.8}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 99.0}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 99.7}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 100.0}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 97.7}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 90.8}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 79.5}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 63.7}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 43.3}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 18.5}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 32.9}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 46.7}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 59.8}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 72.0}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 83.3}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 93.3}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 87.1}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 83.7}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 83.1}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 85.1}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 89.6}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 96.5}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 97.1}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 97.7}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 98.3}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 98.8}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 99.4}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 100.0}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 99.9}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 99.9}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 99.8}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 99.8}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 99.7}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 99.6}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 98.7}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 97.9}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 97.2}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 96.6}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 96.2}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 95.8}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 93.8}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 92.3}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 91.1}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 90.3}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 90.0}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 90.0}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 88.8}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 88.4}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 89.1}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 91.1}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 94.4}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 99.3}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 99.4}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 99.6}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 99.7}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 99.8}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 99.9}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 100.0}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 98.3}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 93.6}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 86.6}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 77.8}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 67.7}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 57.1}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 65.0}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 72.1}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 78.4}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 83.9}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 88.7}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 92.6}]}, {'AttributeName': 'visibility:km', 'AttributeUnitOfMeasure': 'km', 'AttributeDescription': '[MET] visibility [km]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 26.7}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 27.4}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 27.9}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 27.5}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 28.5}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 29.5}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 30.3}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 31.2}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 32.2}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 33.1}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 32.6}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 32.0}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 31.4}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 31.6}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 31.8}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 32.0}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 32.6}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 33.3}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 34.0}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 32.9}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 31.7}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 30.5}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 29.1}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 27.7}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 26.3}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 28.4}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 28.9}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 31.0}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 33.1}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 35.1}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 36.3}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 37.5}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 38.6}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 40.6}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 42.5}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 44.5}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 41.7}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 38.9}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 36.1}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 34.7}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 33.4}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 32.1}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 31.0}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 30.0}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 28.9}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 28.4}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 28.0}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 27.0}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 27.7}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 28.4}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 29.1}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 29.9}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 30.7}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 31.8}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 32.9}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 34.0}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 35.0}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 36.1}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 37.1}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 37.0}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 36.9}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 36.7}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 36.6}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 36.4}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 36.2}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 35.8}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 35.5}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 35.2}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 34.9}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 34.6}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 34.3}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 34.3}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 34.4}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 34.5}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 34.5}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 34.7}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 34.7}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 35.1}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 35.5}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 35.8}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 36.2}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 36.6}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 37.0}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 36.3}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 35.6}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 34.9}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 34.2}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 33.5}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 32.8}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 31.7}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 30.6}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 29.6}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 28.5}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 27.5}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 26.4}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 26.5}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 26.6}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 26.6}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 26.7}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 26.9}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 27.0}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 28.3}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 29.5}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 30.8}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 32.1}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 33.4}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 34.7}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 34.4}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 34.0}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 33.6}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 33.2}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 32.9}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 32.5}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 27.8}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 23.2}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 18.7}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 14.1}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 9.6}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 8.7}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 10.5}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 12.4}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 14.3}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 16.1}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 13.7}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 11.3}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 8.9}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 1.6}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 12.0}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 17.1}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 22.3}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 27.5}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 32.6}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 32.3}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 32.1}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 31.9}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 31.6}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 31.4}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 31.2}]}, {'AttributeName': 'wet_bulb_t_2m:C', 'AttributeUnitOfMeasure': '°C', 'AttributeDescription': '[MET] wet bulb temperature at 2m [C]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 0.7}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 0.7}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 0.7}, {'UTC': '2021-04-13T03:00:00Z', 'Value': -2.4}, {'UTC': '2021-04-13T04:00:00Z', 'Value': -1.7}, {'UTC': '2021-04-13T05:00:00Z', 'Value': -1.0}, {'UTC': '2021-04-13T06:00:00Z', 'Value': -0.3}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 1.8}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 0.7}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 0.7}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 1.6}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 3.0}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 2.6}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 2.5}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 0.2}, {'UTC': '2021-04-12T22:00:00Z', 'Value': -0.4}, {'UTC': '2021-04-12T23:00:00Z', 'Value': -1.1}, {'UTC': '2021-04-13T00:00:00Z', 'Value': -1.8}, {'UTC': '2021-04-13T01:00:00Z', 'Value': -2.0}, {'UTC': '2021-04-13T02:00:00Z', 'Value': -2.2}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 2.0}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 1.5}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 2.6}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 2.6}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 2.5}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 9.4}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 9.7}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 10.0}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 10.3}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 10.6}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 10.9}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 11.2}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 10.8}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 10.5}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 10.1}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 9.8}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 9.4}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 9.1}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 9.2}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 9.3}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 9.4}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 9.5}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 9.6}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 9.7}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 10.5}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 11.4}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 12.3}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 13.2}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 14.1}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 15.0}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 15.1}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 15.2}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 15.3}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 15.4}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 15.4}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 15.5}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 15.2}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 14.8}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 14.5}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 14.1}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 13.8}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 13.4}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 13.2}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 13.0}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 12.8}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 12.5}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 12.3}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 12.1}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 12.2}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 12.4}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 12.5}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 12.7}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 12.9}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 13.0}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 12.3}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 11.7}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 11.0}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 10.4}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 9.8}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 9.2}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 9.1}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 9.0}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 9.0}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 8.9}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 8.9}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 8.8}]}, {'AttributeName': 'wind_dir_20m:d', 'AttributeUnitOfMeasure': '°', 'AttributeDescription': '[MET] wind direction at 20m', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 359.0}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 354.1}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 350.4}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 199.7}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 197.5}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 195.7}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 194.2}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 201.3}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 209.3}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 218.1}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 226.2}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 237.3}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 251.7}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 248.6}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 245.1}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 241.3}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 271.9}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 0.2}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 23.9}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 61.3}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 96.4}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 114.9}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 125.1}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 136.1}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 147.2}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 346.4}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 342.0}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 357.9}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 14.5}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 8.5}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 2.1}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 355.4}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 359.6}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 8.7}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 359.6}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 12.8}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 22.0}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 347.1}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 298.1}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 273.9}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 249.0}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 220.9}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 149.6}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 151.6}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 153.4}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 155.0}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 156.4}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 157.7}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 153.7}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 150.2}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 147.0}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 144.2}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 141.7}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 139.4}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 136.3}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 133.1}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 129.9}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 126.5}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 123.2}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 119.8}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 124.7}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 129.3}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 133.6}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 137.5}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 141.0}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 144.2}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 143.3}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 142.3}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 141.4}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 140.5}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 139.6}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 138.7}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 143.4}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 148.3}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 153.2}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 158.1}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 163.0}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 167.7}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 167.8}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 167.8}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 167.7}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 167.7}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 167.6}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 167.3}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 166.3}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 165.5}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 164.8}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 164.1}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 163.6}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 163.1}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 161.7}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 160.4}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 159.0}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 157.7}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 156.3}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 155.0}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 158.1}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 161.5}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 164.9}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 168.5}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 172.2}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 176.1}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 172.2}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 167.8}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 163.1}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 157.8}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 152.1}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 146.1}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 155.7}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 164.6}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 172.5}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 179.3}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 185.0}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 189.8}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 189.0}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 188.2}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 187.2}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 186.2}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 185.1}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 183.9}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 192.3}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 203.1}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 216.3}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 231.1}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 245.8}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 258.7}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 257.9}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 257.1}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 256.3}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 255.5}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 254.6}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 253.8}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 244.3}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 237.0}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 231.5}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 227.2}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 223.8}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 221.0}]}, {'AttributeName': 'wind_dir_50m:d', 'AttributeUnitOfMeasure': '°', 'AttributeDescription': '[MET] wind direction at 50m', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 358.5}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 356.0}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 208.3}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 205.1}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 202.3}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 200.0}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 205.3}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 211.6}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 218.9}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 226.8}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 237.6}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 251.9}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 248.6}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 245.0}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 241.1}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 276.1}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 1.2}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 22.8}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 64.8}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 100.9}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 118.2}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 128.7}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 139.8}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 150.6}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 353.3}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 350.3}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 9.4}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 14.7}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 8.7}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 355.6}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 359.6}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 8.3}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 0.2}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 11.8}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 21.4}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 348.1}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 304.5}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 281.2}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 254.4}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 227.4}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 152.6}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 154.4}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 156.1}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 157.5}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 158.8}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 160.0}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 156.1}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 152.5}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 149.0}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 145.7}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 142.5}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 139.5}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 136.2}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 132.9}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 129.8}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 126.7}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 123.7}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 120.7}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 125.7}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 130.4}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 134.7}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 138.6}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 142.3}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 145.5}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 144.6}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 143.7}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 142.8}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 141.9}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 141.0}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 140.1}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 144.4}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 148.8}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 153.4}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 158.1}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 163.0}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 167.9}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 168.4}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 168.9}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 169.4}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 169.9}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 170.4}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 170.9}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 169.7}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 168.6}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 167.7}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 166.9}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 166.2}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 165.5}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 164.3}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 163.0}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 161.7}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 160.4}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 159.1}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 157.7}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 160.3}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 163.1}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 166.0}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 169.2}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 172.6}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 176.2}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 172.2}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 168.1}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 163.7}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 159.2}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 154.4}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 149.5}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 158.6}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 167.1}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 174.7}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 181.5}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 187.3}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 192.2}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 191.4}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 190.5}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 189.5}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 188.5}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 187.4}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 186.2}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 193.9}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 203.8}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 216.2}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 230.6}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 245.5}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 259.3}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 258.6}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 258.0}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 257.3}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 256.7}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 256.1}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 255.4}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 246.0}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 238.7}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 233.0}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 228.6}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 225.0}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 222.1}]}, {'AttributeName': 'wind_gusts_10m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': '[MET] wind gusts at 10m [m/s]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 2.6}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 2.0}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 2.0}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 1.9}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 1.8}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 1.8}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 1.9}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 2.1}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 5.7}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 5.7}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 2.1}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 3.0}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 7.6}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 8.6}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 9.5}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 10.4}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 11.4}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 12.3}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 13.2}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 14.1}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 13.9}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 13.6}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 13.4}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 13.1}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 12.8}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 12.6}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 11.7}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 10.8}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 9.9}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 9.0}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 7.6}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 7.1}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 7.1}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 7.1}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 8.6}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 9.0}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 9.5}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 8.6}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 7.6}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 5.7}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 7.3}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 8.8}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 9.5}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 10.0}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 10.6}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 11.1}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 11.8}]}, {'AttributeName': 'wind_gusts_20m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': '[MET] wind gusts at 20m [m/s]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 7.6}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 7.1}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 3.0}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 2.1}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 2.1}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 2.6}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 7.3}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 8.4}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 8.9}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 9.8}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 10.8}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 11.7}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 12.6}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 13.6}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 14.5}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 14.3}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 14.0}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 13.7}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 13.5}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 13.2}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 13.0}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 12.0}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 11.1}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 10.2}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 9.3}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 8.6}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 8.0}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 7.6}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 7.3}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 7.1}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 7.3}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 7.1}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 7.3}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 7.5}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 7.1}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 7.5}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 8.4}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 8.8}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 9.3}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 9.8}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 8.8}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 7.5}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 9.0}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 9.8}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 10.4}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 11.0}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 11.6}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 12.2}]}, {'AttributeName': 'wind_gusts_50m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': '[MET] wind gusts at 50m [m/s]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 7.5}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 7.1}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 3.0}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 2.6}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 2.5}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 2.5}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 2.6}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 5.7}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 6.2}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 7.2}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 8.8}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 9.4}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 10.3}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 11.3}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 12.3}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 13.2}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 14.2}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 15.2}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 14.9}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 14.6}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 14.3}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 14.1}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 13.8}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 13.5}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 12.5}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 11.6}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 10.6}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 9.7}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 9.1}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 8.6}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 8.4}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 8.0}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 7.6}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 7.5}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 7.5}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 7.6}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 7.6}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 7.6}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 7.6}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 7.5}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 7.6}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 7.5}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 7.3}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 8.3}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 8.8}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 9.2}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 9.7}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 10.2}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 9.2}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 8.3}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 7.3}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 5.7}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 7.3}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 8.5}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 9.5}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 10.4}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 11.0}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 11.6}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 12.3}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 12.9}]}, {'AttributeName': 'wind_speed_20m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': '[MET] wind speed at 20m [m/s]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 2.6}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 2.5}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 2.6}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 1.9}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 1.6}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 1.5}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 1.5}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 1.4}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 1.4}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 1.5}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 1.5}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 1.8}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 2.0}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 2.1}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 2.5}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 3.0}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 1.9}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 1.8}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 1.9}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 2.0}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 2.1}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 2.6}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 3.0}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 3.0}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 5.7}]}, {'AttributeName': 'wind_speed_50m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': '[MET] wind speed at 50m [m/s]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 2.1}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 1.8}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 1.6}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 1.8}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 1.9}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 3.0}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 1.9}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 2.1}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 2.5}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 3.0}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 6.1}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 6.9}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 6.4}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 5.7}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 5.7}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 4.9}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 4.8}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 4.6}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 6.5}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 7.1}]}, {'AttributeName': 'wind_speed_10m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': '[MET] wind speed at 10m [m/s]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 2.1}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 2.0}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 1.8}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 2.0}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 2.1}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 2.0}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 1.8}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 1.6}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 1.3}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 1.3}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 1.2}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 1.2}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 1.2}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 1.2}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 1.2}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 1.4}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 1.6}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 1.8}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 1.9}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 1.9}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 3.0}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 3.0}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 1.9}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 1.6}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 1.4}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 1.5}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 1.6}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 1.7}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 1.8}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 1.8}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 1.9}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 2.0}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 2.6}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 3.0}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 3.6}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 4.4}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 4.5}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 3.7}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 2.6}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 2.5}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 2.5}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 2.5}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 3.0}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 3.0}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 2.6}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 2.5}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 2.4}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 2.3}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 2.2}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 2.6}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 3.0}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 3.4}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 3.8}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 4.6}]}, {'AttributeName': 't_2m:C', 'AttributeUnitOfMeasure': '°C', 'AttributeDescription': 'temperature at 2m [C]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 1.4}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 1.4}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 1.5}, {'UTC': '2021-04-13T03:00:00Z', 'Value': -1.7}, {'UTC': '2021-04-13T04:00:00Z', 'Value': -0.9}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 0.8}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 5.7}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 9.2}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 10.2}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 11.2}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 11.2}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 11.3}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 11.3}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 10.5}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 9.6}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 8.7}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 1.5}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 1.5}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 3.1}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 4.7}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 7.3}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 7.8}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 7.9}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 7.0}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 5.1}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 3.9}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 1.6}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 0.7}, {'UTC': '2021-04-12T23:00:00Z', 'Value': -0.2}, {'UTC': '2021-04-13T00:00:00Z', 'Value': -1.0}, {'UTC': '2021-04-13T01:00:00Z', 'Value': -1.3}, {'UTC': '2021-04-13T02:00:00Z', 'Value': -1.5}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 3.3}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 3.2}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 3.0}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 2.7}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 2.6}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 7.3}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 8.9}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 10.5}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 12.1}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 11.8}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 11.5}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 11.3}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 11.0}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 10.7}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 10.4}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 9.7}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 8.9}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 7.4}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 5.9}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 5.8}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 5.6}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 5.3}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 5.2}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 9.8}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 11.3}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 12.9}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 14.5}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 14.4}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 14.4}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 14.4}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 14.4}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 14.3}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 14.3}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 13.6}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 12.9}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 12.2}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 11.5}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 10.8}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 10.1}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 10.3}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 10.4}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 10.5}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 10.6}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 10.8}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 10.9}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 12.3}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 13.7}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 15.0}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 16.4}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 17.8}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 19.2}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 19.0}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 18.8}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 18.6}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 18.4}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 18.2}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 18.0}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 17.3}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 16.6}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 15.9}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 15.3}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 14.6}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 13.9}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 13.7}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 13.4}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 13.1}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 12.8}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 12.5}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 12.2}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 12.6}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 12.9}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 13.2}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 13.5}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 13.9}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 14.2}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 13.8}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 13.5}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 13.1}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 12.7}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 12.4}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 12.0}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 11.8}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 11.7}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 11.5}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 11.3}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 11.2}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 11.0}]}, {'AttributeName': 'air_density_100m:kgm3', 'AttributeUnitOfMeasure': 'kg/m³', 'AttributeDescription': 'The density of air at any height level above ground up to 10 km', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 1.273}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 1.273}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 1.274}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 1.275}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 1.277}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 1.276}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 1.275}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 1.272}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 1.268}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 1.265}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 1.26}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 1.255}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 1.25}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 1.249}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 1.248}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 1.247}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 1.248}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 1.249}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 1.25}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 1.251}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 1.253}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 1.254}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 1.255}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 1.256}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 1.257}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 1.276}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 1.274}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 1.272}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 1.27}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 1.268}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 1.266}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 1.264}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 1.263}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 1.262}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 1.262}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 1.264}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 1.266}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 1.268}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 1.27}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 1.272}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 1.274}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 1.275}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 1.276}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 1.277}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 1.278}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 1.278}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 1.278}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 1.258}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 1.258}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 1.259}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 1.26}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 1.261}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 1.262}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 1.258}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 1.255}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 1.251}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 1.247}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 1.244}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 1.24}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 1.239}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 1.238}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 1.236}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 1.235}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 1.234}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 1.232}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 1.235}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 1.238}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 1.241}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 1.244}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 1.247}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 1.25}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 1.25}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 1.251}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 1.252}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 1.253}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 1.254}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 1.255}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 1.248}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 1.242}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 1.236}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 1.229}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 1.223}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 1.217}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 1.215}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 1.213}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 1.211}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 1.21}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 1.208}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 1.206}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 1.208}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 1.211}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 1.213}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 1.216}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 1.218}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 1.22}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 1.22}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 1.221}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 1.221}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 1.221}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 1.221}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 1.221}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 1.216}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 1.21}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 1.205}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 1.2}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 1.195}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 1.19}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 1.189}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 1.188}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 1.188}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 1.187}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 1.186}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 1.186}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 1.189}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 1.192}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 1.195}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 1.198}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 1.202}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 1.205}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 1.206}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 1.208}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 1.209}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 1.21}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 1.211}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 1.213}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 1.212}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 1.211}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 1.21}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 1.209}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 1.208}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 1.207}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 1.209}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 1.211}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 1.213}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 1.215}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 1.217}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 1.219}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 1.22}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 1.22}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 1.221}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 1.222}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 1.222}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 1.223}]}, {'AttributeName': 'high_cloud_cover:p', 'AttributeUnitOfMeasure': '%', 'AttributeDescription': 'high cloud cover [%]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 29.6}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 59.2}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 88.9}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 91.7}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 94.4}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 97.2}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 97.7}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 98.2}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 98.6}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 98.6}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 98.5}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 98.4}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 92.5}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 86.5}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 80.6}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 74.6}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 68.7}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 62.8}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 59.7}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 56.6}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 53.5}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 50.4}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 47.3}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 44.2}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 38.1}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 32.0}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 25.9}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 19.9}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 13.8}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 7.7}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 21.6}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 35.5}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 49.4}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 63.3}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 77.2}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 91.1}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 92.6}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 94.1}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 95.5}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 97.0}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 98.5}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 100.0}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 83.3}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 66.7}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 50.0}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 33.3}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 16.7}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 6.3}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 12.7}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 19.0}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 25.3}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 31.7}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 38.0}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 47.7}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 57.4}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 67.0}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 76.7}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 86.4}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 96.1}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 96.1}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 96.1}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 96.1}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 96.2}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 96.2}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 96.2}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 95.4}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 94.6}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 93.7}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 92.9}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 92.1}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 91.3}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 91.4}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 91.4}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 91.5}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 91.6}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 91.7}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 91.8}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 87.0}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 82.1}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 77.3}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 72.4}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 67.6}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 62.8}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 68.8}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 74.9}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 81.0}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 87.1}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 93.1}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 99.2}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 99.3}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 99.3}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 99.3}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 99.4}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 99.4}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 99.4}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 82.9}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 66.3}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 49.7}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 33.1}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 16.6}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 0.0}]}, {'AttributeName': 'medium_cloud_cover:p', 'AttributeUnitOfMeasure': '%', 'AttributeDescription': 'amount of medium cloud cover [%]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 33.5}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 23.8}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 14.0}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 4.3}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 2.9}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 1.4}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 24.5}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 48.9}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 73.4}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 75.9}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 78.5}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 81.1}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 82.8}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 84.6}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 86.3}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 64.0}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 41.6}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 19.3}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 41.9}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 64.4}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 87.0}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 19.7}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 39.4}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 59.2}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 57.8}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 56.4}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 55.1}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 45.0}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 34.9}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 24.8}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 16.6}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 8.3}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 0.1}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 0.1}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 11.3}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 22.4}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 73.5}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 60.0}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 46.5}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 33.0}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 19.5}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 6.0}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 5.0}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 4.0}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 3.0}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 2.0}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 16.6}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 33.2}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 49.8}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 66.4}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 83.0}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 99.6}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 86.1}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 72.5}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 59.0}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 45.5}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 32.0}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 18.5}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 15.9}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 13.2}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 10.6}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 8.0}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 4.1}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 6.7}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 8.1}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 9.4}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 10.7}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 25.4}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 40.2}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 55.0}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 69.7}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 84.5}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 99.2}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 98.7}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 98.1}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 97.6}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 97.0}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 96.5}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 95.9}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 84.4}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 72.9}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 61.3}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 49.8}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 38.2}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 26.7}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 32.7}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 38.7}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 44.7}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 50.7}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 56.7}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 62.7}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 52.2}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 41.8}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 31.3}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 20.9}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 10.4}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 16.6}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 33.3}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 49.9}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 66.5}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 83.2}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 99.8}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 87.5}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 75.3}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 63.0}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 50.7}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 38.4}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 26.2}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 34.2}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 42.2}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 50.3}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 58.3}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 66.3}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 74.4}]}, {'AttributeName': 'low_cloud_cover:p', 'AttributeUnitOfMeasure': '%', 'AttributeDescription': 'low cloud cover [%]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 47.1}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 48.7}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 48.7}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 31.6}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 39.5}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 47.5}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 55.5}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 43.3}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 31.0}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 18.8}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 37.8}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 56.8}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 75.8}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 77.6}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 79.3}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 81.1}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 77.3}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 73.4}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 69.6}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 53.9}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 38.1}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 22.4}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 16.3}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 10.3}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 4.2}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 48.7}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 48.7}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 60.3}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 71.9}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 83.6}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 70.4}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 57.3}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 44.2}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 35.7}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 27.1}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 18.6}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 12.6}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 6.6}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 0.5}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 0.4}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 0.2}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 10.5}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 21.0}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 3.5}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 2.8}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 2.1}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 1.4}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 0.7}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 0.1}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 0.0}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 14.8}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 29.6}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 44.5}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 59.3}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 74.1}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 88.9}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 74.3}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 59.6}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 45.0}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 30.3}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 15.7}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 1.0}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 0.9}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 0.9}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 0.9}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 0.9}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 0.8}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 0.7}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 0.7}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 0.6}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 0.5}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 0.5}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 5.5}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 10.4}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 15.4}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 20.4}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 25.3}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 30.3}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 30.0}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 29.6}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 29.3}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 29.0}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 28.6}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 28.3}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 24.5}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 20.7}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 16.9}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 13.1}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 9.2}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 5.4}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 6.8}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 8.2}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 9.6}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 11.1}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 12.5}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 13.9}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 18.5}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 23.2}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 27.8}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 32.5}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 37.2}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 41.8}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 46.8}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 51.7}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 56.6}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 61.5}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 66.4}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 71.3}]}, {'AttributeName': 'msl_pressure:hPa', 'AttributeUnitOfMeasure': 'hPa', 'AttributeDescription': 'mean sea level pressure [hPa]', 'AttributeDataType': 'Numeric', 'Values': [{'UTC': '2021-04-12T02:00:00Z', 'Value': 1024.7}, {'UTC': '2021-04-12T03:00:00Z', 'Value': 1025.0}, {'UTC': '2021-04-12T04:00:00Z', 'Value': 1025.6}, {'UTC': '2021-04-13T03:00:00Z', 'Value': 1030.5}, {'UTC': '2021-04-13T04:00:00Z', 'Value': 1030.7}, {'UTC': '2021-04-13T05:00:00Z', 'Value': 1030.9}, {'UTC': '2021-04-13T06:00:00Z', 'Value': 1031.1}, {'UTC': '2021-04-13T07:00:00Z', 'Value': 1031.1}, {'UTC': '2021-04-13T08:00:00Z', 'Value': 1031.1}, {'UTC': '2021-04-13T09:00:00Z', 'Value': 1031.2}, {'UTC': '2021-04-13T10:00:00Z', 'Value': 1030.8}, {'UTC': '2021-04-13T11:00:00Z', 'Value': 1030.5}, {'UTC': '2021-04-13T12:00:00Z', 'Value': 1030.1}, {'UTC': '2021-04-13T13:00:00Z', 'Value': 1029.8}, {'UTC': '2021-04-13T14:00:00Z', 'Value': 1029.4}, {'UTC': '2021-04-13T15:00:00Z', 'Value': 1029.1}, {'UTC': '2021-04-13T16:00:00Z', 'Value': 1029.0}, {'UTC': '2021-04-13T17:00:00Z', 'Value': 1028.9}, {'UTC': '2021-04-13T18:00:00Z', 'Value': 1028.8}, {'UTC': '2021-04-13T19:00:00Z', 'Value': 1029.0}, {'UTC': '2021-04-13T20:00:00Z', 'Value': 1029.2}, {'UTC': '2021-04-13T21:00:00Z', 'Value': 1029.4}, {'UTC': '2021-04-13T22:00:00Z', 'Value': 1029.2}, {'UTC': '2021-04-13T23:00:00Z', 'Value': 1029.0}, {'UTC': '2021-04-14T00:00:00Z', 'Value': 1028.7}, {'UTC': '2021-04-12T05:00:00Z', 'Value': 1026.2}, {'UTC': '2021-04-12T06:00:00Z', 'Value': 1026.8}, {'UTC': '2021-04-12T07:00:00Z', 'Value': 1027.2}, {'UTC': '2021-04-12T08:00:00Z', 'Value': 1027.7}, {'UTC': '2021-04-12T09:00:00Z', 'Value': 1028.1}, {'UTC': '2021-04-12T10:00:00Z', 'Value': 1028.1}, {'UTC': '2021-04-12T11:00:00Z', 'Value': 1028.1}, {'UTC': '2021-04-12T12:00:00Z', 'Value': 1028.1}, {'UTC': '2021-04-12T13:00:00Z', 'Value': 1028.1}, {'UTC': '2021-04-12T14:00:00Z', 'Value': 1028.0}, {'UTC': '2021-04-12T15:00:00Z', 'Value': 1028.0}, {'UTC': '2021-04-12T16:00:00Z', 'Value': 1028.3}, {'UTC': '2021-04-12T17:00:00Z', 'Value': 1028.7}, {'UTC': '2021-04-12T18:00:00Z', 'Value': 1029.0}, {'UTC': '2021-04-12T19:00:00Z', 'Value': 1029.5}, {'UTC': '2021-04-12T20:00:00Z', 'Value': 1029.9}, {'UTC': '2021-04-12T21:00:00Z', 'Value': 1030.4}, {'UTC': '2021-04-12T22:00:00Z', 'Value': 1030.4}, {'UTC': '2021-04-12T23:00:00Z', 'Value': 1030.5}, {'UTC': '2021-04-13T00:00:00Z', 'Value': 1030.5}, {'UTC': '2021-04-13T01:00:00Z', 'Value': 1030.5}, {'UTC': '2021-04-13T02:00:00Z', 'Value': 1030.5}, {'UTC': '2021-04-14T01:00:00Z', 'Value': 1028.5}, {'UTC': '2021-04-14T02:00:00Z', 'Value': 1028.3}, {'UTC': '2021-04-14T03:00:00Z', 'Value': 1028.1}, {'UTC': '2021-04-14T04:00:00Z', 'Value': 1027.9}, {'UTC': '2021-04-14T05:00:00Z', 'Value': 1027.6}, {'UTC': '2021-04-14T06:00:00Z', 'Value': 1027.4}, {'UTC': '2021-04-14T07:00:00Z', 'Value': 1026.9}, {'UTC': '2021-04-14T08:00:00Z', 'Value': 1026.4}, {'UTC': '2021-04-14T09:00:00Z', 'Value': 1025.9}, {'UTC': '2021-04-14T10:00:00Z', 'Value': 1025.4}, {'UTC': '2021-04-14T11:00:00Z', 'Value': 1024.9}, {'UTC': '2021-04-14T12:00:00Z', 'Value': 1024.4}, {'UTC': '2021-04-14T13:00:00Z', 'Value': 1023.8}, {'UTC': '2021-04-14T14:00:00Z', 'Value': 1023.1}, {'UTC': '2021-04-14T15:00:00Z', 'Value': 1022.4}, {'UTC': '2021-04-14T16:00:00Z', 'Value': 1021.7}, {'UTC': '2021-04-14T17:00:00Z', 'Value': 1021.1}, {'UTC': '2021-04-14T18:00:00Z', 'Value': 1020.4}, {'UTC': '2021-04-14T19:00:00Z', 'Value': 1020.1}, {'UTC': '2021-04-14T20:00:00Z', 'Value': 1019.9}, {'UTC': '2021-04-14T21:00:00Z', 'Value': 1019.6}, {'UTC': '2021-04-14T22:00:00Z', 'Value': 1019.3}, {'UTC': '2021-04-14T23:00:00Z', 'Value': 1019.1}, {'UTC': '2021-04-15T00:00:00Z', 'Value': 1018.8}, {'UTC': '2021-04-15T01:00:00Z', 'Value': 1018.4}, {'UTC': '2021-04-15T02:00:00Z', 'Value': 1018.0}, {'UTC': '2021-04-15T03:00:00Z', 'Value': 1017.7}, {'UTC': '2021-04-15T04:00:00Z', 'Value': 1017.3}, {'UTC': '2021-04-15T05:00:00Z', 'Value': 1016.9}, {'UTC': '2021-04-15T06:00:00Z', 'Value': 1016.5}, {'UTC': '2021-04-15T07:00:00Z', 'Value': 1016.2}, {'UTC': '2021-04-15T08:00:00Z', 'Value': 1015.9}, {'UTC': '2021-04-15T09:00:00Z', 'Value': 1015.6}, {'UTC': '2021-04-15T10:00:00Z', 'Value': 1015.3}, {'UTC': '2021-04-15T11:00:00Z', 'Value': 1015.0}, {'UTC': '2021-04-15T12:00:00Z', 'Value': 1014.7}, {'UTC': '2021-04-15T13:00:00Z', 'Value': 1014.5}, {'UTC': '2021-04-15T14:00:00Z', 'Value': 1014.3}, {'UTC': '2021-04-15T15:00:00Z', 'Value': 1014.1}, {'UTC': '2021-04-15T16:00:00Z', 'Value': 1013.9}, {'UTC': '2021-04-15T17:00:00Z', 'Value': 1013.7}, {'UTC': '2021-04-15T18:00:00Z', 'Value': 1013.6}, {'UTC': '2021-04-15T19:00:00Z', 'Value': 1013.5}, {'UTC': '2021-04-15T20:00:00Z', 'Value': 1013.5}, {'UTC': '2021-04-15T21:00:00Z', 'Value': 1013.4}, {'UTC': '2021-04-15T22:00:00Z', 'Value': 1013.4}, {'UTC': '2021-04-15T23:00:00Z', 'Value': 1013.3}, {'UTC': '2021-04-16T00:00:00Z', 'Value': 1013.3}, {'UTC': '2021-04-16T01:00:00Z', 'Value': 1013.2}, {'UTC': '2021-04-16T02:00:00Z', 'Value': 1013.1}, {'UTC': '2021-04-16T03:00:00Z', 'Value': 1013.0}, {'UTC': '2021-04-16T04:00:00Z', 'Value': 1012.9}, {'UTC': '2021-04-16T05:00:00Z', 'Value': 1012.8}, {'UTC': '2021-04-16T06:00:00Z', 'Value': 1012.7}, {'UTC': '2021-04-16T07:00:00Z', 'Value': 1012.5}, {'UTC': '2021-04-16T08:00:00Z', 'Value': 1012.4}, {'UTC': '2021-04-16T09:00:00Z', 'Value': 1012.2}, {'UTC': '2021-04-16T10:00:00Z', 'Value': 1012.1}, {'UTC': '2021-04-16T11:00:00Z', 'Value': 1011.9}, {'UTC': '2021-04-16T12:00:00Z', 'Value': 1011.7}, {'UTC': '2021-04-16T13:00:00Z', 'Value': 1011.5}, {'UTC': '2021-04-16T14:00:00Z', 'Value': 1011.3}, {'UTC': '2021-04-16T15:00:00Z', 'Value': 1011.1}, {'UTC': '2021-04-16T16:00:00Z', 'Value': 1010.9}, {'UTC': '2021-04-16T17:00:00Z', 'Value': 1010.8}, {'UTC': '2021-04-16T18:00:00Z', 'Value': 1010.6}, {'UTC': '2021-04-16T19:00:00Z', 'Value': 1010.7}, {'UTC': '2021-04-16T20:00:00Z', 'Value': 1010.8}, {'UTC': '2021-04-16T21:00:00Z', 'Value': 1011.0}, {'UTC': '2021-04-16T22:00:00Z', 'Value': 1011.1}, {'UTC': '2021-04-16T23:00:00Z', 'Value': 1011.2}, {'UTC': '2021-04-17T00:00:00Z', 'Value': 1011.4}, {'UTC': '2021-04-17T01:00:00Z', 'Value': 1011.3}, {'UTC': '2021-04-17T02:00:00Z', 'Value': 1011.3}, {'UTC': '2021-04-17T03:00:00Z', 'Value': 1011.3}, {'UTC': '2021-04-17T04:00:00Z', 'Value': 1011.3}, {'UTC': '2021-04-17T05:00:00Z', 'Value': 1011.3}, {'UTC': '2021-04-17T06:00:00Z', 'Value': 1011.2}, {'UTC': '2021-04-17T07:00:00Z', 'Value': 1011.2}, {'UTC': '2021-04-17T08:00:00Z', 'Value': 1011.1}, {'UTC': '2021-04-17T09:00:00Z', 'Value': 1011.0}, {'UTC': '2021-04-17T10:00:00Z', 'Value': 1010.9}, {'UTC': '2021-04-17T11:00:00Z', 'Value': 1010.8}, {'UTC': '2021-04-17T12:00:00Z', 'Value': 1010.7}, {'UTC': '2021-04-17T13:00:00Z', 'Value': 1011.0}, {'UTC': '2021-04-17T14:00:00Z', 'Value': 1011.3}, {'UTC': '2021-04-17T15:00:00Z', 'Value': 1011.6}, {'UTC': '2021-04-17T16:00:00Z', 'Value': 1012.0}, {'UTC': '2021-04-17T17:00:00Z', 'Value': 1012.3}, {'UTC': '2021-04-17T18:00:00Z', 'Value': 1012.6}, {'UTC': '2021-04-17T19:00:00Z', 'Value': 1012.7}, {'UTC': '2021-04-17T20:00:00Z', 'Value': 1012.9}, {'UTC': '2021-04-17T21:00:00Z', 'Value': 1013.0}, {'UTC': '2021-04-17T22:00:00Z', 'Value': 1013.2}, {'UTC': '2021-04-17T23:00:00Z', 'Value': 1013.4}, {'UTC': '2021-04-18T00:00:00Z', 'Value': 1013.5}]}]}]}
Encoded: {'Request': {'locations': ['WIT_BEBEZ_SS001_WT001'], 'attributes': None, 'aggregate': True, 'startDate': '2021-04-12T01:46:08.8622635Z'}, 'Response': [{'LocationName': 'WIT_BEBEZ_SS001_WT001', 'EntityType': 'WIND_TURBINE', 'DisplayName': 'BEZ_E01', 'Latitude': 50.82426, 'Longitude': 3.32744, 'Timezone': 'Europe/Brussels', 'PlanId': '14d14980-306a-40c8-a784-579022ec9d49', 'HistoricalPlanId': '0d0fb8b5-a00b-4546-925f-0a7e7b72503b', 'DataSource': 'ECMWF-IFS', 'AsOfDateUTC': '2021-04-08T00:00:00Z', 'ForecastWeather': [{'AttributeName': 'fresh_snow_6h:cm', 'AttributeUnitOfMeasure': 'cm', 'AttributeDescription': 'fresh snow of previous 6h [cm]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 1, 'encoding_size': 91, 'float_precision': 0, 'data': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'}}, {'AttributeName': 'precip_1h:mm', 'AttributeUnitOfMeasure': 'mm', 'AttributeDescription': 'amount of precipitation in the previous 1h [mm]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 1, 'encoding_size': 91, 'float_precision': 2, 'data': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000KKKKKK888888TTTTTT888888000000'}}, {'AttributeName': 'relative_humidity_100m:p', 'AttributeUnitOfMeasure': '%', 'AttributeDescription': 'relative humidity at 100m [%]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '8M867`7.7_7D6u6A5#5U4`4x4V444j4{5f5v5.605+5q5V5n5&5}6p7D7#7!7_7_6`6J5j5m5p5s5{6X6)6,6;6>6!6m6V6Q6M6H6D68645;5y5h5R5C4{52585D5J5P5V5i5w5*5^686M6L6L6L6L6L6K695|5;5$5t5i5x5/5~6E6U6k6:7G7l7<8I8o8u8-8&8.8>8^8i847t7H6)6X6l6-6;707F7U7,8P8(9M9$AJASAbAjAsA-A)AfAC9.9j9H8=8p8O7}7x7W747G7T7f7r7#7;'}}, {'AttributeName': 'relative_humidity_50m:p', 'AttributeUnitOfMeasure': '%', 'AttributeDescription': 'relative humidity at 50m [%]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '8r8c8T8J8A7W6y635y5S4}4-4b4D4v5D5!5~6R6u6o6g6W6l6_6=7O7w7{7,7x7k6,6B5h5j5m5o646r7E7O7Y7i7c7W7P7H7A726^6<6)6d695,5k5M4|565E5M5V5d5m5z5.5}696M6a6Z6Y6W6V6U6S6G635@5)5w5l5#5[6A6T6m6%767a7%878d8+8:8>8[8}8~938o877v7H6(6W6n6$6[7A7T7l7}8a8:9R9(ALATAcAkAtA_A*AiAI9[9w9W978&8c887)7g7D7O7Z7k7v7&7='}}, {'AttributeName': 't_100m:C', 'AttributeUnitOfMeasure': '°C', 'AttributeDescription': 'temperature at 100m [C]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '0R0S0S0S0S0Y0d0j0o0s0x0z0_0#0z0u0q0n0j0f0d0b0Z0Y0X0W0Z0c0e0m0u0_0.0]1315161815110|0}0]0?0=0;0.0+0)0%0#0_0z0%0.0?0}131A1B1C1D1E1F1G19120`0<0*0!0z0w0t0q0n0k0y0,0`191M1a1d1g1j1n1q1t1n1h1b1W1Q1K1J1J1I1I1H1G1S1e1q1!1:1{1|1|1~2020211]1;1(1z1s1k1h1e1b1Y1W1T1V1X1Z1c1e1g1d1a1X1T1Q1N1M1K1J1I1H1G'}}, {'AttributeName': 'wind_dir_100m:d', 'AttributeUnitOfMeasure': '°', 'AttributeDescription': 'wind direction at 100m', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '140x0s0m0f0@1R1w0~0RdAdl0Z0:0s0Y0D0l1B2McdYwWNS}QHOiN]NfN4NSNzOJP2QFR!RTQ@QgVC0T2S7&B[DsE.G3HEHUHiHwH)H?I1HtHGG$GPF.FWE`ErEND`D-DeD~ElF0FfF<GLGDG4F}F<F(FyG3GeG?HYH[IiIuI(I[J7JNJeJOJ9I{I;I%IwIlIZINIBH|H:I1IJIeI#J2JZI`IlIAH%HZH5H`I,JtKVK~LoLgLXLNLDL2K?LsMlN$PLQ]SrSnSkSgSdSaSYRWQnP?PYO}Ou'}}, {'AttributeName': 'wind_dir_120m:d', 'AttributeUnitOfMeasure': '°', 'AttributeDescription': 'wind direction at 120m', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '1E0(0#0y0t0~1V1x100RdBdm0b0<0u0Z0F0n1E2WcUYoWMT9QfO)OIN!NQNjN+OMP5QHR%RWQ^QjU]022N87CKD.F0GGHNHcHqH!H:H}I6HyHLG*GTF:FWE`ErEND{D!DgE2EoF4FjF[GQGIGAG2F^F:F&G9GiG[HaH[IiIuI+I}JCJSJkJUJHJ4I^I/I%ItIiIWIKI7H^I9IQIjI&J4JZI}IoIEH+HfHCI2I>J-KbL5LuLmLdLULKLAK~L!MvN.PQQ`SqSnSkShSeSbSZRYQqP]PbO|Ow'}}, {'AttributeName': 'wind_dir_80m:d', 'AttributeUnitOfMeasure': '°', 'AttributeDescription': 'wind direction at 80m', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '0(0T0G02db0u1H1v0|0Pd9dl0b0=0v0Y090n1I2QcXYFV#SoP!N;NXM{MvN1NkODO~QDR_RTQ[QhU.0M2Z7jBrDWEoF(G[HAHPHeHrH#H;HdH1GrGFF(FVE}EsEND^DxDXD]EeE]FXF)GDG4F`F;F&FyFpF{GbG=HYH[IhIqI-I+I[J4JGJ1I>I&IwInIgIUIII6H]H*HwH<I9IXIyJ0JYI^IjI6HwHKG,H%IvJfKGK/LZLQLHL8K{K;K#LhMhN%PPQ`SoSjSeSZSVSRSNRLQcP*PPO=On'}}, {'AttributeName': 'wind_gusts_100m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': 'wind gusts at 100m [m/s]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '0}0?0;0+0%0$0_0_0z0y0w0v0t0s0t0u0v0l0b0R0T0V0W0c0h0m0q0u0y0q0i0a0W0S0O0O0N0N0P0R0T0b0i0q0r0s0t0v0x0z0_0#0(0%0$0#0!0!0_0&0.0>0`11181H1R1b1l1v1%1!1z1w1t1q1n1d1S1I17110`0^0]0[0@0?0=0>0?0@0]0{12110~0|0{0`0^0>0=0>0?0@0@0?0>0=0=0=0>0]0}11151A1F150`0;0.0+0(0#0z0v0r0n0o0u0-0(0;0]101B1I1O1V1b1i'}}, {'AttributeName': 'wind_gusts_80m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': 'wind gusts at 80m [m/s]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '0^0=0.0)0#0#0_0!0_0z0x0w0u0t0s0r0q0i0a0S0T0V0X0b0f0j0n0q0u0o0i0b0X0T0P0P0O0N0P0R0S0Z0f0m0m0n0n0p0r0u0y0#0(0$0!0_0_0!0!0&0,0=0^10161G1P1Z1j1t1#1-1x1u1r1o1l1b1R1H17110}0^0]0@0?0=0;0<0<0=0?0[0^0]0[0@0?0?0?0<0<0=0>0?0?0>0=0;0;0;0<0@0^0~14191D140^0/0)0&0#0-0w0t0p0n0o0u0-0&0/0@0|181G1N1T1Z1g'}}, {'AttributeName': 'wind_speed_100m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': 'wind speed at 100m [m/s]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 1, 'encoding_size': 91, 'float_precision': 1, 'data': 'tqmjfiknmkjihgghiaRJLMOSWaehkeXROKHGGFHJLRXeefgijlnpqqpponnqtwy_$(+/<?][[[@@@=/+($_zxvtrptx-$).,+*(&%_xtplhiklnoqsvx-!%#_zxuspmifbYabcefhnu-(/@'}}, {'AttributeName': 'wind_speed_120m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': 'wind speed at 120m [m/s]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 1, 'encoding_size': 91, 'float_precision': 1, 'data': 'wtpkgjlomljihghijaRJLMOSWadhkeXROKHGGFHIKQXdefgikmoqssrqponqux-#&+/<?]{}}}``^@</*%_zxwusqtx_%).,+*)(&!yuplhjkmnpqtwy_$&$_zxusplifcZacefhipv!);['}}, {'AttributeName': 'wind_speed_80m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': 'wind speed at 80m [m/s]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 1, 'encoding_size': 91, 'float_precision': 1, 'data': 'oliebgkonlkjiggfeXQKLNORUYbehcXSOLIHGGHJKQVabbcdfhjkmmnnnooqsuwy-!%),:<<<<<<;/,*&$!zwtqnkorvy!&%$#!__xurolhijjkkloqtwy_zxvtrpmjgdbYZabcdekrx#+<'}}, {'AttributeName': 'direct_rad:W', 'AttributeUnitOfMeasure': ' W/m²', 'AttributeDescription': 'direct radiation [W]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '0000000051E{NYQgPbN3K-G|HmK5I19`1>00000000000000000000005CH%V;gHndmLcEP)IAErAD4#0)000000000000000000000065I<YaohyX$P%$!svDj`TWE42:00000000000000000000004gDkOfZ)iFo5q)p[lVdMOCB52G00000000000000000000000|3I6K9xCsF1GoG{G6D+9G4x1600000000000000000000001D3U5~8)AdBdBzBD9>7~6(4P1L000000000000'}}, {'AttributeName': 'global_rad:W', 'AttributeUnitOfMeasure': ' W/m²', 'AttributeDescription': 'global radiation [W]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '000000009oP$dnnbsAtNrxmfjcglXtJ.4y00000000000000000000009qRHigwS%r&<z?o^fvX_NpC`350000000000000000000000B9UJmt_Q/u@]]x>z*QvOfUMi5J00000000000000000000009sP5ddoczt(C+J)b_zqXa/Jy4u00000000000000000000076dGIP2VmdOi>l$lVhnacQ;F73/000000000000000000000K7MHyQ[XqcZeVdfa1UhNfK1C#3z000000000000'}}, {'AttributeName': 'relative_humidity_2m:p', 'AttributeUnitOfMeasure': '%', 'AttributeDescription': 'relative humidity at 2m [%]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '9a9M9H9C977:6)5=5o5M4}4&4n4V4@5n6O6;7j8I8n8@9P9Y9g9p9I8:8l817o7B6k5^5d5e5f5h6K76838U8x8{9L9k9*9s9b9K948<8-7?7G6n5{5g4~5D5R5f5u5*5}676J6V6h6u6(6#6z6v6s6o6k6U6F605<5!5q5/696Y6z6{7Q7s7[8N8t8{9X9U9R9P9M9K9H8w8B7x7J6,6c6y6[7G7f7%828X8$999i9?ATAZAfAlAsAyA$AjAOA49/9u9c958_8W827!7Z7i7q7y7(7;7`'}}, {'AttributeName': 'wind_dir_10m:d', 'AttributeUnitOfMeasure': '°', 'AttributeDescription': 'wind direction at 10m', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': 'dSc(cRb.bQdH0.1r0^0Ld5dl0f0{0$0adi0u1e2ecAWmT/RFO3LvLdLOLBL{M[N^O;Q6RyRTQ`QmT#dn2z6uAdCkDuE/G5GTGpG(G`H9HMG,GcG8F+FnFSE|EwEPD@DlDCDzEGEwF6FfF,F_FsFjFZFQFHF$GPG:HZH[IdIcIaIYIVISINIEI7I0H^H>H:H-HmHZHLH7G^HRH-I8IjI[JVI[IeH?HRGwF]H1I0I>JvKNK*K_KsKiKYKNKCL7MQN)PcR2ScSTSKSCS3R^R:Q*P|PYO[OnON'}}, {'AttributeName': 't_2m:F', 'AttributeUnitOfMeasure': '°F', 'AttributeDescription': 'temperature at 2m [F]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '3+3,3.3.3/4C4f4)4<4}555657574?4#4m4R453/3y3i3T3O3K3G3V3k3-4F4w5B5U5m5$5%5&5(5r5c5M554<4y4k4W4I4G4D4A4845424V4y4{5Q5s5[5<5,5&5_5w5r5d5Q5C4|4:4-4y4v4t4q4n4l4/5C5f5(666Y6Y6X6X6W6W6V6J665^5+5y5m5o5q5s5u5x5z5`6K6j6)737S7P7L7H7E7A766^6,6z6n6b6P6K6F6A645~5^60666C6I6O6T6N6G6A635}5?5<5/5+5(5$5_'}}, {'AttributeName': 'prob_rr_3h:p', 'AttributeUnitOfMeasure': 'mm', 'AttributeDescription': 'probability of amount of precipitation in the previous 3h [mm]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0A0<1q2M2Q2U2Y1{1j0{0@0;0+1d2E2^3K3k3)392N1F170~0@0t0W0A0A0A0A'}}, {'AttributeName': 'dew_point_2m:C', 'AttributeUnitOfMeasure': '°C', 'AttributeDescription': '[MET] dew point temperature at 2m height [C]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': True, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': 'jbjajZjZjYjUjPjKjHjEjBj6j0i`j2jAjIjJjKjKjIjFjCjBjAj9jCjFjIjYjnj!jzjwjtjujujvj%j;j}j[j<j.j)j%j_jxjtjpjkjgjcjejhjjjljnjqjrjtjujwjxjzjvjqjmjijejajYjVjTjRjPjMjYjjjuj%j<j|k4kAkGkNkTkZkYkYkXkXkWkWkWkXkYkZkZkakfkjknkskwk-k$k)k.k;k?k^k^k]k]k]k]k]k@k>k<k:k.k,k,k,k,k+k+k+k_krkikYkPkFkFkFkGkGkGkG'}}, {'AttributeName': 'diffuse_rad:W', 'AttributeUnitOfMeasure': ' W/m²', 'AttributeDescription': '[MET] diffuse radiation [W]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '000000004nA(GGM`S!WKW|VhR?MgFs9=2)00000000000000000000004e9fCuGBIEKuN%PFNlJADc8K2Q000000000000000000000054BXEJC.FMGxG^G6EDBSB|8e2Y00000000000000000000005CBnE{ExHeJ7JeIjGUDBC_8t2e00000000000000000000075fD0I,L>QzT>VGUZRhMuHzAd2(000000000000000000000K68EUK]O,R}S[R*O=KrFgDM8e2e000000000000'}}, {'AttributeName': 'effective_cloud_cover:p', 'AttributeUnitOfMeasure': '%', 'AttributeDescription': '[MET] effective cloud cover [%]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '5G5W5W5W5W7i9BAN9u8`8L795*4O2|1q050402000001012O4N5~5]636S4^3l265/8pAPAiAxA)A(A&A(A58{7k8P9JAR9i8q7p6e5L3@3z3d3H2^2-2d291(1d180(0c1H1`2#3h4M5066798A98A4A{A98|7u604C233X4!657a8$A38]807M6x6K5`6*7t8e9PAAA`A[A>A;A.A*A&AA9n938t8M7}868I8W8n8%8{8Z7.7N6$6K5&6_7t8i9VAGA|AV9s8*7^786P7D7]8u9K9&AG'}}, {'AttributeName': 'snow_depth:cm', 'AttributeUnitOfMeasure': 'cm', 'AttributeDescription': '[MET] snow depth  [cm]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 1, 'encoding_size': 91, 'float_precision': 0, 'data': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'}}, {'AttributeName': 'sfc_pressure:hPa', 'AttributeUnitOfMeasure': 'hPa', 'AttributeDescription': '[MET] surface preasure [hPa]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 3, 'encoding_size': 91, 'float_precision': 1, 'data': '1Ld1Lg1Lm1Ls1Lx1L!1L&1L,1L,1L,1L,1L,1L+1L+1L/1L=1L@1L}1M01M51M51M51M51M51M51M51M71M91MB1MC1MC1MC1M91M61M21L~1L`1L[1L@1L?1L>1L@1L]1L`1L]1L?1L=1L;1L/1L+1L)1L&1L$1Lz1Lu1Lp1Lk1Lf1La1LU1LN1LG1LA1L31K}1K^1K@1K=1K:1K.1K*1K%1K_1Kx1Ku1Kq1Km1Kj1Kg1Kd1Ka1KX1KU1KS1KQ1KO1KN1KL1KJ1KI1KI1KH1KH1KG1KG1KF1KE1KD1KC1KB1KA1K91K71K61K41K31K11J~1J{1J`1J]1J@1J>1J?1J[1J]1J^1J}1J{1J{1J{1J}1J}1J}1J}1J`1J^1J]1J[1J@1J?1J^1J{1K01K31K61K91KB1KC1KE1KF1KH1KI'}}, {'AttributeName': 'total_cloud_cover:p', 'AttributeUnitOfMeasure': '%', 'AttributeDescription': '[MET] total cloud cover [%]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '5G5W5W5W5W7i9BAN9u8`8L795*4O2|1q050402000001012O4N5~5]636S4^3l265/8pAPAqA+A`A}A{A|A`A[A?A[A^A{A*Ac9=9E8M7D6*6b635x5N4<4H3l2;2H1l0;2Y3@5d6}8iA1ASAoA&A>A}A~A%9|8%704(233u5C6q7[9EAN9q9I9C9W9;AtAzA%A,A<A]A~A|A|A{A{A}A`A;A(A-AuAqAmASADA19]9?9?9(9#9+A1AYA[A]A`A}A{A|A~A,AQ9l8o7e6P7D7]8u9K9&AG'}}, {'AttributeName': 'visibility:km', 'AttributeUnitOfMeasure': 'km', 'AttributeDescription': '[MET] visibility [km]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '2^31363B3G3b3w3<3~4B4M4g4z4?4r4P3{3.3z3m3b3R3G3B37323C3M3U3d3n3w3r3l3f3h3j3l3r3y3%3u3i3W3I342?2{343B3I3Q3Y3j3u3%3;3{4746454342403|3^3@3=3:3,3)3)3*3+3+3.3.3<3@3^3|42463~3[3:3(3-3t3i3X3N3C322@2[2]2]2^2}2{3A3M3Z3m3z3.3*3%3_3x3u3q352o251o150o0(0}1E1X1q1)1k1M0|0#0e0G0&1T1>2f323r3o3m3k3h3f3d'}}, {'AttributeName': 'wet_bulb_t_2m:C', 'AttributeUnitOfMeasure': '°C', 'AttributeDescription': '[MET] wet bulb temperature at 2m [C]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': True, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': 'jqjqjqjqjqjzj(j/j:j;j<j:j.j+j*j)j&j-jtjljfjYjRjPjNjLjSjZjgj_j[kAkDkGkIkJkJkKkLkMkMkFk9k1j`j>j.j+j(j%j#j-jyj*j?j|k6kDkKkKkJkJkJkJkIkDk9k4j|j]j=j;j:j.j,j*j)j@k2kDkOkZkmkpkskvkyk_k$k-kxktkqkmkjkkklkmknkokpkxk&k;k`l4lDlElFlGlHlHlIlFlBl8l4l1k{k`k]k@k=k;k/k:k<k=k?k[k]k;k*k!kwkqkkkjkikikhkhkg'}}, {'AttributeName': 'wind_dir_20m:d', 'AttributeUnitOfMeasure': '°', 'AttributeDescription': '[MET] wind direction at 20m', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': 'dfc[ckc6brdU0=1s0^0Ld5dl0e0}0#0adl0t1b2ccDW(U9RXOPL`L!LkLVMBN0N{O<Q7RyRTQ^QlT>022v6%AsCvD&E}GGGeGyG<H3HHHUG?GkGEF;FqFTE|EvEPD@DnDFD!EJE-FAFjF;F&FwFnFeFVFMF(GRG:HYH[IdIeIeIdIdIcIZIPIHIAI3H|H]H)HvHhHUHGH3HYH&IBIlI]JWI]IeH]HVG#G5HAI8I}J!KUK<K)K-KqKgKVKJLCMTN)PaR1SdSVSNSFS7R|R?Q;Q4PeO{OsOQ'}}, {'AttributeName': 'wind_dir_50m:d', 'AttributeUnitOfMeasure': '°', 'AttributeDescription': '[MET] wind direction at 50m', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '0TdadBc/cj0H131u0}0Nd7dl0c0[0z0Z020q1R2WcNXgU@R}O~M?MnMLL|MpNNO5O]QAR-RTQ]QjUV0C2k7BB8C~EDFXGoG)G{HEHSHfHrHEG(GYG1FyFUE{EtEOD]DsDOD.EUE,FLFwF~F?F+F_FsFjFaF=GWG<HYH[IfIkIpIuIzI$I*IxImIdIVIOIHI5H[H)HvHiHUHuH]IMIsI{JXI]IhH~HjG{GdHdIXJIJ`KrLBL3K^K/K#KsKgLSMaN(PVQ|SjScSWSPSJSDS6R3QLPtPBO$Ob'}}, {'AttributeName': 'wind_gusts_10m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': '[MET] wind gusts at 10m [m/s]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '0.0(0#0z0v0w0v0t0r0p0m0m0l0k0k0m0n0c0R0L0M0O0T0U0W0a0d0g0k0d0X0T0Q0N0K0K0J0I0I0J0L0R0X0d0e0e0f0j0n0r0w0-0$0!0z0x0u0t0t0y0#0)0:0?0`141D1N1W1f1o1m1j1h1e1b1Z1Q1H180~0@0<0:0.0+0)0(0&0&0%0%0%0(0+0*0)0(0)0*0+0(0$0%0(0)0*0(0%0$0$0%0&0+0;0?0`0~140`0:0%0w0u0r0o0l0i0i0j0k0q0v0-0&0,0<0{14191F1K1R'}}, {'AttributeName': 'wind_gusts_20m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': '[MET] wind gusts at 20m [m/s]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '0:0*0%0_0x0y0x0w0u0r0q0p0n0m0l0n0o0c0R0O0Q0R0T0V0W0a0d0h0k0e0Z0X0U0R0N0N0M0L0L0M0M0R0X0d0e0f0g0k0o0s0w0_0%0!0-0y0w0w0w0_0&0,0<0]0|171H1Q1Z1j1s1q1n1k1i1f1d1T1K1B120`0@0>0<0:0,0*0)0)0)0)0)0)0,0+0*0+0,0.0/0+0(0*0+0.0.0+0)0(0(0(0)0/0=0]0{12170{0=0)0y0u0s0p0l0j0k0l0m0r0x0!0)0/0?0~171D1J1P1V'}}, {'AttributeName': 'wind_gusts_50m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': '[MET] wind gusts at 50m [m/s]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '0?0/0*0%0-0!0-0!0-0z0x0v0u0t0p0n0p0d0X0S0T0V0W0Z0b0d0h0k0o0k0f0b0Y0U0Q0P0O0N0O0P0Q0V0a0f0f0f0h0l0p0u0y0!0&0$0_0z0z0-0!0%0+0;0@0{131C1M1W1f1p1z1w1t1q1o1l1i1Y1P1F16100`0]0@0>0<0:0.0.0/0/0:0;0=0<0:0:0;0<0=0:0/0:0;0<0=0;0/0.0,0.0.0<0[0{11161B110[0,0!0y0v0t0r0o0m0m0n0t0z0%0,0=0^141D1J1P1W1c'}}, {'AttributeName': 'wind_speed_20m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': '[MET] wind speed at 20m [m/s]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 1, 'encoding_size': 91, 'float_precision': 1, 'data': 'TRQPOUbhgfedcbWSOMJHIJKLMNPRTSQOMJGFFEEFFIKNMMLNOQSTVXZbdfhhhggffhjlnprrsssstttssssojfbWSUWZbegggggggfedccbZYXVUTVXacehfedbaYXWVTSRRRRRRRWbglqv'}}, {'AttributeName': 'wind_speed_50m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': '[MET] wind speed at 50m [m/s]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 1, 'encoding_size': 91, 'float_precision': 1, 'data': 'ecaYWciomlkihgdaXSOJLMOPRTWZcZVSOLIHHGHIJNRVVUUWYabdfgijlmoopqqrsuxz!$(((((((&%$#!_xtpkgcfimpsvvuuttsqpnljhggfeedgjlortrqomkigecaYWXXYYZZflrx#*'}}, {'AttributeName': 'wind_speed_10m:ms', 'AttributeUnitOfMeasure': 'm/s', 'AttributeDescription': '[MET] wind speed at 10m [m/s]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 1, 'encoding_size': 91, 'float_precision': 1, 'data': 'MLKJJOUaZYXWVURNJHGEFGHHIIKMNMLKIGDDCCCCCEGIHHHIJKMNOQSUWYaaZYYXXYacdfhhhhiiiiijjjjfbXTQMOPRTVXXXXXXXXWWVVVTSRPONPRSUWYXWVUTRRQPONMMMMMMMQUYcgk'}}, {'AttributeName': 't_2m:C', 'AttributeUnitOfMeasure': '°C', 'AttributeDescription': 'temperature at 2m [C]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': True, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': 'jxjxjyjyjyj:k1kHkMkRkWkWkXkXkOkEk5j]j+jzjqjhjZjWjUjSjajjjrj<kBkZkkkuk$k$k%k%kxkokfkWkMkCk4j}j>j<j;j/j.j+j*j}kCkRkhkxk/k+k(k%k!kzkwkpkhkakSkLkDkCkAk9k7k6k4kKkakqk%k[l8l7l7l7l7l6l6k~k[k:k(k-ktkvkwkxkyk-k_k;l0lDlRlfltlrlplnllljlhlalTlMlGl9l2l0k{k^k@k=k:k>k[k`k|l2l5l1k|k^k?k<k.k+k*k(k%k$k!'}}, {'AttributeName': 'air_density_100m:kgm3', 'AttributeUnitOfMeasure': 'kg/m³', 'AttributeDescription': 'The density of air at any height level above ground up to 10 km', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 3, 'data': 'D~D~E0E1E2E0D|D}D^D[D?D>D=D=D?D[D^D}D|E0E1E2E3E4E4E4E3E2E1D|D^D@D;D+D%D$D#D!D#D$D%D&D)D*D+D,D.D/D/D:D;D<D=D/D+D&D!DzDvDuDtDrDqDpDnDqDtDwDzD!D%D%D&D(D)D*D+D#DxDrDkDeDYDWDUDSDRDPDNDPDSDUDXDZDbDbDcDcDcDcDcDXDRDMDHDCD7D6D5D5D4D3D3D6D9DCDFDJDMDNDPDQDRDSDUDTDSDRDQDPDODQDSDUDWDYDaDbDbDcDdDdDe'}}, {'AttributeName': 'high_cloud_cover:p', 'AttributeUnitOfMeasure': '%', 'AttributeDescription': 'high cloud cover [%]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '00000000000000000000000000000000000000000000000000000000000000000000003N6k9)A7AYA-A%A+A:A:A/A.AF9k8<8I7o6@6p6K5>5n5I4<4H3l2;2H1l0;2Y3@5d6}8iA1AGAVAjAyA/A~9E7U5j3y1:000_1a282*3i4G5M6S7X8d9jApApApApAqAqAqAiAaARAJABA3A4A4A5A6A7A89p928j7}7d6@7p8L8@9qALA@A[A[A[A]A]A]9A7Q5g3w1/00000000000000'}}, {'AttributeName': 'medium_cloud_cover:p', 'AttributeUnitOfMeasure': '%', 'AttributeDescription': 'amount of medium cloud cover [%]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '00000000002F4U6k6W6I654`3:2$1/0[000000000001011M2g3-2u1n0h0T0E002_5Y868V8v8[999R9i734q2B4t779p876s5A3v2D0y0o0e0U0K0A000000000000000000000000001/3x5h7R9BA`9g7{6i503l231&1f1F0>0s0S0f0s0%0?131G2+4c647y9QA@A;A*A$AyAtAn9P816%5h4I2^3s4N4[5q6L6?5%4s3e2R1D001/3y5i7S9DA{9u8P6]5q4K2>3(4w5m6b7Q8G'}}, {'AttributeName': 'low_cloud_cover:p', 'AttributeUnitOfMeasure': '%', 'AttributeDescription': 'low cloud cover [%]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 2, 'encoding_size': 91, 'float_precision': 1, 'data': '5G5W5W5W5W6v7@9H7%6R4<3]2|241Z0$050402000000001E2S3h4V5K694(3b264E6M8U8m8#8[8j867x5]4H2g1+1C0g0Z0S0L0E07010000000000000000000000000000000000000000000000000000000000001v3N4?6l8D9)8F6o4`3U1$0A0A0A090909090807070605050t1D1_2M2*3U3R3N3K3H3D3A2_2P1<1e110s0&0@151K1Y1m232o353q484s5D5-6K6(7R7:'}}, {'AttributeName': 'msl_pressure:hPa', 'AttributeUnitOfMeasure': 'hPa', 'AttributeDescription': 'mean sea level pressure [hPa]', 'AttributeDataType': 'Numeric', 'Values': {'encoder': 'TimeSeriesEncoder', 'start': 1618192800.0, 'interval': 3600.0, 'signed': False, 'ts_key': 'UTC', 'ts_value': 'Value', 'encoding_depth': 3, 'encoding_size': 91, 'float_precision': 1, 'data': '1Lt1Lw1L!1L)1L:1L>1L^1L|1L|1L|1L|1L|1L{1L{1M01M41M71MC1MG1ML1ML1MM1MM1MM1MM1MM1MO1MQ1MS1MS1MS1MT1MP1MM1MI1MF1MB1M81M71M61M51M71M91MB1M91M71M41M21M01L|1L}1L]1L@1L;1L+1L%1L-1Lv1Lq1Lk1Ld1LW1LP1LJ1LC1L91L71L41L11K~1K}1K[1K=1K:1K+1K&1K!1Kz1Kw1Kt1Kq1Kn1Kk1Ki1Kg1Ke1Kc1Ka1KZ1KY1KY1KX1KX1KW1KW1KV1KU1KT1KS1KR1KQ1KO1KN1KL1KK1KI1KG1KE1KC1KA1K81K71K51K61K71K91KA1KB1KD1KC1KC1KC1KC1KC1KB1KB1KA1K91K81K71K61K91KC1KF1KJ1KM1KP1KQ1KS1KT1KV1KX1KY'}}]}]}
```
