# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class BatchAddDeviceGroupRelationsRequestDevice(TeaModel):
    def __init__(self, product_key=None, device_name=None):
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchAddDeviceGroupRelationsRequestDevice, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchAddDeviceGroupRelationsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, group_id=None, device=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.group_id = group_id  # type: str
        self.device = device  # type: list[BatchAddDeviceGroupRelationsRequestDevice]

    def validate(self):
        if self.device:
            for k in self.device:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchAddDeviceGroupRelationsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        result['Device'] = []
        if self.device is not None:
            for k in self.device:
                result['Device'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        self.device = []
        if m.get('Device') is not None:
            for k in m.get('Device'):
                temp_model = BatchAddDeviceGroupRelationsRequestDevice()
                self.device.append(temp_model.from_map(k))
        return self


class BatchAddDeviceGroupRelationsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, valid_device_count=None,
                 exceed_ten_group_device_count=None, already_related_group_device_count=None, success_added_device_count=None,
                 error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.valid_device_count = valid_device_count  # type: int
        self.exceed_ten_group_device_count = exceed_ten_group_device_count  # type: int
        self.already_related_group_device_count = already_related_group_device_count  # type: int
        self.success_added_device_count = success_added_device_count  # type: int
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchAddDeviceGroupRelationsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.valid_device_count is not None:
            result['ValidDeviceCount'] = self.valid_device_count
        if self.exceed_ten_group_device_count is not None:
            result['ExceedTenGroupDeviceCount'] = self.exceed_ten_group_device_count
        if self.already_related_group_device_count is not None:
            result['AlreadyRelatedGroupDeviceCount'] = self.already_related_group_device_count
        if self.success_added_device_count is not None:
            result['SuccessAddedDeviceCount'] = self.success_added_device_count
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ValidDeviceCount') is not None:
            self.valid_device_count = m.get('ValidDeviceCount')
        if m.get('ExceedTenGroupDeviceCount') is not None:
            self.exceed_ten_group_device_count = m.get('ExceedTenGroupDeviceCount')
        if m.get('AlreadyRelatedGroupDeviceCount') is not None:
            self.already_related_group_device_count = m.get('AlreadyRelatedGroupDeviceCount')
        if m.get('SuccessAddedDeviceCount') is not None:
            self.success_added_device_count = m.get('SuccessAddedDeviceCount')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchAddDeviceGroupRelationsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchAddDeviceGroupRelationsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchAddDeviceGroupRelationsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchAddDeviceGroupRelationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchAddThingTopoRequestTopoAddItem(TeaModel):
    def __init__(self, product_key=None, device_name=None, sign=None, sign_method=None, timestamp=None,
                 client_id=None):
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.sign = sign  # type: str
        self.sign_method = sign_method  # type: str
        self.timestamp = timestamp  # type: str
        self.client_id = client_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchAddThingTopoRequestTopoAddItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.sign is not None:
            result['Sign'] = self.sign
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Sign') is not None:
            self.sign = m.get('Sign')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        return self


class BatchAddThingTopoRequest(TeaModel):
    def __init__(self, iot_instance_id=None, topo_add_item=None, gw_product_key=None, gw_device_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.topo_add_item = topo_add_item  # type: list[BatchAddThingTopoRequestTopoAddItem]
        self.gw_product_key = gw_product_key  # type: str
        self.gw_device_name = gw_device_name  # type: str

    def validate(self):
        if self.topo_add_item:
            for k in self.topo_add_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchAddThingTopoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['TopoAddItem'] = []
        if self.topo_add_item is not None:
            for k in self.topo_add_item:
                result['TopoAddItem'].append(k.to_map() if k else None)
        if self.gw_product_key is not None:
            result['GwProductKey'] = self.gw_product_key
        if self.gw_device_name is not None:
            result['GwDeviceName'] = self.gw_device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.topo_add_item = []
        if m.get('TopoAddItem') is not None:
            for k in m.get('TopoAddItem'):
                temp_model = BatchAddThingTopoRequestTopoAddItem()
                self.topo_add_item.append(temp_model.from_map(k))
        if m.get('GwProductKey') is not None:
            self.gw_product_key = m.get('GwProductKey')
        if m.get('GwDeviceName') is not None:
            self.gw_device_name = m.get('GwDeviceName')
        return self


class BatchAddThingTopoResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchAddThingTopoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchAddThingTopoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchAddThingTopoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchAddThingTopoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchAddThingTopoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchBindDevicesIntoProjectRequestDevices(TeaModel):
    def __init__(self, product_key=None, device_name=None):
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchBindDevicesIntoProjectRequestDevices, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchBindDevicesIntoProjectRequest(TeaModel):
    def __init__(self, iot_instance_id=None, devices=None, project_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.devices = devices  # type: list[BatchBindDevicesIntoProjectRequestDevices]
        self.project_id = project_id  # type: str

    def validate(self):
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchBindDevicesIntoProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = BatchBindDevicesIntoProjectRequestDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchBindDevicesIntoProjectResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchBindDevicesIntoProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class BatchBindDevicesIntoProjectResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchBindDevicesIntoProjectResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchBindDevicesIntoProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchBindDevicesIntoProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchBindDeviceToEdgeInstanceWithDriverRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None, iot_ids=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.driver_id = driver_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchBindDeviceToEdgeInstanceWithDriverRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchBindDeviceToEdgeInstanceWithDriverResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchBindDeviceToEdgeInstanceWithDriverResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchBindDeviceToEdgeInstanceWithDriverResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchBindDeviceToEdgeInstanceWithDriverResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchBindDeviceToEdgeInstanceWithDriverResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchBindDeviceToEdgeInstanceWithDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchBindProductsIntoProjectRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_keys=None, project_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_keys = product_keys  # type: list[str]
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchBindProductsIntoProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_keys is not None:
            result['ProductKeys'] = self.product_keys
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKeys') is not None:
            self.product_keys = m.get('ProductKeys')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchBindProductsIntoProjectResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchBindProductsIntoProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class BatchBindProductsIntoProjectResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchBindProductsIntoProjectResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchBindProductsIntoProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchBindProductsIntoProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCheckDeviceNamesRequestDeviceNameList(TeaModel):
    def __init__(self, device_name=None, device_nickname=None):
        self.device_name = device_name  # type: str
        self.device_nickname = device_nickname  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCheckDeviceNamesRequestDeviceNameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_nickname is not None:
            result['DeviceNickname'] = self.device_nickname
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceNickname') is not None:
            self.device_nickname = m.get('DeviceNickname')
        return self


class BatchCheckDeviceNamesRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None, device_name_list=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: list[str]
        self.device_name_list = device_name_list  # type: list[BatchCheckDeviceNamesRequestDeviceNameList]

    def validate(self):
        if self.device_name_list:
            for k in self.device_name_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchCheckDeviceNamesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        result['DeviceNameList'] = []
        if self.device_name_list is not None:
            for k in self.device_name_list:
                result['DeviceNameList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        self.device_name_list = []
        if m.get('DeviceNameList') is not None:
            for k in m.get('DeviceNameList'):
                temp_model = BatchCheckDeviceNamesRequestDeviceNameList()
                self.device_name_list.append(temp_model.from_map(k))
        return self


class BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNameList(TeaModel):
    def __init__(self, invalid_device_name=None):
        self.invalid_device_name = invalid_device_name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_device_name is not None:
            result['InvalidDeviceName'] = self.invalid_device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InvalidDeviceName') is not None:
            self.invalid_device_name = m.get('InvalidDeviceName')
        return self


class BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNicknameList(TeaModel):
    def __init__(self, invalid_device_nickname=None):
        self.invalid_device_nickname = invalid_device_nickname  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNicknameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_device_nickname is not None:
            result['InvalidDeviceNickname'] = self.invalid_device_nickname
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InvalidDeviceNickname') is not None:
            self.invalid_device_nickname = m.get('InvalidDeviceNickname')
        return self


class BatchCheckDeviceNamesResponseBodyData(TeaModel):
    def __init__(self, apply_id=None, invalid_device_name_list=None, invalid_device_nickname_list=None):
        self.apply_id = apply_id  # type: long
        self.invalid_device_name_list = invalid_device_name_list  # type: BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNameList
        self.invalid_device_nickname_list = invalid_device_nickname_list  # type: BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNicknameList

    def validate(self):
        if self.invalid_device_name_list:
            self.invalid_device_name_list.validate()
        if self.invalid_device_nickname_list:
            self.invalid_device_nickname_list.validate()

    def to_map(self):
        _map = super(BatchCheckDeviceNamesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        if self.invalid_device_name_list is not None:
            result['InvalidDeviceNameList'] = self.invalid_device_name_list.to_map()
        if self.invalid_device_nickname_list is not None:
            result['InvalidDeviceNicknameList'] = self.invalid_device_nickname_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        if m.get('InvalidDeviceNameList') is not None:
            temp_model = BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNameList()
            self.invalid_device_name_list = temp_model.from_map(m['InvalidDeviceNameList'])
        if m.get('InvalidDeviceNicknameList') is not None:
            temp_model = BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNicknameList()
            self.invalid_device_nickname_list = temp_model.from_map(m['InvalidDeviceNicknameList'])
        return self


class BatchCheckDeviceNamesResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: BatchCheckDeviceNamesResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchCheckDeviceNamesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = BatchCheckDeviceNamesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchCheckDeviceNamesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchCheckDeviceNamesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchCheckDeviceNamesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchCheckDeviceNamesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchClearEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, iot_ids=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchClearEdgeInstanceDeviceConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchClearEdgeInstanceDeviceConfigResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchClearEdgeInstanceDeviceConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchClearEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchClearEdgeInstanceDeviceConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchClearEdgeInstanceDeviceConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchClearEdgeInstanceDeviceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteDeviceGroupRelationsRequestDevice(TeaModel):
    def __init__(self, product_key=None, device_name=None):
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchDeleteDeviceGroupRelationsRequestDevice, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchDeleteDeviceGroupRelationsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, group_id=None, device=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.group_id = group_id  # type: str
        self.device = device  # type: list[BatchDeleteDeviceGroupRelationsRequestDevice]

    def validate(self):
        if self.device:
            for k in self.device:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchDeleteDeviceGroupRelationsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        result['Device'] = []
        if self.device is not None:
            for k in self.device:
                result['Device'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        self.device = []
        if m.get('Device') is not None:
            for k in m.get('Device'):
                temp_model = BatchDeleteDeviceGroupRelationsRequestDevice()
                self.device.append(temp_model.from_map(k))
        return self


class BatchDeleteDeviceGroupRelationsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, valid_device_count=None,
                 already_related_group_device_count=None, success_device_count=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.valid_device_count = valid_device_count  # type: int
        self.already_related_group_device_count = already_related_group_device_count  # type: int
        self.success_device_count = success_device_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchDeleteDeviceGroupRelationsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.valid_device_count is not None:
            result['ValidDeviceCount'] = self.valid_device_count
        if self.already_related_group_device_count is not None:
            result['AlreadyRelatedGroupDeviceCount'] = self.already_related_group_device_count
        if self.success_device_count is not None:
            result['SuccessDeviceCount'] = self.success_device_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ValidDeviceCount') is not None:
            self.valid_device_count = m.get('ValidDeviceCount')
        if m.get('AlreadyRelatedGroupDeviceCount') is not None:
            self.already_related_group_device_count = m.get('AlreadyRelatedGroupDeviceCount')
        if m.get('SuccessDeviceCount') is not None:
            self.success_device_count = m.get('SuccessDeviceCount')
        return self


class BatchDeleteDeviceGroupRelationsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchDeleteDeviceGroupRelationsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchDeleteDeviceGroupRelationsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchDeleteDeviceGroupRelationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteEdgeInstanceChannelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None, channel_ids=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.driver_id = driver_id  # type: str
        self.channel_ids = channel_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchDeleteEdgeInstanceChannelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_ids is not None:
            result['ChannelIds'] = self.channel_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelIds') is not None:
            self.channel_ids = m.get('ChannelIds')
        return self


class BatchDeleteEdgeInstanceChannelResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchDeleteEdgeInstanceChannelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchDeleteEdgeInstanceChannelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchDeleteEdgeInstanceChannelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchDeleteEdgeInstanceChannelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchDeleteEdgeInstanceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetDeviceBindStatusRequest(TeaModel):
    def __init__(self, iot_instance_id=None, iot_ids=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetDeviceBindStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetDeviceBindStatusResponseBodyData(TeaModel):
    def __init__(self, iot_id=None, bind_status=None):
        self.iot_id = iot_id  # type: str
        self.bind_status = bind_status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetDeviceBindStatusResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.bind_status is not None:
            result['BindStatus'] = self.bind_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('BindStatus') is not None:
            self.bind_status = m.get('BindStatus')
        return self


class BatchGetDeviceBindStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: list[BatchGetDeviceBindStatusResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetDeviceBindStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchGetDeviceBindStatusResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class BatchGetDeviceBindStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchGetDeviceBindStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchGetDeviceBindStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetDeviceBindStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetDeviceStateRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, product_key=None, iot_id=None):
        self.device_name = device_name  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.iot_id = iot_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetDeviceStateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetDeviceStateResponseBodyDeviceStatusListDeviceStatus(TeaModel):
    def __init__(self, device_id=None, device_name=None, status=None, as_address=None, last_online_time=None,
                 iot_id=None):
        self.device_id = device_id  # type: str
        self.device_name = device_name  # type: str
        self.status = status  # type: str
        self.as_address = as_address  # type: str
        self.last_online_time = last_online_time  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetDeviceStateResponseBodyDeviceStatusListDeviceStatus, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.status is not None:
            result['Status'] = self.status
        if self.as_address is not None:
            result['AsAddress'] = self.as_address
        if self.last_online_time is not None:
            result['LastOnlineTime'] = self.last_online_time
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('AsAddress') is not None:
            self.as_address = m.get('AsAddress')
        if m.get('LastOnlineTime') is not None:
            self.last_online_time = m.get('LastOnlineTime')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetDeviceStateResponseBodyDeviceStatusList(TeaModel):
    def __init__(self, device_status=None):
        self.device_status = device_status  # type: list[BatchGetDeviceStateResponseBodyDeviceStatusListDeviceStatus]

    def validate(self):
        if self.device_status:
            for k in self.device_status:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetDeviceStateResponseBodyDeviceStatusList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceStatus'] = []
        if self.device_status is not None:
            for k in self.device_status:
                result['DeviceStatus'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_status = []
        if m.get('DeviceStatus') is not None:
            for k in m.get('DeviceStatus'):
                temp_model = BatchGetDeviceStateResponseBodyDeviceStatusListDeviceStatus()
                self.device_status.append(temp_model.from_map(k))
        return self


class BatchGetDeviceStateResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, device_status_list=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.device_status_list = device_status_list  # type: BatchGetDeviceStateResponseBodyDeviceStatusList

    def validate(self):
        if self.device_status_list:
            self.device_status_list.validate()

    def to_map(self):
        _map = super(BatchGetDeviceStateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.device_status_list is not None:
            result['DeviceStatusList'] = self.device_status_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('DeviceStatusList') is not None:
            temp_model = BatchGetDeviceStateResponseBodyDeviceStatusList()
            self.device_status_list = temp_model.from_map(m['DeviceStatusList'])
        return self


class BatchGetDeviceStateResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchGetDeviceStateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchGetDeviceStateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetDeviceStateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeDriverRequest(TeaModel):
    def __init__(self, iot_instance_id=None, driver_ids=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.driver_ids = driver_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeDriverRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_ids is not None:
            result['DriverIds'] = self.driver_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverIds') is not None:
            self.driver_ids = m.get('DriverIds')
        return self


class BatchGetEdgeDriverResponseBodyDriverList(TeaModel):
    def __init__(self, driver_id=None, driver_name=None, driver_protocol=None, runtime=None, cpu_arch=None,
                 type=None, is_built_in=None, gmt_create_timestamp=None, gmt_modified_timestamp=None):
        self.driver_id = driver_id  # type: str
        self.driver_name = driver_name  # type: str
        self.driver_protocol = driver_protocol  # type: str
        self.runtime = runtime  # type: str
        self.cpu_arch = cpu_arch  # type: str
        self.type = type  # type: int
        self.is_built_in = is_built_in  # type: bool
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeDriverResponseBodyDriverList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        if self.driver_protocol is not None:
            result['DriverProtocol'] = self.driver_protocol
        if self.runtime is not None:
            result['Runtime'] = self.runtime
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.type is not None:
            result['Type'] = self.type
        if self.is_built_in is not None:
            result['IsBuiltIn'] = self.is_built_in
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        if m.get('DriverProtocol') is not None:
            self.driver_protocol = m.get('DriverProtocol')
        if m.get('Runtime') is not None:
            self.runtime = m.get('Runtime')
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('IsBuiltIn') is not None:
            self.is_built_in = m.get('IsBuiltIn')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        return self


class BatchGetEdgeDriverResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, driver_list=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.driver_list = driver_list  # type: list[BatchGetEdgeDriverResponseBodyDriverList]

    def validate(self):
        if self.driver_list:
            for k in self.driver_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeDriverResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DriverList'] = []
        if self.driver_list is not None:
            for k in self.driver_list:
                result['DriverList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.driver_list = []
        if m.get('DriverList') is not None:
            for k in m.get('DriverList'):
                temp_model = BatchGetEdgeDriverResponseBodyDriverList()
                self.driver_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeDriverResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchGetEdgeDriverResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchGetEdgeDriverResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceChannelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None, channel_ids=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.driver_id = driver_id  # type: str
        self.channel_ids = channel_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_ids is not None:
            result['ChannelIds'] = self.channel_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelIds') is not None:
            self.channel_ids = m.get('ChannelIds')
        return self


class BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigListConfig(TeaModel):
    def __init__(self, config_id=None, format=None, content=None, key=None):
        self.config_id = config_id  # type: str
        self.format = format  # type: str
        self.content = content  # type: str
        self.key = key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigListConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigList(TeaModel):
    def __init__(self, config=None):
        self.config = config  # type: list[BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigListConfig]

    def validate(self):
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigListConfig()
                self.config.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceChannelResponseBodyDataChannel(TeaModel):
    def __init__(self, channel_id=None, channel_name=None, config_list=None):
        self.channel_id = channel_id  # type: str
        self.channel_name = channel_name  # type: str
        self.config_list = config_list  # type: BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigList

    def validate(self):
        if self.config_list:
            self.config_list.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelResponseBodyDataChannel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.config_list is not None:
            result['ConfigList'] = self.config_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ConfigList') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigList()
            self.config_list = temp_model.from_map(m['ConfigList'])
        return self


class BatchGetEdgeInstanceChannelResponseBodyData(TeaModel):
    def __init__(self, channel=None):
        self.channel = channel  # type: list[BatchGetEdgeInstanceChannelResponseBodyDataChannel]

    def validate(self):
        if self.channel:
            for k in self.channel:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Channel'] = []
        if self.channel is not None:
            for k in self.channel:
                result['Channel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.channel = []
        if m.get('Channel') is not None:
            for k in m.get('Channel'):
                temp_model = BatchGetEdgeInstanceChannelResponseBodyDataChannel()
                self.channel.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceChannelResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: BatchGetEdgeInstanceChannelResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchGetEdgeInstanceChannelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchGetEdgeInstanceChannelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceChannelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDeviceChannelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None, iot_ids=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.driver_id = driver_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceChannelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetEdgeInstanceDeviceChannelResponseBodyDeviceChannelList(TeaModel):
    def __init__(self, channel_id=None, channel_name=None, iot_id=None):
        self.channel_id = channel_id  # type: str
        self.channel_name = channel_name  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceChannelResponseBodyDeviceChannelList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceChannelResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, device_channel_list=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.device_channel_list = device_channel_list  # type: list[BatchGetEdgeInstanceDeviceChannelResponseBodyDeviceChannelList]

    def validate(self):
        if self.device_channel_list:
            for k in self.device_channel_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceChannelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DeviceChannelList'] = []
        if self.device_channel_list is not None:
            for k in self.device_channel_list:
                result['DeviceChannelList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.device_channel_list = []
        if m.get('DeviceChannelList') is not None:
            for k in m.get('DeviceChannelList'):
                temp_model = BatchGetEdgeInstanceDeviceChannelResponseBodyDeviceChannelList()
                self.device_channel_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDeviceChannelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchGetEdgeInstanceDeviceChannelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceChannelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDeviceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, iot_ids=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigListConfig(TeaModel):
    def __init__(self, format=None, content=None):
        self.format = format  # type: str
        self.content = content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigListConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigList(TeaModel):
    def __init__(self, iot_id=None, config=None):
        self.iot_id = iot_id  # type: str
        self.config = config  # type: BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigListConfig

    def validate(self):
        if self.config:
            self.config.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.config is not None:
            result['Config'] = self.config.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Config') is not None:
            temp_model = BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigListConfig()
            self.config = temp_model.from_map(m['Config'])
        return self


class BatchGetEdgeInstanceDeviceConfigResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, device_config_list=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.device_config_list = device_config_list  # type: list[BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigList]

    def validate(self):
        if self.device_config_list:
            for k in self.device_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DeviceConfigList'] = []
        if self.device_config_list is not None:
            for k in self.device_config_list:
                result['DeviceConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.device_config_list = []
        if m.get('DeviceConfigList') is not None:
            for k in m.get('DeviceConfigList'):
                temp_model = BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigList()
                self.device_config_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchGetEdgeInstanceDeviceConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDeviceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDeviceDriverRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, iot_ids=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceDriverRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetEdgeInstanceDeviceDriverResponseBodyDeviceDriverList(TeaModel):
    def __init__(self, driver_id=None, iot_id=None):
        self.driver_id = driver_id  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceDriverResponseBodyDeviceDriverList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceDriverResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, device_driver_list=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.device_driver_list = device_driver_list  # type: list[BatchGetEdgeInstanceDeviceDriverResponseBodyDeviceDriverList]

    def validate(self):
        if self.device_driver_list:
            for k in self.device_driver_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceDriverResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DeviceDriverList'] = []
        if self.device_driver_list is not None:
            for k in self.device_driver_list:
                result['DeviceDriverList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.device_driver_list = []
        if m.get('DeviceDriverList') is not None:
            for k in m.get('DeviceDriverList'):
                temp_model = BatchGetEdgeInstanceDeviceDriverResponseBodyDeviceDriverList()
                self.device_driver_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDeviceDriverResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchGetEdgeInstanceDeviceDriverResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDeviceDriverResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDeviceDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDriverConfigsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_ids=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.driver_ids = driver_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDriverConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_ids is not None:
            result['DriverIds'] = self.driver_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverIds') is not None:
            self.driver_ids = m.get('DriverIds')
        return self


class BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigListConfigList(TeaModel):
    def __init__(self, config_id=None, format=None, content=None, key=None):
        self.config_id = config_id  # type: str
        self.format = format  # type: str
        self.content = content  # type: str
        self.key = key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigListConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigList(TeaModel):
    def __init__(self, driver_id=None, config_list=None):
        self.driver_id = driver_id  # type: str
        self.config_list = config_list  # type: list[BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigListConfigList]

    def validate(self):
        if self.config_list:
            for k in self.config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        result['ConfigList'] = []
        if self.config_list is not None:
            for k in self.config_list:
                result['ConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        self.config_list = []
        if m.get('ConfigList') is not None:
            for k in m.get('ConfigList'):
                temp_model = BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigListConfigList()
                self.config_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDriverConfigsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, driver_config_list=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.driver_config_list = driver_config_list  # type: list[BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigList]

    def validate(self):
        if self.driver_config_list:
            for k in self.driver_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDriverConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DriverConfigList'] = []
        if self.driver_config_list is not None:
            for k in self.driver_config_list:
                result['DriverConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.driver_config_list = []
        if m.get('DriverConfigList') is not None:
            for k in m.get('DriverConfigList'):
                temp_model = BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigList()
                self.driver_config_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDriverConfigsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchGetEdgeInstanceDriverConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchGetEdgeInstanceDriverConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDriverConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchPubRequest(TeaModel):
    def __init__(self, iot_instance_id=None, device_name=None, product_key=None, qos=None, topic_short_name=None,
                 message_content=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.device_name = device_name  # type: list[str]
        self.product_key = product_key  # type: str
        self.qos = qos  # type: int
        self.topic_short_name = topic_short_name  # type: str
        self.message_content = message_content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchPubRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.qos is not None:
            result['Qos'] = self.qos
        if self.topic_short_name is not None:
            result['TopicShortName'] = self.topic_short_name
        if self.message_content is not None:
            result['MessageContent'] = self.message_content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Qos') is not None:
            self.qos = m.get('Qos')
        if m.get('TopicShortName') is not None:
            self.topic_short_name = m.get('TopicShortName')
        if m.get('MessageContent') is not None:
            self.message_content = m.get('MessageContent')
        return self


class BatchPubResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchPubResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchPubResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchPubResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchPubResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchPubResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchQueryDeviceDetailRequest(TeaModel):
    def __init__(self, device_name=None, product_key=None, iot_instance_id=None):
        self.device_name = device_name  # type: list[str]
        self.product_key = product_key  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchQueryDeviceDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class BatchQueryDeviceDetailResponseBodyDataData(TeaModel):
    def __init__(self, product_key=None, product_name=None, device_name=None, nickname=None, device_secret=None,
                 iot_id=None, utc_create=None, gmt_create=None, utc_active=None, gmt_active=None, status=None,
                 firmware_version=None, node_type=None, region=None):
        self.product_key = product_key  # type: str
        self.product_name = product_name  # type: str
        self.device_name = device_name  # type: str
        self.nickname = nickname  # type: str
        self.device_secret = device_secret  # type: str
        self.iot_id = iot_id  # type: str
        self.utc_create = utc_create  # type: str
        self.gmt_create = gmt_create  # type: str
        self.utc_active = utc_active  # type: str
        self.gmt_active = gmt_active  # type: str
        self.status = status  # type: str
        self.firmware_version = firmware_version  # type: str
        self.node_type = node_type  # type: int
        self.region = region  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchQueryDeviceDetailResponseBodyDataData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.utc_active is not None:
            result['UtcActive'] = self.utc_active
        if self.gmt_active is not None:
            result['GmtActive'] = self.gmt_active
        if self.status is not None:
            result['Status'] = self.status
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('UtcActive') is not None:
            self.utc_active = m.get('UtcActive')
        if m.get('GmtActive') is not None:
            self.gmt_active = m.get('GmtActive')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class BatchQueryDeviceDetailResponseBodyData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[BatchQueryDeviceDetailResponseBodyDataData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchQueryDeviceDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchQueryDeviceDetailResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class BatchQueryDeviceDetailResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: BatchQueryDeviceDetailResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchQueryDeviceDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = BatchQueryDeviceDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchQueryDeviceDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchQueryDeviceDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchQueryDeviceDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchQueryDeviceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchRegisterDeviceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, count=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.count = count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchRegisterDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class BatchRegisterDeviceResponseBodyData(TeaModel):
    def __init__(self, apply_id=None):
        self.apply_id = apply_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchRegisterDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class BatchRegisterDeviceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: BatchRegisterDeviceResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchRegisterDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = BatchRegisterDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchRegisterDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchRegisterDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchRegisterDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchRegisterDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchRegisterDeviceWithApplyIdRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, apply_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.apply_id = apply_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchRegisterDeviceWithApplyIdRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class BatchRegisterDeviceWithApplyIdResponseBodyData(TeaModel):
    def __init__(self, apply_id=None):
        self.apply_id = apply_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchRegisterDeviceWithApplyIdResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class BatchRegisterDeviceWithApplyIdResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: BatchRegisterDeviceWithApplyIdResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(BatchRegisterDeviceWithApplyIdResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = BatchRegisterDeviceWithApplyIdResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class BatchRegisterDeviceWithApplyIdResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchRegisterDeviceWithApplyIdResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchRegisterDeviceWithApplyIdResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchRegisterDeviceWithApplyIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSetEdgeInstanceDeviceChannelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None, channel_id=None, iot_ids=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.driver_id = driver_id  # type: str
        self.channel_id = channel_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceChannelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchSetEdgeInstanceDeviceChannelResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceChannelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchSetEdgeInstanceDeviceChannelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchSetEdgeInstanceDeviceChannelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceChannelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchSetEdgeInstanceDeviceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs(TeaModel):
    def __init__(self, iot_id=None, content=None):
        self.iot_id = iot_id  # type: str
        self.content = content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class BatchSetEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, device_configs=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.device_configs = device_configs  # type: list[BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs]

    def validate(self):
        if self.device_configs:
            for k in self.device_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['DeviceConfigs'] = []
        if self.device_configs is not None:
            for k in self.device_configs:
                result['DeviceConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.device_configs = []
        if m.get('DeviceConfigs') is not None:
            for k in m.get('DeviceConfigs'):
                temp_model = BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs()
                self.device_configs.append(temp_model.from_map(k))
        return self


class BatchSetEdgeInstanceDeviceConfigResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchSetEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchSetEdgeInstanceDeviceConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchSetEdgeInstanceDeviceConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchSetEdgeInstanceDeviceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUnbindDeviceFromEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, iot_ids=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.iot_ids = iot_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchUnbindDeviceFromEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchUnbindDeviceFromEdgeInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchUnbindDeviceFromEdgeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchUnbindDeviceFromEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchUnbindDeviceFromEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchUnbindDeviceFromEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchUnbindDeviceFromEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUnbindProjectDevicesRequestDevices(TeaModel):
    def __init__(self, product_key=None, device_name=None):
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchUnbindProjectDevicesRequestDevices, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchUnbindProjectDevicesRequest(TeaModel):
    def __init__(self, devices=None, iot_instance_id=None, project_id=None):
        self.devices = devices  # type: list[BatchUnbindProjectDevicesRequestDevices]
        self.iot_instance_id = iot_instance_id  # type: str
        self.project_id = project_id  # type: str

    def validate(self):
        if self.devices:
            for k in self.devices:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchUnbindProjectDevicesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Devices'] = []
        if self.devices is not None:
            for k in self.devices:
                result['Devices'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.devices = []
        if m.get('Devices') is not None:
            for k in m.get('Devices'):
                temp_model = BatchUnbindProjectDevicesRequestDevices()
                self.devices.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchUnbindProjectDevicesResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchUnbindProjectDevicesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class BatchUnbindProjectDevicesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchUnbindProjectDevicesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchUnbindProjectDevicesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchUnbindProjectDevicesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUnbindProjectProductsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_keys=None, project_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_keys = product_keys  # type: list[str]
        self.project_id = project_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchUnbindProjectProductsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_keys is not None:
            result['ProductKeys'] = self.product_keys
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKeys') is not None:
            self.product_keys = m.get('ProductKeys')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class BatchUnbindProjectProductsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchUnbindProjectProductsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class BatchUnbindProjectProductsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchUnbindProjectProductsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchUnbindProjectProductsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchUnbindProjectProductsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUpdateDeviceNicknameRequestDeviceNicknameInfo(TeaModel):
    def __init__(self, product_key=None, device_name=None, nickname=None, iot_id=None):
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.nickname = nickname  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchUpdateDeviceNicknameRequestDeviceNicknameInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchUpdateDeviceNicknameRequest(TeaModel):
    def __init__(self, iot_instance_id=None, device_nickname_info=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.device_nickname_info = device_nickname_info  # type: list[BatchUpdateDeviceNicknameRequestDeviceNicknameInfo]

    def validate(self):
        if self.device_nickname_info:
            for k in self.device_nickname_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchUpdateDeviceNicknameRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['DeviceNicknameInfo'] = []
        if self.device_nickname_info is not None:
            for k in self.device_nickname_info:
                result['DeviceNicknameInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.device_nickname_info = []
        if m.get('DeviceNicknameInfo') is not None:
            for k in m.get('DeviceNicknameInfo'):
                temp_model = BatchUpdateDeviceNicknameRequestDeviceNicknameInfo()
                self.device_nickname_info.append(temp_model.from_map(k))
        return self


class BatchUpdateDeviceNicknameResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchUpdateDeviceNicknameResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BatchUpdateDeviceNicknameResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BatchUpdateDeviceNicknameResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchUpdateDeviceNicknameResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchUpdateDeviceNicknameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindApplicationToEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, application_id=None, application_version=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.application_id = application_id  # type: str
        self.application_version = application_version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindApplicationToEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_version is not None:
            result['ApplicationVersion'] = self.application_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationVersion') is not None:
            self.application_version = m.get('ApplicationVersion')
        return self


class BindApplicationToEdgeInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindApplicationToEdgeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BindApplicationToEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BindApplicationToEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindApplicationToEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindApplicationToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindDriverToEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None, driver_version=None, order_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.driver_id = driver_id  # type: str
        self.driver_version = driver_version  # type: str
        self.order_id = order_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindDriverToEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class BindDriverToEdgeInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindDriverToEdgeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BindDriverToEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BindDriverToEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindDriverToEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindDriverToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindGatewayToEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, product_key=None, device_name=None, iot_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindGatewayToEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BindGatewayToEdgeInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindGatewayToEdgeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BindGatewayToEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BindGatewayToEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindGatewayToEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindGatewayToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindRoleToEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, role_arn=None, role_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.role_arn = role_arn  # type: str
        self.role_name = role_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindRoleToEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        return self


class BindRoleToEdgeInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindRoleToEdgeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class BindRoleToEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BindRoleToEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindRoleToEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindRoleToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindSceneRuleToEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindSceneRuleToEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class BindSceneRuleToEdgeInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BindSceneRuleToEdgeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class BindSceneRuleToEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: BindSceneRuleToEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BindSceneRuleToEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindSceneRuleToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, job_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelJobResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CancelJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CancelJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOTAStrategyByJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, job_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelOTAStrategyByJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelOTAStrategyByJobResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelOTAStrategyByJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CancelOTAStrategyByJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CancelOTAStrategyByJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelOTAStrategyByJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelOTAStrategyByJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOTATaskByDeviceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, firmware_id=None, product_key=None, device_name=None, job_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.firmware_id = firmware_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: list[str]
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelOTATaskByDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelOTATaskByDeviceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelOTATaskByDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CancelOTATaskByDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CancelOTATaskByDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelOTATaskByDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelOTATaskByDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOTATaskByJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, job_id=None, cancel_scheduled_task=None, cancel_queued_task=None,
                 cancel_in_progress_task=None, cancel_notified_task=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.job_id = job_id  # type: str
        self.cancel_scheduled_task = cancel_scheduled_task  # type: bool
        self.cancel_queued_task = cancel_queued_task  # type: bool
        self.cancel_in_progress_task = cancel_in_progress_task  # type: bool
        self.cancel_notified_task = cancel_notified_task  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelOTATaskByJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.cancel_scheduled_task is not None:
            result['CancelScheduledTask'] = self.cancel_scheduled_task
        if self.cancel_queued_task is not None:
            result['CancelQueuedTask'] = self.cancel_queued_task
        if self.cancel_in_progress_task is not None:
            result['CancelInProgressTask'] = self.cancel_in_progress_task
        if self.cancel_notified_task is not None:
            result['CancelNotifiedTask'] = self.cancel_notified_task
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('CancelScheduledTask') is not None:
            self.cancel_scheduled_task = m.get('CancelScheduledTask')
        if m.get('CancelQueuedTask') is not None:
            self.cancel_queued_task = m.get('CancelQueuedTask')
        if m.get('CancelInProgressTask') is not None:
            self.cancel_in_progress_task = m.get('CancelInProgressTask')
        if m.get('CancelNotifiedTask') is not None:
            self.cancel_notified_task = m.get('CancelNotifiedTask')
        return self


class CancelOTATaskByJobResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelOTATaskByJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CancelOTATaskByJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CancelOTATaskByJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelOTATaskByJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelOTATaskByJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ClearEdgeInstanceDriverConfigsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.driver_id = driver_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ClearEdgeInstanceDriverConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class ClearEdgeInstanceDriverConfigsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ClearEdgeInstanceDriverConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class ClearEdgeInstanceDriverConfigsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ClearEdgeInstanceDriverConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ClearEdgeInstanceDriverConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ClearEdgeInstanceDriverConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloseEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CloseEdgeInstanceDeploymentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CloseEdgeInstanceDeploymentResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CloseEdgeInstanceDeploymentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CloseEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CloseEdgeInstanceDeploymentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CloseEdgeInstanceDeploymentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CloseEdgeInstanceDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyThingModelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, resource_group_id=None, source_product_key=None,
                 target_product_key=None, source_model_version=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.source_product_key = source_product_key  # type: str
        self.target_product_key = target_product_key  # type: str
        self.source_model_version = source_model_version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CopyThingModelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.source_product_key is not None:
            result['SourceProductKey'] = self.source_product_key
        if self.target_product_key is not None:
            result['TargetProductKey'] = self.target_product_key
        if self.source_model_version is not None:
            result['SourceModelVersion'] = self.source_model_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SourceProductKey') is not None:
            self.source_product_key = m.get('SourceProductKey')
        if m.get('TargetProductKey') is not None:
            self.target_product_key = m.get('TargetProductKey')
        if m.get('SourceModelVersion') is not None:
            self.source_model_version = m.get('SourceModelVersion')
        return self


class CopyThingModelResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CopyThingModelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CopyThingModelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CopyThingModelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CopyThingModelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CopyThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConsumerGroupRequest(TeaModel):
    def __init__(self, iot_instance_id=None, group_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.group_name = group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateConsumerGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class CreateConsumerGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, group_id=None, code=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.group_id = group_id  # type: str
        self.code = code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateConsumerGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class CreateConsumerGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateConsumerGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateConsumerGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateConsumerGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConsumerGroupSubscribeRelationRequest(TeaModel):
    def __init__(self, consumer_group_id=None, iot_instance_id=None, product_key=None):
        self.consumer_group_id = consumer_group_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateConsumerGroupSubscribeRelationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consumer_group_id is not None:
            result['ConsumerGroupId'] = self.consumer_group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConsumerGroupId') is not None:
            self.consumer_group_id = m.get('ConsumerGroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CreateConsumerGroupSubscribeRelationResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateConsumerGroupSubscribeRelationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateConsumerGroupSubscribeRelationResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateConsumerGroupSubscribeRelationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateConsumerGroupSubscribeRelationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateConsumerGroupSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataAPIServiceRequestRequestParam(TeaModel):
    def __init__(self, name=None, type=None, desc=None, example=None, required=None):
        self.name = name  # type: str
        self.type = type  # type: str
        self.desc = desc  # type: str
        self.example = example  # type: str
        self.required = required  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataAPIServiceRequestRequestParam, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class CreateDataAPIServiceRequestResponseParam(TeaModel):
    def __init__(self, name=None, type=None, desc=None, example=None, required=None):
        self.name = name  # type: str
        self.type = type  # type: str
        self.desc = desc  # type: str
        self.example = example  # type: str
        self.required = required  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataAPIServiceRequestResponseParam, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class CreateDataAPIServiceRequest(TeaModel):
    def __init__(self, display_name=None, origin_sql=None, request_param=None, desc=None, response_param=None,
                 template_sql=None, api_path=None, iot_instance_id=None):
        self.display_name = display_name  # type: str
        self.origin_sql = origin_sql  # type: str
        self.request_param = request_param  # type: list[CreateDataAPIServiceRequestRequestParam]
        self.desc = desc  # type: str
        self.response_param = response_param  # type: list[CreateDataAPIServiceRequestResponseParam]
        self.template_sql = template_sql  # type: str
        self.api_path = api_path  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        if self.request_param:
            for k in self.request_param:
                if k:
                    k.validate()
        if self.response_param:
            for k in self.response_param:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDataAPIServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.origin_sql is not None:
            result['OriginSql'] = self.origin_sql
        result['RequestParam'] = []
        if self.request_param is not None:
            for k in self.request_param:
                result['RequestParam'].append(k.to_map() if k else None)
        if self.desc is not None:
            result['Desc'] = self.desc
        result['ResponseParam'] = []
        if self.response_param is not None:
            for k in self.response_param:
                result['ResponseParam'].append(k.to_map() if k else None)
        if self.template_sql is not None:
            result['TemplateSql'] = self.template_sql
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('OriginSql') is not None:
            self.origin_sql = m.get('OriginSql')
        self.request_param = []
        if m.get('RequestParam') is not None:
            for k in m.get('RequestParam'):
                temp_model = CreateDataAPIServiceRequestRequestParam()
                self.request_param.append(temp_model.from_map(k))
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        self.response_param = []
        if m.get('ResponseParam') is not None:
            for k in m.get('ResponseParam'):
                temp_model = CreateDataAPIServiceRequestResponseParam()
                self.response_param.append(temp_model.from_map(k))
        if m.get('TemplateSql') is not None:
            self.template_sql = m.get('TemplateSql')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class CreateDataAPIServiceResponseBodyData(TeaModel):
    def __init__(self, api_srn=None, create_time=None, last_update_time=None):
        self.api_srn = api_srn  # type: str
        self.create_time = create_time  # type: long
        self.last_update_time = last_update_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDataAPIServiceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_update_time is not None:
            result['LastUpdateTime'] = self.last_update_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastUpdateTime') is not None:
            self.last_update_time = m.get('LastUpdateTime')
        return self


class CreateDataAPIServiceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: CreateDataAPIServiceResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateDataAPIServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateDataAPIServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateDataAPIServiceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateDataAPIServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDataAPIServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataAPIServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeviceDistributeJobRequestTargetInstanceConfig(TeaModel):
    def __init__(self, target_instance_id=None):
        self.target_instance_id = target_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDeviceDistributeJobRequestTargetInstanceConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        return self


class CreateDeviceDistributeJobRequest(TeaModel):
    def __init__(self, device_name=None, source_instance_id=None, product_key=None, target_uid=None,
                 target_aliyun_id=None, target_instance_config=None, strategy=None):
        self.device_name = device_name  # type: list[str]
        self.source_instance_id = source_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.target_uid = target_uid  # type: str
        self.target_aliyun_id = target_aliyun_id  # type: str
        self.target_instance_config = target_instance_config  # type: list[CreateDeviceDistributeJobRequestTargetInstanceConfig]
        self.strategy = strategy  # type: int

    def validate(self):
        if self.target_instance_config:
            for k in self.target_instance_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDeviceDistributeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        result['TargetInstanceConfig'] = []
        if self.target_instance_config is not None:
            for k in self.target_instance_config:
                result['TargetInstanceConfig'].append(k.to_map() if k else None)
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        self.target_instance_config = []
        if m.get('TargetInstanceConfig') is not None:
            for k in m.get('TargetInstanceConfig'):
                temp_model = CreateDeviceDistributeJobRequestTargetInstanceConfig()
                self.target_instance_config.append(temp_model.from_map(k))
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        return self


class CreateDeviceDistributeJobResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, job_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDeviceDistributeJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CreateDeviceDistributeJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateDeviceDistributeJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDeviceDistributeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDeviceDistributeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeviceGroupRequest(TeaModel):
    def __init__(self, iot_instance_id=None, super_group_id=None, group_desc=None, group_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.super_group_id = super_group_id  # type: str
        self.group_desc = group_desc  # type: str
        self.group_name = group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDeviceGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.super_group_id is not None:
            result['SuperGroupId'] = self.super_group_id
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SuperGroupId') is not None:
            self.super_group_id = m.get('SuperGroupId')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class CreateDeviceGroupResponseBodyData(TeaModel):
    def __init__(self, group_id=None, utc_create=None, group_name=None, group_desc=None):
        self.group_id = group_id  # type: str
        self.utc_create = utc_create  # type: str
        self.group_name = group_name  # type: str
        self.group_desc = group_desc  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDeviceGroupResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        return self


class CreateDeviceGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: CreateDeviceGroupResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateDeviceGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateDeviceGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateDeviceGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateDeviceGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDeviceGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDeviceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeDriverRequest(TeaModel):
    def __init__(self, iot_instance_id=None, driver_name=None, driver_protocol=None, runtime=None, cpu_arch=None,
                 is_built_in=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.driver_name = driver_name  # type: str
        self.driver_protocol = driver_protocol  # type: str
        self.runtime = runtime  # type: str
        self.cpu_arch = cpu_arch  # type: str
        self.is_built_in = is_built_in  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeDriverRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        if self.driver_protocol is not None:
            result['DriverProtocol'] = self.driver_protocol
        if self.runtime is not None:
            result['Runtime'] = self.runtime
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.is_built_in is not None:
            result['IsBuiltIn'] = self.is_built_in
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        if m.get('DriverProtocol') is not None:
            self.driver_protocol = m.get('DriverProtocol')
        if m.get('Runtime') is not None:
            self.runtime = m.get('Runtime')
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('IsBuiltIn') is not None:
            self.is_built_in = m.get('IsBuiltIn')
        return self


class CreateEdgeDriverResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, driver_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.driver_id = driver_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeDriverResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class CreateEdgeDriverResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateEdgeDriverResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEdgeDriverResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeDriverVersionRequest(TeaModel):
    def __init__(self, iot_instance_id=None, driver_id=None, driver_version=None, edge_version=None,
                 description=None, source_config=None, driver_config=None, container_config=None, config_check_rule=None,
                 argument=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.driver_id = driver_id  # type: str
        self.driver_version = driver_version  # type: str
        self.edge_version = edge_version  # type: str
        self.description = description  # type: str
        self.source_config = source_config  # type: str
        self.driver_config = driver_config  # type: str
        self.container_config = container_config  # type: str
        self.config_check_rule = config_check_rule  # type: str
        self.argument = argument  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeDriverVersionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.description is not None:
            result['Description'] = self.description
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.argument is not None:
            result['Argument'] = self.argument
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        return self


class CreateEdgeDriverVersionResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeDriverVersionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateEdgeDriverVersionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateEdgeDriverVersionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEdgeDriverVersionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeDriverVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, name=None, tags=None, spec=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.name = name  # type: str
        self.tags = tags  # type: str
        self.spec = spec  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.spec is not None:
            result['Spec'] = self.spec
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        return self


class CreateEdgeInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, instance_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeInstanceChannelRequestConfigs(TeaModel):
    def __init__(self, format=None, content=None, key=None):
        self.format = format  # type: str
        self.content = content  # type: str
        self.key = key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeInstanceChannelRequestConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class CreateEdgeInstanceChannelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, driver_id=None, channel_name=None, configs=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.driver_id = driver_id  # type: str
        self.channel_name = channel_name  # type: str
        self.configs = configs  # type: list[CreateEdgeInstanceChannelRequestConfigs]

    def validate(self):
        if self.configs:
            for k in self.configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateEdgeInstanceChannelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        result['Configs'] = []
        if self.configs is not None:
            for k in self.configs:
                result['Configs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        self.configs = []
        if m.get('Configs') is not None:
            for k in m.get('Configs'):
                temp_model = CreateEdgeInstanceChannelRequestConfigs()
                self.configs.append(temp_model.from_map(k))
        return self


class CreateEdgeInstanceChannelResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeInstanceChannelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class CreateEdgeInstanceChannelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateEdgeInstanceChannelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEdgeInstanceChannelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeInstanceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, type=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeInstanceDeploymentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateEdgeInstanceDeploymentResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, deployment_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.deployment_id = deployment_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeInstanceDeploymentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        return self


class CreateEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateEdgeInstanceDeploymentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEdgeInstanceDeploymentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeInstanceDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeInstanceMessageRoutingRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, name=None, topic_filter=None, source_type=None,
                 source_data=None, target_type=None, target_data=None, target_iot_hub_qos=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.topic_filter = topic_filter  # type: str
        self.source_type = source_type  # type: str
        self.source_data = source_data  # type: str
        self.target_type = target_type  # type: str
        self.target_data = target_data  # type: str
        self.target_iot_hub_qos = target_iot_hub_qos  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeInstanceMessageRoutingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.topic_filter is not None:
            result['TopicFilter'] = self.topic_filter
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.source_data is not None:
            result['SourceData'] = self.source_data
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.target_data is not None:
            result['TargetData'] = self.target_data
        if self.target_iot_hub_qos is not None:
            result['TargetIotHubQos'] = self.target_iot_hub_qos
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TopicFilter') is not None:
            self.topic_filter = m.get('TopicFilter')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('SourceData') is not None:
            self.source_data = m.get('SourceData')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TargetData') is not None:
            self.target_data = m.get('TargetData')
        if m.get('TargetIotHubQos') is not None:
            self.target_iot_hub_qos = m.get('TargetIotHubQos')
        return self


class CreateEdgeInstanceMessageRoutingResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, route_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.route_id = route_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeInstanceMessageRoutingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.route_id is not None:
            result['RouteId'] = self.route_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RouteId') is not None:
            self.route_id = m.get('RouteId')
        return self


class CreateEdgeInstanceMessageRoutingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateEdgeInstanceMessageRoutingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEdgeInstanceMessageRoutingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeInstanceMessageRoutingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeOssPreSignedAddressRequest(TeaModel):
    def __init__(self, resource_id=None, file_name=None, iot_instance_id=None, type=None, instance_id=None,
                 resource_version=None):
        self.resource_id = resource_id  # type: str
        self.file_name = file_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.type = type  # type: str
        self.instance_id = instance_id  # type: str
        self.resource_version = resource_version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeOssPreSignedAddressRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.type is not None:
            result['Type'] = self.type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.resource_version is not None:
            result['ResourceVersion'] = self.resource_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ResourceVersion') is not None:
            self.resource_version = m.get('ResourceVersion')
        return self


class CreateEdgeOssPreSignedAddressResponseBodyData(TeaModel):
    def __init__(self, oss_pre_signed_address=None, oss_address=None):
        self.oss_pre_signed_address = oss_pre_signed_address  # type: str
        self.oss_address = oss_address  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEdgeOssPreSignedAddressResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.oss_pre_signed_address is not None:
            result['OssPreSignedAddress'] = self.oss_pre_signed_address
        if self.oss_address is not None:
            result['OssAddress'] = self.oss_address
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OssPreSignedAddress') is not None:
            self.oss_pre_signed_address = m.get('OssPreSignedAddress')
        if m.get('OssAddress') is not None:
            self.oss_address = m.get('OssAddress')
        return self


class CreateEdgeOssPreSignedAddressResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: CreateEdgeOssPreSignedAddressResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateEdgeOssPreSignedAddressResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateEdgeOssPreSignedAddressResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateEdgeOssPreSignedAddressResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateEdgeOssPreSignedAddressResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEdgeOssPreSignedAddressResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeOssPreSignedAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, description=None, job_document=None, type=None, job_file=None,
                 job_name=None, timeout_config=None, rollout_config=None, target_config=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.description = description  # type: str
        self.job_document = job_document  # type: str
        self.type = type  # type: str
        self.job_file = job_file  # type: str
        self.job_name = job_name  # type: str
        self.timeout_config = timeout_config  # type: str
        self.rollout_config = rollout_config  # type: str
        self.target_config = target_config  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.description is not None:
            result['Description'] = self.description
        if self.job_document is not None:
            result['JobDocument'] = self.job_document
        if self.type is not None:
            result['Type'] = self.type
        if self.job_file is not None:
            result['JobFile'] = self.job_file
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.timeout_config is not None:
            result['TimeoutConfig'] = self.timeout_config
        if self.rollout_config is not None:
            result['RolloutConfig'] = self.rollout_config
        if self.target_config is not None:
            result['TargetConfig'] = self.target_config
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('JobDocument') is not None:
            self.job_document = m.get('JobDocument')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('JobFile') is not None:
            self.job_file = m.get('JobFile')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TimeoutConfig') is not None:
            self.timeout_config = m.get('TimeoutConfig')
        if m.get('RolloutConfig') is not None:
            self.rollout_config = m.get('RolloutConfig')
        if m.get('TargetConfig') is not None:
            self.target_config = m.get('TargetConfig')
        return self


class CreateJobResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, job_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CreateJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLoRaNodesTaskRequestDeviceInfo(TeaModel):
    def __init__(self, dev_eui=None, pin_code=None):
        self.dev_eui = dev_eui  # type: str
        self.pin_code = pin_code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLoRaNodesTaskRequestDeviceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dev_eui is not None:
            result['DevEui'] = self.dev_eui
        if self.pin_code is not None:
            result['PinCode'] = self.pin_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DevEui') is not None:
            self.dev_eui = m.get('DevEui')
        if m.get('PinCode') is not None:
            self.pin_code = m.get('PinCode')
        return self


class CreateLoRaNodesTaskRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_info=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_info = device_info  # type: list[CreateLoRaNodesTaskRequestDeviceInfo]

    def validate(self):
        if self.device_info:
            for k in self.device_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateLoRaNodesTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        result['DeviceInfo'] = []
        if self.device_info is not None:
            for k in self.device_info:
                result['DeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        self.device_info = []
        if m.get('DeviceInfo') is not None:
            for k in m.get('DeviceInfo'):
                temp_model = CreateLoRaNodesTaskRequestDeviceInfo()
                self.device_info.append(temp_model.from_map(k))
        return self


class CreateLoRaNodesTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, task_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLoRaNodesTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateLoRaNodesTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateLoRaNodesTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateLoRaNodesTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateLoRaNodesTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTADynamicUpgradeJobRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTADynamicUpgradeJobRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOTADynamicUpgradeJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, firmware_id=None, product_key=None, src_version=None,
                 retry_interval=None, retry_count=None, timeout_in_minutes=None, maximum_per_minute=None, overwrite_mode=None,
                 dynamic_mode=None, tag=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.firmware_id = firmware_id  # type: str
        self.product_key = product_key  # type: str
        self.src_version = src_version  # type: list[str]
        self.retry_interval = retry_interval  # type: int
        self.retry_count = retry_count  # type: int
        self.timeout_in_minutes = timeout_in_minutes  # type: int
        self.maximum_per_minute = maximum_per_minute  # type: int
        self.overwrite_mode = overwrite_mode  # type: int
        self.dynamic_mode = dynamic_mode  # type: int
        self.tag = tag  # type: list[CreateOTADynamicUpgradeJobRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateOTADynamicUpgradeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        if self.overwrite_mode is not None:
            result['OverwriteMode'] = self.overwrite_mode
        if self.dynamic_mode is not None:
            result['DynamicMode'] = self.dynamic_mode
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        if m.get('OverwriteMode') is not None:
            self.overwrite_mode = m.get('OverwriteMode')
        if m.get('DynamicMode') is not None:
            self.dynamic_mode = m.get('DynamicMode')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateOTADynamicUpgradeJobRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateOTADynamicUpgradeJobResponseBodyData(TeaModel):
    def __init__(self, job_id=None, utc_create=None):
        self.job_id = job_id  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTADynamicUpgradeJobResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTADynamicUpgradeJobResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: CreateOTADynamicUpgradeJobResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateOTADynamicUpgradeJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateOTADynamicUpgradeJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateOTADynamicUpgradeJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateOTADynamicUpgradeJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOTADynamicUpgradeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTADynamicUpgradeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAFirmwareRequest(TeaModel):
    def __init__(self, iot_instance_id=None, firmware_name=None, dest_version=None, firmware_url=None,
                 firmware_sign=None, sign_method=None, firmware_size=None, product_key=None, firmware_desc=None, type=None,
                 src_version=None, module_name=None, need_to_verify=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.firmware_name = firmware_name  # type: str
        self.dest_version = dest_version  # type: str
        self.firmware_url = firmware_url  # type: str
        self.firmware_sign = firmware_sign  # type: str
        self.sign_method = sign_method  # type: str
        self.firmware_size = firmware_size  # type: int
        self.product_key = product_key  # type: str
        self.firmware_desc = firmware_desc  # type: str
        self.type = type  # type: int
        self.src_version = src_version  # type: str
        self.module_name = module_name  # type: str
        self.need_to_verify = need_to_verify  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTAFirmwareRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_name is not None:
            result['FirmwareName'] = self.firmware_name
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.firmware_sign is not None:
            result['FirmwareSign'] = self.firmware_sign
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.firmware_size is not None:
            result['FirmwareSize'] = self.firmware_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_desc is not None:
            result['FirmwareDesc'] = self.firmware_desc
        if self.type is not None:
            result['Type'] = self.type
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.need_to_verify is not None:
            result['NeedToVerify'] = self.need_to_verify
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareName') is not None:
            self.firmware_name = m.get('FirmwareName')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('FirmwareSign') is not None:
            self.firmware_sign = m.get('FirmwareSign')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('FirmwareSize') is not None:
            self.firmware_size = m.get('FirmwareSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareDesc') is not None:
            self.firmware_desc = m.get('FirmwareDesc')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('NeedToVerify') is not None:
            self.need_to_verify = m.get('NeedToVerify')
        return self


class CreateOTAFirmwareResponseBodyData(TeaModel):
    def __init__(self, firmware_id=None, utc_create=None):
        self.firmware_id = firmware_id  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTAFirmwareResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAFirmwareResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: CreateOTAFirmwareResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateOTAFirmwareResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateOTAFirmwareResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateOTAFirmwareResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateOTAFirmwareResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOTAFirmwareResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTAFirmwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAModuleRequest(TeaModel):
    def __init__(self, alias_name=None, iot_instance_id=None, module_name=None, desc=None, product_key=None):
        self.alias_name = alias_name  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.module_name = module_name  # type: str
        self.desc = desc  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTAModuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CreateOTAModuleResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTAModuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateOTAModuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateOTAModuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOTAModuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTAModuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAStaticUpgradeJobRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTAStaticUpgradeJobRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOTAStaticUpgradeJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, firmware_id=None, product_key=None, target_selection=None,
                 src_version=None, schedule_time=None, retry_interval=None, retry_count=None, timeout_in_minutes=None,
                 maximum_per_minute=None, gray_percent=None, target_device_name=None, schedule_finish_time=None, overwrite_mode=None,
                 tag=None, dn_list_file_url=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.firmware_id = firmware_id  # type: str
        self.product_key = product_key  # type: str
        self.target_selection = target_selection  # type: str
        self.src_version = src_version  # type: list[str]
        self.schedule_time = schedule_time  # type: long
        self.retry_interval = retry_interval  # type: int
        self.retry_count = retry_count  # type: int
        self.timeout_in_minutes = timeout_in_minutes  # type: int
        self.maximum_per_minute = maximum_per_minute  # type: int
        self.gray_percent = gray_percent  # type: str
        self.target_device_name = target_device_name  # type: list[str]
        self.schedule_finish_time = schedule_finish_time  # type: long
        self.overwrite_mode = overwrite_mode  # type: int
        self.tag = tag  # type: list[CreateOTAStaticUpgradeJobRequestTag]
        self.dn_list_file_url = dn_list_file_url  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateOTAStaticUpgradeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.schedule_time is not None:
            result['ScheduleTime'] = self.schedule_time
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        if self.gray_percent is not None:
            result['GrayPercent'] = self.gray_percent
        if self.target_device_name is not None:
            result['TargetDeviceName'] = self.target_device_name
        if self.schedule_finish_time is not None:
            result['ScheduleFinishTime'] = self.schedule_finish_time
        if self.overwrite_mode is not None:
            result['OverwriteMode'] = self.overwrite_mode
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.dn_list_file_url is not None:
            result['DnListFileUrl'] = self.dn_list_file_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('ScheduleTime') is not None:
            self.schedule_time = m.get('ScheduleTime')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        if m.get('GrayPercent') is not None:
            self.gray_percent = m.get('GrayPercent')
        if m.get('TargetDeviceName') is not None:
            self.target_device_name = m.get('TargetDeviceName')
        if m.get('ScheduleFinishTime') is not None:
            self.schedule_finish_time = m.get('ScheduleFinishTime')
        if m.get('OverwriteMode') is not None:
            self.overwrite_mode = m.get('OverwriteMode')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateOTAStaticUpgradeJobRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('DnListFileUrl') is not None:
            self.dn_list_file_url = m.get('DnListFileUrl')
        return self


class CreateOTAStaticUpgradeJobResponseBodyData(TeaModel):
    def __init__(self, job_id=None, utc_create=None):
        self.job_id = job_id  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTAStaticUpgradeJobResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAStaticUpgradeJobResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: CreateOTAStaticUpgradeJobResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateOTAStaticUpgradeJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateOTAStaticUpgradeJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateOTAStaticUpgradeJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateOTAStaticUpgradeJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOTAStaticUpgradeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTAStaticUpgradeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAVerifyJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, firmware_id=None, timeout_in_minutes=None, product_key=None,
                 target_device_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.firmware_id = firmware_id  # type: str
        self.timeout_in_minutes = timeout_in_minutes  # type: int
        self.product_key = product_key  # type: str
        self.target_device_name = target_device_name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTAVerifyJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_device_name is not None:
            result['TargetDeviceName'] = self.target_device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetDeviceName') is not None:
            self.target_device_name = m.get('TargetDeviceName')
        return self


class CreateOTAVerifyJobResponseBodyData(TeaModel):
    def __init__(self, job_id=None, utc_create=None):
        self.job_id = job_id  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOTAVerifyJobResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAVerifyJobResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: CreateOTAVerifyJobResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateOTAVerifyJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = CreateOTAVerifyJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateOTAVerifyJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateOTAVerifyJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOTAVerifyJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTAVerifyJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProductRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_name=None, node_type=None, data_format=None, description=None,
                 aliyun_commodity_code=None, id_2=None, protocol_type=None, net_type=None, join_permission_id=None,
                 resource_group_id=None, auth_type=None, category_key=None, publish_auto=None, validate_type=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_name = product_name  # type: str
        self.node_type = node_type  # type: int
        self.data_format = data_format  # type: int
        self.description = description  # type: str
        self.aliyun_commodity_code = aliyun_commodity_code  # type: str
        self.id_2 = id_2  # type: bool
        self.protocol_type = protocol_type  # type: str
        self.net_type = net_type  # type: str
        self.join_permission_id = join_permission_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.auth_type = auth_type  # type: str
        self.category_key = category_key  # type: str
        self.publish_auto = publish_auto  # type: bool
        self.validate_type = validate_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProductRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.data_format is not None:
            result['DataFormat'] = self.data_format
        if self.description is not None:
            result['Description'] = self.description
        if self.aliyun_commodity_code is not None:
            result['AliyunCommodityCode'] = self.aliyun_commodity_code
        if self.id_2 is not None:
            result['Id2'] = self.id_2
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.join_permission_id is not None:
            result['JoinPermissionId'] = self.join_permission_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        if self.publish_auto is not None:
            result['PublishAuto'] = self.publish_auto
        if self.validate_type is not None:
            result['ValidateType'] = self.validate_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('DataFormat') is not None:
            self.data_format = m.get('DataFormat')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('AliyunCommodityCode') is not None:
            self.aliyun_commodity_code = m.get('AliyunCommodityCode')
        if m.get('Id2') is not None:
            self.id_2 = m.get('Id2')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('JoinPermissionId') is not None:
            self.join_permission_id = m.get('JoinPermissionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        if m.get('PublishAuto') is not None:
            self.publish_auto = m.get('PublishAuto')
        if m.get('ValidateType') is not None:
            self.validate_type = m.get('ValidateType')
        return self


class CreateProductResponseBodyData(TeaModel):
    def __init__(self, data_format=None, description=None, node_type=None, product_key=None, product_name=None,
                 aliyun_commodity_code=None, id_2=None, protocol_type=None, auth_type=None, product_secret=None):
        self.data_format = data_format  # type: int
        self.description = description  # type: str
        self.node_type = node_type  # type: int
        self.product_key = product_key  # type: str
        self.product_name = product_name  # type: str
        self.aliyun_commodity_code = aliyun_commodity_code  # type: str
        self.id_2 = id_2  # type: bool
        self.protocol_type = protocol_type  # type: str
        self.auth_type = auth_type  # type: str
        self.product_secret = product_secret  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProductResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_format is not None:
            result['DataFormat'] = self.data_format
        if self.description is not None:
            result['Description'] = self.description
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.aliyun_commodity_code is not None:
            result['AliyunCommodityCode'] = self.aliyun_commodity_code
        if self.id_2 is not None:
            result['Id2'] = self.id_2
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.product_secret is not None:
            result['ProductSecret'] = self.product_secret
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataFormat') is not None:
            self.data_format = m.get('DataFormat')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('AliyunCommodityCode') is not None:
            self.aliyun_commodity_code = m.get('AliyunCommodityCode')
        if m.get('Id2') is not None:
            self.id_2 = m.get('Id2')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('ProductSecret') is not None:
            self.product_secret = m.get('ProductSecret')
        return self


class CreateProductResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, product_key=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.product_key = product_key  # type: str
        self.data = data  # type: CreateProductResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateProductResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Data') is not None:
            temp_model = CreateProductResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class CreateProductResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateProductResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateProductResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProductDistributeJobRequest(TeaModel):
    def __init__(self, source_instance_id=None, product_key=None, target_instance_id=None, target_uid=None,
                 target_aliyun_id=None):
        self.source_instance_id = source_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.target_instance_id = target_instance_id  # type: str
        self.target_uid = target_uid  # type: str
        self.target_aliyun_id = target_aliyun_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProductDistributeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        return self


class CreateProductDistributeJobResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, job_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProductDistributeJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CreateProductDistributeJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateProductDistributeJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateProductDistributeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateProductDistributeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProductTagsRequestProductTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProductTagsRequestProductTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateProductTagsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, product_tag=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.product_tag = product_tag  # type: list[CreateProductTagsRequestProductTag]

    def validate(self):
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateProductTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = CreateProductTagsRequestProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class CreateProductTagsResponseBodyInvalidProductTagsProductTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProductTagsResponseBodyInvalidProductTagsProductTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateProductTagsResponseBodyInvalidProductTags(TeaModel):
    def __init__(self, product_tag=None):
        self.product_tag = product_tag  # type: list[CreateProductTagsResponseBodyInvalidProductTagsProductTag]

    def validate(self):
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateProductTagsResponseBodyInvalidProductTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = CreateProductTagsResponseBodyInvalidProductTagsProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class CreateProductTagsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, invalid_product_tags=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str
        self.invalid_product_tags = invalid_product_tags  # type: CreateProductTagsResponseBodyInvalidProductTags

    def validate(self):
        if self.invalid_product_tags:
            self.invalid_product_tags.validate()

    def to_map(self):
        _map = super(CreateProductTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.invalid_product_tags is not None:
            result['InvalidProductTags'] = self.invalid_product_tags.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InvalidProductTags') is not None:
            temp_model = CreateProductTagsResponseBodyInvalidProductTags()
            self.invalid_product_tags = temp_model.from_map(m['InvalidProductTags'])
        return self


class CreateProductTagsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateProductTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateProductTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateProductTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProductTopicRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, topic_short_name=None, operation=None, desc=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.topic_short_name = topic_short_name  # type: str
        self.operation = operation  # type: str
        self.desc = desc  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProductTopicRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.topic_short_name is not None:
            result['TopicShortName'] = self.topic_short_name
        if self.operation is not None:
            result['Operation'] = self.operation
        if self.desc is not None:
            result['Desc'] = self.desc
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TopicShortName') is not None:
            self.topic_short_name = m.get('TopicShortName')
        if m.get('Operation') is not None:
            self.operation = m.get('Operation')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        return self


class CreateProductTopicResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, topic_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.topic_id = topic_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateProductTopicResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class CreateProductTopicResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateProductTopicResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateProductTopicResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateProductTopicResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, select=None, short_topic=None, where=None, product_key=None, name=None,
                 rule_desc=None, data_type=None, topic_type=None, resource_group_id=None, topic=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.select = select  # type: str
        self.short_topic = short_topic  # type: str
        self.where = where  # type: str
        self.product_key = product_key  # type: str
        self.name = name  # type: str
        self.rule_desc = rule_desc  # type: str
        self.data_type = data_type  # type: str
        self.topic_type = topic_type  # type: int
        self.resource_group_id = resource_group_id  # type: str
        self.topic = topic  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.select is not None:
            result['Select'] = self.select
        if self.short_topic is not None:
            result['ShortTopic'] = self.short_topic
        if self.where is not None:
            result['Where'] = self.where
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.topic_type is not None:
            result['TopicType'] = self.topic_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('ShortTopic') is not None:
            self.short_topic = m.get('ShortTopic')
        if m.get('Where') is not None:
            self.where = m.get('Where')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('TopicType') is not None:
            self.topic_type = m.get('TopicType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class CreateRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, rule_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.rule_id = rule_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class CreateRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRuleActionRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None, type=None, configuration=None, error_action_flag=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: long
        self.type = type  # type: str
        self.configuration = configuration  # type: str
        self.error_action_flag = error_action_flag  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRuleActionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.type is not None:
            result['Type'] = self.type
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.error_action_flag is not None:
            result['ErrorActionFlag'] = self.error_action_flag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('ErrorActionFlag') is not None:
            self.error_action_flag = m.get('ErrorActionFlag')
        return self


class CreateRuleActionResponseBody(TeaModel):
    def __init__(self, request_id=None, code=None, success=None, error_message=None, action_id=None):
        self.request_id = request_id  # type: str
        self.code = code  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.action_id = action_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRuleActionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        return self


class CreateRuleActionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateRuleActionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateRuleActionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRuleActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRulengDistributeJobRequest(TeaModel):
    def __init__(self, product_key=None, source_instance_id=None, target_instance_id=None):
        self.product_key = product_key  # type: str
        self.source_instance_id = source_instance_id  # type: str
        self.target_instance_id = target_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRulengDistributeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        return self


class CreateRulengDistributeJobResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRulengDistributeJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateRulengDistributeJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateRulengDistributeJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateRulengDistributeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRulengDistributeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_name=None, rule_content=None, rule_description=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_name = rule_name  # type: str
        self.rule_content = rule_content  # type: str
        self.rule_description = rule_description  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSceneRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        return self


class CreateSceneRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, rule_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSceneRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class CreateSceneRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateSceneRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSceneRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSubscribeRelationRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_data_flag=None, device_life_cycle_flag=None,
                 device_status_change_flag=None, device_topo_life_cycle_flag=None, found_device_list_flag=None, mns_configuration=None,
                 type=None, consumer_group_ids=None, ota_event_flag=None, thing_history_flag=None, device_tag_flag=None,
                 ota_version_flag=None, ota_job_flag=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_data_flag = device_data_flag  # type: bool
        self.device_life_cycle_flag = device_life_cycle_flag  # type: bool
        self.device_status_change_flag = device_status_change_flag  # type: bool
        self.device_topo_life_cycle_flag = device_topo_life_cycle_flag  # type: bool
        self.found_device_list_flag = found_device_list_flag  # type: bool
        self.mns_configuration = mns_configuration  # type: str
        self.type = type  # type: str
        self.consumer_group_ids = consumer_group_ids  # type: list[str]
        self.ota_event_flag = ota_event_flag  # type: bool
        self.thing_history_flag = thing_history_flag  # type: bool
        self.device_tag_flag = device_tag_flag  # type: bool
        self.ota_version_flag = ota_version_flag  # type: bool
        self.ota_job_flag = ota_job_flag  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSubscribeRelationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_data_flag is not None:
            result['DeviceDataFlag'] = self.device_data_flag
        if self.device_life_cycle_flag is not None:
            result['DeviceLifeCycleFlag'] = self.device_life_cycle_flag
        if self.device_status_change_flag is not None:
            result['DeviceStatusChangeFlag'] = self.device_status_change_flag
        if self.device_topo_life_cycle_flag is not None:
            result['DeviceTopoLifeCycleFlag'] = self.device_topo_life_cycle_flag
        if self.found_device_list_flag is not None:
            result['FoundDeviceListFlag'] = self.found_device_list_flag
        if self.mns_configuration is not None:
            result['MnsConfiguration'] = self.mns_configuration
        if self.type is not None:
            result['Type'] = self.type
        if self.consumer_group_ids is not None:
            result['ConsumerGroupIds'] = self.consumer_group_ids
        if self.ota_event_flag is not None:
            result['OtaEventFlag'] = self.ota_event_flag
        if self.thing_history_flag is not None:
            result['ThingHistoryFlag'] = self.thing_history_flag
        if self.device_tag_flag is not None:
            result['DeviceTagFlag'] = self.device_tag_flag
        if self.ota_version_flag is not None:
            result['OtaVersionFlag'] = self.ota_version_flag
        if self.ota_job_flag is not None:
            result['OtaJobFlag'] = self.ota_job_flag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceDataFlag') is not None:
            self.device_data_flag = m.get('DeviceDataFlag')
        if m.get('DeviceLifeCycleFlag') is not None:
            self.device_life_cycle_flag = m.get('DeviceLifeCycleFlag')
        if m.get('DeviceStatusChangeFlag') is not None:
            self.device_status_change_flag = m.get('DeviceStatusChangeFlag')
        if m.get('DeviceTopoLifeCycleFlag') is not None:
            self.device_topo_life_cycle_flag = m.get('DeviceTopoLifeCycleFlag')
        if m.get('FoundDeviceListFlag') is not None:
            self.found_device_list_flag = m.get('FoundDeviceListFlag')
        if m.get('MnsConfiguration') is not None:
            self.mns_configuration = m.get('MnsConfiguration')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ConsumerGroupIds') is not None:
            self.consumer_group_ids = m.get('ConsumerGroupIds')
        if m.get('OtaEventFlag') is not None:
            self.ota_event_flag = m.get('OtaEventFlag')
        if m.get('ThingHistoryFlag') is not None:
            self.thing_history_flag = m.get('ThingHistoryFlag')
        if m.get('DeviceTagFlag') is not None:
            self.device_tag_flag = m.get('DeviceTagFlag')
        if m.get('OtaVersionFlag') is not None:
            self.ota_version_flag = m.get('OtaVersionFlag')
        if m.get('OtaJobFlag') is not None:
            self.ota_job_flag = m.get('OtaJobFlag')
        return self


class CreateSubscribeRelationResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSubscribeRelationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateSubscribeRelationResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateSubscribeRelationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSubscribeRelationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateThingModelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, thing_model_json=None, function_block_id=None,
                 function_block_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.thing_model_json = thing_model_json  # type: str
        self.function_block_id = function_block_id  # type: str
        self.function_block_name = function_block_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateThingModelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.thing_model_json is not None:
            result['ThingModelJson'] = self.thing_model_json
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.function_block_name is not None:
            result['FunctionBlockName'] = self.function_block_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ThingModelJson') is not None:
            self.thing_model_json = m.get('ThingModelJson')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('FunctionBlockName') is not None:
            self.function_block_name = m.get('FunctionBlockName')
        return self


class CreateThingModelResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateThingModelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateThingModelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateThingModelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateThingModelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateThingScriptRequest(TeaModel):
    def __init__(self, script_content=None, iot_instance_id=None, product_key=None, script_type=None):
        self.script_content = script_content  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.script_type = script_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateThingScriptRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.script_content is not None:
            result['ScriptContent'] = self.script_content
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.script_type is not None:
            result['ScriptType'] = self.script_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ScriptContent') is not None:
            self.script_content = m.get('ScriptContent')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ScriptType') is not None:
            self.script_type = m.get('ScriptType')
        return self


class CreateThingScriptResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateThingScriptResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class CreateThingScriptResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateThingScriptResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateThingScriptResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateThingScriptResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTopicRouteTableRequest(TeaModel):
    def __init__(self, iot_instance_id=None, dst_topic=None, src_topic=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.dst_topic = dst_topic  # type: list[str]
        self.src_topic = src_topic  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTopicRouteTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.dst_topic is not None:
            result['DstTopic'] = self.dst_topic
        if self.src_topic is not None:
            result['SrcTopic'] = self.src_topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DstTopic') is not None:
            self.dst_topic = m.get('DstTopic')
        if m.get('SrcTopic') is not None:
            self.src_topic = m.get('SrcTopic')
        return self


class CreateTopicRouteTableResponseBodyFailureTopics(TeaModel):
    def __init__(self, topic=None):
        self.topic = topic  # type: list[dict[str, str]]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTopicRouteTableResponseBodyFailureTopics, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class CreateTopicRouteTableResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, is_all_succeed=None, error_message=None,
                 failure_topics=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.is_all_succeed = is_all_succeed  # type: bool
        self.error_message = error_message  # type: str
        self.failure_topics = failure_topics  # type: CreateTopicRouteTableResponseBodyFailureTopics

    def validate(self):
        if self.failure_topics:
            self.failure_topics.validate()

    def to_map(self):
        _map = super(CreateTopicRouteTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.is_all_succeed is not None:
            result['IsAllSucceed'] = self.is_all_succeed
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.failure_topics is not None:
            result['FailureTopics'] = self.failure_topics.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('IsAllSucceed') is not None:
            self.is_all_succeed = m.get('IsAllSucceed')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('FailureTopics') is not None:
            temp_model = CreateTopicRouteTableResponseBodyFailureTopics()
            self.failure_topics = temp_model.from_map(m['FailureTopics'])
        return self


class CreateTopicRouteTableResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateTopicRouteTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTopicRouteTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateTopicRouteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConsumerGroupRequest(TeaModel):
    def __init__(self, iot_instance_id=None, group_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.group_id = group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteConsumerGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class DeleteConsumerGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteConsumerGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class DeleteConsumerGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteConsumerGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteConsumerGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteConsumerGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConsumerGroupSubscribeRelationRequest(TeaModel):
    def __init__(self, consumer_group_id=None, iot_instance_id=None, product_key=None):
        self.consumer_group_id = consumer_group_id  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteConsumerGroupSubscribeRelationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.consumer_group_id is not None:
            result['ConsumerGroupId'] = self.consumer_group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConsumerGroupId') is not None:
            self.consumer_group_id = m.get('ConsumerGroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteConsumerGroupSubscribeRelationResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteConsumerGroupSubscribeRelationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteConsumerGroupSubscribeRelationResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteConsumerGroupSubscribeRelationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteConsumerGroupSubscribeRelationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteConsumerGroupSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None, iot_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class DeleteDeviceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceDistributeJobRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceDistributeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteDeviceDistributeJobResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceDistributeJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteDeviceDistributeJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteDeviceDistributeJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDeviceDistributeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceDistributeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceFileRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None, iot_id=None, file_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.file_id = file_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceFileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class DeleteDeviceFileResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceFileResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteDeviceFileResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteDeviceFileResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDeviceFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceGroupRequest(TeaModel):
    def __init__(self, iot_instance_id=None, group_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.group_id = group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class DeleteDeviceGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeviceGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteDeviceGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteDeviceGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDeviceGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDevicePropRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None, prop_key=None, iot_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.prop_key = prop_key  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDevicePropRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.prop_key is not None:
            result['PropKey'] = self.prop_key
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('PropKey') is not None:
            self.prop_key = m.get('PropKey')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class DeleteDevicePropResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDevicePropResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteDevicePropResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteDevicePropResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDevicePropResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDevicePropResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeDriverRequest(TeaModel):
    def __init__(self, iot_instance_id=None, driver_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.driver_id = driver_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEdgeDriverRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class DeleteEdgeDriverResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEdgeDriverResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteEdgeDriverResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteEdgeDriverResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteEdgeDriverResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteEdgeDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeDriverVersionRequest(TeaModel):
    def __init__(self, iot_instance_id=None, driver_id=None, driver_version=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.driver_id = driver_id  # type: str
        self.driver_version = driver_version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEdgeDriverVersionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        return self


class DeleteEdgeDriverVersionResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEdgeDriverVersionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteEdgeDriverVersionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteEdgeDriverVersionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteEdgeDriverVersionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteEdgeDriverVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteEdgeInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEdgeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeInstanceMessageRoutingRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, route_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.route_id = route_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEdgeInstanceMessageRoutingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.route_id is not None:
            result['RouteId'] = self.route_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RouteId') is not None:
            self.route_id = m.get('RouteId')
        return self


class DeleteEdgeInstanceMessageRoutingResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteEdgeInstanceMessageRoutingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteEdgeInstanceMessageRoutingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteEdgeInstanceMessageRoutingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteEdgeInstanceMessageRoutingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteEdgeInstanceMessageRoutingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, job_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteJobResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOTAFirmwareRequest(TeaModel):
    def __init__(self, iot_instance_id=None, firmware_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.firmware_id = firmware_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteOTAFirmwareRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        return self


class DeleteOTAFirmwareResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteOTAFirmwareResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteOTAFirmwareResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteOTAFirmwareResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteOTAFirmwareResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteOTAFirmwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOTAModuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, module_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.module_name = module_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteOTAModuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class DeleteOTAModuleResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteOTAModuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteOTAModuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteOTAModuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteOTAModuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteOTAModuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProductRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProductRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteProductResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProductResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteProductResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteProductResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteProductResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProductTagsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_tag_key=None, product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_tag_key = product_tag_key  # type: list[str]
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProductTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_tag_key is not None:
            result['ProductTagKey'] = self.product_tag_key
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductTagKey') is not None:
            self.product_tag_key = m.get('ProductTagKey')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteProductTagsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProductTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class DeleteProductTagsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteProductTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteProductTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteProductTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProductTopicRequest(TeaModel):
    def __init__(self, iot_instance_id=None, topic_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.topic_id = topic_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProductTopicRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class DeleteProductTopicResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteProductTopicResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteProductTopicResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteProductTopicResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteProductTopicResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteProductTopicResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRuleActionRequest(TeaModel):
    def __init__(self, iot_instance_id=None, action_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.action_id = action_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRuleActionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        return self


class DeleteRuleActionResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRuleActionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteRuleActionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteRuleActionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteRuleActionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteRuleActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSceneRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteSceneRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSceneRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class DeleteSceneRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteSceneRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSceneRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSubscribeRelationRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, type=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSubscribeRelationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteSubscribeRelationResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSubscribeRelationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteSubscribeRelationResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteSubscribeRelationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSubscribeRelationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteThingModelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, resource_group_id=None, product_key=None, property_identifier=None,
                 service_identifier=None, event_identifier=None, function_block_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.product_key = product_key  # type: str
        self.property_identifier = property_identifier  # type: list[str]
        self.service_identifier = service_identifier  # type: list[str]
        self.event_identifier = event_identifier  # type: list[str]
        self.function_block_id = function_block_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteThingModelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.property_identifier is not None:
            result['PropertyIdentifier'] = self.property_identifier
        if self.service_identifier is not None:
            result['ServiceIdentifier'] = self.service_identifier
        if self.event_identifier is not None:
            result['EventIdentifier'] = self.event_identifier
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('PropertyIdentifier') is not None:
            self.property_identifier = m.get('PropertyIdentifier')
        if m.get('ServiceIdentifier') is not None:
            self.service_identifier = m.get('ServiceIdentifier')
        if m.get('EventIdentifier') is not None:
            self.event_identifier = m.get('EventIdentifier')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class DeleteThingModelResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteThingModelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DeleteThingModelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteThingModelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteThingModelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTopicRouteTableRequest(TeaModel):
    def __init__(self, iot_instance_id=None, dst_topic=None, src_topic=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.dst_topic = dst_topic  # type: list[str]
        self.src_topic = src_topic  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTopicRouteTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.dst_topic is not None:
            result['DstTopic'] = self.dst_topic
        if self.src_topic is not None:
            result['SrcTopic'] = self.src_topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DstTopic') is not None:
            self.dst_topic = m.get('DstTopic')
        if m.get('SrcTopic') is not None:
            self.src_topic = m.get('SrcTopic')
        return self


class DeleteTopicRouteTableResponseBodyFailureTopics(TeaModel):
    def __init__(self, topic=None):
        self.topic = topic  # type: list[dict[str, str]]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTopicRouteTableResponseBodyFailureTopics, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class DeleteTopicRouteTableResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, is_all_succeed=None, error_message=None,
                 failure_topics=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.is_all_succeed = is_all_succeed  # type: bool
        self.error_message = error_message  # type: str
        self.failure_topics = failure_topics  # type: DeleteTopicRouteTableResponseBodyFailureTopics

    def validate(self):
        if self.failure_topics:
            self.failure_topics.validate()

    def to_map(self):
        _map = super(DeleteTopicRouteTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.is_all_succeed is not None:
            result['IsAllSucceed'] = self.is_all_succeed
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.failure_topics is not None:
            result['FailureTopics'] = self.failure_topics.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('IsAllSucceed') is not None:
            self.is_all_succeed = m.get('IsAllSucceed')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('FailureTopics') is not None:
            temp_model = DeleteTopicRouteTableResponseBodyFailureTopics()
            self.failure_topics = temp_model.from_map(m['FailureTopics'])
        return self


class DeleteTopicRouteTableResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DeleteTopicRouteTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTopicRouteTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTopicRouteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableDeviceTunnelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableDeviceTunnelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class DisableDeviceTunnelResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableDeviceTunnelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DisableDeviceTunnelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DisableDeviceTunnelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DisableDeviceTunnelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisableDeviceTunnelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableDeviceTunnelShareRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableDeviceTunnelShareRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class DisableDeviceTunnelShareResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableDeviceTunnelShareResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class DisableDeviceTunnelShareResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DisableDeviceTunnelShareResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DisableDeviceTunnelShareResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisableDeviceTunnelShareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableSceneRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DisableSceneRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableSceneRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class DisableSceneRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DisableSceneRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DisableSceneRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisableSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableThingRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None, iot_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableThingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class DisableThingResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableThingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class DisableThingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DisableThingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DisableThingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisableThingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableDeviceTunnelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableDeviceTunnelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class EnableDeviceTunnelResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableDeviceTunnelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class EnableDeviceTunnelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: EnableDeviceTunnelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EnableDeviceTunnelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableDeviceTunnelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableDeviceTunnelShareRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableDeviceTunnelShareRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class EnableDeviceTunnelShareResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableDeviceTunnelShareResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class EnableDeviceTunnelShareResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: EnableDeviceTunnelShareResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EnableDeviceTunnelShareResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableDeviceTunnelShareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableSceneRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class EnableSceneRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableSceneRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class EnableSceneRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: EnableSceneRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EnableSceneRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableThingRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None, iot_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableThingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class EnableThingResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableThingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class EnableThingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: EnableThingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EnableThingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableThingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateDeviceNameListURLRequest(TeaModel):
    def __init__(self, iot_instance_id=None):
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateDeviceNameListURLRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GenerateDeviceNameListURLResponseBodyData(TeaModel):
    def __init__(self, key=None, host=None, policy=None, access_key_id=None, signature=None, file_url=None,
                 utc_create=None, object_storage=None):
        self.key = key  # type: str
        self.host = host  # type: str
        self.policy = policy  # type: str
        self.access_key_id = access_key_id  # type: str
        self.signature = signature  # type: str
        self.file_url = file_url  # type: str
        self.utc_create = utc_create  # type: str
        self.object_storage = object_storage  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateDeviceNameListURLResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.access_key_id is not None:
            result['AccessKeyId'] = self.access_key_id
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('AccessKeyId') is not None:
            self.access_key_id = m.get('AccessKeyId')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        return self


class GenerateDeviceNameListURLResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: GenerateDeviceNameListURLResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GenerateDeviceNameListURLResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GenerateDeviceNameListURLResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GenerateDeviceNameListURLResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GenerateDeviceNameListURLResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GenerateDeviceNameListURLResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GenerateDeviceNameListURLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateFileUploadURLRequest(TeaModel):
    def __init__(self, iot_instance_id=None, file_suffix=None, biz_code=None, file_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.file_suffix = file_suffix  # type: str
        self.biz_code = biz_code  # type: str
        self.file_name = file_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateFileUploadURLRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.file_suffix is not None:
            result['FileSuffix'] = self.file_suffix
        if self.biz_code is not None:
            result['BizCode'] = self.biz_code
        if self.file_name is not None:
            result['FileName'] = self.file_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FileSuffix') is not None:
            self.file_suffix = m.get('FileSuffix')
        if m.get('BizCode') is not None:
            self.biz_code = m.get('BizCode')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        return self


class GenerateFileUploadURLResponseBodyData(TeaModel):
    def __init__(self, key=None, host=None, policy=None, oss_access_key_id=None, signature=None, object_storage=None):
        self.key = key  # type: str
        self.host = host  # type: str
        self.policy = policy  # type: str
        self.oss_access_key_id = oss_access_key_id  # type: str
        self.signature = signature  # type: str
        self.object_storage = object_storage  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateFileUploadURLResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.oss_access_key_id is not None:
            result['OssAccessKeyId'] = self.oss_access_key_id
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('OssAccessKeyId') is not None:
            self.oss_access_key_id = m.get('OssAccessKeyId')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        return self


class GenerateFileUploadURLResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: GenerateFileUploadURLResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GenerateFileUploadURLResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GenerateFileUploadURLResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GenerateFileUploadURLResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GenerateFileUploadURLResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GenerateFileUploadURLResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GenerateFileUploadURLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateOTAUploadURLRequest(TeaModel):
    def __init__(self, iot_instance_id=None, file_suffix=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.file_suffix = file_suffix  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateOTAUploadURLRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.file_suffix is not None:
            result['FileSuffix'] = self.file_suffix
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FileSuffix') is not None:
            self.file_suffix = m.get('FileSuffix')
        return self


class GenerateOTAUploadURLResponseBodyData(TeaModel):
    def __init__(self, key=None, host=None, policy=None, ossaccess_key_id=None, signature=None, firmware_url=None,
                 utc_create=None, object_storage=None):
        self.key = key  # type: str
        self.host = host  # type: str
        self.policy = policy  # type: str
        self.ossaccess_key_id = ossaccess_key_id  # type: str
        self.signature = signature  # type: str
        self.firmware_url = firmware_url  # type: str
        self.utc_create = utc_create  # type: str
        self.object_storage = object_storage  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateOTAUploadURLResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.ossaccess_key_id is not None:
            result['OSSAccessKeyId'] = self.ossaccess_key_id
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('OSSAccessKeyId') is not None:
            self.ossaccess_key_id = m.get('OSSAccessKeyId')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        return self


class GenerateOTAUploadURLResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: GenerateOTAUploadURLResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GenerateOTAUploadURLResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GenerateOTAUploadURLResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GenerateOTAUploadURLResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GenerateOTAUploadURLResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GenerateOTAUploadURLResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GenerateOTAUploadURLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataAPIServiceDetailRequest(TeaModel):
    def __init__(self, api_srn=None, iot_instance_id=None):
        self.api_srn = api_srn  # type: str
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataAPIServiceDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParamsRequestParams(TeaModel):
    def __init__(self, name=None, type=None, desc=None, example=None, required=None):
        self.name = name  # type: str
        self.type = type  # type: str
        self.desc = desc  # type: str
        self.example = example  # type: str
        self.required = required  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParamsRequestParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParams(TeaModel):
    def __init__(self, request_params=None):
        self.request_params = request_params  # type: list[GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParamsRequestParams]

    def validate(self):
        if self.request_params:
            for k in self.request_params:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RequestParams'] = []
        if self.request_params is not None:
            for k in self.request_params:
                result['RequestParams'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.request_params = []
        if m.get('RequestParams') is not None:
            for k in m.get('RequestParams'):
                temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParamsRequestParams()
                self.request_params.append(temp_model.from_map(k))
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParamsResponseParams(TeaModel):
    def __init__(self, name=None, type=None, desc=None, example=None, required=None):
        self.name = name  # type: str
        self.type = type  # type: str
        self.desc = desc  # type: str
        self.example = example  # type: str
        self.required = required  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParamsResponseParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.example is not None:
            result['Example'] = self.example
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParams(TeaModel):
    def __init__(self, response_params=None):
        self.response_params = response_params  # type: list[GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParamsResponseParams]

    def validate(self):
        if self.response_params:
            for k in self.response_params:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ResponseParams'] = []
        if self.response_params is not None:
            for k in self.response_params:
                result['ResponseParams'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.response_params = []
        if m.get('ResponseParams') is not None:
            for k in m.get('ResponseParams'):
                temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParamsResponseParams()
                self.response_params.append(temp_model.from_map(k))
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTO(TeaModel):
    def __init__(self, origin_sql=None, template_sql=None, request_params=None, response_params=None):
        self.origin_sql = origin_sql  # type: str
        self.template_sql = template_sql  # type: str
        self.request_params = request_params  # type: GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParams
        self.response_params = response_params  # type: GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParams

    def validate(self):
        if self.request_params:
            self.request_params.validate()
        if self.response_params:
            self.response_params.validate()

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTO, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.origin_sql is not None:
            result['OriginSql'] = self.origin_sql
        if self.template_sql is not None:
            result['TemplateSql'] = self.template_sql
        if self.request_params is not None:
            result['RequestParams'] = self.request_params.to_map()
        if self.response_params is not None:
            result['ResponseParams'] = self.response_params.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OriginSql') is not None:
            self.origin_sql = m.get('OriginSql')
        if m.get('TemplateSql') is not None:
            self.template_sql = m.get('TemplateSql')
        if m.get('RequestParams') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParams()
            self.request_params = temp_model.from_map(m['RequestParams'])
        if m.get('ResponseParams') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParams()
            self.response_params = temp_model.from_map(m['ResponseParams'])
        return self


class GetDataAPIServiceDetailResponseBodyData(TeaModel):
    def __init__(self, api_srn=None, status=None, display_name=None, api_path=None, create_time=None,
                 last_update_time=None, date_format=None, request_method=None, request_protocol=None, description=None,
                 sql_template_dto=None):
        self.api_srn = api_srn  # type: str
        self.status = status  # type: int
        self.display_name = display_name  # type: str
        self.api_path = api_path  # type: str
        self.create_time = create_time  # type: long
        self.last_update_time = last_update_time  # type: long
        self.date_format = date_format  # type: str
        self.request_method = request_method  # type: str
        self.request_protocol = request_protocol  # type: str
        self.description = description  # type: str
        self.sql_template_dto = sql_template_dto  # type: GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTO

    def validate(self):
        if self.sql_template_dto:
            self.sql_template_dto.validate()

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.status is not None:
            result['Status'] = self.status
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_update_time is not None:
            result['LastUpdateTime'] = self.last_update_time
        if self.date_format is not None:
            result['DateFormat'] = self.date_format
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.request_protocol is not None:
            result['RequestProtocol'] = self.request_protocol
        if self.description is not None:
            result['Description'] = self.description
        if self.sql_template_dto is not None:
            result['SqlTemplateDTO'] = self.sql_template_dto.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastUpdateTime') is not None:
            self.last_update_time = m.get('LastUpdateTime')
        if m.get('DateFormat') is not None:
            self.date_format = m.get('DateFormat')
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('RequestProtocol') is not None:
            self.request_protocol = m.get('RequestProtocol')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SqlTemplateDTO') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTO()
            self.sql_template_dto = temp_model.from_map(m['SqlTemplateDTO'])
        return self


class GetDataAPIServiceDetailResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: GetDataAPIServiceDetailResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDataAPIServiceDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetDataAPIServiceDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDataAPIServiceDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataAPIServiceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceShadowRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceShadowRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class GetDeviceShadowResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, shadow_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.shadow_message = shadow_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceShadowResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.shadow_message is not None:
            result['ShadowMessage'] = self.shadow_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ShadowMessage') is not None:
            self.shadow_message = m.get('ShadowMessage')
        return self


class GetDeviceShadowResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetDeviceShadowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDeviceShadowResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceShadowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceStatusRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None, iot_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class GetDeviceStatusResponseBodyData(TeaModel):
    def __init__(self, status=None):
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceStatusResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetDeviceStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: GetDeviceStatusResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDeviceStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetDeviceStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDeviceStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetDeviceStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDeviceStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceTunnelShareStatusRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceTunnelShareStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class GetDeviceTunnelShareStatusResponseBodyData(TeaModel):
    def __init__(self, share_id=None, password=None, is_open=None, gmt_opened=None):
        self.share_id = share_id  # type: str
        self.password = password  # type: str
        self.is_open = is_open  # type: bool
        self.gmt_opened = gmt_opened  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceTunnelShareStatusResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.share_id is not None:
            result['ShareId'] = self.share_id
        if self.password is not None:
            result['Password'] = self.password
        if self.is_open is not None:
            result['IsOpen'] = self.is_open
        if self.gmt_opened is not None:
            result['GmtOpened'] = self.gmt_opened
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ShareId') is not None:
            self.share_id = m.get('ShareId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('IsOpen') is not None:
            self.is_open = m.get('IsOpen')
        if m.get('GmtOpened') is not None:
            self.gmt_opened = m.get('GmtOpened')
        return self


class GetDeviceTunnelShareStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str
        self.data = data  # type: GetDeviceTunnelShareStatusResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDeviceTunnelShareStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDeviceTunnelShareStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetDeviceTunnelShareStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetDeviceTunnelShareStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDeviceTunnelShareStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceTunnelShareStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceTunnelStatusRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceTunnelStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class GetDeviceTunnelStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str
        self.data = data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDeviceTunnelStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class GetDeviceTunnelStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetDeviceTunnelStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDeviceTunnelStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceTunnelStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeDriverVersionRequest(TeaModel):
    def __init__(self, iot_instance_id=None, driver_id=None, driver_version=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.driver_id = driver_id  # type: str
        self.driver_version = driver_version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEdgeDriverVersionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        return self


class GetEdgeDriverVersionResponseBodyData(TeaModel):
    def __init__(self, driver_id=None, driver_version=None, version_state=None, edge_version=None, description=None,
                 source_config=None, driver_config=None, container_config=None, config_check_rule=None,
                 gmt_create_timestamp=None, gmt_modified_timestamp=None, argument=None):
        self.driver_id = driver_id  # type: str
        self.driver_version = driver_version  # type: str
        self.version_state = version_state  # type: str
        self.edge_version = edge_version  # type: str
        self.description = description  # type: str
        self.source_config = source_config  # type: str
        self.driver_config = driver_config  # type: str
        self.container_config = container_config  # type: str
        self.config_check_rule = config_check_rule  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.argument = argument  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEdgeDriverVersionResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.version_state is not None:
            result['VersionState'] = self.version_state
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.description is not None:
            result['Description'] = self.description
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.argument is not None:
            result['Argument'] = self.argument
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('VersionState') is not None:
            self.version_state = m.get('VersionState')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        return self


class GetEdgeDriverVersionResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: GetEdgeDriverVersionResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetEdgeDriverVersionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetEdgeDriverVersionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetEdgeDriverVersionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetEdgeDriverVersionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetEdgeDriverVersionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetEdgeDriverVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeInstanceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEdgeInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetEdgeInstanceResponseBodyData(TeaModel):
    def __init__(self, instance_id=None, name=None, tags=None, type=None, spec=None, biz_enable=None, gmt_create=None,
                 gmt_modified=None, role_arn=None, role_name=None, role_attach_time=None, latest_deployment_status=None,
                 latest_deployment_type=None, gmt_create_timestamp=None, gmt_modified_timestamp=None, role_attach_timestamp=None):
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.tags = tags  # type: str
        self.type = type  # type: str
        self.spec = spec  # type: int
        self.biz_enable = biz_enable  # type: bool
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.role_arn = role_arn  # type: str
        self.role_name = role_name  # type: str
        self.role_attach_time = role_attach_time  # type: str
        self.latest_deployment_status = latest_deployment_status  # type: int
        self.latest_deployment_type = latest_deployment_type  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.role_attach_timestamp = role_attach_timestamp  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEdgeInstanceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.type is not None:
            result['Type'] = self.type
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.biz_enable is not None:
            result['BizEnable'] = self.biz_enable
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.role_attach_time is not None:
            result['RoleAttachTime'] = self.role_attach_time
        if self.latest_deployment_status is not None:
            result['LatestDeploymentStatus'] = self.latest_deployment_status
        if self.latest_deployment_type is not None:
            result['LatestDeploymentType'] = self.latest_deployment_type
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.role_attach_timestamp is not None:
            result['RoleAttachTimestamp'] = self.role_attach_timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('BizEnable') is not None:
            self.biz_enable = m.get('BizEnable')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('RoleAttachTime') is not None:
            self.role_attach_time = m.get('RoleAttachTime')
        if m.get('LatestDeploymentStatus') is not None:
            self.latest_deployment_status = m.get('LatestDeploymentStatus')
        if m.get('LatestDeploymentType') is not None:
            self.latest_deployment_type = m.get('LatestDeploymentType')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('RoleAttachTimestamp') is not None:
            self.role_attach_timestamp = m.get('RoleAttachTimestamp')
        return self


class GetEdgeInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: GetEdgeInstanceResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, deployment_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.deployment_id = deployment_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEdgeInstanceDeploymentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        return self


class GetEdgeInstanceDeploymentResponseBodyDataTaskListResourceSnapshotList(TeaModel):
    def __init__(self, gmt_create=None, gmt_modified=None, gmt_completed=None, snapshot_id=None, resource_type=None,
                 resource_id=None, resource_name=None, operate_type=None, stage=None, status=None, log=None,
                 gmt_create_timestamp=None, gmt_modified_timestamp=None, gmt_completed_timestamp=None):
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.gmt_completed = gmt_completed  # type: str
        self.snapshot_id = snapshot_id  # type: str
        self.resource_type = resource_type  # type: str
        self.resource_id = resource_id  # type: str
        self.resource_name = resource_name  # type: str
        self.operate_type = operate_type  # type: int
        self.stage = stage  # type: int
        self.status = status  # type: int
        self.log = log  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.gmt_completed_timestamp = gmt_completed_timestamp  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEdgeInstanceDeploymentResponseBodyDataTaskListResourceSnapshotList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.status is not None:
            result['Status'] = self.status
        if self.log is not None:
            result['Log'] = self.log
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Log') is not None:
            self.log = m.get('Log')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        return self


class GetEdgeInstanceDeploymentResponseBodyDataTaskList(TeaModel):
    def __init__(self, gmt_create=None, gmt_modified=None, gmt_completed=None, gateway_id=None, task_id=None,
                 stage=None, status=None, gmt_create_timestamp=None, gmt_modified_timestamp=None,
                 gmt_completed_timestamp=None, resource_snapshot_list=None):
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.gmt_completed = gmt_completed  # type: str
        self.gateway_id = gateway_id  # type: str
        self.task_id = task_id  # type: str
        self.stage = stage  # type: int
        self.status = status  # type: int
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.gmt_completed_timestamp = gmt_completed_timestamp  # type: long
        self.resource_snapshot_list = resource_snapshot_list  # type: list[GetEdgeInstanceDeploymentResponseBodyDataTaskListResourceSnapshotList]

    def validate(self):
        if self.resource_snapshot_list:
            for k in self.resource_snapshot_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceDeploymentResponseBodyDataTaskList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.status is not None:
            result['Status'] = self.status
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        result['ResourceSnapshotList'] = []
        if self.resource_snapshot_list is not None:
            for k in self.resource_snapshot_list:
                result['ResourceSnapshotList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        self.resource_snapshot_list = []
        if m.get('ResourceSnapshotList') is not None:
            for k in m.get('ResourceSnapshotList'):
                temp_model = GetEdgeInstanceDeploymentResponseBodyDataTaskListResourceSnapshotList()
                self.resource_snapshot_list.append(temp_model.from_map(k))
        return self


class GetEdgeInstanceDeploymentResponseBodyData(TeaModel):
    def __init__(self, gmt_create=None, gmt_modified=None, gmt_completed=None, deployment_id=None, description=None,
                 status=None, type=None, gmt_create_timestamp=None, gmt_modified_timestamp=None,
                 gmt_completed_timestamp=None, task_list=None):
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.gmt_completed = gmt_completed  # type: str
        self.deployment_id = deployment_id  # type: str
        self.description = description  # type: str
        self.status = status  # type: int
        self.type = type  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.gmt_completed_timestamp = gmt_completed_timestamp  # type: long
        self.task_list = task_list  # type: list[GetEdgeInstanceDeploymentResponseBodyDataTaskList]

    def validate(self):
        if self.task_list:
            for k in self.task_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceDeploymentResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.description is not None:
            result['Description'] = self.description
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        result['TaskList'] = []
        if self.task_list is not None:
            for k in self.task_list:
                result['TaskList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        self.task_list = []
        if m.get('TaskList') is not None:
            for k in m.get('TaskList'):
                temp_model = GetEdgeInstanceDeploymentResponseBodyDataTaskList()
                self.task_list.append(temp_model.from_map(k))
        return self


class GetEdgeInstanceDeploymentResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: GetEdgeInstanceDeploymentResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceDeploymentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceDeploymentResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetEdgeInstanceDeploymentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceDeploymentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetEdgeInstanceDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeInstanceMessageRoutingRequest(TeaModel):
    def __init__(self, iot_instance_id=None, instance_id=None, route_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.instance_id = instance_id  # type: str
        self.route_id = route_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEdgeInstanceMessageRoutingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.route_id is not None:
            result['RouteId'] = self.route_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RouteId') is not None:
            self.route_id = m.get('RouteId')
        return self


class GetEdgeInstanceMessageRoutingResponseBodyDataRouteContext(TeaModel):
    def __init__(self, source_fc_service_name=None, source_fc_function_name=None, source_application_name=None,
                 target_fc_service_name=None, target_fc_function_name=None, target_application_name=None, qos=None):
        self.source_fc_service_name = source_fc_service_name  # type: str
        self.source_fc_function_name = source_fc_function_name  # type: str
        self.source_application_name = source_application_name  # type: str
        self.target_fc_service_name = target_fc_service_name  # type: str
        self.target_fc_function_name = target_fc_function_name  # type: str
        self.target_application_name = target_application_name  # type: str
        self.qos = qos  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetEdgeInstanceMessageRoutingResponseBodyDataRouteContext, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_fc_service_name is not None:
            result['SourceFcServiceName'] = self.source_fc_service_name
        if self.source_fc_function_name is not None:
            result['SourceFcFunctionName'] = self.source_fc_function_name
        if self.source_application_name is not None:
            result['SourceApplicationName'] = self.source_application_name
        if self.target_fc_service_name is not None:
            result['TargetFcServiceName'] = self.target_fc_service_name
        if self.target_fc_function_name is not None:
            result['TargetFcFunctionName'] = self.target_fc_function_name
        if self.target_application_name is not None:
            result['TargetApplicationName'] = self.target_application_name
        if self.qos is not None:
            result['Qos'] = self.qos
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceFcServiceName') is not None:
            self.source_fc_service_name = m.get('SourceFcServiceName')
        if m.get('SourceFcFunctionName') is not None:
            self.source_fc_function_name = m.get('SourceFcFunctionName')
        if m.get('SourceApplicationName') is not None:
            self.source_application_name = m.get('SourceApplicationName')
        if m.get('TargetFcServiceName') is not None:
            self.target_fc_service_name = m.get('TargetFcServiceName')
        if m.get('TargetFcFunctionName') is not None:
            self.target_fc_function_name = m.get('TargetFcFunctionName')
        if m.get('TargetApplicationName') is not None:
            self.target_application_name = m.get('TargetApplicationName')
        if m.get('Qos') is not None:
            self.qos = m.get('Qos')
        return self


class GetEdgeInstanceMessageRoutingResponseBodyData(TeaModel):
    def __init__(self, topic_filter=None, source_type=None, name=None, source_data=None, target_type=None,
                 target_data=None, gmt_create=None, gmt_modified=None, gmt_create_timestamp=None, gmt_modified_timestamp=None,
                 route_context=None):
        self.topic_filter = topic_filter  # type: str
        self.source_type = source_type  # type: str
        self.name = name  # type: str
        self.source_data = source_data  # type: str
        self.target_type = target_type  # type: str
        self.target_data = target_data  # type: str
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.route_context = route_context  # type: GetEdgeInstanceMessageRoutingResponseBodyDataRouteContext

    def validate(self):
        if self.route_context:
            self.route_context.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceMessageRoutingResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.topic_filter is not None:
            result['TopicFilter'] = self.topic_filter
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.name is not None:
            result['Name'] = self.name
        if self.source_data is not None:
            result['SourceData'] = self.source_data
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.target_data is not None:
            result['TargetData'] = self.target_data
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.route_context is not None:
            result['RouteContext'] = self.route_context.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TopicFilter') is not None:
            self.topic_filter = m.get('TopicFilter')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SourceData') is not None:
            self.source_data = m.get('SourceData')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TargetData') is not None:
            self.target_data = m.get('TargetData')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('RouteContext') is not None:
            temp_model = GetEdgeInstanceMessageRoutingResponseBodyDataRouteContext()
            self.route_context = temp_model.from_map(m['RouteContext'])
        return self


class GetEdgeInstanceMessageRoutingResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: GetEdgeInstanceMessageRoutingResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceMessageRoutingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceMessageRoutingResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetEdgeInstanceMessageRoutingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetEdgeInstanceMessageRoutingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetEdgeInstanceMessageRoutingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetEdgeInstanceMessageRoutingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetGatewayBySubDeviceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None, iot_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetGatewayBySubDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class GetGatewayBySubDeviceResponseBodyData(TeaModel):
    def __init__(self, product_key=None, product_name=None, device_secret=None, device_name=None,
                 firmware_version=None, gmt_create=None, utc_create=None, gmt_active=None, utc_active=None, gmt_online=None,
                 utc_online=None, status=None, ip_address=None, node_type=None, region=None, iot_id=None):
        self.product_key = product_key  # type: str
        self.product_name = product_name  # type: str
        self.device_secret = device_secret  # type: str
        self.device_name = device_name  # type: str
        self.firmware_version = firmware_version  # type: str
        self.gmt_create = gmt_create  # type: str
        self.utc_create = utc_create  # type: str
        self.gmt_active = gmt_active  # type: str
        self.utc_active = utc_active  # type: str
        self.gmt_online = gmt_online  # type: str
        self.utc_online = utc_online  # type: str
        self.status = status  # type: str
        self.ip_address = ip_address  # type: str
        self.node_type = node_type  # type: str
        self.region = region  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetGatewayBySubDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.gmt_active is not None:
            result['GmtActive'] = self.gmt_active
        if self.utc_active is not None:
            result['UtcActive'] = self.utc_active
        if self.gmt_online is not None:
            result['GmtOnline'] = self.gmt_online
        if self.utc_online is not None:
            result['UtcOnline'] = self.utc_online
        if self.status is not None:
            result['Status'] = self.status
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.region is not None:
            result['region'] = self.region
        if self.iot_id is not None:
            result['iotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GmtActive') is not None:
            self.gmt_active = m.get('GmtActive')
        if m.get('UtcActive') is not None:
            self.utc_active = m.get('UtcActive')
        if m.get('GmtOnline') is not None:
            self.gmt_online = m.get('GmtOnline')
        if m.get('UtcOnline') is not None:
            self.utc_online = m.get('UtcOnline')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('iotId') is not None:
            self.iot_id = m.get('iotId')
        return self


class GetGatewayBySubDeviceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: GetGatewayBySubDeviceResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetGatewayBySubDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetGatewayBySubDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetGatewayBySubDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetGatewayBySubDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetGatewayBySubDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetGatewayBySubDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLoraNodesTaskRequest(TeaModel):
    def __init__(self, iot_instance_id=None, task_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLoraNodesTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetLoraNodesTaskResponseBodySuccessDevEuis(TeaModel):
    def __init__(self, success_dev_eui=None):
        self.success_dev_eui = success_dev_eui  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetLoraNodesTaskResponseBodySuccessDevEuis, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success_dev_eui is not None:
            result['SuccessDevEui'] = self.success_dev_eui
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SuccessDevEui') is not None:
            self.success_dev_eui = m.get('SuccessDevEui')
        return self


class GetLoraNodesTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, task_id=None, task_state=None,
                 total_count=None, success_count=None, success_dev_euis=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.task_id = task_id  # type: str
        self.task_state = task_state  # type: str
        self.total_count = total_count  # type: long
        self.success_count = success_count  # type: long
        self.success_dev_euis = success_dev_euis  # type: GetLoraNodesTaskResponseBodySuccessDevEuis

    def validate(self):
        if self.success_dev_euis:
            self.success_dev_euis.validate()

    def to_map(self):
        _map = super(GetLoraNodesTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.success_dev_euis is not None:
            result['SuccessDevEuis'] = self.success_dev_euis.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('SuccessDevEuis') is not None:
            temp_model = GetLoraNodesTaskResponseBodySuccessDevEuis()
            self.success_dev_euis = temp_model.from_map(m['SuccessDevEuis'])
        return self


class GetLoraNodesTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetLoraNodesTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetLoraNodesTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetLoraNodesTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodesAddingTaskRequest(TeaModel):
    def __init__(self, iot_instance_id=None, task_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNodesAddingTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetNodesAddingTaskResponseBodySuccessDevEuis(TeaModel):
    def __init__(self, success_dev_eui=None):
        self.success_dev_eui = success_dev_eui  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNodesAddingTaskResponseBodySuccessDevEuis, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success_dev_eui is not None:
            result['SuccessDevEui'] = self.success_dev_eui
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SuccessDevEui') is not None:
            self.success_dev_eui = m.get('SuccessDevEui')
        return self


class GetNodesAddingTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, task_id=None, task_state=None,
                 total_count=None, success_count=None, success_dev_euis=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.task_id = task_id  # type: str
        self.task_state = task_state  # type: str
        self.total_count = total_count  # type: long
        self.success_count = success_count  # type: long
        self.success_dev_euis = success_dev_euis  # type: GetNodesAddingTaskResponseBodySuccessDevEuis

    def validate(self):
        if self.success_dev_euis:
            self.success_dev_euis.validate()

    def to_map(self):
        _map = super(GetNodesAddingTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.success_dev_euis is not None:
            result['SuccessDevEuis'] = self.success_dev_euis.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('SuccessDevEuis') is not None:
            temp_model = GetNodesAddingTaskResponseBodySuccessDevEuis()
            self.success_dev_euis = temp_model.from_map(m['SuccessDevEuis'])
        return self


class GetNodesAddingTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetNodesAddingTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetNodesAddingTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodesAddingTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class GetRuleResponseBodyRuleInfo(TeaModel):
    def __init__(self, id=None, select=None, topic=None, short_topic=None, where=None, status=None,
                 create_user_id=None, product_key=None, name=None, rule_desc=None, data_type=None, created=None, utc_created=None,
                 modified=None, utc_modified=None, topic_type=None):
        self.id = id  # type: long
        self.select = select  # type: str
        self.topic = topic  # type: str
        self.short_topic = short_topic  # type: str
        self.where = where  # type: str
        self.status = status  # type: str
        self.create_user_id = create_user_id  # type: long
        self.product_key = product_key  # type: str
        self.name = name  # type: str
        self.rule_desc = rule_desc  # type: str
        self.data_type = data_type  # type: str
        self.created = created  # type: str
        self.utc_created = utc_created  # type: str
        self.modified = modified  # type: str
        self.utc_modified = utc_modified  # type: str
        self.topic_type = topic_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRuleResponseBodyRuleInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.select is not None:
            result['Select'] = self.select
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.short_topic is not None:
            result['ShortTopic'] = self.short_topic
        if self.where is not None:
            result['Where'] = self.where
        if self.status is not None:
            result['Status'] = self.status
        if self.create_user_id is not None:
            result['CreateUserId'] = self.create_user_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.created is not None:
            result['Created'] = self.created
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        if self.modified is not None:
            result['Modified'] = self.modified
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.topic_type is not None:
            result['TopicType'] = self.topic_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('ShortTopic') is not None:
            self.short_topic = m.get('ShortTopic')
        if m.get('Where') is not None:
            self.where = m.get('Where')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CreateUserId') is not None:
            self.create_user_id = m.get('CreateUserId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('Created') is not None:
            self.created = m.get('Created')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        if m.get('Modified') is not None:
            self.modified = m.get('Modified')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('TopicType') is not None:
            self.topic_type = m.get('TopicType')
        return self


class GetRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, rule_info=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.rule_info = rule_info  # type: GetRuleResponseBodyRuleInfo

    def validate(self):
        if self.rule_info:
            self.rule_info.validate()

    def to_map(self):
        _map = super(GetRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.rule_info is not None:
            result['RuleInfo'] = self.rule_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RuleInfo') is not None:
            temp_model = GetRuleResponseBodyRuleInfo()
            self.rule_info = temp_model.from_map(m['RuleInfo'])
        return self


class GetRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRuleActionRequest(TeaModel):
    def __init__(self, iot_instance_id=None, action_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.action_id = action_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRuleActionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        return self


class GetRuleActionResponseBodyRuleActionInfo(TeaModel):
    def __init__(self, id=None, rule_id=None, type=None, configuration=None, error_action_flag=None):
        self.id = id  # type: long
        self.rule_id = rule_id  # type: long
        self.type = type  # type: str
        self.configuration = configuration  # type: str
        self.error_action_flag = error_action_flag  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRuleActionResponseBodyRuleActionInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.type is not None:
            result['Type'] = self.type
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.error_action_flag is not None:
            result['ErrorActionFlag'] = self.error_action_flag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('ErrorActionFlag') is not None:
            self.error_action_flag = m.get('ErrorActionFlag')
        return self


class GetRuleActionResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, rule_action_info=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.rule_action_info = rule_action_info  # type: GetRuleActionResponseBodyRuleActionInfo

    def validate(self):
        if self.rule_action_info:
            self.rule_action_info.validate()

    def to_map(self):
        _map = super(GetRuleActionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.rule_action_info is not None:
            result['RuleActionInfo'] = self.rule_action_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RuleActionInfo') is not None:
            temp_model = GetRuleActionResponseBodyRuleActionInfo()
            self.rule_action_info = temp_model.from_map(m['RuleActionInfo'])
        return self


class GetRuleActionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetRuleActionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetRuleActionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetRuleActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSceneRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSceneRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class GetSceneRuleResponseBodyData(TeaModel):
    def __init__(self, gmt_create=None, gmt_modified=None, rule_name=None, rule_content=None, rule_description=None,
                 rule_status=None):
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.rule_name = rule_name  # type: str
        self.rule_content = rule_content  # type: str
        self.rule_description = rule_description  # type: str
        self.rule_status = rule_status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSceneRuleResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        if self.rule_status is not None:
            result['RuleStatus'] = self.rule_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        if m.get('RuleStatus') is not None:
            self.rule_status = m.get('RuleStatus')
        return self


class GetSceneRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str
        self.data = data  # type: GetSceneRuleResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSceneRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSceneRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetSceneRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetSceneRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSceneRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingModelTslRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, model_version=None, simple=None,
                 function_block_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.model_version = model_version  # type: str
        self.simple = simple  # type: bool
        self.function_block_id = function_block_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingModelTslRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.simple is not None:
            result['Simple'] = self.simple
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('Simple') is not None:
            self.simple = m.get('Simple')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class GetThingModelTslResponseBodyData(TeaModel):
    def __init__(self, tsl_str=None, tsl_uri=None):
        self.tsl_str = tsl_str  # type: str
        self.tsl_uri = tsl_uri  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingModelTslResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_uri is not None:
            result['TslUri'] = self.tsl_uri
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUri') is not None:
            self.tsl_uri = m.get('TslUri')
        return self


class GetThingModelTslResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: GetThingModelTslResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetThingModelTslResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetThingModelTslResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetThingModelTslResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetThingModelTslResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetThingModelTslResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingModelTslResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingModelTslPublishedRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, resource_group_id=None, simple=None,
                 model_version=None, function_block_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.simple = simple  # type: bool
        self.model_version = model_version  # type: str
        self.function_block_id = function_block_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingModelTslPublishedRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.simple is not None:
            result['Simple'] = self.simple
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Simple') is not None:
            self.simple = m.get('Simple')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class GetThingModelTslPublishedResponseBodyData(TeaModel):
    def __init__(self, tsl_str=None, tsl_uri=None):
        self.tsl_str = tsl_str  # type: str
        self.tsl_uri = tsl_uri  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingModelTslPublishedResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_uri is not None:
            result['TslUri'] = self.tsl_uri
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUri') is not None:
            self.tsl_uri = m.get('TslUri')
        return self


class GetThingModelTslPublishedResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: GetThingModelTslPublishedResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetThingModelTslPublishedResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetThingModelTslPublishedResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetThingModelTslPublishedResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetThingModelTslPublishedResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetThingModelTslPublishedResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingModelTslPublishedResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingScriptRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingScriptRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetThingScriptResponseBodyData(TeaModel):
    def __init__(self, script_type=None, script_url=None):
        self.script_type = script_type  # type: str
        self.script_url = script_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingScriptResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.script_type is not None:
            result['ScriptType'] = self.script_type
        if self.script_url is not None:
            result['ScriptUrl'] = self.script_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ScriptType') is not None:
            self.script_type = m.get('ScriptType')
        if m.get('ScriptUrl') is not None:
            self.script_url = m.get('ScriptUrl')
        return self


class GetThingScriptResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: GetThingScriptResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetThingScriptResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetThingScriptResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetThingScriptResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetThingScriptResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetThingScriptResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingScriptResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingTemplateRequest(TeaModel):
    def __init__(self, iot_instance_id=None, resource_group_id=None, category_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.category_key = category_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        return self


class GetThingTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, thing_model_json=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.thing_model_json = thing_model_json  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.thing_model_json is not None:
            result['ThingModelJSON'] = self.thing_model_json
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('ThingModelJSON') is not None:
            self.thing_model_json = m.get('ThingModelJSON')
        return self


class GetThingTemplateResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetThingTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetThingTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingTopoRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, product_key=None, device_name=None, page_no=None,
                 iot_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.page_size = page_size  # type: int
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.page_no = page_no  # type: int
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingTopoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class GetThingTopoResponseBodyDataListDeviceInfo(TeaModel):
    def __init__(self, iot_id=None, product_key=None, device_name=None):
        self.iot_id = iot_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetThingTopoResponseBodyDataListDeviceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class GetThingTopoResponseBodyDataList(TeaModel):
    def __init__(self, device_info=None):
        self.device_info = device_info  # type: list[GetThingTopoResponseBodyDataListDeviceInfo]

    def validate(self):
        if self.device_info:
            for k in self.device_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetThingTopoResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['deviceInfo'] = []
        if self.device_info is not None:
            for k in self.device_info:
                result['deviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_info = []
        if m.get('deviceInfo') is not None:
            for k in m.get('deviceInfo'):
                temp_model = GetThingTopoResponseBodyDataListDeviceInfo()
                self.device_info.append(temp_model.from_map(k))
        return self


class GetThingTopoResponseBodyData(TeaModel):
    def __init__(self, total=None, current_page=None, page_size=None, page_count=None, list=None):
        self.total = total  # type: long
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: long
        self.list = list  # type: GetThingTopoResponseBodyDataList

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        _map = super(GetThingTopoResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('List') is not None:
            temp_model = GetThingTopoResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class GetThingTopoResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: GetThingTopoResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetThingTopoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = GetThingTopoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class GetThingTopoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetThingTopoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetThingTopoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingTopoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportThingModelTslRequest(TeaModel):
    def __init__(self, iot_instance_id=None, resource_group_id=None, product_key=None, tsl_str=None, tsl_url=None,
                 function_block_id=None, function_block_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.product_key = product_key  # type: str
        self.tsl_str = tsl_str  # type: str
        self.tsl_url = tsl_url  # type: str
        self.function_block_id = function_block_id  # type: str
        self.function_block_name = function_block_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImportThingModelTslRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_url is not None:
            result['TslUrl'] = self.tsl_url
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.function_block_name is not None:
            result['FunctionBlockName'] = self.function_block_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUrl') is not None:
            self.tsl_url = m.get('TslUrl')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('FunctionBlockName') is not None:
            self.function_block_name = m.get('FunctionBlockName')
        return self


class ImportThingModelTslResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ImportThingModelTslResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class ImportThingModelTslResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ImportThingModelTslResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ImportThingModelTslResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ImportThingModelTslResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvokeDataAPIServiceRequestParam(TeaModel):
    def __init__(self, param_type=None, list_param_value=None, list_param_type=None, param_name=None,
                 param_value=None):
        self.param_type = param_type  # type: str
        self.list_param_value = list_param_value  # type: list[str]
        self.list_param_type = list_param_type  # type: str
        self.param_name = param_name  # type: str
        self.param_value = param_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvokeDataAPIServiceRequestParam, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.param_type is not None:
            result['ParamType'] = self.param_type
        if self.list_param_value is not None:
            result['ListParamValue'] = self.list_param_value
        if self.list_param_type is not None:
            result['ListParamType'] = self.list_param_type
        if self.param_name is not None:
            result['ParamName'] = self.param_name
        if self.param_value is not None:
            result['ParamValue'] = self.param_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParamType') is not None:
            self.param_type = m.get('ParamType')
        if m.get('ListParamValue') is not None:
            self.list_param_value = m.get('ListParamValue')
        if m.get('ListParamType') is not None:
            self.list_param_type = m.get('ListParamType')
        if m.get('ParamName') is not None:
            self.param_name = m.get('ParamName')
        if m.get('ParamValue') is not None:
            self.param_value = m.get('ParamValue')
        return self


class InvokeDataAPIServiceRequest(TeaModel):
    def __init__(self, api_srn=None, param=None, iot_instance_id=None):
        self.api_srn = api_srn  # type: str
        self.param = param  # type: list[InvokeDataAPIServiceRequestParam]
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        if self.param:
            for k in self.param:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(InvokeDataAPIServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        result['Param'] = []
        if self.param is not None:
            for k in self.param:
                result['Param'].append(k.to_map() if k else None)
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        self.param = []
        if m.get('Param') is not None:
            for k in m.get('Param'):
                temp_model = InvokeDataAPIServiceRequestParam()
                self.param.append(temp_model.from_map(k))
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class InvokeDataAPIServiceResponseBodyDataFieldNameList(TeaModel):
    def __init__(self, field_name_list=None):
        self.field_name_list = field_name_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvokeDataAPIServiceResponseBodyDataFieldNameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_name_list is not None:
            result['FieldNameList'] = self.field_name_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FieldNameList') is not None:
            self.field_name_list = m.get('FieldNameList')
        return self


class InvokeDataAPIServiceResponseBodyDataResultList(TeaModel):
    def __init__(self, result_list=None):
        self.result_list = result_list  # type: list[dict[str, str]]

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvokeDataAPIServiceResponseBodyDataResultList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result_list is not None:
            result['ResultList'] = self.result_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResultList') is not None:
            self.result_list = m.get('ResultList')
        return self


class InvokeDataAPIServiceResponseBodyData(TeaModel):
    def __init__(self, page_no=None, page_size=None, api_srn=None, field_name_list=None, result_list=None):
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.api_srn = api_srn  # type: str
        self.field_name_list = field_name_list  # type: InvokeDataAPIServiceResponseBodyDataFieldNameList
        self.result_list = result_list  # type: InvokeDataAPIServiceResponseBodyDataResultList

    def validate(self):
        if self.field_name_list:
            self.field_name_list.validate()
        if self.result_list:
            self.result_list.validate()

    def to_map(self):
        _map = super(InvokeDataAPIServiceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.field_name_list is not None:
            result['FieldNameList'] = self.field_name_list.to_map()
        if self.result_list is not None:
            result['ResultList'] = self.result_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('FieldNameList') is not None:
            temp_model = InvokeDataAPIServiceResponseBodyDataFieldNameList()
            self.field_name_list = temp_model.from_map(m['FieldNameList'])
        if m.get('ResultList') is not None:
            temp_model = InvokeDataAPIServiceResponseBodyDataResultList()
            self.result_list = temp_model.from_map(m['ResultList'])
        return self


class InvokeDataAPIServiceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: InvokeDataAPIServiceResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(InvokeDataAPIServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = InvokeDataAPIServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class InvokeDataAPIServiceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: InvokeDataAPIServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InvokeDataAPIServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InvokeDataAPIServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvokeThingServiceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None, identifier=None, args=None,
                 iot_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.identifier = identifier  # type: str
        self.args = args  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvokeThingServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.args is not None:
            result['Args'] = self.args
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Args') is not None:
            self.args = m.get('Args')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class InvokeThingServiceResponseBodyData(TeaModel):
    def __init__(self, result=None, message_id=None):
        self.result = result  # type: str
        self.message_id = message_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvokeThingServiceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.result is not None:
            result['Result'] = self.result
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class InvokeThingServiceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str
        self.data = data  # type: InvokeThingServiceResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(InvokeThingServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = InvokeThingServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class InvokeThingServiceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: InvokeThingServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InvokeThingServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InvokeThingServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvokeThingsServiceRequest(TeaModel):
    def __init__(self, device_name=None, iot_instance_id=None, product_key=None, identifier=None, args=None):
        self.device_name = device_name  # type: list[str]
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.identifier = identifier  # type: str
        self.args = args  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvokeThingsServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.args is not None:
            result['Args'] = self.args
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Args') is not None:
            self.args = m.get('Args')
        return self


class InvokeThingsServiceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InvokeThingsServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class InvokeThingsServiceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: InvokeThingsServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InvokeThingsServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InvokeThingsServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAnalyticsDataRequestCondition(TeaModel):
    def __init__(self, field_name=None, operate=None, value=None, between_start=None, between_end=None):
        self.field_name = field_name  # type: str
        self.operate = operate  # type: str
        self.value = value  # type: str
        self.between_start = between_start  # type: str
        self.between_end = between_end  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAnalyticsDataRequestCondition, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_name is not None:
            result['FieldName'] = self.field_name
        if self.operate is not None:
            result['Operate'] = self.operate
        if self.value is not None:
            result['Value'] = self.value
        if self.between_start is not None:
            result['BetweenStart'] = self.between_start
        if self.between_end is not None:
            result['BetweenEnd'] = self.between_end
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FieldName') is not None:
            self.field_name = m.get('FieldName')
        if m.get('Operate') is not None:
            self.operate = m.get('Operate')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('BetweenStart') is not None:
            self.between_start = m.get('BetweenStart')
        if m.get('BetweenEnd') is not None:
            self.between_end = m.get('BetweenEnd')
        return self


class ListAnalyticsDataRequest(TeaModel):
    def __init__(self, iot_instance_id=None, iso_id=None, api_path=None, page_size=None, condition=None,
                 page_num=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.iso_id = iso_id  # type: str
        self.api_path = api_path  # type: str
        self.page_size = page_size  # type: int
        self.condition = condition  # type: list[ListAnalyticsDataRequestCondition]
        self.page_num = page_num  # type: int

    def validate(self):
        if self.condition:
            for k in self.condition:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAnalyticsDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.iso_id is not None:
            result['IsoId'] = self.iso_id
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Condition'] = []
        if self.condition is not None:
            for k in self.condition:
                result['Condition'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('IsoId') is not None:
            self.iso_id = m.get('IsoId')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.condition = []
        if m.get('Condition') is not None:
            for k in m.get('Condition'):
                temp_model = ListAnalyticsDataRequestCondition()
                self.condition.append(temp_model.from_map(k))
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        return self


class ListAnalyticsDataResponseBodyData(TeaModel):
    def __init__(self, has_next=None, result_json=None, count=None, page_num=None, page_size=None):
        self.has_next = has_next  # type: bool
        self.result_json = result_json  # type: str
        self.count = count  # type: long
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAnalyticsDataResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.has_next is not None:
            result['HasNext'] = self.has_next
        if self.result_json is not None:
            result['ResultJson'] = self.result_json
        if self.count is not None:
            result['Count'] = self.count
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HasNext') is not None:
            self.has_next = m.get('HasNext')
        if m.get('ResultJson') is not None:
            self.result_json = m.get('ResultJson')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListAnalyticsDataResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: ListAnalyticsDataResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListAnalyticsDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListAnalyticsDataResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListAnalyticsDataResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListAnalyticsDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAnalyticsDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAnalyticsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDeviceDistributeJobRequest(TeaModel):
    def __init__(self, target_uid=None, current_page=None, page_size=None, status=None):
        self.target_uid = target_uid  # type: str
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDeviceDistributeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListDeviceDistributeJobResponseBodyDataJobInfoItemsTargetInstanceConfigsTargetInstanceConfigs(TeaModel):
    def __init__(self, target_instance_id=None):
        self.target_instance_id = target_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDeviceDistributeJobResponseBodyDataJobInfoItemsTargetInstanceConfigsTargetInstanceConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        return self


class ListDeviceDistributeJobResponseBodyDataJobInfoItemsTargetInstanceConfigs(TeaModel):
    def __init__(self, target_instance_configs=None):
        self.target_instance_configs = target_instance_configs  # type: list[ListDeviceDistributeJobResponseBodyDataJobInfoItemsTargetInstanceConfigsTargetInstanceConfigs]

    def validate(self):
        if self.target_instance_configs:
            for k in self.target_instance_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDeviceDistributeJobResponseBodyDataJobInfoItemsTargetInstanceConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['targetInstanceConfigs'] = []
        if self.target_instance_configs is not None:
            for k in self.target_instance_configs:
                result['targetInstanceConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.target_instance_configs = []
        if m.get('targetInstanceConfigs') is not None:
            for k in m.get('targetInstanceConfigs'):
                temp_model = ListDeviceDistributeJobResponseBodyDataJobInfoItemsTargetInstanceConfigsTargetInstanceConfigs()
                self.target_instance_configs.append(temp_model.from_map(k))
        return self


class ListDeviceDistributeJobResponseBodyDataJobInfoItems(TeaModel):
    def __init__(self, gmt_create=None, source_uid=None, target_uid=None, job_id=None, source_instance_id=None,
                 product_key=None, total=None, status=None, strategy=None, target_instance_configs=None):
        self.gmt_create = gmt_create  # type: long
        self.source_uid = source_uid  # type: str
        self.target_uid = target_uid  # type: str
        self.job_id = job_id  # type: str
        self.source_instance_id = source_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.total = total  # type: int
        self.status = status  # type: int
        self.strategy = strategy  # type: int
        self.target_instance_configs = target_instance_configs  # type: ListDeviceDistributeJobResponseBodyDataJobInfoItemsTargetInstanceConfigs

    def validate(self):
        if self.target_instance_configs:
            self.target_instance_configs.validate()

    def to_map(self):
        _map = super(ListDeviceDistributeJobResponseBodyDataJobInfoItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.source_uid is not None:
            result['SourceUid'] = self.source_uid
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.total is not None:
            result['Total'] = self.total
        if self.status is not None:
            result['Status'] = self.status
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        if self.target_instance_configs is not None:
            result['TargetInstanceConfigs'] = self.target_instance_configs.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('SourceUid') is not None:
            self.source_uid = m.get('SourceUid')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        if m.get('TargetInstanceConfigs') is not None:
            temp_model = ListDeviceDistributeJobResponseBodyDataJobInfoItemsTargetInstanceConfigs()
            self.target_instance_configs = temp_model.from_map(m['TargetInstanceConfigs'])
        return self


class ListDeviceDistributeJobResponseBodyDataJobInfo(TeaModel):
    def __init__(self, items=None):
        self.items = items  # type: list[ListDeviceDistributeJobResponseBodyDataJobInfoItems]

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDeviceDistributeJobResponseBodyDataJobInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListDeviceDistributeJobResponseBodyDataJobInfoItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListDeviceDistributeJobResponseBodyData(TeaModel):
    def __init__(self, total=None, job_info=None):
        self.total = total  # type: int
        self.job_info = job_info  # type: ListDeviceDistributeJobResponseBodyDataJobInfo

    def validate(self):
        if self.job_info:
            self.job_info.validate()

    def to_map(self):
        _map = super(ListDeviceDistributeJobResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.job_info is not None:
            result['JobInfo'] = self.job_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('JobInfo') is not None:
            temp_model = ListDeviceDistributeJobResponseBodyDataJobInfo()
            self.job_info = temp_model.from_map(m['JobInfo'])
        return self


class ListDeviceDistributeJobResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: ListDeviceDistributeJobResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListDeviceDistributeJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListDeviceDistributeJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDeviceDistributeJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListDeviceDistributeJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListDeviceDistributeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDeviceDistributeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDistributedDeviceRequest(TeaModel):
    def __init__(self, page_size=None, product_key=None, device_name=None, current_page=None, target_uid=None,
                 source_instance_id=None):
        self.page_size = page_size  # type: int
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.current_page = current_page  # type: int
        self.target_uid = target_uid  # type: str
        self.source_instance_id = source_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDistributedDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        return self


class ListDistributedDeviceResponseBodyDataInfoItems(TeaModel):
    def __init__(self, source_uid=None, target_uid=None, product_key=None, device_name=None,
                 source_instance_id=None, target_instance_id=None, gmt_create=None, target_aliyun_id=None, source_region=None,
                 target_region=None, source_instance_name=None, target_instance_name=None, gmt_modified=None):
        self.source_uid = source_uid  # type: str
        self.target_uid = target_uid  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.source_instance_id = source_instance_id  # type: str
        self.target_instance_id = target_instance_id  # type: str
        self.gmt_create = gmt_create  # type: long
        self.target_aliyun_id = target_aliyun_id  # type: str
        self.source_region = source_region  # type: str
        self.target_region = target_region  # type: str
        self.source_instance_name = source_instance_name  # type: str
        self.target_instance_name = target_instance_name  # type: str
        self.gmt_modified = gmt_modified  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDistributedDeviceResponseBodyDataInfoItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_uid is not None:
            result['SourceUid'] = self.source_uid
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        if self.source_region is not None:
            result['SourceRegion'] = self.source_region
        if self.target_region is not None:
            result['TargetRegion'] = self.target_region
        if self.source_instance_name is not None:
            result['SourceInstanceName'] = self.source_instance_name
        if self.target_instance_name is not None:
            result['TargetInstanceName'] = self.target_instance_name
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceUid') is not None:
            self.source_uid = m.get('SourceUid')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        if m.get('SourceRegion') is not None:
            self.source_region = m.get('SourceRegion')
        if m.get('TargetRegion') is not None:
            self.target_region = m.get('TargetRegion')
        if m.get('SourceInstanceName') is not None:
            self.source_instance_name = m.get('SourceInstanceName')
        if m.get('TargetInstanceName') is not None:
            self.target_instance_name = m.get('TargetInstanceName')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        return self


class ListDistributedDeviceResponseBodyDataInfo(TeaModel):
    def __init__(self, items=None):
        self.items = items  # type: list[ListDistributedDeviceResponseBodyDataInfoItems]

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDistributedDeviceResponseBodyDataInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListDistributedDeviceResponseBodyDataInfoItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListDistributedDeviceResponseBodyData(TeaModel):
    def __init__(self, total=None, info=None):
        self.total = total  # type: int
        self.info = info  # type: ListDistributedDeviceResponseBodyDataInfo

    def validate(self):
        if self.info:
            self.info.validate()

    def to_map(self):
        _map = super(ListDistributedDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.info is not None:
            result['Info'] = self.info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Info') is not None:
            temp_model = ListDistributedDeviceResponseBodyDataInfo()
            self.info = temp_model.from_map(m['Info'])
        return self


class ListDistributedDeviceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: ListDistributedDeviceResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListDistributedDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListDistributedDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDistributedDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListDistributedDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListDistributedDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDistributedDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDistributedProductRequest(TeaModel):
    def __init__(self, page_size=None, source_instance_id=None, product_key=None, target_instance_id=None,
                 target_uid=None, current_page=None):
        self.page_size = page_size  # type: int
        self.source_instance_id = source_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.target_instance_id = target_instance_id  # type: str
        self.target_uid = target_uid  # type: str
        self.current_page = current_page  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDistributedProductRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListDistributedProductResponseBodyDataInfoItems(TeaModel):
    def __init__(self, source_uid=None, target_uid=None, product_key=None, source_instance_id=None,
                 target_instance_id=None, gmt_create=None, target_aliyun_id=None, source_region=None, target_region=None,
                 source_instance_name=None, target_instance_name=None):
        self.source_uid = source_uid  # type: str
        self.target_uid = target_uid  # type: str
        self.product_key = product_key  # type: str
        self.source_instance_id = source_instance_id  # type: str
        self.target_instance_id = target_instance_id  # type: str
        self.gmt_create = gmt_create  # type: int
        self.target_aliyun_id = target_aliyun_id  # type: str
        self.source_region = source_region  # type: str
        self.target_region = target_region  # type: str
        self.source_instance_name = source_instance_name  # type: str
        self.target_instance_name = target_instance_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDistributedProductResponseBodyDataInfoItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_uid is not None:
            result['SourceUid'] = self.source_uid
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.target_aliyun_id is not None:
            result['TargetAliyunId'] = self.target_aliyun_id
        if self.source_region is not None:
            result['SourceRegion'] = self.source_region
        if self.target_region is not None:
            result['TargetRegion'] = self.target_region
        if self.source_instance_name is not None:
            result['SourceInstanceName'] = self.source_instance_name
        if self.target_instance_name is not None:
            result['TargetInstanceName'] = self.target_instance_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceUid') is not None:
            self.source_uid = m.get('SourceUid')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('TargetAliyunId') is not None:
            self.target_aliyun_id = m.get('TargetAliyunId')
        if m.get('SourceRegion') is not None:
            self.source_region = m.get('SourceRegion')
        if m.get('TargetRegion') is not None:
            self.target_region = m.get('TargetRegion')
        if m.get('SourceInstanceName') is not None:
            self.source_instance_name = m.get('SourceInstanceName')
        if m.get('TargetInstanceName') is not None:
            self.target_instance_name = m.get('TargetInstanceName')
        return self


class ListDistributedProductResponseBodyDataInfo(TeaModel):
    def __init__(self, items=None):
        self.items = items  # type: list[ListDistributedProductResponseBodyDataInfoItems]

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDistributedProductResponseBodyDataInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListDistributedProductResponseBodyDataInfoItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListDistributedProductResponseBodyData(TeaModel):
    def __init__(self, total=None, info=None):
        self.total = total  # type: int
        self.info = info  # type: ListDistributedProductResponseBodyDataInfo

    def validate(self):
        if self.info:
            self.info.validate()

    def to_map(self):
        _map = super(ListDistributedProductResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.info is not None:
            result['Info'] = self.info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Info') is not None:
            temp_model = ListDistributedProductResponseBodyDataInfo()
            self.info = temp_model.from_map(m['Info'])
        return self


class ListDistributedProductResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: ListDistributedProductResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListDistributedProductResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListDistributedProductResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListDistributedProductResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListDistributedProductResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListDistributedProductResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDistributedProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, status=None, page_size=None, current_page=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.status = status  # type: str
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.status is not None:
            result['Status'] = self.status
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListJobResponseBodyDataData(TeaModel):
    def __init__(self, job_id=None, job_name=None, utc_create=None, utc_modified=None, status=None, description=None,
                 type=None):
        self.job_id = job_id  # type: str
        self.job_name = job_name  # type: str
        self.utc_create = utc_create  # type: str
        self.utc_modified = utc_modified  # type: str
        self.status = status  # type: str
        self.description = description  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListJobResponseBodyDataData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListJobResponseBodyData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[ListJobResponseBodyDataData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListJobResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListJobResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListJobResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page = page  # type: int
        self.data = data  # type: ListJobResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page is not None:
            result['Page'] = self.page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Data') is not None:
            temp_model = ListJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAFirmwareRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, page_size=None, current_page=None, dest_version=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.dest_version = dest_version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOTAFirmwareRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        return self


class ListOTAFirmwareResponseBodyFirmwareInfoSimpleFirmwareInfo(TeaModel):
    def __init__(self, firmware_name=None, firmware_id=None, src_version=None, dest_version=None, utc_create=None,
                 utc_modified=None, status=None, firmware_desc=None, firmware_sign=None, firmware_size=None, firmware_url=None,
                 product_key=None, sign_method=None, product_name=None, type=None, module_name=None):
        self.firmware_name = firmware_name  # type: str
        self.firmware_id = firmware_id  # type: str
        self.src_version = src_version  # type: str
        self.dest_version = dest_version  # type: str
        self.utc_create = utc_create  # type: str
        self.utc_modified = utc_modified  # type: str
        self.status = status  # type: int
        self.firmware_desc = firmware_desc  # type: str
        self.firmware_sign = firmware_sign  # type: str
        self.firmware_size = firmware_size  # type: int
        self.firmware_url = firmware_url  # type: str
        self.product_key = product_key  # type: str
        self.sign_method = sign_method  # type: str
        self.product_name = product_name  # type: str
        self.type = type  # type: int
        self.module_name = module_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOTAFirmwareResponseBodyFirmwareInfoSimpleFirmwareInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firmware_name is not None:
            result['FirmwareName'] = self.firmware_name
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        if self.firmware_desc is not None:
            result['FirmwareDesc'] = self.firmware_desc
        if self.firmware_sign is not None:
            result['FirmwareSign'] = self.firmware_sign
        if self.firmware_size is not None:
            result['FirmwareSize'] = self.firmware_size
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.type is not None:
            result['Type'] = self.type
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FirmwareName') is not None:
            self.firmware_name = m.get('FirmwareName')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FirmwareDesc') is not None:
            self.firmware_desc = m.get('FirmwareDesc')
        if m.get('FirmwareSign') is not None:
            self.firmware_sign = m.get('FirmwareSign')
        if m.get('FirmwareSize') is not None:
            self.firmware_size = m.get('FirmwareSize')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class ListOTAFirmwareResponseBodyFirmwareInfo(TeaModel):
    def __init__(self, simple_firmware_info=None):
        self.simple_firmware_info = simple_firmware_info  # type: list[ListOTAFirmwareResponseBodyFirmwareInfoSimpleFirmwareInfo]

    def validate(self):
        if self.simple_firmware_info:
            for k in self.simple_firmware_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListOTAFirmwareResponseBodyFirmwareInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SimpleFirmwareInfo'] = []
        if self.simple_firmware_info is not None:
            for k in self.simple_firmware_info:
                result['SimpleFirmwareInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_firmware_info = []
        if m.get('SimpleFirmwareInfo') is not None:
            for k in m.get('SimpleFirmwareInfo'):
                temp_model = ListOTAFirmwareResponseBodyFirmwareInfoSimpleFirmwareInfo()
                self.simple_firmware_info.append(temp_model.from_map(k))
        return self


class ListOTAFirmwareResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, current_page=None, firmware_info=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.current_page = current_page  # type: int
        self.firmware_info = firmware_info  # type: ListOTAFirmwareResponseBodyFirmwareInfo

    def validate(self):
        if self.firmware_info:
            self.firmware_info.validate()

    def to_map(self):
        _map = super(ListOTAFirmwareResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.firmware_info is not None:
            result['FirmwareInfo'] = self.firmware_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FirmwareInfo') is not None:
            temp_model = ListOTAFirmwareResponseBodyFirmwareInfo()
            self.firmware_info = temp_model.from_map(m['FirmwareInfo'])
        return self


class ListOTAFirmwareResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListOTAFirmwareResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListOTAFirmwareResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAFirmwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAJobByDeviceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, firmware_id=None, page_size=None, product_key=None, device_name=None,
                 current_page=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.firmware_id = firmware_id  # type: str
        self.page_size = page_size  # type: int
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.current_page = current_page  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOTAJobByDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTags(TeaModel):
    def __init__(self, ota_tag_dto=None):
        self.ota_tag_dto = ota_tag_dto  # type: list[ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO]

    def validate(self):
        if self.ota_tag_dto:
            for k in self.ota_tag_dto:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OtaTagDTO'] = []
        if self.ota_tag_dto is not None:
            for k in self.ota_tag_dto:
                result['OtaTagDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ota_tag_dto = []
        if m.get('OtaTagDTO') is not None:
            for k in m.get('OtaTagDTO'):
                temp_model = ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO()
                self.ota_tag_dto.append(temp_model.from_map(k))
        return self


class ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfo(TeaModel):
    def __init__(self, job_id=None, utc_create=None, utc_modified=None, product_key=None, firmware_id=None,
                 utc_start_time=None, utc_end_time=None, job_status=None, job_type=None, target_selection=None,
                 selection_type=None, tags=None):
        self.job_id = job_id  # type: str
        self.utc_create = utc_create  # type: str
        self.utc_modified = utc_modified  # type: str
        self.product_key = product_key  # type: str
        self.firmware_id = firmware_id  # type: str
        self.utc_start_time = utc_start_time  # type: str
        self.utc_end_time = utc_end_time  # type: str
        self.job_status = job_status  # type: str
        self.job_type = job_type  # type: str
        self.target_selection = target_selection  # type: str
        self.selection_type = selection_type  # type: str
        self.tags = tags  # type: ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTags

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_start_time is not None:
            result['UtcStartTime'] = self.utc_start_time
        if self.utc_end_time is not None:
            result['UtcEndTime'] = self.utc_end_time
        if self.job_status is not None:
            result['JobStatus'] = self.job_status
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.selection_type is not None:
            result['SelectionType'] = self.selection_type
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcStartTime') is not None:
            self.utc_start_time = m.get('UtcStartTime')
        if m.get('UtcEndTime') is not None:
            self.utc_end_time = m.get('UtcEndTime')
        if m.get('JobStatus') is not None:
            self.job_status = m.get('JobStatus')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('SelectionType') is not None:
            self.selection_type = m.get('SelectionType')
        if m.get('Tags') is not None:
            temp_model = ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class ListOTAJobByDeviceResponseBodyData(TeaModel):
    def __init__(self, simple_otajob_info=None):
        self.simple_otajob_info = simple_otajob_info  # type: list[ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfo]

    def validate(self):
        if self.simple_otajob_info:
            for k in self.simple_otajob_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListOTAJobByDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SimpleOTAJobInfo'] = []
        if self.simple_otajob_info is not None:
            for k in self.simple_otajob_info:
                result['SimpleOTAJobInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_otajob_info = []
        if m.get('SimpleOTAJobInfo') is not None:
            for k in m.get('SimpleOTAJobInfo'):
                temp_model = ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfo()
                self.simple_otajob_info.append(temp_model.from_map(k))
        return self


class ListOTAJobByDeviceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, current_page=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.current_page = current_page  # type: int
        self.data = data  # type: ListOTAJobByDeviceResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListOTAJobByDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTAJobByDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAJobByDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListOTAJobByDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListOTAJobByDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAJobByDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAJobByFirmwareRequest(TeaModel):
    def __init__(self, iot_instance_id=None, firmware_id=None, page_size=None, current_page=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.firmware_id = firmware_id  # type: str
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOTAJobByFirmwareRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTags(TeaModel):
    def __init__(self, ota_tag_dto=None):
        self.ota_tag_dto = ota_tag_dto  # type: list[ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO]

    def validate(self):
        if self.ota_tag_dto:
            for k in self.ota_tag_dto:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OtaTagDTO'] = []
        if self.ota_tag_dto is not None:
            for k in self.ota_tag_dto:
                result['OtaTagDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ota_tag_dto = []
        if m.get('OtaTagDTO') is not None:
            for k in m.get('OtaTagDTO'):
                temp_model = ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO()
                self.ota_tag_dto.append(temp_model.from_map(k))
        return self


class ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfo(TeaModel):
    def __init__(self, job_id=None, utc_create=None, utc_modified=None, product_key=None, firmware_id=None,
                 utc_start_time=None, utc_end_time=None, job_status=None, job_type=None, target_selection=None,
                 selection_type=None, tags=None):
        self.job_id = job_id  # type: str
        self.utc_create = utc_create  # type: str
        self.utc_modified = utc_modified  # type: str
        self.product_key = product_key  # type: str
        self.firmware_id = firmware_id  # type: str
        self.utc_start_time = utc_start_time  # type: str
        self.utc_end_time = utc_end_time  # type: str
        self.job_status = job_status  # type: str
        self.job_type = job_type  # type: str
        self.target_selection = target_selection  # type: str
        self.selection_type = selection_type  # type: str
        self.tags = tags  # type: ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTags

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_start_time is not None:
            result['UtcStartTime'] = self.utc_start_time
        if self.utc_end_time is not None:
            result['UtcEndTime'] = self.utc_end_time
        if self.job_status is not None:
            result['JobStatus'] = self.job_status
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.selection_type is not None:
            result['SelectionType'] = self.selection_type
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcStartTime') is not None:
            self.utc_start_time = m.get('UtcStartTime')
        if m.get('UtcEndTime') is not None:
            self.utc_end_time = m.get('UtcEndTime')
        if m.get('JobStatus') is not None:
            self.job_status = m.get('JobStatus')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('SelectionType') is not None:
            self.selection_type = m.get('SelectionType')
        if m.get('Tags') is not None:
            temp_model = ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class ListOTAJobByFirmwareResponseBodyData(TeaModel):
    def __init__(self, simple_otajob_info=None):
        self.simple_otajob_info = simple_otajob_info  # type: list[ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfo]

    def validate(self):
        if self.simple_otajob_info:
            for k in self.simple_otajob_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListOTAJobByFirmwareResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SimpleOTAJobInfo'] = []
        if self.simple_otajob_info is not None:
            for k in self.simple_otajob_info:
                result['SimpleOTAJobInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_otajob_info = []
        if m.get('SimpleOTAJobInfo') is not None:
            for k in m.get('SimpleOTAJobInfo'):
                temp_model = ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfo()
                self.simple_otajob_info.append(temp_model.from_map(k))
        return self


class ListOTAJobByFirmwareResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, current_page=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.current_page = current_page  # type: int
        self.data = data  # type: ListOTAJobByFirmwareResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListOTAJobByFirmwareResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTAJobByFirmwareResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAJobByFirmwareResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListOTAJobByFirmwareResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListOTAJobByFirmwareResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAJobByFirmwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAModuleByProductRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOTAModuleByProductRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ListOTAModuleByProductResponseBodyData(TeaModel):
    def __init__(self, product_key=None, module_name=None, alias_name=None, desc=None, gmt_create=None,
                 gmt_modified=None):
        self.product_key = product_key  # type: str
        self.module_name = module_name  # type: str
        self.alias_name = alias_name  # type: str
        self.desc = desc  # type: str
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOTAModuleByProductResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        return self


class ListOTAModuleByProductResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: list[ListOTAModuleByProductResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListOTAModuleByProductResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListOTAModuleByProductResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class ListOTAModuleByProductResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListOTAModuleByProductResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListOTAModuleByProductResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAModuleByProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAModuleVersionsByDeviceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, product_key=None, device_name=None, iot_id=None,
                 current_page=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.page_size = page_size  # type: int
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.current_page = current_page  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOTAModuleVersionsByDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListOTAModuleVersionsByDeviceResponseBodyDataSimpleOTAModuleInfo(TeaModel):
    def __init__(self, product_key=None, device_name=None, iot_id=None, module_version=None, module_name=None):
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.module_version = module_version  # type: str
        self.module_name = module_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOTAModuleVersionsByDeviceResponseBodyDataSimpleOTAModuleInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.module_version is not None:
            result['ModuleVersion'] = self.module_version
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ModuleVersion') is not None:
            self.module_version = m.get('ModuleVersion')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class ListOTAModuleVersionsByDeviceResponseBodyData(TeaModel):
    def __init__(self, simple_otamodule_info=None):
        self.simple_otamodule_info = simple_otamodule_info  # type: list[ListOTAModuleVersionsByDeviceResponseBodyDataSimpleOTAModuleInfo]

    def validate(self):
        if self.simple_otamodule_info:
            for k in self.simple_otamodule_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListOTAModuleVersionsByDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SimpleOTAModuleInfo'] = []
        if self.simple_otamodule_info is not None:
            for k in self.simple_otamodule_info:
                result['SimpleOTAModuleInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_otamodule_info = []
        if m.get('SimpleOTAModuleInfo') is not None:
            for k in m.get('SimpleOTAModuleInfo'):
                temp_model = ListOTAModuleVersionsByDeviceResponseBodyDataSimpleOTAModuleInfo()
                self.simple_otamodule_info.append(temp_model.from_map(k))
        return self


class ListOTAModuleVersionsByDeviceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, current_page=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.current_page = current_page  # type: int
        self.data = data  # type: ListOTAModuleVersionsByDeviceResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListOTAModuleVersionsByDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTAModuleVersionsByDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAModuleVersionsByDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListOTAModuleVersionsByDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListOTAModuleVersionsByDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAModuleVersionsByDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTATaskByJobRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, task_status=None, job_id=None, current_page=None,
                 device_names=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.page_size = page_size  # type: int
        self.task_status = task_status  # type: str
        self.job_id = job_id  # type: str
        self.current_page = current_page  # type: int
        self.device_names = device_names  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOTATaskByJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.device_names is not None:
            result['DeviceNames'] = self.device_names
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DeviceNames') is not None:
            self.device_names = m.get('DeviceNames')
        return self


class ListOTATaskByJobResponseBodyDataSimpleOTATaskInfo(TeaModel):
    def __init__(self, task_id=None, utc_modified=None, product_key=None, firmware_id=None, task_status=None,
                 job_id=None, product_name=None, device_name=None, src_version=None, dest_version=None, task_desc=None,
                 progress=None, iot_id=None, utc_create=None):
        self.task_id = task_id  # type: str
        self.utc_modified = utc_modified  # type: str
        self.product_key = product_key  # type: str
        self.firmware_id = firmware_id  # type: str
        self.task_status = task_status  # type: str
        self.job_id = job_id  # type: str
        self.product_name = product_name  # type: str
        self.device_name = device_name  # type: str
        self.src_version = src_version  # type: str
        self.dest_version = dest_version  # type: str
        self.task_desc = task_desc  # type: str
        self.progress = progress  # type: str
        self.iot_id = iot_id  # type: str
        self.utc_create = utc_create  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOTATaskByJobResponseBodyDataSimpleOTATaskInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.task_desc is not None:
            result['TaskDesc'] = self.task_desc
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('TaskDesc') is not None:
            self.task_desc = m.get('TaskDesc')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class ListOTATaskByJobResponseBodyData(TeaModel):
    def __init__(self, simple_otatask_info=None):
        self.simple_otatask_info = simple_otatask_info  # type: list[ListOTATaskByJobResponseBodyDataSimpleOTATaskInfo]

    def validate(self):
        if self.simple_otatask_info:
            for k in self.simple_otatask_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListOTATaskByJobResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SimpleOTATaskInfo'] = []
        if self.simple_otatask_info is not None:
            for k in self.simple_otatask_info:
                result['SimpleOTATaskInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_otatask_info = []
        if m.get('SimpleOTATaskInfo') is not None:
            for k in m.get('SimpleOTATaskInfo'):
                temp_model = ListOTATaskByJobResponseBodyDataSimpleOTATaskInfo()
                self.simple_otatask_info.append(temp_model.from_map(k))
        return self


class ListOTATaskByJobResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, current_page=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.current_page = current_page  # type: int
        self.data = data  # type: ListOTATaskByJobResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListOTATaskByJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTATaskByJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTATaskByJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListOTATaskByJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListOTATaskByJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTATaskByJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListProductByTagsRequestProductTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListProductByTagsRequestProductTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class ListProductByTagsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, current_page=None, page_size=None, product_tag=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.product_tag = product_tag  # type: list[ListProductByTagsRequestProductTag]

    def validate(self):
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListProductByTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = ListProductByTagsRequestProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class ListProductByTagsResponseBodyProductInfosProductInfo(TeaModel):
    def __init__(self, product_name=None, product_key=None, create_time=None, description=None, node_type=None):
        self.product_name = product_name  # type: str
        self.product_key = product_key  # type: str
        self.create_time = create_time  # type: long
        self.description = description  # type: str
        self.node_type = node_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListProductByTagsResponseBodyProductInfosProductInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        return self


class ListProductByTagsResponseBodyProductInfos(TeaModel):
    def __init__(self, product_info=None):
        self.product_info = product_info  # type: list[ListProductByTagsResponseBodyProductInfosProductInfo]

    def validate(self):
        if self.product_info:
            for k in self.product_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListProductByTagsResponseBodyProductInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ProductInfo'] = []
        if self.product_info is not None:
            for k in self.product_info:
                result['ProductInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.product_info = []
        if m.get('ProductInfo') is not None:
            for k in m.get('ProductInfo'):
                temp_model = ListProductByTagsResponseBodyProductInfosProductInfo()
                self.product_info.append(temp_model.from_map(k))
        return self


class ListProductByTagsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, product_infos=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str
        self.product_infos = product_infos  # type: ListProductByTagsResponseBodyProductInfos

    def validate(self):
        if self.product_infos:
            self.product_infos.validate()

    def to_map(self):
        _map = super(ListProductByTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.product_infos is not None:
            result['ProductInfos'] = self.product_infos.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ProductInfos') is not None:
            temp_model = ListProductByTagsResponseBodyProductInfos()
            self.product_infos = temp_model.from_map(m['ProductInfos'])
        return self


class ListProductByTagsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListProductByTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListProductByTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListProductByTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListProductTagsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListProductTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ListProductTagsResponseBodyDataProductTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListProductTagsResponseBodyDataProductTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class ListProductTagsResponseBodyData(TeaModel):
    def __init__(self, product_tag=None):
        self.product_tag = product_tag  # type: list[ListProductTagsResponseBodyDataProductTag]

    def validate(self):
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListProductTagsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = ListProductTagsResponseBodyDataProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class ListProductTagsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str
        self.data = data  # type: ListProductTagsResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListProductTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListProductTagsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListProductTagsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListProductTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListProductTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListProductTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRuleRequest(TeaModel):
    def __init__(self, iot_instance_id=None, current_page=None, page_size=None, resource_group_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListRuleResponseBodyDataRuleInfo(TeaModel):
    def __init__(self, id=None, select=None, topic=None, short_topic=None, where=None, status=None,
                 create_user_id=None, product_key=None, name=None, data_type=None, rule_desc=None, created=None, utc_created=None,
                 modified=None, utc_modified=None):
        self.id = id  # type: long
        self.select = select  # type: str
        self.topic = topic  # type: str
        self.short_topic = short_topic  # type: str
        self.where = where  # type: str
        self.status = status  # type: str
        self.create_user_id = create_user_id  # type: long
        self.product_key = product_key  # type: str
        self.name = name  # type: str
        self.data_type = data_type  # type: str
        self.rule_desc = rule_desc  # type: str
        self.created = created  # type: str
        self.utc_created = utc_created  # type: str
        self.modified = modified  # type: str
        self.utc_modified = utc_modified  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRuleResponseBodyDataRuleInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.select is not None:
            result['Select'] = self.select
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.short_topic is not None:
            result['ShortTopic'] = self.short_topic
        if self.where is not None:
            result['Where'] = self.where
        if self.status is not None:
            result['Status'] = self.status
        if self.create_user_id is not None:
            result['CreateUserId'] = self.create_user_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.name is not None:
            result['Name'] = self.name
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.created is not None:
            result['Created'] = self.created
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        if self.modified is not None:
            result['Modified'] = self.modified
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('ShortTopic') is not None:
            self.short_topic = m.get('ShortTopic')
        if m.get('Where') is not None:
            self.where = m.get('Where')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CreateUserId') is not None:
            self.create_user_id = m.get('CreateUserId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('Created') is not None:
            self.created = m.get('Created')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        if m.get('Modified') is not None:
            self.modified = m.get('Modified')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        return self


class ListRuleResponseBodyData(TeaModel):
    def __init__(self, rule_info=None):
        self.rule_info = rule_info  # type: list[ListRuleResponseBodyDataRuleInfo]

    def validate(self):
        if self.rule_info:
            for k in self.rule_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListRuleResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RuleInfo'] = []
        if self.rule_info is not None:
            for k in self.rule_info:
                result['RuleInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.rule_info = []
        if m.get('RuleInfo') is not None:
            for k in m.get('RuleInfo'):
                temp_model = ListRuleResponseBodyDataRuleInfo()
                self.rule_info.append(temp_model.from_map(k))
        return self


class ListRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, page=None, total=None,
                 page_size=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.page = page  # type: int
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.data = data  # type: ListRuleResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Data') is not None:
            temp_model = ListRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRuleActionsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRuleActionsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class ListRuleActionsResponseBodyRuleActionListRuleActionInfo(TeaModel):
    def __init__(self, id=None, rule_id=None, type=None, configuration=None, error_action_flag=None):
        self.id = id  # type: long
        self.rule_id = rule_id  # type: long
        self.type = type  # type: str
        self.configuration = configuration  # type: str
        self.error_action_flag = error_action_flag  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRuleActionsResponseBodyRuleActionListRuleActionInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.type is not None:
            result['Type'] = self.type
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.error_action_flag is not None:
            result['ErrorActionFlag'] = self.error_action_flag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('ErrorActionFlag') is not None:
            self.error_action_flag = m.get('ErrorActionFlag')
        return self


class ListRuleActionsResponseBodyRuleActionList(TeaModel):
    def __init__(self, rule_action_info=None):
        self.rule_action_info = rule_action_info  # type: list[ListRuleActionsResponseBodyRuleActionListRuleActionInfo]

    def validate(self):
        if self.rule_action_info:
            for k in self.rule_action_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListRuleActionsResponseBodyRuleActionList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RuleActionInfo'] = []
        if self.rule_action_info is not None:
            for k in self.rule_action_info:
                result['RuleActionInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.rule_action_info = []
        if m.get('RuleActionInfo') is not None:
            for k in m.get('RuleActionInfo'):
                temp_model = ListRuleActionsResponseBodyRuleActionListRuleActionInfo()
                self.rule_action_info.append(temp_model.from_map(k))
        return self


class ListRuleActionsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, rule_action_list=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.rule_action_list = rule_action_list  # type: ListRuleActionsResponseBodyRuleActionList

    def validate(self):
        if self.rule_action_list:
            self.rule_action_list.validate()

    def to_map(self):
        _map = super(ListRuleActionsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.rule_action_list is not None:
            result['RuleActionList'] = self.rule_action_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RuleActionList') is not None:
            temp_model = ListRuleActionsResponseBodyRuleActionList()
            self.rule_action_list = temp_model.from_map(m['RuleActionList'])
        return self


class ListRuleActionsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListRuleActionsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListRuleActionsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListRuleActionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTaskRequest(TeaModel):
    def __init__(self, iot_instance_id=None, limit=None, job_id=None, next_token=None, device=None, status=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.limit = limit  # type: int
        self.job_id = job_id  # type: str
        self.next_token = next_token  # type: str
        self.device = device  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.device is not None:
            result['Device'] = self.device
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListTaskResponseBodyDataData(TeaModel):
    def __init__(self, job_id=None, job_name=None, task_id=None, product_key=None, device_name=None, iot_id=None,
                 progress=None, utc_queue_time=None, utc_modified=None, status=None):
        self.job_id = job_id  # type: str
        self.job_name = job_name  # type: str
        self.task_id = task_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.progress = progress  # type: str
        self.utc_queue_time = utc_queue_time  # type: str
        self.utc_modified = utc_modified  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTaskResponseBodyDataData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.utc_queue_time is not None:
            result['UtcQueueTime'] = self.utc_queue_time
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('UtcQueueTime') is not None:
            self.utc_queue_time = m.get('UtcQueueTime')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListTaskResponseBodyData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[ListTaskResponseBodyDataData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTaskResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListTaskResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, next_token=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.next_token = next_token  # type: str
        self.data = data  # type: ListTaskResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Data') is not None:
            temp_model = ListTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTaskByPageRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, page_no=None, job_id=None, device=None, status=None,
                 device_name=None, job_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.page_size = page_size  # type: str
        self.page_no = page_no  # type: str
        self.job_id = job_id  # type: str
        self.device = device  # type: str
        self.status = status  # type: str
        self.device_name = device_name  # type: str
        self.job_name = job_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTaskByPageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.device is not None:
            result['Device'] = self.device
        if self.status is not None:
            result['Status'] = self.status
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.job_name is not None:
            result['JobName'] = self.job_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        return self


class ListTaskByPageResponseBodyDataData(TeaModel):
    def __init__(self, job_id=None, job_name=None, task_id=None, product_key=None, device_name=None, iot_id=None,
                 progress=None, utc_queue_time=None, utc_modified=None, status_detail=None, status=None, product_name=None):
        self.job_id = job_id  # type: str
        self.job_name = job_name  # type: str
        self.task_id = task_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.progress = progress  # type: int
        self.utc_queue_time = utc_queue_time  # type: str
        self.utc_modified = utc_modified  # type: str
        self.status_detail = status_detail  # type: str
        self.status = status  # type: str
        self.product_name = product_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTaskByPageResponseBodyDataData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.utc_queue_time is not None:
            result['UtcQueueTime'] = self.utc_queue_time
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status_detail is not None:
            result['StatusDetail'] = self.status_detail
        if self.status is not None:
            result['Status'] = self.status
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('UtcQueueTime') is not None:
            self.utc_queue_time = m.get('UtcQueueTime')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('StatusDetail') is not None:
            self.status_detail = m.get('StatusDetail')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        return self


class ListTaskByPageResponseBodyData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[ListTaskByPageResponseBodyDataData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTaskByPageResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListTaskByPageResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListTaskByPageResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, page=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.page = page  # type: int
        self.data = data  # type: ListTaskByPageResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListTaskByPageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page is not None:
            result['Page'] = self.page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Data') is not None:
            temp_model = ListTaskByPageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListTaskByPageResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListTaskByPageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTaskByPageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTaskByPageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListThingModelVersionRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListThingModelVersionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ListThingModelVersionResponseBodyDataModelVersions(TeaModel):
    def __init__(self, model_version=None, description=None, gmt_create=None):
        self.model_version = model_version  # type: str
        self.description = description  # type: str
        self.gmt_create = gmt_create  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListThingModelVersionResponseBodyDataModelVersions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        return self


class ListThingModelVersionResponseBodyData(TeaModel):
    def __init__(self, model_versions=None):
        self.model_versions = model_versions  # type: list[ListThingModelVersionResponseBodyDataModelVersions]

    def validate(self):
        if self.model_versions:
            for k in self.model_versions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListThingModelVersionResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ModelVersions'] = []
        if self.model_versions is not None:
            for k in self.model_versions:
                result['ModelVersions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.model_versions = []
        if m.get('ModelVersions') is not None:
            for k in m.get('ModelVersions'):
                temp_model = ListThingModelVersionResponseBodyDataModelVersions()
                self.model_versions.append(temp_model.from_map(k))
        return self


class ListThingModelVersionResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: ListThingModelVersionResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListThingModelVersionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListThingModelVersionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListThingModelVersionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListThingModelVersionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListThingModelVersionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListThingModelVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListThingTemplatesRequest(TeaModel):
    def __init__(self, iot_instance_id=None):
        self.iot_instance_id = iot_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListThingTemplatesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class ListThingTemplatesResponseBodyData(TeaModel):
    def __init__(self, category_key=None, category_name=None):
        self.category_key = category_key  # type: str
        self.category_name = category_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListThingTemplatesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        if self.category_name is not None:
            result['CategoryName'] = self.category_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        if m.get('CategoryName') is not None:
            self.category_name = m.get('CategoryName')
        return self


class ListThingTemplatesResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: list[ListThingTemplatesResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListThingTemplatesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListThingTemplatesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class ListThingTemplatesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListThingTemplatesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListThingTemplatesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListThingTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class NotifyAddThingTopoRequest(TeaModel):
    def __init__(self, iot_instance_id=None, device_list_str=None, gw_iot_id=None, gw_product_key=None,
                 gw_device_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.device_list_str = device_list_str  # type: str
        self.gw_iot_id = gw_iot_id  # type: str
        self.gw_product_key = gw_product_key  # type: str
        self.gw_device_name = gw_device_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(NotifyAddThingTopoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.device_list_str is not None:
            result['DeviceListStr'] = self.device_list_str
        if self.gw_iot_id is not None:
            result['GwIotId'] = self.gw_iot_id
        if self.gw_product_key is not None:
            result['GwProductKey'] = self.gw_product_key
        if self.gw_device_name is not None:
            result['GwDeviceName'] = self.gw_device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DeviceListStr') is not None:
            self.device_list_str = m.get('DeviceListStr')
        if m.get('GwIotId') is not None:
            self.gw_iot_id = m.get('GwIotId')
        if m.get('GwProductKey') is not None:
            self.gw_product_key = m.get('GwProductKey')
        if m.get('GwDeviceName') is not None:
            self.gw_device_name = m.get('GwDeviceName')
        return self


class NotifyAddThingTopoResponseBodyData(TeaModel):
    def __init__(self, message_id=None):
        self.message_id = message_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(NotifyAddThingTopoResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class NotifyAddThingTopoResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str
        self.data = data  # type: NotifyAddThingTopoResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(NotifyAddThingTopoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = NotifyAddThingTopoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class NotifyAddThingTopoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: NotifyAddThingTopoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(NotifyAddThingTopoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = NotifyAddThingTopoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class OpenIotServiceRequest(TeaModel):
    def __init__(self, owner_id=None):
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(OpenIotServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class OpenIotServiceResponseBody(TeaModel):
    def __init__(self, request_id=None, order_id=None):
        self.request_id = request_id  # type: str
        self.order_id = order_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(OpenIotServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class OpenIotServiceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: OpenIotServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(OpenIotServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = OpenIotServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PrintByTemplateRequest(TeaModel):
    def __init__(self, params_json_string=None, iot_id=None, project_code=None, iot_instance_id=None,
                 template_biz_code=None, product_key=None, device_name=None):
        self.params_json_string = params_json_string  # type: str
        self.iot_id = iot_id  # type: str
        self.project_code = project_code  # type: str
        self.iot_instance_id = iot_instance_id  # type: str
        self.template_biz_code = template_biz_code  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PrintByTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.params_json_string is not None:
            result['ParamsJsonString'] = self.params_json_string
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.project_code is not None:
            result['ProjectCode'] = self.project_code
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.template_biz_code is not None:
            result['TemplateBizCode'] = self.template_biz_code
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParamsJsonString') is not None:
            self.params_json_string = m.get('ParamsJsonString')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ProjectCode') is not None:
            self.project_code = m.get('ProjectCode')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TemplateBizCode') is not None:
            self.template_biz_code = m.get('TemplateBizCode')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class PrintByTemplateResponseBodyData(TeaModel):
    def __init__(self, success=None, device_error_code=None, device_error_message=None, id=None, retry_count=None):
        self.success = success  # type: bool
        self.device_error_code = device_error_code  # type: str
        self.device_error_message = device_error_message  # type: str
        self.id = id  # type: str
        self.retry_count = retry_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(PrintByTemplateResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        if self.device_error_code is not None:
            result['DeviceErrorCode'] = self.device_error_code
        if self.device_error_message is not None:
            result['DeviceErrorMessage'] = self.device_error_message
        if self.id is not None:
            result['Id'] = self.id
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('DeviceErrorCode') is not None:
            self.device_error_code = m.get('DeviceErrorCode')
        if m.get('DeviceErrorMessage') is not None:
            self.device_error_message = m.get('DeviceErrorMessage')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        return self


class PrintByTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: PrintByTemplateResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(PrintByTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = PrintByTemplateResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class PrintByTemplateResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: PrintByTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(PrintByTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PrintByTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PubRequestUserProp(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PubRequestUserProp, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class PubRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, qos=None, topic_full_name=None, message_content=None,
                 response_topic=None, correlation_data=None, user_prop=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.qos = qos  # type: int
        self.topic_full_name = topic_full_name  # type: str
        self.message_content = message_content  # type: str
        self.response_topic = response_topic  # type: str
        self.correlation_data = correlation_data  # type: str
        self.user_prop = user_prop  # type: list[PubRequestUserProp]

    def validate(self):
        if self.user_prop:
            for k in self.user_prop:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(PubRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.qos is not None:
            result['Qos'] = self.qos
        if self.topic_full_name is not None:
            result['TopicFullName'] = self.topic_full_name
        if self.message_content is not None:
            result['MessageContent'] = self.message_content
        if self.response_topic is not None:
            result['ResponseTopic'] = self.response_topic
        if self.correlation_data is not None:
            result['CorrelationData'] = self.correlation_data
        result['UserProp'] = []
        if self.user_prop is not None:
            for k in self.user_prop:
                result['UserProp'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Qos') is not None:
            self.qos = m.get('Qos')
        if m.get('TopicFullName') is not None:
            self.topic_full_name = m.get('TopicFullName')
        if m.get('MessageContent') is not None:
            self.message_content = m.get('MessageContent')
        if m.get('ResponseTopic') is not None:
            self.response_topic = m.get('ResponseTopic')
        if m.get('CorrelationData') is not None:
            self.correlation_data = m.get('CorrelationData')
        self.user_prop = []
        if m.get('UserProp') is not None:
            for k in m.get('UserProp'):
                temp_model = PubRequestUserProp()
                self.user_prop.append(temp_model.from_map(k))
        return self


class PubResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, message_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.message_id = message_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PubResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class PubResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: PubResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(PubResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PubResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PubBroadcastRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, topic_full_name=None, message_content=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.topic_full_name = topic_full_name  # type: str
        self.message_content = message_content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PubBroadcastRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.topic_full_name is not None:
            result['TopicFullName'] = self.topic_full_name
        if self.message_content is not None:
            result['MessageContent'] = self.message_content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TopicFullName') is not None:
            self.topic_full_name = m.get('TopicFullName')
        if m.get('MessageContent') is not None:
            self.message_content = m.get('MessageContent')
        return self


class PubBroadcastResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, message_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.message_id = message_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(PubBroadcastResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class PubBroadcastResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: PubBroadcastResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(PubBroadcastResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PubBroadcastResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PublishThingModelRequest(TeaModel):
    def __init__(self, iot_instance_id=None, resource_group_id=None, product_key=None, model_version=None,
                 description=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.product_key = product_key  # type: str
        self.model_version = model_version  # type: str
        self.description = description  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PublishThingModelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class PublishThingModelResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PublishThingModelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class PublishThingModelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: PublishThingModelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(PublishThingModelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PublishThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAppDeviceListRequestTagList(TeaModel):
    def __init__(self, tag_name=None, tag_value=None):
        self.tag_name = tag_name  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryAppDeviceListRequestTagList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryAppDeviceListRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, product_key_list=None, category_key_list=None,
                 app_key=None, tag_list=None, current_page=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.page_size = page_size  # type: int
        self.product_key_list = product_key_list  # type: list[str]
        self.category_key_list = category_key_list  # type: list[str]
        self.app_key = app_key  # type: str
        self.tag_list = tag_list  # type: list[QueryAppDeviceListRequestTagList]
        self.current_page = current_page  # type: int

    def validate(self):
        if self.tag_list:
            for k in self.tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryAppDeviceListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key_list is not None:
            result['ProductKeyList'] = self.product_key_list
        if self.category_key_list is not None:
            result['CategoryKeyList'] = self.category_key_list
        if self.app_key is not None:
            result['AppKey'] = self.app_key
        result['TagList'] = []
        if self.tag_list is not None:
            for k in self.tag_list:
                result['TagList'].append(k.to_map() if k else None)
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKeyList') is not None:
            self.product_key_list = m.get('ProductKeyList')
        if m.get('CategoryKeyList') is not None:
            self.category_key_list = m.get('CategoryKeyList')
        if m.get('AppKey') is not None:
            self.app_key = m.get('AppKey')
        self.tag_list = []
        if m.get('TagList') is not None:
            for k in m.get('TagList'):
                temp_model = QueryAppDeviceListRequestTagList()
                self.tag_list.append(temp_model.from_map(k))
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryAppDeviceListResponseBodyDataData(TeaModel):
    def __init__(self, product_name=None, product_key=None, device_name=None, node_type=None, status=None,
                 active_time=None, last_online_time=None, create_time=None, child_device_count=None, utc_active_time=None,
                 utc_last_online_time=None, utc_create_time=None):
        self.product_name = product_name  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.node_type = node_type  # type: int
        self.status = status  # type: str
        self.active_time = active_time  # type: str
        self.last_online_time = last_online_time  # type: str
        self.create_time = create_time  # type: str
        self.child_device_count = child_device_count  # type: long
        self.utc_active_time = utc_active_time  # type: str
        self.utc_last_online_time = utc_last_online_time  # type: str
        self.utc_create_time = utc_create_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryAppDeviceListResponseBodyDataData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.status is not None:
            result['Status'] = self.status
        if self.active_time is not None:
            result['ActiveTime'] = self.active_time
        if self.last_online_time is not None:
            result['LastOnlineTime'] = self.last_online_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.child_device_count is not None:
            result['ChildDeviceCount'] = self.child_device_count
        if self.utc_active_time is not None:
            result['UtcActiveTime'] = self.utc_active_time
        if self.utc_last_online_time is not None:
            result['UtcLastOnlineTime'] = self.utc_last_online_time
        if self.utc_create_time is not None:
            result['UtcCreateTime'] = self.utc_create_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ActiveTime') is not None:
            self.active_time = m.get('ActiveTime')
        if m.get('LastOnlineTime') is not None:
            self.last_online_time = m.get('LastOnlineTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ChildDeviceCount') is not None:
            self.child_device_count = m.get('ChildDeviceCount')
        if m.get('UtcActiveTime') is not None:
            self.utc_active_time = m.get('UtcActiveTime')
        if m.get('UtcLastOnlineTime') is not None:
            self.utc_last_online_time = m.get('UtcLastOnlineTime')
        if m.get('UtcCreateTime') is not None:
            self.utc_create_time = m.get('UtcCreateTime')
        return self


class QueryAppDeviceListResponseBodyData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[QueryAppDeviceListResponseBodyDataData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryAppDeviceListResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = QueryAppDeviceListResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class QueryAppDeviceListResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, page=None, page_size=None,
                 page_count=None, total=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.total = total  # type: int
        self.data = data  # type: QueryAppDeviceListResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(QueryAppDeviceListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryAppDeviceListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryAppDeviceListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: QueryAppDeviceListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryAppDeviceListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryAppDeviceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryBatchRegisterDeviceStatusRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, apply_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.apply_id = apply_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryBatchRegisterDeviceStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class QueryBatchRegisterDeviceStatusResponseBodyDataValidList(TeaModel):
    def __init__(self, name=None):
        self.name = name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryBatchRegisterDeviceStatusResponseBodyDataValidList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class QueryBatchRegisterDeviceStatusResponseBodyDataInvalidList(TeaModel):
    def __init__(self, name=None):
        self.name = name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryBatchRegisterDeviceStatusResponseBodyDataInvalidList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class QueryBatchRegisterDeviceStatusResponseBodyData(TeaModel):
    def __init__(self, status=None, valid_list=None, invalid_list=None):
        self.status = status  # type: str
        self.valid_list = valid_list  # type: QueryBatchRegisterDeviceStatusResponseBodyDataValidList
        self.invalid_list = invalid_list  # type: QueryBatchRegisterDeviceStatusResponseBodyDataInvalidList

    def validate(self):
        if self.valid_list:
            self.valid_list.validate()
        if self.invalid_list:
            self.invalid_list.validate()

    def to_map(self):
        _map = super(QueryBatchRegisterDeviceStatusResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.valid_list is not None:
            result['ValidList'] = self.valid_list.to_map()
        if self.invalid_list is not None:
            result['InvalidList'] = self.invalid_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ValidList') is not None:
            temp_model = QueryBatchRegisterDeviceStatusResponseBodyDataValidList()
            self.valid_list = temp_model.from_map(m['ValidList'])
        if m.get('InvalidList') is not None:
            temp_model = QueryBatchRegisterDeviceStatusResponseBodyDataInvalidList()
            self.invalid_list = temp_model.from_map(m['InvalidList'])
        return self


class QueryBatchRegisterDeviceStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: QueryBatchRegisterDeviceStatusResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(QueryBatchRegisterDeviceStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryBatchRegisterDeviceStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryBatchRegisterDeviceStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: QueryBatchRegisterDeviceStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryBatchRegisterDeviceStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryBatchRegisterDeviceStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCertUrlByApplyIdRequest(TeaModel):
    def __init__(self, iot_instance_id=None, apply_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.apply_id = apply_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryCertUrlByApplyIdRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class QueryCertUrlByApplyIdResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, cert_url=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.cert_url = cert_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryCertUrlByApplyIdResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.cert_url is not None:
            result['CertUrl'] = self.cert_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('CertUrl') is not None:
            self.cert_url = m.get('CertUrl')
        return self


class QueryCertUrlByApplyIdResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: QueryCertUrlByApplyIdResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryCertUrlByApplyIdResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryCertUrlByApplyIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryConsumerGroupByGroupIdRequest(TeaModel):
    def __init__(self, iot_instance_id=None, group_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.group_id = group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryConsumerGroupByGroupIdRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryConsumerGroupByGroupIdResponseBodyData(TeaModel):
    def __init__(self, group_id=None, group_name=None, create_time=None):
        self.group_id = group_id  # type: str
        self.group_name = group_name  # type: str
        self.create_time = create_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryConsumerGroupByGroupIdResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class QueryConsumerGroupByGroupIdResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str
        self.data = data  # type: QueryConsumerGroupByGroupIdResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(QueryConsumerGroupByGroupIdResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryConsumerGroupByGroupIdResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryConsumerGroupByGroupIdResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: QueryConsumerGroupByGroupIdResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryConsumerGroupByGroupIdResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryConsumerGroupByGroupIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryConsumerGroupListRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, current_page=None, fuzzy=None, group_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.fuzzy = fuzzy  # type: bool
        self.group_name = group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryConsumerGroupListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.fuzzy is not None:
            result['Fuzzy'] = self.fuzzy
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Fuzzy') is not None:
            self.fuzzy = m.get('Fuzzy')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class QueryConsumerGroupListResponseBodyDataConsumerGroupDTO(TeaModel):
    def __init__(self, group_id=None, group_name=None, create_time=None):
        self.group_id = group_id  # type: str
        self.group_name = group_name  # type: str
        self.create_time = create_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryConsumerGroupListResponseBodyDataConsumerGroupDTO, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class QueryConsumerGroupListResponseBodyData(TeaModel):
    def __init__(self, consumer_group_dto=None):
        self.consumer_group_dto = consumer_group_dto  # type: list[QueryConsumerGroupListResponseBodyDataConsumerGroupDTO]

    def validate(self):
        if self.consumer_group_dto:
            for k in self.consumer_group_dto:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryConsumerGroupListResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConsumerGroupDTO'] = []
        if self.consumer_group_dto is not None:
            for k in self.consumer_group_dto:
                result['ConsumerGroupDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.consumer_group_dto = []
        if m.get('ConsumerGroupDTO') is not None:
            for k in m.get('ConsumerGroupDTO'):
                temp_model = QueryConsumerGroupListResponseBodyDataConsumerGroupDTO()
                self.consumer_group_dto.append(temp_model.from_map(k))
        return self


class QueryConsumerGroupListResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, page_size=None, page_count=None,
                 total=None, current_page=None, code=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.total = total  # type: int
        self.current_page = current_page  # type: int
        self.code = code  # type: str
        self.data = data  # type: QueryConsumerGroupListResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(QueryConsumerGroupListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryConsumerGroupListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryConsumerGroupListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: QueryConsumerGroupListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryConsumerGroupListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryConsumerGroupListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryConsumerGroupStatusRequest(TeaModel):
    def __init__(self, iot_instance_id=None, group_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.group_id = group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryConsumerGroupStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryConsumerGroupStatusResponseBodyClientConnectionStatusListConsumerGroupClientConnectionInfo(TeaModel):
    def __init__(self, client_id=None, client_ip_port=None, online_time=None,
                 real_time_consume_count_per_minute=None, accumulated_consume_count_per_minute=None):
        self.client_id = client_id  # type: str
        self.client_ip_port = client_ip_port  # type: str
        self.online_time = online_time  # type: long
        self.real_time_consume_count_per_minute = real_time_consume_count_per_minute  # type: int
        self.accumulated_consume_count_per_minute = accumulated_consume_count_per_minute  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryConsumerGroupStatusResponseBodyClientConnectionStatusListConsumerGroupClientConnectionInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_ip_port is not None:
            result['ClientIpPort'] = self.client_ip_port
        if self.online_time is not None:
            result['OnlineTime'] = self.online_time
        if self.real_time_consume_count_per_minute is not None:
            result['RealTimeConsumeCountPerMinute'] = self.real_time_consume_count_per_minute
        if self.accumulated_consume_count_per_minute is not None:
            result['AccumulatedConsumeCountPerMinute'] = self.accumulated_consume_count_per_minute
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientIpPort') is not None:
            self.client_ip_port = m.get('ClientIpPort')
        if m.get('OnlineTime') is not None:
            self.online_time = m.get('OnlineTime')
        if m.get('RealTimeConsumeCountPerMinute') is not None:
            self.real_time_consume_count_per_minute = m.get('RealTimeConsumeCountPerMinute')
        if m.get('AccumulatedConsumeCountPerMinute') is not None:
            self.accumulated_consume_count_per_minute = m.get('AccumulatedConsumeCountPerMinute')
        return self


class QueryConsumerGroupStatusResponseBodyClientConnectionStatusList(TeaModel):
    def __init__(self, consumer_group_client_connection_info=None):
        self.consumer_group_client_connection_info = consumer_group_client_connection_info  # type: list[QueryConsumerGroupStatusResponseBodyClientConnectionStatusListConsumerGroupClientConnectionInfo]

    def validate(self):
        if self.consumer_group_client_connection_info:
            for k in self.consumer_group_client_connection_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryConsumerGroupStatusResponseBodyClientConnectionStatusList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConsumerGroupClientConnectionInfo'] = []
        if self.consumer_group_client_connection_info is not None:
            for k in self.consumer_group_client_connection_info:
                result['ConsumerGroupClientConnectionInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.consumer_group_client_connection_info = []
        if m.get('ConsumerGroupClientConnectionInfo') is not None:
            for k in m.get('ConsumerGroupClientConnectionInfo'):
                temp_model = QueryConsumerGroupStatusResponseBodyClientConnectionStatusListConsumerGroupClientConnectionInfo()
                self.consumer_group_client_connection_info.append(temp_model.from_map(k))
        return self


class QueryConsumerGroupStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, accumulation_count=None,
                 consumer_speed=None, last_consumer_time=None, code=None, accumulated_consume_count_per_minute=None,
                 real_time_consume_count_per_minute=None, client_connection_status_list=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.accumulation_count = accumulation_count  # type: int
        self.consumer_speed = consumer_speed  # type: int
        self.last_consumer_time = last_consumer_time  # type: str
        self.code = code  # type: str
        self.accumulated_consume_count_per_minute = accumulated_consume_count_per_minute  # type: int
        self.real_time_consume_count_per_minute = real_time_consume_count_per_minute  # type: int
        self.client_connection_status_list = client_connection_status_list  # type: QueryConsumerGroupStatusResponseBodyClientConnectionStatusList

    def validate(self):
        if self.client_connection_status_list:
            self.client_connection_status_list.validate()

    def to_map(self):
        _map = super(QueryConsumerGroupStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.accumulation_count is not None:
            result['AccumulationCount'] = self.accumulation_count
        if self.consumer_speed is not None:
            result['ConsumerSpeed'] = self.consumer_speed
        if self.last_consumer_time is not None:
            result['LastConsumerTime'] = self.last_consumer_time
        if self.code is not None:
            result['Code'] = self.code
        if self.accumulated_consume_count_per_minute is not None:
            result['AccumulatedConsumeCountPerMinute'] = self.accumulated_consume_count_per_minute
        if self.real_time_consume_count_per_minute is not None:
            result['RealTimeConsumeCountPerMinute'] = self.real_time_consume_count_per_minute
        if self.client_connection_status_list is not None:
            result['ClientConnectionStatusList'] = self.client_connection_status_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('AccumulationCount') is not None:
            self.accumulation_count = m.get('AccumulationCount')
        if m.get('ConsumerSpeed') is not None:
            self.consumer_speed = m.get('ConsumerSpeed')
        if m.get('LastConsumerTime') is not None:
            self.last_consumer_time = m.get('LastConsumerTime')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('AccumulatedConsumeCountPerMinute') is not None:
            self.accumulated_consume_count_per_minute = m.get('AccumulatedConsumeCountPerMinute')
        if m.get('RealTimeConsumeCountPerMinute') is not None:
            self.real_time_consume_count_per_minute = m.get('RealTimeConsumeCountPerMinute')
        if m.get('ClientConnectionStatusList') is not None:
            temp_model = QueryConsumerGroupStatusResponseBodyClientConnectionStatusList()
            self.client_connection_status_list = temp_model.from_map(m['ClientConnectionStatusList'])
        return self


class QueryConsumerGroupStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: QueryConsumerGroupStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryConsumerGroupStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryConsumerGroupStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDetailSceneRuleLogRequest(TeaModel):
    def __init__(self, iot_instance_id=None, rule_id=None, start_time=None, end_time=None, trace_id=None,
                 page_size=None, current_page=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.rule_id = rule_id  # type: str
        self.start_time = start_time  # type: int
        self.end_time = end_time  # type: int
        self.trace_id = trace_id  # type: str
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDetailSceneRuleLogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDetailSceneRuleLogResponseBodyDataLogList(TeaModel):
    def __init__(self, code=None, message=None, pk_dn=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.pk_dn = pk_dn  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDetailSceneRuleLogResponseBodyDataLogList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.pk_dn is not None:
            result['PkDn'] = self.pk_dn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PkDn') is not None:
            self.pk_dn = m.get('PkDn')
        return self


class QueryDetailSceneRuleLogResponseBodyData(TeaModel):
    def __init__(self, total=None, page_size=None, current_page=None, log_list=None):
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.log_list = log_list  # type: list[QueryDetailSceneRuleLogResponseBodyDataLogList]

    def validate(self):
        if self.log_list:
            for k in self.log_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryDetailSceneRuleLogResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['LogList'] = []
        if self.log_list is not None:
            for k in self.log_list:
                result['LogList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.log_list = []
        if m.get('LogList') is not None:
            for k in m.get('LogList'):
                temp_model = QueryDetailSceneRuleLogResponseBodyDataLogList()
                self.log_list.append(temp_model.from_map(k))
        return self


class QueryDetailSceneRuleLogResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.error_message = error_message  # type: str
        self.code = code  # type: str
        self.data = data  # type: QueryDetailSceneRuleLogResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(QueryDetailSceneRuleLogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryDetailSceneRuleLogResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDetailSceneRuleLogResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: QueryDetailSceneRuleLogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryDetailSceneRuleLogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDetailSceneRuleLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, product_key=None, current_page=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.page_size = page_size  # type: int
        self.product_key = product_key  # type: str
        self.current_page = current_page  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDeviceResponseBodyDataDeviceInfo(TeaModel):
    def __init__(self, device_id=None, device_secret=None, product_key=None, device_status=None, device_name=None,
                 device_type=None, gmt_create=None, gmt_modified=None, utc_create=None, utc_modified=None, iot_id=None,
                 nickname=None):
        self.device_id = device_id  # type: str
        self.device_secret = device_secret  # type: str
        self.product_key = product_key  # type: str
        self.device_status = device_status  # type: str
        self.device_name = device_name  # type: str
        self.device_type = device_type  # type: str
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.utc_create = utc_create  # type: str
        self.utc_modified = utc_modified  # type: str
        self.iot_id = iot_id  # type: str
        self.nickname = nickname  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceResponseBodyDataDeviceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_status is not None:
            result['DeviceStatus'] = self.device_status
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceStatus') is not None:
            self.device_status = m.get('DeviceStatus')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        return self


class QueryDeviceResponseBodyData(TeaModel):
    def __init__(self, device_info=None):
        self.device_info = device_info  # type: list[QueryDeviceResponseBodyDataDeviceInfo]

    def validate(self):
        if self.device_info:
            for k in self.device_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryDeviceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DeviceInfo'] = []
        if self.device_info is not None:
            for k in self.device_info:
                result['DeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_info = []
        if m.get('DeviceInfo') is not None:
            for k in m.get('DeviceInfo'):
                temp_model = QueryDeviceResponseBodyDataDeviceInfo()
                self.device_info.append(temp_model.from_map(k))
        return self


class QueryDeviceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, page=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.page = page  # type: int
        self.data = data  # type: QueryDeviceResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(QueryDeviceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page is not None:
            result['Page'] = self.page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Data') is not None:
            temp_model = QueryDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: QueryDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryDeviceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceBySQLRequest(TeaModel):
    def __init__(self, iot_instance_id=None, sql=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.sql = sql  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceBySQLRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.sql is not None:
            result['SQL'] = self.sql
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SQL') is not None:
            self.sql = m.get('SQL')
        return self


class QueryDeviceBySQLResponseBodyDataGroups(TeaModel):
    def __init__(self, group_id=None):
        self.group_id = group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceBySQLResponseBodyDataGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryDeviceBySQLResponseBodyDataTags(TeaModel):
    def __init__(self, tag_name=None, tag_value=None):
        self.tag_name = tag_name  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceBySQLResponseBodyDataTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryDeviceBySQLResponseBodyDataOTAModules(TeaModel):
    def __init__(self, module_name=None, firmware_version=None):
        self.module_name = module_name  # type: str
        self.firmware_version = firmware_version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceBySQLResponseBodyDataOTAModules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        return self


class QueryDeviceBySQLResponseBodyData(TeaModel):
    def __init__(self, product_key=None, device_name=None, nickname=None, status=None, active_time=None, iot_id=None,
                 gmt_create=None, gmt_modified=None, groups=None, tags=None, otamodules=None):
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.nickname = nickname  # type: str
        self.status = status  # type: str
        self.active_time = active_time  # type: str
        self.iot_id = iot_id  # type: str
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.groups = groups  # type: list[QueryDeviceBySQLResponseBodyDataGroups]
        self.tags = tags  # type: list[QueryDeviceBySQLResponseBodyDataTags]
        self.otamodules = otamodules  # type: list[QueryDeviceBySQLResponseBodyDataOTAModules]

    def validate(self):
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()
        if self.otamodules:
            for k in self.otamodules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryDeviceBySQLResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.status is not None:
            result['Status'] = self.status
        if self.active_time is not None:
            result['ActiveTime'] = self.active_time
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        result['OTAModules'] = []
        if self.otamodules is not None:
            for k in self.otamodules:
                result['OTAModules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ActiveTime') is not None:
            self.active_time = m.get('ActiveTime')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = QueryDeviceBySQLResponseBodyDataGroups()
                self.groups.append(temp_model.from_map(k))
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = QueryDeviceBySQLResponseBodyDataTags()
                self.tags.append(temp_model.from_map(k))
        self.otamodules = []
        if m.get('OTAModules') is not None:
            for k in m.get('OTAModules'):
                temp_model = QueryDeviceBySQLResponseBodyDataOTAModules()
                self.otamodules.append(temp_model.from_map(k))
        return self


class QueryDeviceBySQLResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total_count=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.total_count = total_count  # type: long
        self.data = data  # type: list[QueryDeviceBySQLResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryDeviceBySQLResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = QueryDeviceBySQLResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class QueryDeviceBySQLResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: QueryDeviceBySQLResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryDeviceBySQLResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceBySQLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceByStatusRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, status=None, current_page=None, page_size=None,
                 resource_group_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.status = status  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceByStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.status is not None:
            result['Status'] = self.status
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class QueryDeviceByStatusResponseBodyDataSimpleDeviceInfo(TeaModel):
    def __init__(self, product_key=None, device_name=None, status=None, iot_id=None, nickname=None, gmt_create=None,
                 gmt_modified=None, utc_create=None, utc_modified=None, device_secret=None):
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.status = status  # type: str
        self.iot_id = iot_id  # type: str
        self.nickname = nickname  # type: str
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.utc_create = utc_create  # type: str
        self.utc_modified = utc_modified  # type: str
        self.device_secret = device_secret  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceByStatusResponseBodyDataSimpleDeviceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.status is not None:
            result['Status'] = self.status
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        return self


class QueryDeviceByStatusResponseBodyData(TeaModel):
    def __init__(self, simple_device_info=None):
        self.simple_device_info = simple_device_info  # type: list[QueryDeviceByStatusResponseBodyDataSimpleDeviceInfo]

    def validate(self):
        if self.simple_device_info:
            for k in self.simple_device_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryDeviceByStatusResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SimpleDeviceInfo'] = []
        if self.simple_device_info is not None:
            for k in self.simple_device_info:
                result['SimpleDeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_device_info = []
        if m.get('SimpleDeviceInfo') is not None:
            for k in m.get('SimpleDeviceInfo'):
                temp_model = QueryDeviceByStatusResponseBodyDataSimpleDeviceInfo()
                self.simple_device_info.append(temp_model.from_map(k))
        return self


class QueryDeviceByStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, page=None, page_size=None,
                 page_count=None, total=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.total = total  # type: int
        self.data = data  # type: QueryDeviceByStatusResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(QueryDeviceByStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceByStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceByStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: QueryDeviceByStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryDeviceByStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceByStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceByTagsRequestTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceByTagsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryDeviceByTagsRequest(TeaModel):
    def __init__(self, iot_instance_id=None, tag=None, current_page=None, page_size=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.tag = tag  # type: list[QueryDeviceByTagsRequestTag]
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryDeviceByTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = QueryDeviceByTagsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryDeviceByTagsResponseBodyDataSimpleDeviceInfo(TeaModel):
    def __init__(self, product_name=None, product_key=None, device_name=None, iot_id=None):
        self.product_name = product_name  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceByTagsResponseBodyDataSimpleDeviceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class QueryDeviceByTagsResponseBodyData(TeaModel):
    def __init__(self, simple_device_info=None):
        self.simple_device_info = simple_device_info  # type: list[QueryDeviceByTagsResponseBodyDataSimpleDeviceInfo]

    def validate(self):
        if self.simple_device_info:
            for k in self.simple_device_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryDeviceByTagsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SimpleDeviceInfo'] = []
        if self.simple_device_info is not None:
            for k in self.simple_device_info:
                result['SimpleDeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_device_info = []
        if m.get('SimpleDeviceInfo') is not None:
            for k in m.get('SimpleDeviceInfo'):
                temp_model = QueryDeviceByTagsResponseBodyDataSimpleDeviceInfo()
                self.simple_device_info.append(temp_model.from_map(k))
        return self


class QueryDeviceByTagsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, page=None, page_size=None,
                 page_count=None, total=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.total = total  # type: int
        self.data = data  # type: QueryDeviceByTagsResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(QueryDeviceByTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceByTagsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceByTagsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: QueryDeviceByTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryDeviceByTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceByTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceCertRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceCertRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class QueryDeviceCertResponseBodyDeviceCertInfo(TeaModel):
    def __init__(self, status=None, certificate=None, private_key=None, cert_sn=None):
        self.status = status  # type: int
        self.certificate = certificate  # type: str
        self.private_key = private_key  # type: str
        self.cert_sn = cert_sn  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceCertResponseBodyDeviceCertInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.certificate is not None:
            result['Certificate'] = self.certificate
        if self.private_key is not None:
            result['PrivateKey'] = self.private_key
        if self.cert_sn is not None:
            result['CertSN'] = self.cert_sn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Certificate') is not None:
            self.certificate = m.get('Certificate')
        if m.get('PrivateKey') is not None:
            self.private_key = m.get('PrivateKey')
        if m.get('CertSN') is not None:
            self.cert_sn = m.get('CertSN')
        return self


class QueryDeviceCertResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, device_cert_info=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.device_cert_info = device_cert_info  # type: QueryDeviceCertResponseBodyDeviceCertInfo

    def validate(self):
        if self.device_cert_info:
            self.device_cert_info.validate()

    def to_map(self):
        _map = super(QueryDeviceCertResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.device_cert_info is not None:
            result['DeviceCertInfo'] = self.device_cert_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('DeviceCertInfo') is not None:
            temp_model = QueryDeviceCertResponseBodyDeviceCertInfo()
            self.device_cert_info = temp_model.from_map(m['DeviceCertInfo'])
        return self


class QueryDeviceCertResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: QueryDeviceCertResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryDeviceCertResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceCertResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceDesiredPropertyRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None, identifier=None, iot_id=None,
                 function_block_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.identifier = identifier  # type: list[str]
        self.iot_id = iot_id  # type: str
        self.function_block_id = function_block_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceDesiredPropertyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        return self


class QueryDeviceDesiredPropertyResponseBodyDataListDesiredPropertyInfo(TeaModel):
    def __init__(self, unit=None, identifier=None, data_type=None, time=None, value=None, name=None, version=None):
        self.unit = unit  # type: str
        self.identifier = identifier  # type: str
        self.data_type = data_type  # type: str
        self.time = time  # type: str
        self.value = value  # type: str
        self.name = name  # type: str
        self.version = version  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceDesiredPropertyResponseBodyDataListDesiredPropertyInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.time is not None:
            result['Time'] = self.time
        if self.value is not None:
            result['Value'] = self.value
        if self.name is not None:
            result['Name'] = self.name
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class QueryDeviceDesiredPropertyResponseBodyDataList(TeaModel):
    def __init__(self, desired_property_info=None):
        self.desired_property_info = desired_property_info  # type: list[QueryDeviceDesiredPropertyResponseBodyDataListDesiredPropertyInfo]

    def validate(self):
        if self.desired_property_info:
            for k in self.desired_property_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryDeviceDesiredPropertyResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DesiredPropertyInfo'] = []
        if self.desired_property_info is not None:
            for k in self.desired_property_info:
                result['DesiredPropertyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.desired_property_info = []
        if m.get('DesiredPropertyInfo') is not None:
            for k in m.get('DesiredPropertyInfo'):
                temp_model = QueryDeviceDesiredPropertyResponseBodyDataListDesiredPropertyInfo()
                self.desired_property_info.append(temp_model.from_map(k))
        return self


class QueryDeviceDesiredPropertyResponseBodyData(TeaModel):
    def __init__(self, list=None):
        self.list = list  # type: QueryDeviceDesiredPropertyResponseBodyDataList

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        _map = super(QueryDeviceDesiredPropertyResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = QueryDeviceDesiredPropertyResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceDesiredPropertyResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: QueryDeviceDesiredPropertyResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(QueryDeviceDesiredPropertyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceDesiredPropertyResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceDesiredPropertyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: QueryDeviceDesiredPropertyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryDeviceDesiredPropertyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceDesiredPropertyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceDetailRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None, iot_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class QueryDeviceDetailResponseBodyData(TeaModel):
    def __init__(self, iot_id=None, product_key=None, product_name=None, device_name=None, device_secret=None,
                 firmware_version=None, gmt_create=None, utc_create=None, gmt_active=None, utc_active=None, gmt_online=None,
                 utc_online=None, status=None, ip_address=None, node_type=None, region=None, owner=None, nickname=None):
        self.iot_id = iot_id  # type: str
        self.product_key = product_key  # type: str
        self.product_name = product_name  # type: str
        self.device_name = device_name  # type: str
        self.device_secret = device_secret  # type: str
        self.firmware_version = firmware_version  # type: str
        self.gmt_create = gmt_create  # type: str
        self.utc_create = utc_create  # type: str
        self.gmt_active = gmt_active  # type: str
        self.utc_active = utc_active  # type: str
        self.gmt_online = gmt_online  # type: str
        self.utc_online = utc_online  # type: str
        self.status = status  # type: str
        self.ip_address = ip_address  # type: str
        self.node_type = node_type  # type: int
        self.region = region  # type: str
        self.owner = owner  # type: bool
        self.nickname = nickname  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.gmt_active is not None:
            result['GmtActive'] = self.gmt_active
        if self.utc_active is not None:
            result['UtcActive'] = self.utc_active
        if self.gmt_online is not None:
            result['GmtOnline'] = self.gmt_online
        if self.utc_online is not None:
            result['UtcOnline'] = self.utc_online
        if self.status is not None:
            result['Status'] = self.status
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.region is not None:
            result['Region'] = self.region
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GmtActive') is not None:
            self.gmt_active = m.get('GmtActive')
        if m.get('UtcActive') is not None:
            self.utc_active = m.get('UtcActive')
        if m.get('GmtOnline') is not None:
            self.gmt_online = m.get('GmtOnline')
        if m.get('UtcOnline') is not None:
            self.utc_online = m.get('UtcOnline')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        return self


class QueryDeviceDetailResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: QueryDeviceDetailResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(QueryDeviceDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: QueryDeviceDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryDeviceDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceDistributeDetailRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceDistributeDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryDeviceDistributeDetailResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, file=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.file = file  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceDistributeDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.file is not None:
            result['File'] = self.file
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('File') is not None:
            self.file = m.get('File')
        return self


class QueryDeviceDistributeDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: QueryDeviceDistributeDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryDeviceDistributeDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceDistributeDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceDistributeJobRequest(TeaModel):
    def __init__(self, job_id=None):
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceDistributeJobRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class QueryDeviceDistributeJobResponseBodyDataTargetInstanceConfigsTargetInstanceConfigs(TeaModel):
    def __init__(self, target_instance_id=None):
        self.target_instance_id = target_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceDistributeJobResponseBodyDataTargetInstanceConfigsTargetInstanceConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_instance_id is not None:
            result['TargetInstanceId'] = self.target_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetInstanceId') is not None:
            self.target_instance_id = m.get('TargetInstanceId')
        return self


class QueryDeviceDistributeJobResponseBodyDataTargetInstanceConfigs(TeaModel):
    def __init__(self, target_instance_configs=None):
        self.target_instance_configs = target_instance_configs  # type: list[QueryDeviceDistributeJobResponseBodyDataTargetInstanceConfigsTargetInstanceConfigs]

    def validate(self):
        if self.target_instance_configs:
            for k in self.target_instance_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryDeviceDistributeJobResponseBodyDataTargetInstanceConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['targetInstanceConfigs'] = []
        if self.target_instance_configs is not None:
            for k in self.target_instance_configs:
                result['targetInstanceConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.target_instance_configs = []
        if m.get('targetInstanceConfigs') is not None:
            for k in m.get('targetInstanceConfigs'):
                temp_model = QueryDeviceDistributeJobResponseBodyDataTargetInstanceConfigsTargetInstanceConfigs()
                self.target_instance_configs.append(temp_model.from_map(k))
        return self


class QueryDeviceDistributeJobResponseBodyData(TeaModel):
    def __init__(self, source_uid=None, target_uid=None, source_instance_id=None, job_id=None, product_key=None,
                 total=None, status=None, gmt_create=None, strategy=None, target_instance_configs=None):
        self.source_uid = source_uid  # type: str
        self.target_uid = target_uid  # type: str
        self.source_instance_id = source_instance_id  # type: str
        self.job_id = job_id  # type: str
        self.product_key = product_key  # type: str
        self.total = total  # type: int
        self.status = status  # type: int
        self.gmt_create = gmt_create  # type: long
        self.strategy = strategy  # type: int
        self.target_instance_configs = target_instance_configs  # type: QueryDeviceDistributeJobResponseBodyDataTargetInstanceConfigs

    def validate(self):
        if self.target_instance_configs:
            self.target_instance_configs.validate()

    def to_map(self):
        _map = super(QueryDeviceDistributeJobResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_uid is not None:
            result['SourceUid'] = self.source_uid
        if self.target_uid is not None:
            result['TargetUid'] = self.target_uid
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.total is not None:
            result['Total'] = self.total
        if self.status is not None:
            result['Status'] = self.status
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        if self.target_instance_configs is not None:
            result['TargetInstanceConfigs'] = self.target_instance_configs.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceUid') is not None:
            self.source_uid = m.get('SourceUid')
        if m.get('TargetUid') is not None:
            self.target_uid = m.get('TargetUid')
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        if m.get('TargetInstanceConfigs') is not None:
            temp_model = QueryDeviceDistributeJobResponseBodyDataTargetInstanceConfigs()
            self.target_instance_configs = temp_model.from_map(m['TargetInstanceConfigs'])
        return self


class QueryDeviceDistributeJobResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: QueryDeviceDistributeJobResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(QueryDeviceDistributeJobResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceDistributeJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceDistributeJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: QueryDeviceDistributeJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryDeviceDistributeJobResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceDistributeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceEventDataRequest(TeaModel):
    def __init__(self, iot_instance_id=None, page_size=None, product_key=None, device_name=None, start_time=None,
                 identifier=None, event_type=None, asc=None, iot_id=None, end_time=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.page_size = page_size  # type: int
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.start_time = start_time  # type: long
        self.identifier = identifier  # type: str
        self.event_type = event_type  # type: str
        self.asc = asc  # type: int
        self.iot_id = iot_id  # type: str
        self.end_time = end_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceEventDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        return self


class QueryDeviceEventDataResponseBodyDataListEventInfo(TeaModel):
    def __init__(self, time=None, identifier=None, name=None, event_type=None, output_data=None):
        self.time = time  # type: str
        self.identifier = identifier  # type: str
        self.name = name  # type: str
        self.event_type = event_type  # type: str
        self.output_data = output_data  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceEventDataResponseBodyDataListEventInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time is not None:
            result['Time'] = self.time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.name is not None:
            result['Name'] = self.name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.output_data is not None:
            result['OutputData'] = self.output_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('OutputData') is not None:
            self.output_data = m.get('OutputData')
        return self


class QueryDeviceEventDataResponseBodyDataList(TeaModel):
    def __init__(self, event_info=None):
        self.event_info = event_info  # type: list[QueryDeviceEventDataResponseBodyDataListEventInfo]

    def validate(self):
        if self.event_info:
            for k in self.event_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryDeviceEventDataResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventInfo'] = []
        if self.event_info is not None:
            for k in self.event_info:
                result['EventInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.event_info = []
        if m.get('EventInfo') is not None:
            for k in m.get('EventInfo'):
                temp_model = QueryDeviceEventDataResponseBodyDataListEventInfo()
                self.event_info.append(temp_model.from_map(k))
        return self


class QueryDeviceEventDataResponseBodyData(TeaModel):
    def __init__(self, next_time=None, next_valid=None, list=None):
        self.next_time = next_time  # type: long
        self.next_valid = next_valid  # type: bool
        self.list = list  # type: QueryDeviceEventDataResponseBodyDataList

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        _map = super(QueryDeviceEventDataResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_time is not None:
            result['NextTime'] = self.next_time
        if self.next_valid is not None:
            result['NextValid'] = self.next_valid
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextTime') is not None:
            self.next_time = m.get('NextTime')
        if m.get('NextValid') is not None:
            self.next_valid = m.get('NextValid')
        if m.get('List') is not None:
            temp_model = QueryDeviceEventDataResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceEventDataResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.code = code  # type: str
        self.error_message = error_message  # type: str
        self.data = data  # type: QueryDeviceEventDataResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(QueryDeviceEventDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceEventDataResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceEventDataResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: QueryDeviceEventDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryDeviceEventDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceEventDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceFileRequest(TeaModel):
    def __init__(self, iot_instance_id=None, product_key=None, device_name=None, iot_id=None, file_id=None):
        self.iot_instance_id = iot_instance_id  # type: str
        self.product_key = product_key  # type: str
        self.device_name = device_name  # type: str
        self.iot_id = iot_id  # type: str
        self.file_id = file_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryDeviceFileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('FileId') is not None:
          