"""Implemented internal directory

Peek Plugin Database Migration Script

Revision ID: 0498d92479c8
Revises: 3fec57d8da58
Create Date: 2017-10-07 17:33:08.316831

"""

# revision identifiers, used by Alembic.
revision = '0498d92479c8'
down_revision = '3fec57d8da58'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
import geoalchemy2


def upgrade():
    op.execute('TRUNCATE TABLE core_user."UserLoggedIn" ')

    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('InternalGroup',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('groupName', sa.String(length=50), nullable=False),
    sa.Column('groupTitle', sa.String(), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('groupName'),
    sa.UniqueConstraint('groupTitle'),
    schema='core_user'
    )
    op.create_table('InternalUser',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('userName', sa.String(length=50), nullable=False),
    sa.Column('userTitle', sa.String(length=50), nullable=False),
    sa.Column('userUuid', sa.String(length=50), nullable=False),
    sa.Column('password', sa.String(length=50), nullable=False),
    sa.Column('mobile', sa.String(length=50), nullable=True),
    sa.Column('email', sa.String(length=50), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('userName'),
    sa.UniqueConstraint('userTitle'),
    sa.UniqueConstraint('userUuid'),
    schema='core_user'
    )
    op.create_table('InternalUserGroup',
    sa.Column('userId', sa.Integer(), nullable=False),
    sa.Column('groupId', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['groupId'], ['core_user.InternalGroup.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['userId'], ['core_user.InternalUser.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('userId', 'groupId'),
    schema='core_user'
    )
    op.create_index('idx_InternalUserGroup_map', 'InternalUserGroup', ['userId', 'groupId'], unique=True, schema='core_user')
    op.add_column('UserLoggedIn', sa.Column('deviceToken', sa.String(length=100), nullable=False), schema='core_user')
    op.add_column('UserLoggedIn', sa.Column('userName', sa.String(length=50), nullable=True), schema='core_user')
    op.drop_constraint('UserLoggedIn_clientDeviceToken_key', 'UserLoggedIn', schema='core_user', type_='unique')
    op.drop_constraint('UserLoggedIn_userId_key', 'UserLoggedIn', schema='core_user', type_='unique')
    op.create_unique_constraint(None, 'UserLoggedIn', ['userName'], schema='core_user')
    op.create_unique_constraint(None, 'UserLoggedIn', ['deviceToken'], schema='core_user')
    op.drop_column('UserLoggedIn', 'userId', schema='core_user')
    op.drop_column('UserLoggedIn', 'clientDeviceToken', schema='core_user')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('UserLoggedIn', sa.Column('clientDeviceToken', sa.VARCHAR(length=100), autoincrement=False, nullable=False), schema='core_user')
    op.add_column('UserLoggedIn', sa.Column('userId', sa.VARCHAR(length=50), autoincrement=False, nullable=True), schema='core_user')
    op.drop_constraint(None, 'UserLoggedIn', schema='core_user', type_='unique')
    op.drop_constraint(None, 'UserLoggedIn', schema='core_user', type_='unique')
    op.create_unique_constraint('UserLoggedIn_userId_key', 'UserLoggedIn', ['userId'], schema='core_user')
    op.create_unique_constraint('UserLoggedIn_clientDeviceToken_key', 'UserLoggedIn', ['clientDeviceToken'], schema='core_user')
    op.drop_column('UserLoggedIn', 'userName', schema='core_user')
    op.drop_column('UserLoggedIn', 'deviceToken', schema='core_user')
    op.drop_index('idx_InternalUserGroup_map', table_name='InternalUserGroup', schema='core_user')
    op.drop_table('InternalUserGroup', schema='core_user')
    op.drop_table('InternalUser', schema='core_user')
    op.drop_table('InternalGroup', schema='core_user')
    # ### end Alembic commands ###
