basic = {
    "src": {
        "type": "dir",
        "name": "src",
        "child": {
            "api": {
                "type": "dir",
                "name": "api",
                "child": {
                    "routes.py": {
                        "type": "file",
                        "name": "routes.py",
                        "content": """# 🛸 Generated by zPy
from di import @usecase_var
from flask import Flask
from zpy.api.http.response import response_builder
from zpy.api.flask import create_app


app: Flask = create_app()


@app.route("/api/awesome", methods=["GET"])
@response_builder()
def awesome_api():
    return @usecase_var.execute(None)"""
                    }
                }
            },
            "contexts": {
                "type": "dir",
                "name": "contexts",
                "child": {
                    "@context_name": {
                        "type": "dir",
                        "name": "@context_name",
                        "child": {
                            "application": {
                                "type": "dir",
                                "name": "application",
                                "child": {
                                    "@usecase_file.py": {
                                        "type": "file",
                                        "name": "@usecase_file.py",
                                        "content": """# 🛸 Generated by zPy
from typing import Any

from zpy.app.usecase import UseCase


from ..domain.repositories import @repository_name


class @usecase_class(UseCase[Any, Any]):
    \"\"\"
        Use Case description.
    \"\"\"

    def __init__(self, repository: @repository_name) -> None:
        self.repository = repository

    def execute(self, data: Any, *args, **kwargs) -> None:
        # TODO Do magic with business rules 😁
        return self.repository.@repository_action(data)"""
                                    }
                                }

                            },
                            "domain": {
                                "type": "dir",
                                "name": "domain",
                                "child": {
                                    "catalogs.py": {
                                        "type": "file",
                                        "name": "catalogs.py",
                                        "content": """# 🛸 Generated by zPy
from enum import Enum

class SomeCatalog(Enum):
    \"\"\"
        Catalog example
    \"\"\"
    SOME_CONSTANT = 9
    ANOTHER_CONSTANT = 10"""
                                    },
                                    "repositories.py": {
                                        "type": "file",
                                        "name": "repositories.py",
                                        "content": """# 🛸 Generated by zPy
from abc import abstractmethod
from abc import ABC
from typing import Any


class @repository_name(ABC):
    @abstractmethod
    def @repository_action(self, data: Any) -> Any:
        \"\"\"
        Description

        :param data: input data
        :return: result
        \"\"\"
        ..."""
                                    }
                                }

                            },
                            "infraestructure": {
                                "type": "dir",
                                "name": "infraestructure",
                                "child": {
                                    "@repository_impl_file.py": {
                                        "type": "file",
                                        "name": "@repository_file.py",
                                        "content": """# 🛸 Generated by zPy
from ..domain.repositories import @repository_name
from typing import Any

class @repository_impl(@repository_name):

    def __init__(self):
        ...

    def @repository_action(self, data: Any) -> Any:
        try:
            # TODO Do magic with data 😁
            return "😁"
        finally:
            ..."""
                                    }
                                }

                            },
                            "__init__.py": {
                                "type": "file",
                                "name": "__init__.py",
                                "content": """# 🛸 Generated by zPy
# 🛰 Application Layer

from .application.@usecase_file import @usecase_class

# 📦  Domain Layer

from .domain.repositories import @repository_name


# Infrastructure

from .infraestructure.@repository_file import @repository_impl"""
                            }
                        }
                    }
                }
            },
            "di.py": {
                "type": "file",
                "name": "di.py",
                "content": """# 🛸 Generated by zPy
from zpy.utils import get_env_or_throw as var
from zpy.app.usecase import UseCase
from typing import Any

# * Setup Dependencies 📃
from contexts.@context_name.domain.repositories import @repository_name
from contexts.@context_name.infraestructure.@repository_file import @repository_impl
from contexts.@context_name.application.@usecase_file import @usecase_class

repository: @repository_name = @repository_impl()


# Setup UseCases

@usecase_var: UseCase[Any, None] = @usecase_class(repository)
print("🚀 Dependencies loaded successfully...")"""
            },
            "handler.py": {
                "type": "file",
                "name": "handler.py",
                "content": """# 🛸 Generated by zPy
from typing import Any
from zpy.api.flask.cloud_handlers import aws_lambda

from api.routes import app
import aws_lambda_wsgi as awsgi


@aws_lambda()
def handle(event: dict, context: dict) -> Any:
    return awsgi.response(app, event, context)"""
            },
            "local_deploy.py": {
                "type": "file",
                "name": "local_deploy.py",
                "content": """# 🛸 Generated by zPy
from dotenv import load_dotenv
load_dotenv(
    dotenv_path="@base_path\\\\.env"
)

from api.routes import app

if __name__ == "__main__":
    app.run(host="127.0.0.1", port="5050", debug=True)"""
            }
        }
    },
    "tests": {
        "type": "dir",
        "name": "tests",
        "child": {
            "@usecase_file_test.py": {
                "type": "file",
                "name": "@usecase_file_test.py",
                "content": """# 🛸 Generated by zPy
from dotenv import load_dotenv
load_dotenv(dotenv_path="..\\.env")

from src.handler import handle

if __name__ == "__main__":
    handle({}, {})"""
            }
        }
    },
    ".env": {
        "type": "file",
        "name": ".env",
        "content": "ENVIRONMENT=local\nORACLE_CLIENT_PATH=C:\oracle\win32\instantclient_19_9"
    },
    ".gitignore": {
        "type": "raw-file",
        "name": ".gitignore",
        "path": "ignore.py"
    },
    "package.json": {
        "type": "file",
        "content": """{
    "name": "@project_name",
    "version": "1.0.0"
}""",
        "name": "package.json"
    },
    "CHANGELOG.md": {
        "type": "file",
        "name": "CHANGELOG.md",
        "content": """# Change Log
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](http://keepachangelog.com/)
and this project adheres to [Semantic Versioning](http://semver.org/).

## [1.0.0] - @date Project scaffolding generated by @project_name

> Author: @developer | @dev_url

### Added

- Project scaffolding configured
- Default Use Case implemented
- Default Repository Implementation"""
    },
    "README.md": {
        "type": "file",
        "name": "README.md",
        "content": """# @project_name

@project_description

## Getting Started

Clone this repository for local deploy.

### Prerequisites

- python3.9
- pip
- virtualenv

### Dependencies

Some dependencies are optional according of the requirements.
- zpy-api-core
- zpy-db-core
- boto3

For more information see requirements.txt file

### Installing

- Create virtual environment, activate it and download all dependencies.

```
  virtualenv venv
```

- Clone repository

```

git clone http-url-repository

```

## Running the tests

Load env vars

```bash
ENVIRONMENT=
```

Test use cases

```python

from src.di import @usecase_class

if __name__ == "__main__":
    @usecase_var.execute(@usecase_repository_dependency)


```

Or test from handler

`````python
from dotenv import load_dotenv

load_dotenv()

from src.handler import handle

if __name__ == "__main__":
    handle({}, {})

`````

Use selenium or cucumber

## Built With

- Python 3.9
- zpy cli

## Versioning

We use [SemVer](http://semver.org/) for versioning. For the versions available, see
the [tags on this repository](./CHANGELOG.md)
.

## Authors

- **@developer** - _[Backend Developer](@dev_url)_
"""
    },
    "requirements.txt": {
        "type": "file",
        "name": "requirements.txt",
        "content":
            """zpy-api-core~=1.0.12
python-dotenv~=0.19.1"""
    }
}
