import typing

import httplib2  # type: ignore
import typing_extensions

import googleapiclient.discovery
import googleapiclient.http  # type: ignore

from .schemas import *

class HomeGraphServiceResource(googleapiclient.discovery.Resource):
    class AgentUsersResource(googleapiclient.discovery.Resource):
        def delete(
            self, *, agentUserId: str, requestId: str = ..., **kwargs: typing.Any
        ) -> EmptyHttpRequest: ...
    class DevicesResource(googleapiclient.discovery.Resource):
        def sync(
            self, *, body: SyncRequest = ..., **kwargs: typing.Any
        ) -> SyncResponseHttpRequest: ...
        def reportStateAndNotification(
            self, *, body: ReportStateAndNotificationRequest = ..., **kwargs: typing.Any
        ) -> ReportStateAndNotificationResponseHttpRequest: ...
        def query(
            self, *, body: QueryRequest = ..., **kwargs: typing.Any
        ) -> QueryResponseHttpRequest: ...
        def requestSync(
            self, *, body: RequestSyncDevicesRequest = ..., **kwargs: typing.Any
        ) -> RequestSyncDevicesResponseHttpRequest: ...
    def agentUsers(self) -> AgentUsersResource: ...
    def devices(self) -> DevicesResource: ...

class EmptyHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> Empty: ...

class RequestSyncDevicesResponseHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> RequestSyncDevicesResponse: ...

class ReportStateAndNotificationResponseHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> ReportStateAndNotificationResponse: ...

class SyncResponseHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> SyncResponse: ...

class QueryResponseHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self, http: typing.Optional[httplib2.Http] = ..., num_retries: int = ...
    ) -> QueryResponse: ...
