"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PDKPipelineTsProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const projen_1 = require("projen");
const awscdk_1 = require("projen/lib/awscdk");
/**
 * Synthesizes a Typescript Project with a CI/CD pipeline.
 *
 * @pjid pdk-pipeline-ts
 */
class PDKPipelineTsProject extends awscdk_1.AwsCdkTypeScriptApp {
    constructor(options) {
        super({
            github: false,
            package: false,
            prettier: true,
            projenrcTs: true,
            release: false,
            sampleCode: false,
            ...options,
            appEntrypoint: options.appEntrypoint || "pipeline.ts",
        });
        this.addDeps("aws-prototyping-sdk", "cdk-nag");
        // AwsCdkTypeScriptApp removes ts compilation - add back to err on the side of caution should infrastructure
        // include NodejsFunctions that won't be type-checked during CDK synthesis
        this.compileTask.reset("tsc --build");
        new projen_1.SampleDir(this, this.srcdir, {
            sourceDir: path.join(__dirname, "..", "samples", "typescript", "src"),
        });
        new projen_1.SampleDir(this, this.testdir, {
            sourceDir: path.join(__dirname, "..", "samples", "typescript", "test"),
        });
    }
}
exports.PDKPipelineTsProject = PDKPipelineTsProject;
_a = JSII_RTTI_SYMBOL_1;
PDKPipelineTsProject[_a] = { fqn: "aws-prototyping-sdk.pipeline.PDKPipelineTsProject", version: "0.0.0" };
//# sourceMappingURL=data:application/json;base64,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