"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cdk8sTypeScriptApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs-extra");
const auto_discover_1 = require("./auto-discover");
const cdk8s_deps_js_1 = require("./cdk8s-deps-js");
const component_1 = require("../component");
const dependencies_1 = require("../dependencies");
const typescript_1 = require("../typescript");
const yaml_1 = require("../yaml");
/**
 * CDK8s app in TypeScript
 *
 *
 * @pjid cdk8s-app-ts
 */
class Cdk8sTypeScriptApp extends typescript_1.TypeScriptAppProject {
    constructor(options) {
        super({
            ...options,
            sampleCode: false,
        });
        this.cdk8sDeps = new cdk8s_deps_js_1.Cdk8sDepsJs(this, {
            dependencyType: dependencies_1.DependencyType.RUNTIME,
            cdk8sCliDependency: true,
            ...options,
        });
        if (!options.cdk8sVersion) {
            throw new Error("Required field cdk8sVersion is not specified.");
        }
        // encode a hidden assumption further down the chain
        if (this.srcdir !== "src") {
            throw new Error('sources are expected under the "src" directory');
        }
        // encode a hidden assumption further down the chain
        if (this.testdir !== "test") {
            throw new Error('test sources are expected under the "test" directory');
        }
        this.appEntrypoint = options.appEntrypoint ?? "main.ts";
        const synth = this.addTask("synth", {
            description: 'Synthesizes your cdk8s app into dist (part of "yarn build")',
            exec: "cdk8s synth",
        });
        this.addTask("import", {
            description: "Imports API objects to your app by generating constructs.",
            exec: "cdk8s import -o src/imports",
        });
        // add synth to the build
        this.postCompileTask.spawn(synth);
        const cdk8sImports = options.cdk8sImports ?? [];
        const k8sSpec = options.k8sSpecVersion
            ? `k8s@${options.k8sSpecVersion}`
            : "k8s";
        const appEntrypointBaseName = path.basename(this.appEntrypoint, ".ts");
        new yaml_1.YamlFile(this, "cdk8s.yaml", {
            committed: true,
            editGitignore: true,
            obj: {
                language: "typescript",
                app: `node lib/${appEntrypointBaseName}.js`,
                imports: [k8sSpec, ...cdk8sImports],
            },
        });
        if (options.sampleCode ?? true) {
            new SampleCode(this);
        }
        new auto_discover_1.AutoDiscover(this, {
            testdir: this.testdir,
            tsconfigPath: this.tsconfigDev.fileName,
            integrationTestAutoDiscover: options.integrationTestAutoDiscover ?? true,
        });
    }
}
exports.Cdk8sTypeScriptApp = Cdk8sTypeScriptApp;
_a = JSII_RTTI_SYMBOL_1;
Cdk8sTypeScriptApp[_a] = { fqn: "projen.cdk8s.Cdk8sTypeScriptApp", version: "0.67.87" };
class SampleCode extends component_1.Component {
    constructor(project) {
        super(project);
        this.appProject = project;
    }
    synthesize() {
        const outdir = this.project.outdir;
        const srcdir = path.join(outdir, this.appProject.srcdir);
        if (fs.pathExistsSync(srcdir) &&
            fs.readdirSync(srcdir).filter((x) => x.endsWith(".ts"))) {
            return;
        }
        const srcCode = `import { Construct } from 'constructs';
import { App, Chart, ChartProps, ApiObject } from 'cdk8s';

export class MyChart extends Chart {
  constructor(scope: Construct, id: string, props: ChartProps = { }) {
    super(scope, id, props);

    const label = { app: 'hello-k8s' };



    new ApiObject(this, 'deployment', {
      apiVersion: "v1",
      kind: "Pod",
      metadata: {
          namespace: "frontend",
          name: "nginx",
          labels: label,
      },
      spec: {
          containers: [{
              name: "nginx",
              image: "nginx:1.14-alpine",
              resources: {
                  limits: {
                      memory: "20Mi",
                      cpu: 0.2,
                  },
              },
          }],
      },
    });
  }
}

const app = new App();
new MyChart(app, 'hello');
app.synth();`;
        fs.mkdirpSync(srcdir);
        fs.writeFileSync(path.join(srcdir, this.appProject.appEntrypoint), srcCode);
    }
}
//# sourceMappingURL=data:application/json;base64,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