import * as log4js from 'log4js';
import * as ts from 'typescript';
/**
 * Name of the logger for diagnostics information
 */
export declare const DIAGNOSTICS = "diagnostics";
/**
 * Diagnostic code for JSII-generated messages.
 */
export declare const JSII_DIAGNOSTICS_CODE = 9999;
/**
 * Obtains the relevant logger to be used for a given diagnostic message.
 *
 * @param logger     the ``log4js.Logger`` to use for emitting the message.
 * @param diagnostic the message for which a logger is requested.
 *
 * @returns a logger method of the ``logger`` for the appropriate level.
 */
export declare function diagnosticsLogger(logger: log4js.Logger, diagnostic: ts.Diagnostic): ((message: any, ...args: any[]) => void) | undefined;
/**
 * Formats a diagnostic message with color and context, if possible.
 *
 * @param diagnostic  the diagnostic message ot be formatted.
 * @param projectRoot the root of the TypeScript project.
 *
 * @returns a formatted string.
 */
export declare function formatDiagnostic(diagnostic: ts.Diagnostic, projectRoot: string): string;
/**
 * Formats a diagnostic message with color and context, if possible. Users
 * should use `formatDiagnostic` instead, as this implementation is intended for
 * internal usafe only.
 *
 * @param diagnostic  the diagnostic message ot be formatted.
 * @param projectRoot the root of the TypeScript project.
 *
 * @returns a formatted string.
 */
export declare function _formatDiagnostic(diagnostic: ts.Diagnostic, projectRoot: string): string;
export declare function logDiagnostic(diagnostic: ts.Diagnostic, projectRoot: string): void;
/**
 * Parses a string-formatted person entry from `package.json`.
 * @param value the string-formatted person entry.
 *
 * @example
 *  parsePerson("Barney Rubble <b@rubble.com> (http://barnyrubble.tumblr.com/)");
 *  // => { name: "Barney Rubble", email: "b@rubble.com", url: "http://barnyrubble.tumblr.com/" }
 */
export declare function parsePerson(value: string): {
    name: string;
    email?: string | undefined;
    url?: string | undefined;
};
export declare function parseRepository(value: string): {
    url: string;
};
/**
 * Find the directory that contains a given dependency, identified by its 'package.json', from a starting search directory
 *
 * (This code is duplicated among jsii/jsii-pacmak/jsii-reflect. Changes should be done in all
 * 3 locations, and we should unify these at some point: https://github.com/aws/jsii/issues/3236)
 */
export declare function findDependencyDirectory(dependencyName: string, searchStart: string): string;
/**
 * Find the package.json for a given package upwards from the given directory
 *
 * (This code is duplicated among jsii/jsii-pacmak/jsii-reflect. Changes should be done in all
 * 3 locations, and we should unify these at some point: https://github.com/aws/jsii/issues/3236)
 */
export declare function findPackageJsonUp(packageName: string, directory: string): string | undefined;
/**
 * Find a directory up the tree from a starting directory matching a condition
 *
 * Will return `undefined` if no directory matches
 *
 * (This code is duplicated among jsii/jsii-pacmak/jsii-reflect. Changes should be done in all
 * 3 locations, and we should unify these at some point: https://github.com/aws/jsii/issues/3236)
 */
export declare function findUp(directory: string, pred: (dir: string) => boolean): string | undefined;
export declare function stripAnsi(x: string): string;
//# sourceMappingURL=utils.d.ts.map