"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderSummary = exports.stabilityPrefixFor = void 0;
const spec = require("@jsii/spec");
function stabilityPrefixFor(element) {
    if (element.docs?.stability === spec.Stability.Experimental) {
        return '(experimental) ';
    }
    if (element.docs?.stability === spec.Stability.Deprecated) {
        return '(deprecated) ';
    }
    return '';
}
exports.stabilityPrefixFor = stabilityPrefixFor;
function renderSummary(docs) {
    return docs?.summary ? stabilityPrefixFor({ docs }) + docs.summary : '';
}
exports.renderSummary = renderSummary;
//# sourceMappingURL=_utils.js.map