import { Mismatches } from './types';
export declare enum DiagLevel {
    Error = 0,
    Warning = 1,
    Skipped = 2
}
export interface Diagnostic {
    level: DiagLevel;
    message: string;
    suppressionKey: string;
}
export declare function formatDiagnostic(diag: Diagnostic, includeSuppressionKey?: boolean): string;
export declare function hasErrors(diags: Diagnostic[]): boolean;
/**
 * Classify API mismatches into a set of warnings and errors
 */
export declare function classifyDiagnostics(mismatches: Mismatches, experimentalErrors: boolean, skipFilter: Set<string>): Diagnostic[];
//# sourceMappingURL=diagnostics.d.ts.map