"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.loadBalancerNameFromListenerArn=exports.TargetGroupBase=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cdk=require("../../../core"),constructs_1=require("constructs"),enums_1=require("./enums"),util_1=require("./util"),elasticloadbalancingv2_generated_1=require("../elasticloadbalancingv2.generated");class TargetGroupBase extends constructs_1.Construct{constructor(scope,id,baseProps,additionalProps){super(scope,id),this.loadBalancerAttachedDependencies=new constructs_1.DependencyGroup,this.attributes={},this.targetsJson=new Array;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_BaseTargetGroupProps(baseProps)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,TargetGroupBase),error}baseProps.deregistrationDelay!==void 0&&this.setAttribute("deregistration_delay.timeout_seconds",baseProps.deregistrationDelay.toSeconds().toString()),this.healthCheck=baseProps.healthCheck||{},this.vpc=baseProps.vpc,this.targetType=baseProps.targetType,this.resource=new elasticloadbalancingv2_generated_1.CfnTargetGroup(this,"Resource",{name:baseProps.targetGroupName,targetGroupAttributes:cdk.Lazy.any({produce:()=>util_1.renderAttributes(this.attributes)},{omitEmptyArray:!0}),targetType:cdk.Lazy.string({produce:()=>this.targetType}),targets:cdk.Lazy.any({produce:()=>this.targetsJson},{omitEmptyArray:!0}),vpcId:cdk.Lazy.string({produce:()=>this.vpc&&this.targetType!==enums_1.TargetType.LAMBDA?this.vpc.vpcId:void 0}),healthCheckEnabled:cdk.Lazy.any({produce:()=>this.healthCheck?.enabled}),healthCheckIntervalSeconds:cdk.Lazy.number({produce:()=>this.healthCheck?.interval?.toSeconds()}),healthCheckPath:cdk.Lazy.string({produce:()=>this.healthCheck?.path}),healthCheckPort:cdk.Lazy.string({produce:()=>this.healthCheck?.port}),healthCheckProtocol:cdk.Lazy.string({produce:()=>this.healthCheck?.protocol}),healthCheckTimeoutSeconds:cdk.Lazy.number({produce:()=>this.healthCheck?.timeout?.toSeconds()}),healthyThresholdCount:cdk.Lazy.number({produce:()=>this.healthCheck?.healthyThresholdCount}),unhealthyThresholdCount:cdk.Lazy.number({produce:()=>this.healthCheck?.unhealthyThresholdCount}),matcher:cdk.Lazy.any({produce:()=>this.healthCheck?.healthyHttpCodes!==void 0||this.healthCheck?.healthyGrpcCodes!==void 0?{grpcCode:this.healthCheck.healthyGrpcCodes,httpCode:this.healthCheck.healthyHttpCodes}:void 0}),...additionalProps}),this.targetGroupLoadBalancerArns=this.resource.attrLoadBalancerArns,this.targetGroupArn=this.resource.ref,this.targetGroupFullName=this.resource.attrTargetGroupFullName,this.loadBalancerArns=this.resource.attrLoadBalancerArns.toString(),this.targetGroupName=this.resource.attrTargetGroupName,this.defaultPort=additionalProps.port,this.node.addValidation({validate:()=>this.validateTargetGroup()})}get loadBalancerAttached(){return this.loadBalancerAttachedDependencies}configureHealthCheck(healthCheck){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_HealthCheck(healthCheck)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.configureHealthCheck),error}this.healthCheck=healthCheck}setAttribute(key,value){this.attributes[key]=value}addLoadBalancerTarget(props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_LoadBalancerTargetProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addLoadBalancerTarget),error}if(this.targetType!==void 0&&this.targetType!==props.targetType)throw new Error(`Already have a of type '${this.targetType}', adding '${props.targetType}'; make all targets the same type.`);if(this.targetType=props.targetType,this.targetType===enums_1.TargetType.LAMBDA&&this.targetsJson.length>=1)throw new Error("TargetGroup can only contain one LAMBDA target. Create a new TargetGroup.");props.targetJson&&this.targetsJson.push(props.targetJson)}validateTargetGroup(){const ret=new Array;this.targetType===void 0&&this.targetsJson.length===0&&cdk.Annotations.of(this).addWarning("When creating an empty TargetGroup, you should specify a 'targetType' (this warning may become an error in the future)."),this.targetType!==enums_1.TargetType.LAMBDA&&this.vpc===void 0&&ret.push("'vpc' is required for a non-Lambda TargetGroup");const targetGroupName=this.resource.name;return!cdk.Token.isUnresolved(targetGroupName)&&targetGroupName!==void 0&&(targetGroupName.length>32&&ret.push(`Target group name: "${targetGroupName}" can have a maximum of 32 characters.`),(targetGroupName.startsWith("-")||targetGroupName.endsWith("-"))&&ret.push(`Target group name: "${targetGroupName}" must not begin or end with a hyphen.`),/^[0-9a-z-]+$/i.test(targetGroupName)||ret.push(`Target group name: "${targetGroupName}" must contain only alphanumeric characters or hyphens.`)),ret}}exports.TargetGroupBase=TargetGroupBase,_a=JSII_RTTI_SYMBOL_1,TargetGroupBase[_a]={fqn:"aws-cdk-lib.aws_elasticloadbalancingv2.TargetGroupBase",version:"2.69.0"};function loadBalancerNameFromListenerArn(listenerArn){const arnParts=cdk.Fn.split("/",listenerArn);return`${cdk.Fn.select(1,arnParts)}/${cdk.Fn.select(2,arnParts)}/${cdk.Fn.select(3,arnParts)}`}exports.loadBalancerNameFromListenerArn=loadBalancerNameFromListenerArn;
