"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.BaseLoadBalancer=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),ec2=require("../../../aws-ec2"),iam=require("../../../aws-iam"),aws_iam_1=require("../../../aws-iam"),cxschema=require("../../../cloud-assembly-schema"),core_1=require("../../../core"),cxapi=require("../../../cx-api"),region_info_1=require("../../../region-info"),util_1=require("./util"),elasticloadbalancingv2_generated_1=require("../elasticloadbalancingv2.generated");class BaseLoadBalancer extends core_1.Resource{constructor(scope,id,baseProps,additionalProps){super(scope,id,{physicalName:baseProps.loadBalancerName}),this.attributes={};try{jsiiDeprecationWarnings.aws_cdk_lib_aws_elasticloadbalancingv2_BaseLoadBalancerProps(baseProps)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,BaseLoadBalancer),error}const internetFacing=util_1.ifUndefined(baseProps.internetFacing,!1),vpcSubnets=util_1.ifUndefined(baseProps.vpcSubnets,internetFacing?{subnetType:ec2.SubnetType.PUBLIC}:{}),{subnetIds,internetConnectivityEstablished}=baseProps.vpc.selectSubnets(vpcSubnets);this.vpc=baseProps.vpc;const resource=new elasticloadbalancingv2_generated_1.CfnLoadBalancer(this,"Resource",{name:this.physicalName,subnets:subnetIds,scheme:internetFacing?"internet-facing":"internal",loadBalancerAttributes:core_1.Lazy.any({produce:()=>util_1.renderAttributes(this.attributes)},{omitEmptyArray:!0}),...additionalProps});internetFacing&&resource.node.addDependency(internetConnectivityEstablished),this.setAttribute("deletion_protection.enabled",baseProps.deletionProtection?"true":"false"),this.loadBalancerCanonicalHostedZoneId=resource.attrCanonicalHostedZoneId,this.loadBalancerDnsName=resource.attrDnsName,this.loadBalancerFullName=resource.attrLoadBalancerFullName,this.loadBalancerName=resource.attrLoadBalancerName,this.loadBalancerArn=resource.ref,this.loadBalancerSecurityGroups=resource.attrSecurityGroups,this.node.addValidation({validate:this.validateLoadBalancer.bind(this)})}static _queryContextProvider(scope,options){if(core_1.Token.isUnresolved(options.userOptions.loadBalancerArn)||Object.values(options.userOptions.loadBalancerTags??{}).some(core_1.Token.isUnresolved))throw new Error("All arguments to look up a load balancer must be concrete (no Tokens)");let cxschemaTags;return options.userOptions.loadBalancerTags&&(cxschemaTags=util_1.mapTagMapToCxschema(options.userOptions.loadBalancerTags)),core_1.ContextProvider.getValue(scope,{provider:cxschema.ContextProvider.LOAD_BALANCER_PROVIDER,props:{loadBalancerArn:options.userOptions.loadBalancerArn,loadBalancerTags:cxschemaTags,loadBalancerType:options.loadBalancerType},dummyValue:{ipAddressType:cxapi.LoadBalancerIpAddressType.DUAL_STACK,loadBalancerArn:`arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/${options.loadBalancerType}/my-load-balancer/50dc6c495c0c9188`,loadBalancerCanonicalHostedZoneId:"Z3DZXE0EXAMPLE",loadBalancerDnsName:"my-load-balancer-1234567890.us-west-2.elb.amazonaws.com",securityGroupIds:["sg-1234"],vpcId:"vpc-12345"}}).value}logAccessLogs(bucket,prefix){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_s3_IBucket(bucket)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.logAccessLogs),error}prefix=prefix||"",this.setAttribute("access_logs.s3.enabled","true"),this.setAttribute("access_logs.s3.bucket",bucket.bucketName.toString()),this.setAttribute("access_logs.s3.prefix",prefix);const logsDeliveryServicePrincipal=new aws_iam_1.ServicePrincipal("delivery.logs.amazonaws.com");bucket.grantPut(this.resourcePolicyPrincipal(),`${prefix?prefix+"/":""}AWSLogs/${core_1.Stack.of(this).account}/*`),bucket.addToResourcePolicy(new aws_iam_1.PolicyStatement({actions:["s3:PutObject"],principals:[logsDeliveryServicePrincipal],resources:[bucket.arnForObjects(`${prefix?prefix+"/":""}AWSLogs/${this.env.account}/*`)],conditions:{StringEquals:{"s3:x-amz-acl":"bucket-owner-full-control"}}})),bucket.addToResourcePolicy(new aws_iam_1.PolicyStatement({actions:["s3:GetBucketAcl"],principals:[logsDeliveryServicePrincipal],resources:[bucket.bucketArn]})),this.node.addDependency(bucket)}setAttribute(key,value){this.attributes[key]=value}removeAttribute(key){this.setAttribute(key,void 0)}resourcePolicyPrincipal(){const region=core_1.Stack.of(this).region;if(core_1.Token.isUnresolved(region))throw new Error("Region is required to enable ELBv2 access logging");const account=region_info_1.RegionInfo.get(region).elbv2Account;return account?new iam.AccountPrincipal(account):new iam.ServicePrincipal("logdelivery.elasticloadbalancing.amazonaws.com")}validateLoadBalancer(){const ret=new Array,loadBalancerName=this.physicalName;return!core_1.Token.isUnresolved(loadBalancerName)&&loadBalancerName!==void 0&&(loadBalancerName.length>32&&ret.push(`Load balancer name: "${loadBalancerName}" can have a maximum of 32 characters.`),loadBalancerName.startsWith("internal-")&&ret.push(`Load balancer name: "${loadBalancerName}" must not begin with "internal-".`),(loadBalancerName.startsWith("-")||loadBalancerName.endsWith("-"))&&ret.push(`Load balancer name: "${loadBalancerName}" must not begin or end with a hyphen.`),/^[0-9a-z-]+$/i.test(loadBalancerName)||ret.push(`Load balancer name: "${loadBalancerName}" must contain only alphanumeric characters or hyphens.`)),ret}}exports.BaseLoadBalancer=BaseLoadBalancer,_a=JSII_RTTI_SYMBOL_1,BaseLoadBalancer[_a]={fqn:"aws-cdk-lib.aws_elasticloadbalancingv2.BaseLoadBalancer",version:"2.69.0"};
