"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.clusterArnComponents=exports.ClusterResource=void 0;const iam=require("../../aws-iam"),core_1=require("../../core"),constructs_1=require("constructs"),consts_1=require("./cluster-resource-handler/consts"),cluster_resource_provider_1=require("./cluster-resource-provider");class ClusterResource extends constructs_1.Construct{constructor(scope,id,props){if(super(scope,id),!props.roleArn)throw new Error('"roleArn" is required');this.adminRole=this.createAdminRole(props);const provider=cluster_resource_provider_1.ClusterResourceProvider.getOrCreate(this,{adminRole:this.adminRole,subnets:props.subnets,vpc:props.vpc,environment:props.environment,onEventLayer:props.onEventLayer,securityGroup:props.clusterHandlerSecurityGroup}),resource=new core_1.CustomResource(this,"Resource",{resourceType:consts_1.CLUSTER_RESOURCE_TYPE,serviceToken:provider.serviceToken,properties:{Config:{name:props.name,version:props.version,roleArn:props.roleArn,encryptionConfig:props.encryptionConfig,kubernetesNetworkConfig:props.kubernetesNetworkConfig,resourcesVpcConfig:{subnetIds:props.resourcesVpcConfig.subnetIds,securityGroupIds:props.resourcesVpcConfig.securityGroupIds,endpointPublicAccess:props.endpointPublicAccess,endpointPrivateAccess:props.endpointPrivateAccess,publicAccessCidrs:props.publicAccessCidrs},tags:props.tags,logging:props.logging},AssumeRoleArn:this.adminRole.roleArn,AttributesRevision:2}});resource.node.addDependency(this.adminRole),this.ref=resource.ref,this.attrEndpoint=core_1.Token.asString(resource.getAtt("Endpoint")),this.attrArn=core_1.Token.asString(resource.getAtt("Arn")),this.attrCertificateAuthorityData=core_1.Token.asString(resource.getAtt("CertificateAuthorityData")),this.attrClusterSecurityGroupId=core_1.Token.asString(resource.getAtt("ClusterSecurityGroupId")),this.attrEncryptionConfigKeyArn=core_1.Token.asString(resource.getAtt("EncryptionConfigKeyArn")),this.attrOpenIdConnectIssuerUrl=core_1.Token.asString(resource.getAtt("OpenIdConnectIssuerUrl")),this.attrOpenIdConnectIssuer=core_1.Token.asString(resource.getAtt("OpenIdConnectIssuer"))}createAdminRole(props){const stack=core_1.Stack.of(this),creationRole=new iam.Role(this,"CreationRole",{assumedBy:new iam.AccountRootPrincipal});creationRole.addToPolicy(new iam.PolicyStatement({actions:["iam:PassRole"],resources:[props.roleArn]}));const resourceArns=core_1.Lazy.list({produce:()=>{const arn=stack.formatArn(clusterArnComponents(stack.resolve(props.name)));return stack.resolve(props.name)?[arn,`${arn}/*`]:["*"]}}),fargateProfileResourceArn=core_1.Lazy.string({produce:()=>stack.resolve(props.name)?stack.formatArn({service:"eks",resource:"fargateprofile",resourceName:stack.resolve(props.name)+"/*"}):"*"});return creationRole.addToPolicy(new iam.PolicyStatement({actions:["eks:CreateCluster","eks:DescribeCluster","eks:DescribeUpdate","eks:DeleteCluster","eks:UpdateClusterVersion","eks:UpdateClusterConfig","eks:CreateFargateProfile","eks:TagResource","eks:UntagResource"],resources:resourceArns})),creationRole.addToPolicy(new iam.PolicyStatement({actions:["eks:DescribeFargateProfile","eks:DeleteFargateProfile"],resources:[fargateProfileResourceArn]})),creationRole.addToPolicy(new iam.PolicyStatement({actions:["iam:GetRole","iam:listAttachedRolePolicies"],resources:["*"]})),creationRole.addToPolicy(new iam.PolicyStatement({actions:["iam:CreateServiceLinkedRole"],resources:["*"]})),creationRole.addToPolicy(new iam.PolicyStatement({actions:["ec2:DescribeInstances","ec2:DescribeNetworkInterfaces","ec2:DescribeSecurityGroups","ec2:DescribeSubnets","ec2:DescribeRouteTables","ec2:DescribeDhcpOptions","ec2:DescribeVpcs"],resources:["*"]})),props.secretsEncryptionKey&&creationRole.addToPolicy(new iam.PolicyStatement({actions:["kms:Encrypt","kms:Decrypt","kms:DescribeKey","kms:CreateGrant"],resources:[props.secretsEncryptionKey.keyArn]})),creationRole}}exports.ClusterResource=ClusterResource;function clusterArnComponents(clusterName){return{service:"eks",resource:"cluster",resourceName:clusterName}}exports.clusterArnComponents=clusterArnComponents;
