"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CfnRepository=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cdk=require("../../core"),cfn_parse=require("../../core/lib/helpers-internal");function CfnRepositoryPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("code",CfnRepository_CodePropertyValidator)(properties.code)),errors.collect(cdk.propertyValidator("repositoryDescription",cdk.validateString)(properties.repositoryDescription)),errors.collect(cdk.propertyValidator("repositoryName",cdk.requiredValidator)(properties.repositoryName)),errors.collect(cdk.propertyValidator("repositoryName",cdk.validateString)(properties.repositoryName)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.collect(cdk.propertyValidator("triggers",cdk.listValidator(CfnRepository_RepositoryTriggerPropertyValidator))(properties.triggers)),errors.wrap('supplied properties not correct for "CfnRepositoryProps"')}function cfnRepositoryPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnRepositoryPropsValidator(properties).assertSuccess(),{RepositoryName:cdk.stringToCloudFormation(properties.repositoryName),Code:cfnRepositoryCodePropertyToCloudFormation(properties.code),RepositoryDescription:cdk.stringToCloudFormation(properties.repositoryDescription),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),Triggers:cdk.listMapper(cfnRepositoryRepositoryTriggerPropertyToCloudFormation)(properties.triggers)}):properties}function CfnRepositoryPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("repositoryName","RepositoryName",cfn_parse.FromCloudFormation.getString(properties.RepositoryName)),ret.addPropertyResult("code","Code",properties.Code!=null?CfnRepositoryCodePropertyFromCloudFormation(properties.Code):void 0),ret.addPropertyResult("repositoryDescription","RepositoryDescription",properties.RepositoryDescription!=null?cfn_parse.FromCloudFormation.getString(properties.RepositoryDescription):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addPropertyResult("triggers","Triggers",properties.Triggers!=null?cfn_parse.FromCloudFormation.getArray(CfnRepositoryRepositoryTriggerPropertyFromCloudFormation)(properties.Triggers):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnRepository extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnRepository.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codecommit_CfnRepositoryProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnRepository),error}cdk.requireProperty(props,"repositoryName",this),this.attrArn=cdk.Token.asString(this.getAtt("Arn",cdk.ResolutionTypeHint.STRING)),this.attrCloneUrlHttp=cdk.Token.asString(this.getAtt("CloneUrlHttp",cdk.ResolutionTypeHint.STRING)),this.attrCloneUrlSsh=cdk.Token.asString(this.getAtt("CloneUrlSsh",cdk.ResolutionTypeHint.STRING)),this.attrName=cdk.Token.asString(this.getAtt("Name",cdk.ResolutionTypeHint.STRING)),this.repositoryName=props.repositoryName,this.code=props.code,this.repositoryDescription=props.repositoryDescription,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::CodeCommit::Repository",props.tags,{tagPropertyName:"tags"}),this.triggers=props.triggers}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnRepositoryPropsFromCloudFormation(resourceProperties),ret=new CfnRepository(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnRepository.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{repositoryName:this.repositoryName,code:this.code,repositoryDescription:this.repositoryDescription,tags:this.tags.renderTags(),triggers:this.triggers}}renderProperties(props){return cfnRepositoryPropsToCloudFormation(props)}}exports.CfnRepository=CfnRepository,_a=JSII_RTTI_SYMBOL_1,CfnRepository[_a]={fqn:"aws-cdk-lib.aws_codecommit.CfnRepository",version:"2.69.0"},CfnRepository.CFN_RESOURCE_TYPE_NAME="AWS::CodeCommit::Repository";function CfnRepository_CodePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("branchName",cdk.validateString)(properties.branchName)),errors.collect(cdk.propertyValidator("s3",cdk.requiredValidator)(properties.s3)),errors.collect(cdk.propertyValidator("s3",CfnRepository_S3PropertyValidator)(properties.s3)),errors.wrap('supplied properties not correct for "CodeProperty"')}function cfnRepositoryCodePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnRepository_CodePropertyValidator(properties).assertSuccess(),{BranchName:cdk.stringToCloudFormation(properties.branchName),S3:cfnRepositoryS3PropertyToCloudFormation(properties.s3)}):properties}function CfnRepositoryCodePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("branchName","BranchName",properties.BranchName!=null?cfn_parse.FromCloudFormation.getString(properties.BranchName):void 0),ret.addPropertyResult("s3","S3",CfnRepositoryS3PropertyFromCloudFormation(properties.S3)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnRepository_RepositoryTriggerPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("branches",cdk.listValidator(cdk.validateString))(properties.branches)),errors.collect(cdk.propertyValidator("customData",cdk.validateString)(properties.customData)),errors.collect(cdk.propertyValidator("destinationArn",cdk.requiredValidator)(properties.destinationArn)),errors.collect(cdk.propertyValidator("destinationArn",cdk.validateString)(properties.destinationArn)),errors.collect(cdk.propertyValidator("events",cdk.requiredValidator)(properties.events)),errors.collect(cdk.propertyValidator("events",cdk.listValidator(cdk.validateString))(properties.events)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.wrap('supplied properties not correct for "RepositoryTriggerProperty"')}function cfnRepositoryRepositoryTriggerPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnRepository_RepositoryTriggerPropertyValidator(properties).assertSuccess(),{Branches:cdk.listMapper(cdk.stringToCloudFormation)(properties.branches),CustomData:cdk.stringToCloudFormation(properties.customData),DestinationArn:cdk.stringToCloudFormation(properties.destinationArn),Events:cdk.listMapper(cdk.stringToCloudFormation)(properties.events),Name:cdk.stringToCloudFormation(properties.name)}):properties}function CfnRepositoryRepositoryTriggerPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("branches","Branches",properties.Branches!=null?cfn_parse.FromCloudFormation.getStringArray(properties.Branches):void 0),ret.addPropertyResult("customData","CustomData",properties.CustomData!=null?cfn_parse.FromCloudFormation.getString(properties.CustomData):void 0),ret.addPropertyResult("destinationArn","DestinationArn",cfn_parse.FromCloudFormation.getString(properties.DestinationArn)),ret.addPropertyResult("events","Events",cfn_parse.FromCloudFormation.getStringArray(properties.Events)),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnRepository_S3PropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("bucket",cdk.requiredValidator)(properties.bucket)),errors.collect(cdk.propertyValidator("bucket",cdk.validateString)(properties.bucket)),errors.collect(cdk.propertyValidator("key",cdk.requiredValidator)(properties.key)),errors.collect(cdk.propertyValidator("key",cdk.validateString)(properties.key)),errors.collect(cdk.propertyValidator("objectVersion",cdk.validateString)(properties.objectVersion)),errors.wrap('supplied properties not correct for "S3Property"')}function cfnRepositoryS3PropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnRepository_S3PropertyValidator(properties).assertSuccess(),{Bucket:cdk.stringToCloudFormation(properties.bucket),Key:cdk.stringToCloudFormation(properties.key),ObjectVersion:cdk.stringToCloudFormation(properties.objectVersion)}):properties}function CfnRepositoryS3PropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("bucket","Bucket",cfn_parse.FromCloudFormation.getString(properties.Bucket)),ret.addPropertyResult("key","Key",cfn_parse.FromCloudFormation.getString(properties.Key)),ret.addPropertyResult("objectVersion","ObjectVersion",properties.ObjectVersion!=null?cfn_parse.FromCloudFormation.getString(properties.ObjectVersion):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}
