"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CfnRepository=exports.CfnDomain=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cdk=require("../../core"),cfn_parse=require("../../core/lib/helpers-internal");function CfnDomainPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("domainName",cdk.requiredValidator)(properties.domainName)),errors.collect(cdk.propertyValidator("domainName",cdk.validateString)(properties.domainName)),errors.collect(cdk.propertyValidator("encryptionKey",cdk.validateString)(properties.encryptionKey)),errors.collect(cdk.propertyValidator("permissionsPolicyDocument",cdk.validateObject)(properties.permissionsPolicyDocument)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.wrap('supplied properties not correct for "CfnDomainProps"')}function cfnDomainPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomainPropsValidator(properties).assertSuccess(),{DomainName:cdk.stringToCloudFormation(properties.domainName),EncryptionKey:cdk.stringToCloudFormation(properties.encryptionKey),PermissionsPolicyDocument:cdk.objectToCloudFormation(properties.permissionsPolicyDocument),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnDomainPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("domainName","DomainName",cfn_parse.FromCloudFormation.getString(properties.DomainName)),ret.addPropertyResult("encryptionKey","EncryptionKey",properties.EncryptionKey!=null?cfn_parse.FromCloudFormation.getString(properties.EncryptionKey):void 0),ret.addPropertyResult("permissionsPolicyDocument","PermissionsPolicyDocument",properties.PermissionsPolicyDocument!=null?cfn_parse.FromCloudFormation.getAny(properties.PermissionsPolicyDocument):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnDomain extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnDomain.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codeartifact_CfnDomainProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnDomain),error}cdk.requireProperty(props,"domainName",this),this.attrArn=cdk.Token.asString(this.getAtt("Arn",cdk.ResolutionTypeHint.STRING)),this.attrEncryptionKey=cdk.Token.asString(this.getAtt("EncryptionKey",cdk.ResolutionTypeHint.STRING)),this.attrName=cdk.Token.asString(this.getAtt("Name",cdk.ResolutionTypeHint.STRING)),this.attrOwner=cdk.Token.asString(this.getAtt("Owner",cdk.ResolutionTypeHint.STRING)),this.domainName=props.domainName,this.encryptionKey=props.encryptionKey,this.permissionsPolicyDocument=props.permissionsPolicyDocument,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::CodeArtifact::Domain",props.tags,{tagPropertyName:"tags"})}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnDomainPropsFromCloudFormation(resourceProperties),ret=new CfnDomain(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnDomain.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{domainName:this.domainName,encryptionKey:this.encryptionKey,permissionsPolicyDocument:this.permissionsPolicyDocument,tags:this.tags.renderTags()}}renderProperties(props){return cfnDomainPropsToCloudFormation(props)}}exports.CfnDomain=CfnDomain,_a=JSII_RTTI_SYMBOL_1,CfnDomain[_a]={fqn:"aws-cdk-lib.aws_codeartifact.CfnDomain",version:"2.69.0"},CfnDomain.CFN_RESOURCE_TYPE_NAME="AWS::CodeArtifact::Domain";function CfnRepositoryPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("description",cdk.validateString)(properties.description)),errors.collect(cdk.propertyValidator("domainName",cdk.requiredValidator)(properties.domainName)),errors.collect(cdk.propertyValidator("domainName",cdk.validateString)(properties.domainName)),errors.collect(cdk.propertyValidator("domainOwner",cdk.validateString)(properties.domainOwner)),errors.collect(cdk.propertyValidator("externalConnections",cdk.listValidator(cdk.validateString))(properties.externalConnections)),errors.collect(cdk.propertyValidator("permissionsPolicyDocument",cdk.validateObject)(properties.permissionsPolicyDocument)),errors.collect(cdk.propertyValidator("repositoryName",cdk.requiredValidator)(properties.repositoryName)),errors.collect(cdk.propertyValidator("repositoryName",cdk.validateString)(properties.repositoryName)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.collect(cdk.propertyValidator("upstreams",cdk.listValidator(cdk.validateString))(properties.upstreams)),errors.wrap('supplied properties not correct for "CfnRepositoryProps"')}function cfnRepositoryPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnRepositoryPropsValidator(properties).assertSuccess(),{DomainName:cdk.stringToCloudFormation(properties.domainName),RepositoryName:cdk.stringToCloudFormation(properties.repositoryName),Description:cdk.stringToCloudFormation(properties.description),DomainOwner:cdk.stringToCloudFormation(properties.domainOwner),ExternalConnections:cdk.listMapper(cdk.stringToCloudFormation)(properties.externalConnections),PermissionsPolicyDocument:cdk.objectToCloudFormation(properties.permissionsPolicyDocument),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),Upstreams:cdk.listMapper(cdk.stringToCloudFormation)(properties.upstreams)}):properties}function CfnRepositoryPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("domainName","DomainName",cfn_parse.FromCloudFormation.getString(properties.DomainName)),ret.addPropertyResult("repositoryName","RepositoryName",cfn_parse.FromCloudFormation.getString(properties.RepositoryName)),ret.addPropertyResult("description","Description",properties.Description!=null?cfn_parse.FromCloudFormation.getString(properties.Description):void 0),ret.addPropertyResult("domainOwner","DomainOwner",properties.DomainOwner!=null?cfn_parse.FromCloudFormation.getString(properties.DomainOwner):void 0),ret.addPropertyResult("externalConnections","ExternalConnections",properties.ExternalConnections!=null?cfn_parse.FromCloudFormation.getStringArray(properties.ExternalConnections):void 0),ret.addPropertyResult("permissionsPolicyDocument","PermissionsPolicyDocument",properties.PermissionsPolicyDocument!=null?cfn_parse.FromCloudFormation.getAny(properties.PermissionsPolicyDocument):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addPropertyResult("upstreams","Upstreams",properties.Upstreams!=null?cfn_parse.FromCloudFormation.getStringArray(properties.Upstreams):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnRepository extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnRepository.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_codeartifact_CfnRepositoryProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnRepository),error}cdk.requireProperty(props,"domainName",this),cdk.requireProperty(props,"repositoryName",this),this.attrArn=cdk.Token.asString(this.getAtt("Arn",cdk.ResolutionTypeHint.STRING)),this.attrDomainName=cdk.Token.asString(this.getAtt("DomainName",cdk.ResolutionTypeHint.STRING)),this.attrDomainOwner=cdk.Token.asString(this.getAtt("DomainOwner",cdk.ResolutionTypeHint.STRING)),this.attrName=cdk.Token.asString(this.getAtt("Name",cdk.ResolutionTypeHint.STRING)),this.domainName=props.domainName,this.repositoryName=props.repositoryName,this.description=props.description,this.domainOwner=props.domainOwner,this.externalConnections=props.externalConnections,this.permissionsPolicyDocument=props.permissionsPolicyDocument,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::CodeArtifact::Repository",props.tags,{tagPropertyName:"tags"}),this.upstreams=props.upstreams}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnRepositoryPropsFromCloudFormation(resourceProperties),ret=new CfnRepository(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnRepository.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{domainName:this.domainName,repositoryName:this.repositoryName,description:this.description,domainOwner:this.domainOwner,externalConnections:this.externalConnections,permissionsPolicyDocument:this.permissionsPolicyDocument,tags:this.tags.renderTags(),upstreams:this.upstreams}}renderProperties(props){return cfnRepositoryPropsToCloudFormation(props)}}exports.CfnRepository=CfnRepository,_b=JSII_RTTI_SYMBOL_1,CfnRepository[_b]={fqn:"aws-cdk-lib.aws_codeartifact.CfnRepository",version:"2.69.0"},CfnRepository.CFN_RESOURCE_TYPE_NAME="AWS::CodeArtifact::Repository";
