"use strict";var _a,_b,_c,_d;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CfnPipeline=exports.CfnDatastore=exports.CfnDataset=exports.CfnChannel=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cdk=require("../../core"),cfn_parse=require("../../core/lib/helpers-internal");function CfnChannelPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("channelName",cdk.validateString)(properties.channelName)),errors.collect(cdk.propertyValidator("channelStorage",CfnChannel_ChannelStoragePropertyValidator)(properties.channelStorage)),errors.collect(cdk.propertyValidator("retentionPeriod",CfnChannel_RetentionPeriodPropertyValidator)(properties.retentionPeriod)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.wrap('supplied properties not correct for "CfnChannelProps"')}function cfnChannelPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnChannelPropsValidator(properties).assertSuccess(),{ChannelName:cdk.stringToCloudFormation(properties.channelName),ChannelStorage:cfnChannelChannelStoragePropertyToCloudFormation(properties.channelStorage),RetentionPeriod:cfnChannelRetentionPeriodPropertyToCloudFormation(properties.retentionPeriod),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnChannelPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("channelName","ChannelName",properties.ChannelName!=null?cfn_parse.FromCloudFormation.getString(properties.ChannelName):void 0),ret.addPropertyResult("channelStorage","ChannelStorage",properties.ChannelStorage!=null?CfnChannelChannelStoragePropertyFromCloudFormation(properties.ChannelStorage):void 0),ret.addPropertyResult("retentionPeriod","RetentionPeriod",properties.RetentionPeriod!=null?CfnChannelRetentionPeriodPropertyFromCloudFormation(properties.RetentionPeriod):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnChannel extends cdk.CfnResource{constructor(scope,id,props={}){super(scope,id,{type:CfnChannel.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iotanalytics_CfnChannelProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnChannel),error}this.attrId=cdk.Token.asString(this.getAtt("Id",cdk.ResolutionTypeHint.STRING)),this.channelName=props.channelName,this.channelStorage=props.channelStorage,this.retentionPeriod=props.retentionPeriod,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::IoTAnalytics::Channel",props.tags,{tagPropertyName:"tags"})}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnChannelPropsFromCloudFormation(resourceProperties),ret=new CfnChannel(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnChannel.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{channelName:this.channelName,channelStorage:this.channelStorage,retentionPeriod:this.retentionPeriod,tags:this.tags.renderTags()}}renderProperties(props){return cfnChannelPropsToCloudFormation(props)}}exports.CfnChannel=CfnChannel,_a=JSII_RTTI_SYMBOL_1,CfnChannel[_a]={fqn:"aws-cdk-lib.aws_iotanalytics.CfnChannel",version:"2.69.0"},CfnChannel.CFN_RESOURCE_TYPE_NAME="AWS::IoTAnalytics::Channel";function CfnChannel_ChannelStoragePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("customerManagedS3",CfnChannel_CustomerManagedS3PropertyValidator)(properties.customerManagedS3)),errors.collect(cdk.propertyValidator("serviceManagedS3",cdk.validateObject)(properties.serviceManagedS3)),errors.wrap('supplied properties not correct for "ChannelStorageProperty"')}function cfnChannelChannelStoragePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnChannel_ChannelStoragePropertyValidator(properties).assertSuccess(),{CustomerManagedS3:cfnChannelCustomerManagedS3PropertyToCloudFormation(properties.customerManagedS3),ServiceManagedS3:cdk.objectToCloudFormation(properties.serviceManagedS3)}):properties}function CfnChannelChannelStoragePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("customerManagedS3","CustomerManagedS3",properties.CustomerManagedS3!=null?CfnChannelCustomerManagedS3PropertyFromCloudFormation(properties.CustomerManagedS3):void 0),ret.addPropertyResult("serviceManagedS3","ServiceManagedS3",properties.ServiceManagedS3!=null?cfn_parse.FromCloudFormation.getAny(properties.ServiceManagedS3):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnChannel_CustomerManagedS3PropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("bucket",cdk.requiredValidator)(properties.bucket)),errors.collect(cdk.propertyValidator("bucket",cdk.validateString)(properties.bucket)),errors.collect(cdk.propertyValidator("keyPrefix",cdk.validateString)(properties.keyPrefix)),errors.collect(cdk.propertyValidator("roleArn",cdk.requiredValidator)(properties.roleArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.validateString)(properties.roleArn)),errors.wrap('supplied properties not correct for "CustomerManagedS3Property"')}function cfnChannelCustomerManagedS3PropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnChannel_CustomerManagedS3PropertyValidator(properties).assertSuccess(),{Bucket:cdk.stringToCloudFormation(properties.bucket),KeyPrefix:cdk.stringToCloudFormation(properties.keyPrefix),RoleArn:cdk.stringToCloudFormation(properties.roleArn)}):properties}function CfnChannelCustomerManagedS3PropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("bucket","Bucket",cfn_parse.FromCloudFormation.getString(properties.Bucket)),ret.addPropertyResult("keyPrefix","KeyPrefix",properties.KeyPrefix!=null?cfn_parse.FromCloudFormation.getString(properties.KeyPrefix):void 0),ret.addPropertyResult("roleArn","RoleArn",cfn_parse.FromCloudFormation.getString(properties.RoleArn)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnChannel_RetentionPeriodPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("numberOfDays",cdk.validateNumber)(properties.numberOfDays)),errors.collect(cdk.propertyValidator("unlimited",cdk.validateBoolean)(properties.unlimited)),errors.wrap('supplied properties not correct for "RetentionPeriodProperty"')}function cfnChannelRetentionPeriodPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnChannel_RetentionPeriodPropertyValidator(properties).assertSuccess(),{NumberOfDays:cdk.numberToCloudFormation(properties.numberOfDays),Unlimited:cdk.booleanToCloudFormation(properties.unlimited)}):properties}function CfnChannelRetentionPeriodPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("numberOfDays","NumberOfDays",properties.NumberOfDays!=null?cfn_parse.FromCloudFormation.getNumber(properties.NumberOfDays):void 0),ret.addPropertyResult("unlimited","Unlimited",properties.Unlimited!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Unlimited):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDatasetPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("actions",cdk.requiredValidator)(properties.actions)),errors.collect(cdk.propertyValidator("actions",cdk.listValidator(CfnDataset_ActionPropertyValidator))(properties.actions)),errors.collect(cdk.propertyValidator("contentDeliveryRules",cdk.listValidator(CfnDataset_DatasetContentDeliveryRulePropertyValidator))(properties.contentDeliveryRules)),errors.collect(cdk.propertyValidator("datasetName",cdk.validateString)(properties.datasetName)),errors.collect(cdk.propertyValidator("lateDataRules",cdk.listValidator(CfnDataset_LateDataRulePropertyValidator))(properties.lateDataRules)),errors.collect(cdk.propertyValidator("retentionPeriod",CfnDataset_RetentionPeriodPropertyValidator)(properties.retentionPeriod)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.collect(cdk.propertyValidator("triggers",cdk.listValidator(CfnDataset_TriggerPropertyValidator))(properties.triggers)),errors.collect(cdk.propertyValidator("versioningConfiguration",CfnDataset_VersioningConfigurationPropertyValidator)(properties.versioningConfiguration)),errors.wrap('supplied properties not correct for "CfnDatasetProps"')}function cfnDatasetPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDatasetPropsValidator(properties).assertSuccess(),{Actions:cdk.listMapper(cfnDatasetActionPropertyToCloudFormation)(properties.actions),ContentDeliveryRules:cdk.listMapper(cfnDatasetDatasetContentDeliveryRulePropertyToCloudFormation)(properties.contentDeliveryRules),DatasetName:cdk.stringToCloudFormation(properties.datasetName),LateDataRules:cdk.listMapper(cfnDatasetLateDataRulePropertyToCloudFormation)(properties.lateDataRules),RetentionPeriod:cfnDatasetRetentionPeriodPropertyToCloudFormation(properties.retentionPeriod),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),Triggers:cdk.listMapper(cfnDatasetTriggerPropertyToCloudFormation)(properties.triggers),VersioningConfiguration:cfnDatasetVersioningConfigurationPropertyToCloudFormation(properties.versioningConfiguration)}):properties}function CfnDatasetPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("actions","Actions",cfn_parse.FromCloudFormation.getArray(CfnDatasetActionPropertyFromCloudFormation)(properties.Actions)),ret.addPropertyResult("contentDeliveryRules","ContentDeliveryRules",properties.ContentDeliveryRules!=null?cfn_parse.FromCloudFormation.getArray(CfnDatasetDatasetContentDeliveryRulePropertyFromCloudFormation)(properties.ContentDeliveryRules):void 0),ret.addPropertyResult("datasetName","DatasetName",properties.DatasetName!=null?cfn_parse.FromCloudFormation.getString(properties.DatasetName):void 0),ret.addPropertyResult("lateDataRules","LateDataRules",properties.LateDataRules!=null?cfn_parse.FromCloudFormation.getArray(CfnDatasetLateDataRulePropertyFromCloudFormation)(properties.LateDataRules):void 0),ret.addPropertyResult("retentionPeriod","RetentionPeriod",properties.RetentionPeriod!=null?CfnDatasetRetentionPeriodPropertyFromCloudFormation(properties.RetentionPeriod):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addPropertyResult("triggers","Triggers",properties.Triggers!=null?cfn_parse.FromCloudFormation.getArray(CfnDatasetTriggerPropertyFromCloudFormation)(properties.Triggers):void 0),ret.addPropertyResult("versioningConfiguration","VersioningConfiguration",properties.VersioningConfiguration!=null?CfnDatasetVersioningConfigurationPropertyFromCloudFormation(properties.VersioningConfiguration):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnDataset extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnDataset.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iotanalytics_CfnDatasetProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnDataset),error}cdk.requireProperty(props,"actions",this),this.attrId=cdk.Token.asString(this.getAtt("Id",cdk.ResolutionTypeHint.STRING)),this.actions=props.actions,this.contentDeliveryRules=props.contentDeliveryRules,this.datasetName=props.datasetName,this.lateDataRules=props.lateDataRules,this.retentionPeriod=props.retentionPeriod,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::IoTAnalytics::Dataset",props.tags,{tagPropertyName:"tags"}),this.triggers=props.triggers,this.versioningConfiguration=props.versioningConfiguration}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnDatasetPropsFromCloudFormation(resourceProperties),ret=new CfnDataset(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnDataset.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{actions:this.actions,contentDeliveryRules:this.contentDeliveryRules,datasetName:this.datasetName,lateDataRules:this.lateDataRules,retentionPeriod:this.retentionPeriod,tags:this.tags.renderTags(),triggers:this.triggers,versioningConfiguration:this.versioningConfiguration}}renderProperties(props){return cfnDatasetPropsToCloudFormation(props)}}exports.CfnDataset=CfnDataset,_b=JSII_RTTI_SYMBOL_1,CfnDataset[_b]={fqn:"aws-cdk-lib.aws_iotanalytics.CfnDataset",version:"2.69.0"},CfnDataset.CFN_RESOURCE_TYPE_NAME="AWS::IoTAnalytics::Dataset";function CfnDataset_ActionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("actionName",cdk.requiredValidator)(properties.actionName)),errors.collect(cdk.propertyValidator("actionName",cdk.validateString)(properties.actionName)),errors.collect(cdk.propertyValidator("containerAction",CfnDataset_ContainerActionPropertyValidator)(properties.containerAction)),errors.collect(cdk.propertyValidator("queryAction",CfnDataset_QueryActionPropertyValidator)(properties.queryAction)),errors.wrap('supplied properties not correct for "ActionProperty"')}function cfnDatasetActionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_ActionPropertyValidator(properties).assertSuccess(),{ActionName:cdk.stringToCloudFormation(properties.actionName),ContainerAction:cfnDatasetContainerActionPropertyToCloudFormation(properties.containerAction),QueryAction:cfnDatasetQueryActionPropertyToCloudFormation(properties.queryAction)}):properties}function CfnDatasetActionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("actionName","ActionName",cfn_parse.FromCloudFormation.getString(properties.ActionName)),ret.addPropertyResult("containerAction","ContainerAction",properties.ContainerAction!=null?CfnDatasetContainerActionPropertyFromCloudFormation(properties.ContainerAction):void 0),ret.addPropertyResult("queryAction","QueryAction",properties.QueryAction!=null?CfnDatasetQueryActionPropertyFromCloudFormation(properties.QueryAction):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_ContainerActionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("executionRoleArn",cdk.requiredValidator)(properties.executionRoleArn)),errors.collect(cdk.propertyValidator("executionRoleArn",cdk.validateString)(properties.executionRoleArn)),errors.collect(cdk.propertyValidator("image",cdk.requiredValidator)(properties.image)),errors.collect(cdk.propertyValidator("image",cdk.validateString)(properties.image)),errors.collect(cdk.propertyValidator("resourceConfiguration",cdk.requiredValidator)(properties.resourceConfiguration)),errors.collect(cdk.propertyValidator("resourceConfiguration",CfnDataset_ResourceConfigurationPropertyValidator)(properties.resourceConfiguration)),errors.collect(cdk.propertyValidator("variables",cdk.listValidator(CfnDataset_VariablePropertyValidator))(properties.variables)),errors.wrap('supplied properties not correct for "ContainerActionProperty"')}function cfnDatasetContainerActionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_ContainerActionPropertyValidator(properties).assertSuccess(),{ExecutionRoleArn:cdk.stringToCloudFormation(properties.executionRoleArn),Image:cdk.stringToCloudFormation(properties.image),ResourceConfiguration:cfnDatasetResourceConfigurationPropertyToCloudFormation(properties.resourceConfiguration),Variables:cdk.listMapper(cfnDatasetVariablePropertyToCloudFormation)(properties.variables)}):properties}function CfnDatasetContainerActionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("executionRoleArn","ExecutionRoleArn",cfn_parse.FromCloudFormation.getString(properties.ExecutionRoleArn)),ret.addPropertyResult("image","Image",cfn_parse.FromCloudFormation.getString(properties.Image)),ret.addPropertyResult("resourceConfiguration","ResourceConfiguration",CfnDatasetResourceConfigurationPropertyFromCloudFormation(properties.ResourceConfiguration)),ret.addPropertyResult("variables","Variables",properties.Variables!=null?cfn_parse.FromCloudFormation.getArray(CfnDatasetVariablePropertyFromCloudFormation)(properties.Variables):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_DatasetContentDeliveryRulePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("destination",cdk.requiredValidator)(properties.destination)),errors.collect(cdk.propertyValidator("destination",CfnDataset_DatasetContentDeliveryRuleDestinationPropertyValidator)(properties.destination)),errors.collect(cdk.propertyValidator("entryName",cdk.validateString)(properties.entryName)),errors.wrap('supplied properties not correct for "DatasetContentDeliveryRuleProperty"')}function cfnDatasetDatasetContentDeliveryRulePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_DatasetContentDeliveryRulePropertyValidator(properties).assertSuccess(),{Destination:cfnDatasetDatasetContentDeliveryRuleDestinationPropertyToCloudFormation(properties.destination),EntryName:cdk.stringToCloudFormation(properties.entryName)}):properties}function CfnDatasetDatasetContentDeliveryRulePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("destination","Destination",CfnDatasetDatasetContentDeliveryRuleDestinationPropertyFromCloudFormation(properties.Destination)),ret.addPropertyResult("entryName","EntryName",properties.EntryName!=null?cfn_parse.FromCloudFormation.getString(properties.EntryName):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_DatasetContentDeliveryRuleDestinationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("iotEventsDestinationConfiguration",CfnDataset_IotEventsDestinationConfigurationPropertyValidator)(properties.iotEventsDestinationConfiguration)),errors.collect(cdk.propertyValidator("s3DestinationConfiguration",CfnDataset_S3DestinationConfigurationPropertyValidator)(properties.s3DestinationConfiguration)),errors.wrap('supplied properties not correct for "DatasetContentDeliveryRuleDestinationProperty"')}function cfnDatasetDatasetContentDeliveryRuleDestinationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_DatasetContentDeliveryRuleDestinationPropertyValidator(properties).assertSuccess(),{IotEventsDestinationConfiguration:cfnDatasetIotEventsDestinationConfigurationPropertyToCloudFormation(properties.iotEventsDestinationConfiguration),S3DestinationConfiguration:cfnDatasetS3DestinationConfigurationPropertyToCloudFormation(properties.s3DestinationConfiguration)}):properties}function CfnDatasetDatasetContentDeliveryRuleDestinationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("iotEventsDestinationConfiguration","IotEventsDestinationConfiguration",properties.IotEventsDestinationConfiguration!=null?CfnDatasetIotEventsDestinationConfigurationPropertyFromCloudFormation(properties.IotEventsDestinationConfiguration):void 0),ret.addPropertyResult("s3DestinationConfiguration","S3DestinationConfiguration",properties.S3DestinationConfiguration!=null?CfnDatasetS3DestinationConfigurationPropertyFromCloudFormation(properties.S3DestinationConfiguration):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_DatasetContentVersionValuePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("datasetName",cdk.requiredValidator)(properties.datasetName)),errors.collect(cdk.propertyValidator("datasetName",cdk.validateString)(properties.datasetName)),errors.wrap('supplied properties not correct for "DatasetContentVersionValueProperty"')}function cfnDatasetDatasetContentVersionValuePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_DatasetContentVersionValuePropertyValidator(properties).assertSuccess(),{DatasetName:cdk.stringToCloudFormation(properties.datasetName)}):properties}function CfnDatasetDatasetContentVersionValuePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("datasetName","DatasetName",cfn_parse.FromCloudFormation.getString(properties.DatasetName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_DeltaTimePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("offsetSeconds",cdk.requiredValidator)(properties.offsetSeconds)),errors.collect(cdk.propertyValidator("offsetSeconds",cdk.validateNumber)(properties.offsetSeconds)),errors.collect(cdk.propertyValidator("timeExpression",cdk.requiredValidator)(properties.timeExpression)),errors.collect(cdk.propertyValidator("timeExpression",cdk.validateString)(properties.timeExpression)),errors.wrap('supplied properties not correct for "DeltaTimeProperty"')}function cfnDatasetDeltaTimePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_DeltaTimePropertyValidator(properties).assertSuccess(),{OffsetSeconds:cdk.numberToCloudFormation(properties.offsetSeconds),TimeExpression:cdk.stringToCloudFormation(properties.timeExpression)}):properties}function CfnDatasetDeltaTimePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("offsetSeconds","OffsetSeconds",cfn_parse.FromCloudFormation.getNumber(properties.OffsetSeconds)),ret.addPropertyResult("timeExpression","TimeExpression",cfn_parse.FromCloudFormation.getString(properties.TimeExpression)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_DeltaTimeSessionWindowConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("timeoutInMinutes",cdk.requiredValidator)(properties.timeoutInMinutes)),errors.collect(cdk.propertyValidator("timeoutInMinutes",cdk.validateNumber)(properties.timeoutInMinutes)),errors.wrap('supplied properties not correct for "DeltaTimeSessionWindowConfigurationProperty"')}function cfnDatasetDeltaTimeSessionWindowConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_DeltaTimeSessionWindowConfigurationPropertyValidator(properties).assertSuccess(),{TimeoutInMinutes:cdk.numberToCloudFormation(properties.timeoutInMinutes)}):properties}function CfnDatasetDeltaTimeSessionWindowConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("timeoutInMinutes","TimeoutInMinutes",cfn_parse.FromCloudFormation.getNumber(properties.TimeoutInMinutes)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_FilterPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("deltaTime",CfnDataset_DeltaTimePropertyValidator)(properties.deltaTime)),errors.wrap('supplied properties not correct for "FilterProperty"')}function cfnDatasetFilterPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_FilterPropertyValidator(properties).assertSuccess(),{DeltaTime:cfnDatasetDeltaTimePropertyToCloudFormation(properties.deltaTime)}):properties}function CfnDatasetFilterPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("deltaTime","DeltaTime",properties.DeltaTime!=null?CfnDatasetDeltaTimePropertyFromCloudFormation(properties.DeltaTime):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_GlueConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("databaseName",cdk.requiredValidator)(properties.databaseName)),errors.collect(cdk.propertyValidator("databaseName",cdk.validateString)(properties.databaseName)),errors.collect(cdk.propertyValidator("tableName",cdk.requiredValidator)(properties.tableName)),errors.collect(cdk.propertyValidator("tableName",cdk.validateString)(properties.tableName)),errors.wrap('supplied properties not correct for "GlueConfigurationProperty"')}function cfnDatasetGlueConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_GlueConfigurationPropertyValidator(properties).assertSuccess(),{DatabaseName:cdk.stringToCloudFormation(properties.databaseName),TableName:cdk.stringToCloudFormation(properties.tableName)}):properties}function CfnDatasetGlueConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("databaseName","DatabaseName",cfn_parse.FromCloudFormation.getString(properties.DatabaseName)),ret.addPropertyResult("tableName","TableName",cfn_parse.FromCloudFormation.getString(properties.TableName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_IotEventsDestinationConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("inputName",cdk.requiredValidator)(properties.inputName)),errors.collect(cdk.propertyValidator("inputName",cdk.validateString)(properties.inputName)),errors.collect(cdk.propertyValidator("roleArn",cdk.requiredValidator)(properties.roleArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.validateString)(properties.roleArn)),errors.wrap('supplied properties not correct for "IotEventsDestinationConfigurationProperty"')}function cfnDatasetIotEventsDestinationConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_IotEventsDestinationConfigurationPropertyValidator(properties).assertSuccess(),{InputName:cdk.stringToCloudFormation(properties.inputName),RoleArn:cdk.stringToCloudFormation(properties.roleArn)}):properties}function CfnDatasetIotEventsDestinationConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("inputName","InputName",cfn_parse.FromCloudFormation.getString(properties.InputName)),ret.addPropertyResult("roleArn","RoleArn",cfn_parse.FromCloudFormation.getString(properties.RoleArn)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_LateDataRulePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("ruleConfiguration",cdk.requiredValidator)(properties.ruleConfiguration)),errors.collect(cdk.propertyValidator("ruleConfiguration",CfnDataset_LateDataRuleConfigurationPropertyValidator)(properties.ruleConfiguration)),errors.collect(cdk.propertyValidator("ruleName",cdk.validateString)(properties.ruleName)),errors.wrap('supplied properties not correct for "LateDataRuleProperty"')}function cfnDatasetLateDataRulePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_LateDataRulePropertyValidator(properties).assertSuccess(),{RuleConfiguration:cfnDatasetLateDataRuleConfigurationPropertyToCloudFormation(properties.ruleConfiguration),RuleName:cdk.stringToCloudFormation(properties.ruleName)}):properties}function CfnDatasetLateDataRulePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("ruleConfiguration","RuleConfiguration",CfnDatasetLateDataRuleConfigurationPropertyFromCloudFormation(properties.RuleConfiguration)),ret.addPropertyResult("ruleName","RuleName",properties.RuleName!=null?cfn_parse.FromCloudFormation.getString(properties.RuleName):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_LateDataRuleConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("deltaTimeSessionWindowConfiguration",CfnDataset_DeltaTimeSessionWindowConfigurationPropertyValidator)(properties.deltaTimeSessionWindowConfiguration)),errors.wrap('supplied properties not correct for "LateDataRuleConfigurationProperty"')}function cfnDatasetLateDataRuleConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_LateDataRuleConfigurationPropertyValidator(properties).assertSuccess(),{DeltaTimeSessionWindowConfiguration:cfnDatasetDeltaTimeSessionWindowConfigurationPropertyToCloudFormation(properties.deltaTimeSessionWindowConfiguration)}):properties}function CfnDatasetLateDataRuleConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("deltaTimeSessionWindowConfiguration","DeltaTimeSessionWindowConfiguration",properties.DeltaTimeSessionWindowConfiguration!=null?CfnDatasetDeltaTimeSessionWindowConfigurationPropertyFromCloudFormation(properties.DeltaTimeSessionWindowConfiguration):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_OutputFileUriValuePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("fileName",cdk.requiredValidator)(properties.fileName)),errors.collect(cdk.propertyValidator("fileName",cdk.validateString)(properties.fileName)),errors.wrap('supplied properties not correct for "OutputFileUriValueProperty"')}function cfnDatasetOutputFileUriValuePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_OutputFileUriValuePropertyValidator(properties).assertSuccess(),{FileName:cdk.stringToCloudFormation(properties.fileName)}):properties}function CfnDatasetOutputFileUriValuePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("fileName","FileName",cfn_parse.FromCloudFormation.getString(properties.FileName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_QueryActionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("filters",cdk.listValidator(CfnDataset_FilterPropertyValidator))(properties.filters)),errors.collect(cdk.propertyValidator("sqlQuery",cdk.requiredValidator)(properties.sqlQuery)),errors.collect(cdk.propertyValidator("sqlQuery",cdk.validateString)(properties.sqlQuery)),errors.wrap('supplied properties not correct for "QueryActionProperty"')}function cfnDatasetQueryActionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_QueryActionPropertyValidator(properties).assertSuccess(),{Filters:cdk.listMapper(cfnDatasetFilterPropertyToCloudFormation)(properties.filters),SqlQuery:cdk.stringToCloudFormation(properties.sqlQuery)}):properties}function CfnDatasetQueryActionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("filters","Filters",properties.Filters!=null?cfn_parse.FromCloudFormation.getArray(CfnDatasetFilterPropertyFromCloudFormation)(properties.Filters):void 0),ret.addPropertyResult("sqlQuery","SqlQuery",cfn_parse.FromCloudFormation.getString(properties.SqlQuery)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_ResourceConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("computeType",cdk.requiredValidator)(properties.computeType)),errors.collect(cdk.propertyValidator("computeType",cdk.validateString)(properties.computeType)),errors.collect(cdk.propertyValidator("volumeSizeInGb",cdk.requiredValidator)(properties.volumeSizeInGb)),errors.collect(cdk.propertyValidator("volumeSizeInGb",cdk.validateNumber)(properties.volumeSizeInGb)),errors.wrap('supplied properties not correct for "ResourceConfigurationProperty"')}function cfnDatasetResourceConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_ResourceConfigurationPropertyValidator(properties).assertSuccess(),{ComputeType:cdk.stringToCloudFormation(properties.computeType),VolumeSizeInGB:cdk.numberToCloudFormation(properties.volumeSizeInGb)}):properties}function CfnDatasetResourceConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("computeType","ComputeType",cfn_parse.FromCloudFormation.getString(properties.ComputeType)),ret.addPropertyResult("volumeSizeInGb","VolumeSizeInGB",cfn_parse.FromCloudFormation.getNumber(properties.VolumeSizeInGB)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_RetentionPeriodPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("numberOfDays",cdk.validateNumber)(properties.numberOfDays)),errors.collect(cdk.propertyValidator("unlimited",cdk.validateBoolean)(properties.unlimited)),errors.wrap('supplied properties not correct for "RetentionPeriodProperty"')}function cfnDatasetRetentionPeriodPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_RetentionPeriodPropertyValidator(properties).assertSuccess(),{NumberOfDays:cdk.numberToCloudFormation(properties.numberOfDays),Unlimited:cdk.booleanToCloudFormation(properties.unlimited)}):properties}function CfnDatasetRetentionPeriodPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("numberOfDays","NumberOfDays",properties.NumberOfDays!=null?cfn_parse.FromCloudFormation.getNumber(properties.NumberOfDays):void 0),ret.addPropertyResult("unlimited","Unlimited",properties.Unlimited!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Unlimited):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_S3DestinationConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("bucket",cdk.requiredValidator)(properties.bucket)),errors.collect(cdk.propertyValidator("bucket",cdk.validateString)(properties.bucket)),errors.collect(cdk.propertyValidator("glueConfiguration",CfnDataset_GlueConfigurationPropertyValidator)(properties.glueConfiguration)),errors.collect(cdk.propertyValidator("key",cdk.requiredValidator)(properties.key)),errors.collect(cdk.propertyValidator("key",cdk.validateString)(properties.key)),errors.collect(cdk.propertyValidator("roleArn",cdk.requiredValidator)(properties.roleArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.validateString)(properties.roleArn)),errors.wrap('supplied properties not correct for "S3DestinationConfigurationProperty"')}function cfnDatasetS3DestinationConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_S3DestinationConfigurationPropertyValidator(properties).assertSuccess(),{Bucket:cdk.stringToCloudFormation(properties.bucket),GlueConfiguration:cfnDatasetGlueConfigurationPropertyToCloudFormation(properties.glueConfiguration),Key:cdk.stringToCloudFormation(properties.key),RoleArn:cdk.stringToCloudFormation(properties.roleArn)}):properties}function CfnDatasetS3DestinationConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("bucket","Bucket",cfn_parse.FromCloudFormation.getString(properties.Bucket)),ret.addPropertyResult("glueConfiguration","GlueConfiguration",properties.GlueConfiguration!=null?CfnDatasetGlueConfigurationPropertyFromCloudFormation(properties.GlueConfiguration):void 0),ret.addPropertyResult("key","Key",cfn_parse.FromCloudFormation.getString(properties.Key)),ret.addPropertyResult("roleArn","RoleArn",cfn_parse.FromCloudFormation.getString(properties.RoleArn)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_SchedulePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("scheduleExpression",cdk.requiredValidator)(properties.scheduleExpression)),errors.collect(cdk.propertyValidator("scheduleExpression",cdk.validateString)(properties.scheduleExpression)),errors.wrap('supplied properties not correct for "ScheduleProperty"')}function cfnDatasetSchedulePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_SchedulePropertyValidator(properties).assertSuccess(),{ScheduleExpression:cdk.stringToCloudFormation(properties.scheduleExpression)}):properties}function CfnDatasetSchedulePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("scheduleExpression","ScheduleExpression",cfn_parse.FromCloudFormation.getString(properties.ScheduleExpression)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_TriggerPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("schedule",CfnDataset_SchedulePropertyValidator)(properties.schedule)),errors.collect(cdk.propertyValidator("triggeringDataset",CfnDataset_TriggeringDatasetPropertyValidator)(properties.triggeringDataset)),errors.wrap('supplied properties not correct for "TriggerProperty"')}function cfnDatasetTriggerPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_TriggerPropertyValidator(properties).assertSuccess(),{Schedule:cfnDatasetSchedulePropertyToCloudFormation(properties.schedule),TriggeringDataset:cfnDatasetTriggeringDatasetPropertyToCloudFormation(properties.triggeringDataset)}):properties}function CfnDatasetTriggerPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("schedule","Schedule",properties.Schedule!=null?CfnDatasetSchedulePropertyFromCloudFormation(properties.Schedule):void 0),ret.addPropertyResult("triggeringDataset","TriggeringDataset",properties.TriggeringDataset!=null?CfnDatasetTriggeringDatasetPropertyFromCloudFormation(properties.TriggeringDataset):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_TriggeringDatasetPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("datasetName",cdk.requiredValidator)(properties.datasetName)),errors.collect(cdk.propertyValidator("datasetName",cdk.validateString)(properties.datasetName)),errors.wrap('supplied properties not correct for "TriggeringDatasetProperty"')}function cfnDatasetTriggeringDatasetPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_TriggeringDatasetPropertyValidator(properties).assertSuccess(),{DatasetName:cdk.stringToCloudFormation(properties.datasetName)}):properties}function CfnDatasetTriggeringDatasetPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("datasetName","DatasetName",cfn_parse.FromCloudFormation.getString(properties.DatasetName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_VariablePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("datasetContentVersionValue",CfnDataset_DatasetContentVersionValuePropertyValidator)(properties.datasetContentVersionValue)),errors.collect(cdk.propertyValidator("doubleValue",cdk.validateNumber)(properties.doubleValue)),errors.collect(cdk.propertyValidator("outputFileUriValue",CfnDataset_OutputFileUriValuePropertyValidator)(properties.outputFileUriValue)),errors.collect(cdk.propertyValidator("stringValue",cdk.validateString)(properties.stringValue)),errors.collect(cdk.propertyValidator("variableName",cdk.requiredValidator)(properties.variableName)),errors.collect(cdk.propertyValidator("variableName",cdk.validateString)(properties.variableName)),errors.wrap('supplied properties not correct for "VariableProperty"')}function cfnDatasetVariablePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_VariablePropertyValidator(properties).assertSuccess(),{DatasetContentVersionValue:cfnDatasetDatasetContentVersionValuePropertyToCloudFormation(properties.datasetContentVersionValue),DoubleValue:cdk.numberToCloudFormation(properties.doubleValue),OutputFileUriValue:cfnDatasetOutputFileUriValuePropertyToCloudFormation(properties.outputFileUriValue),StringValue:cdk.stringToCloudFormation(properties.stringValue),VariableName:cdk.stringToCloudFormation(properties.variableName)}):properties}function CfnDatasetVariablePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("datasetContentVersionValue","DatasetContentVersionValue",properties.DatasetContentVersionValue!=null?CfnDatasetDatasetContentVersionValuePropertyFromCloudFormation(properties.DatasetContentVersionValue):void 0),ret.addPropertyResult("doubleValue","DoubleValue",properties.DoubleValue!=null?cfn_parse.FromCloudFormation.getNumber(properties.DoubleValue):void 0),ret.addPropertyResult("outputFileUriValue","OutputFileUriValue",properties.OutputFileUriValue!=null?CfnDatasetOutputFileUriValuePropertyFromCloudFormation(properties.OutputFileUriValue):void 0),ret.addPropertyResult("stringValue","StringValue",properties.StringValue!=null?cfn_parse.FromCloudFormation.getString(properties.StringValue):void 0),ret.addPropertyResult("variableName","VariableName",cfn_parse.FromCloudFormation.getString(properties.VariableName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDataset_VersioningConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("maxVersions",cdk.validateNumber)(properties.maxVersions)),errors.collect(cdk.propertyValidator("unlimited",cdk.validateBoolean)(properties.unlimited)),errors.wrap('supplied properties not correct for "VersioningConfigurationProperty"')}function cfnDatasetVersioningConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDataset_VersioningConfigurationPropertyValidator(properties).assertSuccess(),{MaxVersions:cdk.numberToCloudFormation(properties.maxVersions),Unlimited:cdk.booleanToCloudFormation(properties.unlimited)}):properties}function CfnDatasetVersioningConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("maxVersions","MaxVersions",properties.MaxVersions!=null?cfn_parse.FromCloudFormation.getNumber(properties.MaxVersions):void 0),ret.addPropertyResult("unlimited","Unlimited",properties.Unlimited!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Unlimited):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDatastorePropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("datastoreName",cdk.validateString)(properties.datastoreName)),errors.collect(cdk.propertyValidator("datastorePartitions",CfnDatastore_DatastorePartitionsPropertyValidator)(properties.datastorePartitions)),errors.collect(cdk.propertyValidator("datastoreStorage",CfnDatastore_DatastoreStoragePropertyValidator)(properties.datastoreStorage)),errors.collect(cdk.propertyValidator("fileFormatConfiguration",CfnDatastore_FileFormatConfigurationPropertyValidator)(properties.fileFormatConfiguration)),errors.collect(cdk.propertyValidator("retentionPeriod",CfnDatastore_RetentionPeriodPropertyValidator)(properties.retentionPeriod)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.wrap('supplied properties not correct for "CfnDatastoreProps"')}function cfnDatastorePropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDatastorePropsValidator(properties).assertSuccess(),{DatastoreName:cdk.stringToCloudFormation(properties.datastoreName),DatastorePartitions:cfnDatastoreDatastorePartitionsPropertyToCloudFormation(properties.datastorePartitions),DatastoreStorage:cfnDatastoreDatastoreStoragePropertyToCloudFormation(properties.datastoreStorage),FileFormatConfiguration:cfnDatastoreFileFormatConfigurationPropertyToCloudFormation(properties.fileFormatConfiguration),RetentionPeriod:cfnDatastoreRetentionPeriodPropertyToCloudFormation(properties.retentionPeriod),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnDatastorePropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("datastoreName","DatastoreName",properties.DatastoreName!=null?cfn_parse.FromCloudFormation.getString(properties.DatastoreName):void 0),ret.addPropertyResult("datastorePartitions","DatastorePartitions",properties.DatastorePartitions!=null?CfnDatastoreDatastorePartitionsPropertyFromCloudFormation(properties.DatastorePartitions):void 0),ret.addPropertyResult("datastoreStorage","DatastoreStorage",properties.DatastoreStorage!=null?CfnDatastoreDatastoreStoragePropertyFromCloudFormation(properties.DatastoreStorage):void 0),ret.addPropertyResult("fileFormatConfiguration","FileFormatConfiguration",properties.FileFormatConfiguration!=null?CfnDatastoreFileFormatConfigurationPropertyFromCloudFormation(properties.FileFormatConfiguration):void 0),ret.addPropertyResult("retentionPeriod","RetentionPeriod",properties.RetentionPeriod!=null?CfnDatastoreRetentionPeriodPropertyFromCloudFormation(properties.RetentionPeriod):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnDatastore extends cdk.CfnResource{constructor(scope,id,props={}){super(scope,id,{type:CfnDatastore.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iotanalytics_CfnDatastoreProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnDatastore),error}this.attrId=cdk.Token.asString(this.getAtt("Id",cdk.ResolutionTypeHint.STRING)),this.datastoreName=props.datastoreName,this.datastorePartitions=props.datastorePartitions,this.datastoreStorage=props.datastoreStorage,this.fileFormatConfiguration=props.fileFormatConfiguration,this.retentionPeriod=props.retentionPeriod,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::IoTAnalytics::Datastore",props.tags,{tagPropertyName:"tags"})}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnDatastorePropsFromCloudFormation(resourceProperties),ret=new CfnDatastore(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnDatastore.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{datastoreName:this.datastoreName,datastorePartitions:this.datastorePartitions,datastoreStorage:this.datastoreStorage,fileFormatConfiguration:this.fileFormatConfiguration,retentionPeriod:this.retentionPeriod,tags:this.tags.renderTags()}}renderProperties(props){return cfnDatastorePropsToCloudFormation(props)}}exports.CfnDatastore=CfnDatastore,_c=JSII_RTTI_SYMBOL_1,CfnDatastore[_c]={fqn:"aws-cdk-lib.aws_iotanalytics.CfnDatastore",version:"2.69.0"},CfnDatastore.CFN_RESOURCE_TYPE_NAME="AWS::IoTAnalytics::Datastore";function CfnDatastore_ColumnPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("type",cdk.requiredValidator)(properties.type)),errors.collect(cdk.propertyValidator("type",cdk.validateString)(properties.type)),errors.wrap('supplied properties not correct for "ColumnProperty"')}function cfnDatastoreColumnPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDatastore_ColumnPropertyValidator(properties).assertSuccess(),{Name:cdk.stringToCloudFormation(properties.name),Type:cdk.stringToCloudFormation(properties.type)}):properties}function CfnDatastoreColumnPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("type","Type",cfn_parse.FromCloudFormation.getString(properties.Type)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDatastore_CustomerManagedS3PropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("bucket",cdk.requiredValidator)(properties.bucket)),errors.collect(cdk.propertyValidator("bucket",cdk.validateString)(properties.bucket)),errors.collect(cdk.propertyValidator("keyPrefix",cdk.validateString)(properties.keyPrefix)),errors.collect(cdk.propertyValidator("roleArn",cdk.requiredValidator)(properties.roleArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.validateString)(properties.roleArn)),errors.wrap('supplied properties not correct for "CustomerManagedS3Property"')}function cfnDatastoreCustomerManagedS3PropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDatastore_CustomerManagedS3PropertyValidator(properties).assertSuccess(),{Bucket:cdk.stringToCloudFormation(properties.bucket),KeyPrefix:cdk.stringToCloudFormation(properties.keyPrefix),RoleArn:cdk.stringToCloudFormation(properties.roleArn)}):properties}function CfnDatastoreCustomerManagedS3PropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("bucket","Bucket",cfn_parse.FromCloudFormation.getString(properties.Bucket)),ret.addPropertyResult("keyPrefix","KeyPrefix",properties.KeyPrefix!=null?cfn_parse.FromCloudFormation.getString(properties.KeyPrefix):void 0),ret.addPropertyResult("roleArn","RoleArn",cfn_parse.FromCloudFormation.getString(properties.RoleArn)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDatastore_CustomerManagedS3StoragePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("bucket",cdk.requiredValidator)(properties.bucket)),errors.collect(cdk.propertyValidator("bucket",cdk.validateString)(properties.bucket)),errors.collect(cdk.propertyValidator("keyPrefix",cdk.validateString)(properties.keyPrefix)),errors.wrap('supplied properties not correct for "CustomerManagedS3StorageProperty"')}function cfnDatastoreCustomerManagedS3StoragePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDatastore_CustomerManagedS3StoragePropertyValidator(properties).assertSuccess(),{Bucket:cdk.stringToCloudFormation(properties.bucket),KeyPrefix:cdk.stringToCloudFormation(properties.keyPrefix)}):properties}function CfnDatastoreCustomerManagedS3StoragePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("bucket","Bucket",cfn_parse.FromCloudFormation.getString(properties.Bucket)),ret.addPropertyResult("keyPrefix","KeyPrefix",properties.KeyPrefix!=null?cfn_parse.FromCloudFormation.getString(properties.KeyPrefix):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDatastore_DatastorePartitionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("partition",CfnDatastore_PartitionPropertyValidator)(properties.partition)),errors.collect(cdk.propertyValidator("timestampPartition",CfnDatastore_TimestampPartitionPropertyValidator)(properties.timestampPartition)),errors.wrap('supplied properties not correct for "DatastorePartitionProperty"')}function cfnDatastoreDatastorePartitionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDatastore_DatastorePartitionPropertyValidator(properties).assertSuccess(),{Partition:cfnDatastorePartitionPropertyToCloudFormation(properties.partition),TimestampPartition:cfnDatastoreTimestampPartitionPropertyToCloudFormation(properties.timestampPartition)}):properties}function CfnDatastoreDatastorePartitionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("partition","Partition",properties.Partition!=null?CfnDatastorePartitionPropertyFromCloudFormation(properties.Partition):void 0),ret.addPropertyResult("timestampPartition","TimestampPartition",properties.TimestampPartition!=null?CfnDatastoreTimestampPartitionPropertyFromCloudFormation(properties.TimestampPartition):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDatastore_DatastorePartitionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("partitions",cdk.listValidator(CfnDatastore_DatastorePartitionPropertyValidator))(properties.partitions)),errors.wrap('supplied properties not correct for "DatastorePartitionsProperty"')}function cfnDatastoreDatastorePartitionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDatastore_DatastorePartitionsPropertyValidator(properties).assertSuccess(),{Partitions:cdk.listMapper(cfnDatastoreDatastorePartitionPropertyToCloudFormation)(properties.partitions)}):properties}function CfnDatastoreDatastorePartitionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("partitions","Partitions",properties.Partitions!=null?cfn_parse.FromCloudFormation.getArray(CfnDatastoreDatastorePartitionPropertyFromCloudFormation)(properties.Partitions):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDatastore_DatastoreStoragePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("customerManagedS3",CfnDatastore_CustomerManagedS3PropertyValidator)(properties.customerManagedS3)),errors.collect(cdk.propertyValidator("iotSiteWiseMultiLayerStorage",CfnDatastore_IotSiteWiseMultiLayerStoragePropertyValidator)(properties.iotSiteWiseMultiLayerStorage)),errors.collect(cdk.propertyValidator("serviceManagedS3",cdk.validateObject)(properties.serviceManagedS3)),errors.wrap('supplied properties not correct for "DatastoreStorageProperty"')}function cfnDatastoreDatastoreStoragePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDatastore_DatastoreStoragePropertyValidator(properties).assertSuccess(),{CustomerManagedS3:cfnDatastoreCustomerManagedS3PropertyToCloudFormation(properties.customerManagedS3),IotSiteWiseMultiLayerStorage:cfnDatastoreIotSiteWiseMultiLayerStoragePropertyToCloudFormation(properties.iotSiteWiseMultiLayerStorage),ServiceManagedS3:cdk.objectToCloudFormation(properties.serviceManagedS3)}):properties}function CfnDatastoreDatastoreStoragePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("customerManagedS3","CustomerManagedS3",properties.CustomerManagedS3!=null?CfnDatastoreCustomerManagedS3PropertyFromCloudFormation(properties.CustomerManagedS3):void 0),ret.addPropertyResult("iotSiteWiseMultiLayerStorage","IotSiteWiseMultiLayerStorage",properties.IotSiteWiseMultiLayerStorage!=null?CfnDatastoreIotSiteWiseMultiLayerStoragePropertyFromCloudFormation(properties.IotSiteWiseMultiLayerStorage):void 0),ret.addPropertyResult("serviceManagedS3","ServiceManagedS3",properties.ServiceManagedS3!=null?cfn_parse.FromCloudFormation.getAny(properties.ServiceManagedS3):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDatastore_FileFormatConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("jsonConfiguration",cdk.validateObject)(properties.jsonConfiguration)),errors.collect(cdk.propertyValidator("parquetConfiguration",CfnDatastore_ParquetConfigurationPropertyValidator)(properties.parquetConfiguration)),errors.wrap('supplied properties not correct for "FileFormatConfigurationProperty"')}function cfnDatastoreFileFormatConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDatastore_FileFormatConfigurationPropertyValidator(properties).assertSuccess(),{JsonConfiguration:cdk.objectToCloudFormation(properties.jsonConfiguration),ParquetConfiguration:cfnDatastoreParquetConfigurationPropertyToCloudFormation(properties.parquetConfiguration)}):properties}function CfnDatastoreFileFormatConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("jsonConfiguration","JsonConfiguration",properties.JsonConfiguration!=null?cfn_parse.FromCloudFormation.getAny(properties.JsonConfiguration):void 0),ret.addPropertyResult("parquetConfiguration","ParquetConfiguration",properties.ParquetConfiguration!=null?CfnDatastoreParquetConfigurationPropertyFromCloudFormation(properties.ParquetConfiguration):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDatastore_IotSiteWiseMultiLayerStoragePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("customerManagedS3Storage",CfnDatastore_CustomerManagedS3StoragePropertyValidator)(properties.customerManagedS3Storage)),errors.wrap('supplied properties not correct for "IotSiteWiseMultiLayerStorageProperty"')}function cfnDatastoreIotSiteWiseMultiLayerStoragePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDatastore_IotSiteWiseMultiLayerStoragePropertyValidator(properties).assertSuccess(),{CustomerManagedS3Storage:cfnDatastoreCustomerManagedS3StoragePropertyToCloudFormation(properties.customerManagedS3Storage)}):properties}function CfnDatastoreIotSiteWiseMultiLayerStoragePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("customerManagedS3Storage","CustomerManagedS3Storage",properties.CustomerManagedS3Storage!=null?CfnDatastoreCustomerManagedS3StoragePropertyFromCloudFormation(properties.CustomerManagedS3Storage):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDatastore_ParquetConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("schemaDefinition",CfnDatastore_SchemaDefinitionPropertyValidator)(properties.schemaDefinition)),errors.wrap('supplied properties not correct for "ParquetConfigurationProperty"')}function cfnDatastoreParquetConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDatastore_ParquetConfigurationPropertyValidator(properties).assertSuccess(),{SchemaDefinition:cfnDatastoreSchemaDefinitionPropertyToCloudFormation(properties.schemaDefinition)}):properties}function CfnDatastoreParquetConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("schemaDefinition","SchemaDefinition",properties.SchemaDefinition!=null?CfnDatastoreSchemaDefinitionPropertyFromCloudFormation(properties.SchemaDefinition):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDatastore_PartitionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("attributeName",cdk.requiredValidator)(properties.attributeName)),errors.collect(cdk.propertyValidator("attributeName",cdk.validateString)(properties.attributeName)),errors.wrap('supplied properties not correct for "PartitionProperty"')}function cfnDatastorePartitionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDatastore_PartitionPropertyValidator(properties).assertSuccess(),{AttributeName:cdk.stringToCloudFormation(properties.attributeName)}):properties}function CfnDatastorePartitionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("attributeName","AttributeName",cfn_parse.FromCloudFormation.getString(properties.AttributeName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDatastore_RetentionPeriodPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("numberOfDays",cdk.validateNumber)(properties.numberOfDays)),errors.collect(cdk.propertyValidator("unlimited",cdk.validateBoolean)(properties.unlimited)),errors.wrap('supplied properties not correct for "RetentionPeriodProperty"')}function cfnDatastoreRetentionPeriodPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDatastore_RetentionPeriodPropertyValidator(properties).assertSuccess(),{NumberOfDays:cdk.numberToCloudFormation(properties.numberOfDays),Unlimited:cdk.booleanToCloudFormation(properties.unlimited)}):properties}function CfnDatastoreRetentionPeriodPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("numberOfDays","NumberOfDays",properties.NumberOfDays!=null?cfn_parse.FromCloudFormation.getNumber(properties.NumberOfDays):void 0),ret.addPropertyResult("unlimited","Unlimited",properties.Unlimited!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Unlimited):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDatastore_SchemaDefinitionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("columns",cdk.listValidator(CfnDatastore_ColumnPropertyValidator))(properties.columns)),errors.wrap('supplied properties not correct for "SchemaDefinitionProperty"')}function cfnDatastoreSchemaDefinitionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDatastore_SchemaDefinitionPropertyValidator(properties).assertSuccess(),{Columns:cdk.listMapper(cfnDatastoreColumnPropertyToCloudFormation)(properties.columns)}):properties}function CfnDatastoreSchemaDefinitionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("columns","Columns",properties.Columns!=null?cfn_parse.FromCloudFormation.getArray(CfnDatastoreColumnPropertyFromCloudFormation)(properties.Columns):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDatastore_TimestampPartitionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("attributeName",cdk.requiredValidator)(properties.attributeName)),errors.collect(cdk.propertyValidator("attributeName",cdk.validateString)(properties.attributeName)),errors.collect(cdk.propertyValidator("timestampFormat",cdk.validateString)(properties.timestampFormat)),errors.wrap('supplied properties not correct for "TimestampPartitionProperty"')}function cfnDatastoreTimestampPartitionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDatastore_TimestampPartitionPropertyValidator(properties).assertSuccess(),{AttributeName:cdk.stringToCloudFormation(properties.attributeName),TimestampFormat:cdk.stringToCloudFormation(properties.timestampFormat)}):properties}function CfnDatastoreTimestampPartitionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("attributeName","AttributeName",cfn_parse.FromCloudFormation.getString(properties.AttributeName)),ret.addPropertyResult("timestampFormat","TimestampFormat",properties.TimestampFormat!=null?cfn_parse.FromCloudFormation.getString(properties.TimestampFormat):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnPipelinePropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("pipelineActivities",cdk.requiredValidator)(properties.pipelineActivities)),errors.collect(cdk.propertyValidator("pipelineActivities",cdk.listValidator(CfnPipeline_ActivityPropertyValidator))(properties.pipelineActivities)),errors.collect(cdk.propertyValidator("pipelineName",cdk.validateString)(properties.pipelineName)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.wrap('supplied properties not correct for "CfnPipelineProps"')}function cfnPipelinePropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnPipelinePropsValidator(properties).assertSuccess(),{PipelineActivities:cdk.listMapper(cfnPipelineActivityPropertyToCloudFormation)(properties.pipelineActivities),PipelineName:cdk.stringToCloudFormation(properties.pipelineName),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnPipelinePropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("pipelineActivities","PipelineActivities",cfn_parse.FromCloudFormation.getArray(CfnPipelineActivityPropertyFromCloudFormation)(properties.PipelineActivities)),ret.addPropertyResult("pipelineName","PipelineName",properties.PipelineName!=null?cfn_parse.FromCloudFormation.getString(properties.PipelineName):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnPipeline extends cdk.CfnResource{constructor(scope,id,props){super(scope,id,{type:CfnPipeline.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iotanalytics_CfnPipelineProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnPipeline),error}cdk.requireProperty(props,"pipelineActivities",this),this.attrId=cdk.Token.asString(this.getAtt("Id",cdk.ResolutionTypeHint.STRING)),this.pipelineActivities=props.pipelineActivities,this.pipelineName=props.pipelineName,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::IoTAnalytics::Pipeline",props.tags,{tagPropertyName:"tags"})}static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnPipelinePropsFromCloudFormation(resourceProperties),ret=new CfnPipeline(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnPipeline.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{pipelineActivities:this.pipelineActivities,pipelineName:this.pipelineName,tags:this.tags.renderTags()}}renderProperties(props){return cfnPipelinePropsToCloudFormation(props)}}exports.CfnPipeline=CfnPipeline,_d=JSII_RTTI_SYMBOL_1,CfnPipeline[_d]={fqn:"aws-cdk-lib.aws_iotanalytics.CfnPipeline",version:"2.69.0"},CfnPipeline.CFN_RESOURCE_TYPE_NAME="AWS::IoTAnalytics::Pipeline";function CfnPipeline_ActivityPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("addAttributes",CfnPipeline_AddAttributesPropertyValidator)(properties.addAttributes)),errors.collect(cdk.propertyValidator("channel",CfnPipeline_ChannelPropertyValidator)(properties.channel)),errors.collect(cdk.propertyValidator("datastore",CfnPipeline_DatastorePropertyValidator)(properties.datastore)),errors.collect(cdk.propertyValidator("deviceRegistryEnrich",CfnPipeline_DeviceRegistryEnrichPropertyValidator)(properties.deviceRegistryEnrich)),errors.collect(cdk.propertyValidator("deviceShadowEnrich",CfnPipeline_DeviceShadowEnrichPropertyValidator)(properties.deviceShadowEnrich)),errors.collect(cdk.propertyValidator("filter",CfnPipeline_FilterPropertyValidator)(properties.filter)),errors.collect(cdk.propertyValidator("lambda",CfnPipeline_LambdaPropertyValidator)(properties.lambda)),errors.collect(cdk.propertyValidator("math",CfnPipeline_MathPropertyValidator)(properties.math)),errors.collect(cdk.propertyValidator("removeAttributes",CfnPipeline_RemoveAttributesPropertyValidator)(properties.removeAttributes)),errors.collect(cdk.propertyValidator("selectAttributes",CfnPipeline_SelectAttributesPropertyValidator)(properties.selectAttributes)),errors.wrap('supplied properties not correct for "ActivityProperty"')}function cfnPipelineActivityPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnPipeline_ActivityPropertyValidator(properties).assertSuccess(),{AddAttributes:cfnPipelineAddAttributesPropertyToCloudFormation(properties.addAttributes),Channel:cfnPipelineChannelPropertyToCloudFormation(properties.channel),Datastore:cfnPipelineDatastorePropertyToCloudFormation(properties.datastore),DeviceRegistryEnrich:cfnPipelineDeviceRegistryEnrichPropertyToCloudFormation(properties.deviceRegistryEnrich),DeviceShadowEnrich:cfnPipelineDeviceShadowEnrichPropertyToCloudFormation(properties.deviceShadowEnrich),Filter:cfnPipelineFilterPropertyToCloudFormation(properties.filter),Lambda:cfnPipelineLambdaPropertyToCloudFormation(properties.lambda),Math:cfnPipelineMathPropertyToCloudFormation(properties.math),RemoveAttributes:cfnPipelineRemoveAttributesPropertyToCloudFormation(properties.removeAttributes),SelectAttributes:cfnPipelineSelectAttributesPropertyToCloudFormation(properties.selectAttributes)}):properties}function CfnPipelineActivityPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("addAttributes","AddAttributes",properties.AddAttributes!=null?CfnPipelineAddAttributesPropertyFromCloudFormation(properties.AddAttributes):void 0),ret.addPropertyResult("channel","Channel",properties.Channel!=null?CfnPipelineChannelPropertyFromCloudFormation(properties.Channel):void 0),ret.addPropertyResult("datastore","Datastore",properties.Datastore!=null?CfnPipelineDatastorePropertyFromCloudFormation(properties.Datastore):void 0),ret.addPropertyResult("deviceRegistryEnrich","DeviceRegistryEnrich",properties.DeviceRegistryEnrich!=null?CfnPipelineDeviceRegistryEnrichPropertyFromCloudFormation(properties.DeviceRegistryEnrich):void 0),ret.addPropertyResult("deviceShadowEnrich","DeviceShadowEnrich",properties.DeviceShadowEnrich!=null?CfnPipelineDeviceShadowEnrichPropertyFromCloudFormation(properties.DeviceShadowEnrich):void 0),ret.addPropertyResult("filter","Filter",properties.Filter!=null?CfnPipelineFilterPropertyFromCloudFormation(properties.Filter):void 0),ret.addPropertyResult("lambda","Lambda",properties.Lambda!=null?CfnPipelineLambdaPropertyFromCloudFormation(properties.Lambda):void 0),ret.addPropertyResult("math","Math",properties.Math!=null?CfnPipelineMathPropertyFromCloudFormation(properties.Math):void 0),ret.addPropertyResult("removeAttributes","RemoveAttributes",properties.RemoveAttributes!=null?CfnPipelineRemoveAttributesPropertyFromCloudFormation(properties.RemoveAttributes):void 0),ret.addPropertyResult("selectAttributes","SelectAttributes",properties.SelectAttributes!=null?CfnPipelineSelectAttributesPropertyFromCloudFormation(properties.SelectAttributes):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnPipeline_AddAttributesPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("attributes",cdk.requiredValidator)(properties.attributes)),errors.collect(cdk.propertyValidator("attributes",cdk.hashValidator(cdk.validateString))(properties.attributes)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("next",cdk.validateString)(properties.next)),errors.wrap('supplied properties not correct for "AddAttributesProperty"')}function cfnPipelineAddAttributesPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnPipeline_AddAttributesPropertyValidator(properties).assertSuccess(),{Attributes:cdk.hashMapper(cdk.stringToCloudFormation)(properties.attributes),Name:cdk.stringToCloudFormation(properties.name),Next:cdk.stringToCloudFormation(properties.next)}):properties}function CfnPipelineAddAttributesPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("attributes","Attributes",cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.Attributes)),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("next","Next",properties.Next!=null?cfn_parse.FromCloudFormation.getString(properties.Next):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnPipeline_ChannelPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("channelName",cdk.requiredValidator)(properties.channelName)),errors.collect(cdk.propertyValidator("channelName",cdk.validateString)(properties.channelName)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("next",cdk.validateString)(properties.next)),errors.wrap('supplied properties not correct for "ChannelProperty"')}function cfnPipelineChannelPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnPipeline_ChannelPropertyValidator(properties).assertSuccess(),{ChannelName:cdk.stringToCloudFormation(properties.channelName),Name:cdk.stringToCloudFormation(properties.name),Next:cdk.stringToCloudFormation(properties.next)}):properties}function CfnPipelineChannelPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("channelName","ChannelName",cfn_parse.FromCloudFormation.getString(properties.ChannelName)),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("next","Next",properties.Next!=null?cfn_parse.FromCloudFormation.getString(properties.Next):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnPipeline_DatastorePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("datastoreName",cdk.requiredValidator)(properties.datastoreName)),errors.collect(cdk.propertyValidator("datastoreName",cdk.validateString)(properties.datastoreName)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.wrap('supplied properties not correct for "DatastoreProperty"')}function cfnPipelineDatastorePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnPipeline_DatastorePropertyValidator(properties).assertSuccess(),{DatastoreName:cdk.stringToCloudFormation(properties.datastoreName),Name:cdk.stringToCloudFormation(properties.name)}):properties}function CfnPipelineDatastorePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("datastoreName","DatastoreName",cfn_parse.FromCloudFormation.getString(properties.DatastoreName)),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnPipeline_DeviceRegistryEnrichPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("attribute",cdk.requiredValidator)(properties.attribute)),errors.collect(cdk.propertyValidator("attribute",cdk.validateString)(properties.attribute)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("next",cdk.validateString)(properties.next)),errors.collect(cdk.propertyValidator("roleArn",cdk.requiredValidator)(properties.roleArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.validateString)(properties.roleArn)),errors.collect(cdk.propertyValidator("thingName",cdk.requiredValidator)(properties.thingName)),errors.collect(cdk.propertyValidator("thingName",cdk.validateString)(properties.thingName)),errors.wrap('supplied properties not correct for "DeviceRegistryEnrichProperty"')}function cfnPipelineDeviceRegistryEnrichPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnPipeline_DeviceRegistryEnrichPropertyValidator(properties).assertSuccess(),{Attribute:cdk.stringToCloudFormation(properties.attribute),Name:cdk.stringToCloudFormation(properties.name),Next:cdk.stringToCloudFormation(properties.next),RoleArn:cdk.stringToCloudFormation(properties.roleArn),ThingName:cdk.stringToCloudFormation(properties.thingName)}):properties}function CfnPipelineDeviceRegistryEnrichPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("attribute","Attribute",cfn_parse.FromCloudFormation.getString(properties.Attribute)),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("next","Next",properties.Next!=null?cfn_parse.FromCloudFormation.getString(properties.Next):void 0),ret.addPropertyResult("roleArn","RoleArn",cfn_parse.FromCloudFormation.getString(properties.RoleArn)),ret.addPropertyResult("thingName","ThingName",cfn_parse.FromCloudFormation.getString(properties.ThingName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnPipeline_DeviceShadowEnrichPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("attribute",cdk.requiredValidator)(properties.attribute)),errors.collect(cdk.propertyValidator("attribute",cdk.validateString)(properties.attribute)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("next",cdk.validateString)(properties.next)),errors.collect(cdk.propertyValidator("roleArn",cdk.requiredValidator)(properties.roleArn)),errors.collect(cdk.propertyValidator("roleArn",cdk.validateString)(properties.roleArn)),errors.collect(cdk.propertyValidator("thingName",cdk.requiredValidator)(properties.thingName)),errors.collect(cdk.propertyValidator("thingName",cdk.validateString)(properties.thingName)),errors.wrap('supplied properties not correct for "DeviceShadowEnrichProperty"')}function cfnPipelineDeviceShadowEnrichPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnPipeline_DeviceShadowEnrichPropertyValidator(properties).assertSuccess(),{Attribute:cdk.stringToCloudFormation(properties.attribute),Name:cdk.stringToCloudFormation(properties.name),Next:cdk.stringToCloudFormation(properties.next),RoleArn:cdk.stringToCloudFormation(properties.roleArn),ThingName:cdk.stringToCloudFormation(properties.thingName)}):properties}function CfnPipelineDeviceShadowEnrichPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("attribute","Attribute",cfn_parse.FromCloudFormation.getString(properties.Attribute)),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("next","Next",properties.Next!=null?cfn_parse.FromCloudFormation.getString(properties.Next):void 0),ret.addPropertyResult("roleArn","RoleArn",cfn_parse.FromCloudFormation.getString(properties.RoleArn)),ret.addPropertyResult("thingName","ThingName",cfn_parse.FromCloudFormation.getString(properties.ThingName)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnPipeline_FilterPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("filter",cdk.requiredValidator)(properties.filter)),errors.collect(cdk.propertyValidator("filter",cdk.validateString)(properties.filter)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("next",cdk.validateString)(properties.next)),errors.wrap('supplied properties not correct for "FilterProperty"')}function cfnPipelineFilterPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnPipeline_FilterPropertyValidator(properties).assertSuccess(),{Filter:cdk.stringToCloudFormation(properties.filter),Name:cdk.stringToCloudFormation(properties.name),Next:cdk.stringToCloudFormation(properties.next)}):properties}function CfnPipelineFilterPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("filter","Filter",cfn_parse.FromCloudFormation.getString(properties.Filter)),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("next","Next",properties.Next!=null?cfn_parse.FromCloudFormation.getString(properties.Next):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnPipeline_LambdaPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("batchSize",cdk.requiredValidator)(properties.batchSize)),errors.collect(cdk.propertyValidator("batchSize",cdk.validateNumber)(properties.batchSize)),errors.collect(cdk.propertyValidator("lambdaName",cdk.requiredValidator)(properties.lambdaName)),errors.collect(cdk.propertyValidator("lambdaName",cdk.validateString)(properties.lambdaName)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("next",cdk.validateString)(properties.next)),errors.wrap('supplied properties not correct for "LambdaProperty"')}function cfnPipelineLambdaPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnPipeline_LambdaPropertyValidator(properties).assertSuccess(),{BatchSize:cdk.numberToCloudFormation(properties.batchSize),LambdaName:cdk.stringToCloudFormation(properties.lambdaName),Name:cdk.stringToCloudFormation(properties.name),Next:cdk.stringToCloudFormation(properties.next)}):properties}function CfnPipelineLambdaPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("batchSize","BatchSize",cfn_parse.FromCloudFormation.getNumber(properties.BatchSize)),ret.addPropertyResult("lambdaName","LambdaName",cfn_parse.FromCloudFormation.getString(properties.LambdaName)),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("next","Next",properties.Next!=null?cfn_parse.FromCloudFormation.getString(properties.Next):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnPipeline_MathPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("attribute",cdk.requiredValidator)(properties.attribute)),errors.collect(cdk.propertyValidator("attribute",cdk.validateString)(properties.attribute)),errors.collect(cdk.propertyValidator("math",cdk.requiredValidator)(properties.math)),errors.collect(cdk.propertyValidator("math",cdk.validateString)(properties.math)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("next",cdk.validateString)(properties.next)),errors.wrap('supplied properties not correct for "MathProperty"')}function cfnPipelineMathPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnPipeline_MathPropertyValidator(properties).assertSuccess(),{Attribute:cdk.stringToCloudFormation(properties.attribute),Math:cdk.stringToCloudFormation(properties.math),Name:cdk.stringToCloudFormation(properties.name),Next:cdk.stringToCloudFormation(properties.next)}):properties}function CfnPipelineMathPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("attribute","Attribute",cfn_parse.FromCloudFormation.getString(properties.Attribute)),ret.addPropertyResult("math","Math",cfn_parse.FromCloudFormation.getString(properties.Math)),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("next","Next",properties.Next!=null?cfn_parse.FromCloudFormation.getString(properties.Next):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnPipeline_RemoveAttributesPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("attributes",cdk.requiredValidator)(properties.attributes)),errors.collect(cdk.propertyValidator("attributes",cdk.listValidator(cdk.validateString))(properties.attributes)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("next",cdk.validateString)(properties.next)),errors.wrap('supplied properties not correct for "RemoveAttributesProperty"')}function cfnPipelineRemoveAttributesPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnPipeline_RemoveAttributesPropertyValidator(properties).assertSuccess(),{Attributes:cdk.listMapper(cdk.stringToCloudFormation)(properties.attributes),Name:cdk.stringToCloudFormation(properties.name),Next:cdk.stringToCloudFormation(properties.next)}):properties}function CfnPipelineRemoveAttributesPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("attributes","Attributes",cfn_parse.FromCloudFormation.getStringArray(properties.Attributes)),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("next","Next",properties.Next!=null?cfn_parse.FromCloudFormation.getString(properties.Next):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnPipeline_SelectAttributesPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("attributes",cdk.requiredValidator)(properties.attributes)),errors.collect(cdk.propertyValidator("attributes",cdk.listValidator(cdk.validateString))(properties.attributes)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("next",cdk.validateString)(properties.next)),errors.wrap('supplied properties not correct for "SelectAttributesProperty"')}function cfnPipelineSelectAttributesPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnPipeline_SelectAttributesPropertyValidator(properties).assertSuccess(),{Attributes:cdk.listMapper(cdk.stringToCloudFormation)(properties.attributes),Name:cdk.stringToCloudFormation(properties.name),Next:cdk.stringToCloudFormation(properties.next)}):properties}function CfnPipelineSelectAttributesPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("attributes","Attributes",cfn_parse.FromCloudFormation.getStringArray(properties.Attributes)),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("next","Next",properties.Next!=null?cfn_parse.FromCloudFormation.getString(properties.Next):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}
