"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const iam=require("../../aws-iam"),lambda=require("../../aws-lambda"),s3=require("../../aws-s3"),cdk=require("../../core"),cloudtrail=require("../lib"),app=new cdk.App,stack=new cdk.Stack(app,"integ-cloudtrail"),bucket=new s3.Bucket(stack,"Bucket",{removalPolicy:cdk.RemovalPolicy.DESTROY,autoDeleteObjects:!0}),lambdaFunction=new lambda.Function(stack,"LambdaFunction",{runtime:lambda.Runtime.NODEJS_14_X,handler:"hello.handler",code:lambda.Code.fromInline("exports.handler = {}")}),cloudTrailPrincipal=new iam.ServicePrincipal("cloudtrail.amazonaws.com"),Trailbucket=new s3.Bucket(stack,"S3",{encryption:s3.BucketEncryption.UNENCRYPTED,removalPolicy:cdk.RemovalPolicy.DESTROY,autoDeleteObjects:!0});Trailbucket.addToResourcePolicy(new iam.PolicyStatement({resources:[Trailbucket.bucketArn],actions:["s3:GetBucketAcl"],principals:[cloudTrailPrincipal]})),Trailbucket.addToResourcePolicy(new iam.PolicyStatement({resources:[Trailbucket.arnForObjects(`AWSLogs/${cdk.Stack.of(stack).account}/*`)],actions:["s3:PutObject"],principals:[cloudTrailPrincipal],conditions:{StringEquals:{"s3:x-amz-acl":"bucket-owner-full-control"}}}));const trail=new cloudtrail.Trail(stack,"Trail",{bucket:Trailbucket});trail.addLambdaEventSelector([lambdaFunction]),trail.addS3EventSelector([{bucket}]),app.synth();
